/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.costprice;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.datatype.LongType;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.form.field.TextEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.helper.CalBalanceModelHelper;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.common.helper.WriteLogHelper;

public class PriceDimensionHelperNew {
    private static Log log = LogFactory.getLog(PriceDimensionHelperNew.class);
    private Set<Object> calOrgs = new HashSet<Object>(16);
    private Set<Object> materialIds = new HashSet<Object>(16);
    private Set<Object> storageorgunitIds = new HashSet<Object>(16);
    private Map<Object, String> materialGroupLongNumMap = new HashMap<Object, String>(16);
    private Map<Object, Object> entyrIdCalOrgMap = new HashMap<Object, Object>(16);
    private Map<Object, Object> calOrgCurrencyMap = new HashMap<Object, Object>(16);
    private Map<Object, Object> calOrgCostAccountMap = new HashMap<Object, Object>(16);
    private Set<Long> costAccountIds = new HashSet<Long>(16);
    private Map<Object, String[]> calOrgDividebasisMap = new HashMap<Object, String[]>(16);
    private Map<Object, String> costAccount2DividebasisMap = new HashMap<Object, String>(16);
    private Set<String> entityObjects = new HashSet<String>(16);
    private Map<Object, Object> calOrgCalRangeIdMap = new HashMap<Object, Object>(16);
    private Map<Object, Object> costAccountCalRangeIdMap = new HashMap<Object, Object>(16);
    private Map<String, Object> divdebasisValuesCalRangeIdMap = new HashMap<String, Object>(16);
    private Map<Object, String[]> calRangeDimensionMap = new HashMap<Object, String[]>(16);
    private Map<Object, String> calRangeDimensionStrMap = new HashMap<Object, String>(16);
    private Map<String, String[]> calRangeMaterialDimensionMap = new HashMap<String, String[]>(16);
    private Map<String, String> calRangeMaterialDimensionStrMap = new HashMap<String, String>(16);
    private Map<String, String[]> calRangeMatGroupDimensionMap = new HashMap<String, String[]>(16);
    private Map<String, String> calRangeMatGroupDimensionStrMap = new HashMap<String, String>(16);
    private Date maxBookdate = null;
    private Map<Object, Map<String, Object>> paramsMap = null;
    private Set<Long> entryids = new HashSet<Long>(16);
    private Boolean get_scm_price_null2zero = CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.GET_SCM_PRICE_NULL2ZERO);

    public Set<Long> getEntryids() {
        return this.entryids;
    }

    public PriceDimensionHelperNew(Map<Object, Map<String, Object>> paramsMap) {
        this.paramsMap = paramsMap;
        this.buildEntityCalOrgAndMaterial(paramsMap);
        this.buildCostAccountAndDividebasis();
        this.buildCalDimension();
        this.buildMaterialGroup();
    }

    public DataSet createDestDataSet() {
        List<String> dimList = this.getSortAllDimensions();
        List<Field> fields = this.getFieldRowMetas(dimList);
        RowMeta rowMeta = new RowMeta(fields.toArray(new Field[0]));
        DataSetBuilder dataSetBuilder = Algo.create((String)this.getClass().getName()).createDataSetBuilder(rowMeta);
        this.resolveParamsMap();
        for (Map.Entry<Object, Map<String, Object>> objectMapEntry : this.paramsMap.entrySet()) {
            Map<String, Object> map = objectMapEntry.getValue();
            ArrayList<Object> objects = new ArrayList<Object>(16);
            for (String dim : dimList) {
                objects.add(map.get(dim));
            }
            dataSetBuilder.append(objects.toArray());
        }
        DataSet dataSet = dataSetBuilder.build();
        return dataSet;
    }

    private void resolveParamsMap() {
        for (Map.Entry<Object, Map<String, Object>> objectMapEntry : this.paramsMap.entrySet()) {
            Object calRangeId;
            Map<String, Object> map = objectMapEntry.getValue();
            Object calorg = map.get("calorg");
            Object costAccountId = this.calOrgCostAccountMap.get(calorg);
            map.putIfAbsent("costaccount", costAccountId);
            String dividebasis = this.costAccount2DividebasisMap.get(costAccountId);
            map.put("dividebasis", dividebasis);
            StringBuilder key = new StringBuilder();
            key.append(costAccountId);
            boolean noDividebasisField = true;
            if (dividebasis != null) {
                for (String string : dividebasis.split(",")) {
                    if (!StringUtils.isNotEmpty((String)string)) continue;
                    key.append("_");
                    Object value = map.get(string);
                    key.append(value);
                    if (!noDividebasisField || !(value instanceof Long) || ((Long)value).compareTo(0L) == 0) continue;
                    noDividebasisField = false;
                }
            }
            if ((calRangeId = map.get("calrange")) == null || calRangeId instanceof Long && ((Long)calRangeId).compareTo(0L) == 0) {
                calRangeId = this.divdebasisValuesCalRangeIdMap.get(key.toString());
                if (calRangeId == null) {
                    calRangeId = noDividebasisField ? null : this.costAccountCalRangeIdMap.get(costAccountId);
                }
                map.put("calrange", calRangeId);
            }
            if (calRangeId == null) continue;
            Object materialId = map.get("material");
            String calRangeIdMaterial = calRangeId.toString() + "_" + materialId;
            String calDimensions = this.calRangeMaterialDimensionStrMap.get(calRangeIdMaterial);
            if (StringUtils.isEmpty((String)calDimensions)) {
                String groupLongNum = this.materialGroupLongNumMap.get(materialId);
                String calRangeIdMaterialGroup = calRangeId.toString() + "_" + groupLongNum;
                calDimensions = this.calRangeMatGroupDimensionStrMap.get(calRangeIdMaterialGroup);
                if (StringUtils.isEmpty((String)calDimensions)) {
                    for (Map.Entry<String, String[]> entryMap : this.calRangeMatGroupDimensionMap.entrySet()) {
                        String calRangeGroup = entryMap.getKey();
                        if (!calRangeIdMaterialGroup.startsWith(calRangeGroup)) continue;
                        this.calRangeMatGroupDimensionStrMap.put(calRangeIdMaterialGroup, calDimensions);
                    }
                }
                if (StringUtils.isEmpty((String)calDimensions)) {
                    calDimensions = this.calRangeDimensionStrMap.get(calRangeId);
                }
            }
            map.put("caldimension", calDimensions);
        }
    }

    private List<Field> getFieldRowMetas(List<String> dimList) {
        String balanceenity = CalBalanceModelHelper.isNewBalance() ? "cal_bal" : "cal_balance";
        MainEntityType balanceEntityType = MetadataServiceHelper.getDataEntityType((String)balanceenity);
        ArrayList<Field> fields = new ArrayList<Field>(16);
        for (String fieldkey : dimList) {
            if (StringUtils.isEmpty((String)fieldkey)) continue;
            if ("caldimension".equals(fieldkey)) {
                fields.add(new Field(fieldkey, (DataType)DataType.StringType));
                continue;
            }
            Field field = new Field(fieldkey, (DataType)DataType.StringType);
            IDataEntityProperty property = balanceEntityType.findProperty(fieldkey);
            if (property == null) {
                switch (fieldkey) {
                    case "entryid": 
                    case "bizbillid": {
                        field = new Field(fieldkey, (DataType)DataType.LongType);
                        break;
                    }
                    case "bookdate": {
                        field = new Field(fieldkey, (DataType)DataType.DateType);
                        break;
                    }
                    case "dividebasis": {
                        field = new Field(fieldkey, (DataType)DataType.StringType);
                    }
                }
            } else if (property instanceof BasedataProp || property instanceof LongProp) {
                field = new Field(fieldkey, (DataType)DataType.LongType);
            } else if (property instanceof TextEdit) {
                field = new Field(fieldkey, (DataType)DataType.StringType);
            } else if (property instanceof TimeProp) {
                field = new Field(fieldkey, (DataType)DataType.DateType);
            } else if (property instanceof ComboProp) {
                field = new Field(fieldkey, (DataType)DataType.StringType);
            }
            fields.add(field);
        }
        return fields;
    }

    private List<String> getSortAllDimensions() {
        String[] calDimension = CommonSettingHelper.getCalDimension();
        String[] divideBasis = CommonSettingHelper.getDivideBasis();
        HashSet<String> dims = new HashSet<String>(16);
        dims.addAll(Arrays.asList(calDimension));
        dims.addAll(Arrays.asList(divideBasis));
        dims.add("costaccount");
        dims.add("calrange");
        dims.add("id");
        dims.add("entryid");
        dims.add("bizbillid");
        dims.add("bookdate");
        dims.add("dividebasis");
        dims.add("caldimension");
        dims.add("material");
        ArrayList<String> dimList = new ArrayList<String>(dims);
        dimList.sort(Comparator.naturalOrder());
        return dimList;
    }

    public Set<Long> getCostAccountIds() {
        return this.costAccountIds;
    }

    public Set<Object> getMaterialIds() {
        return this.materialIds;
    }

    public Set<Object> getStorageorgunitIds() {
        return this.storageorgunitIds;
    }

    public Date getMaxBookdate() {
        return this.maxBookdate;
    }

    public Set<String> getEntityObjects() {
        return this.entityObjects;
    }

    public Map<Object, Object> getEntryIdCurrencyIdMap() {
        HashMap<Object, Object> entryIdCurrencyIdMap = new HashMap<Object, Object>(16);
        for (Map.Entry<Object, Object> entryMap : this.entyrIdCalOrgMap.entrySet()) {
            Object entryId = entryMap.getKey();
            Object calOrg = entryMap.getValue();
            Object currencyId = this.calOrgCurrencyMap.get(calOrg);
            entryIdCurrencyIdMap.put(entryId, currencyId);
        }
        return entryIdCurrencyIdMap;
    }

    public Set<String> getPriceDimension(Map<String, Object> map, String dimension) {
        Object calRangeId;
        HashSet<String> priceDimensions = new HashSet<String>(16);
        priceDimensions.add("calorg");
        priceDimensions.add("costaccount");
        priceDimensions.add("material");
        if ("A".equals(dimension)) {
            return priceDimensions;
        }
        Object calOrg = map.get("calorg");
        String[] dividebasis = this.calOrgDividebasisMap.get(calOrg);
        Object costAccountId = this.calOrgCostAccountMap.get(calOrg);
        StringBuilder key = new StringBuilder();
        key.append(costAccountId);
        if (dividebasis != null) {
            for (String string : dividebasis) {
                key.append("_");
                key.append(map.get(string));
            }
        }
        if ((calRangeId = this.divdebasisValuesCalRangeIdMap.get(key.toString())) == null) {
            calRangeId = this.calOrgCalRangeIdMap.get(calOrg);
            if (dividebasis != null) {
                for (String string : dividebasis) {
                    priceDimensions.add(string);
                }
            }
        } else {
            map.put("calrange", calRangeId);
            priceDimensions.add("calrange");
        }
        if ("C".equals(dimension) && calRangeId != null) {
            Object materialId = map.get("material");
            String calRangeIdMaterial = calRangeId.toString() + "_" + materialId;
            String[] calDimensions = this.calRangeMaterialDimensionMap.get(calRangeIdMaterial);
            if (calDimensions == null) {
                String groupLongNum = this.materialGroupLongNumMap.get(materialId);
                String calRangeIdMaterialGroup = calRangeId.toString() + "_" + groupLongNum;
                calDimensions = this.calRangeMatGroupDimensionMap.get(calRangeIdMaterialGroup);
                if (calDimensions == null) {
                    for (Map.Entry<String, String[]> entryMap : this.calRangeMatGroupDimensionMap.entrySet()) {
                        String calRangeGroup = entryMap.getKey();
                        if (!calRangeIdMaterialGroup.startsWith(calRangeGroup)) continue;
                        calDimensions = entryMap.getValue();
                    }
                }
                if (calDimensions == null) {
                    calDimensions = this.calRangeDimensionMap.get(calRangeId);
                }
            }
            if (calDimensions != null) {
                for (String string : calDimensions) {
                    priceDimensions.add(string);
                }
            }
        }
        return priceDimensions;
    }

    public QFilter getRecentCostFilter(Map<String, Object> map, String dimension, RowMeta rowMeta) {
        Object calOrg = map.get("calorg");
        Object costAccountId = this.calOrgCostAccountMap.get(calOrg);
        QFilter recentCostFilter = new QFilter("costaccount", "=", costAccountId);
        recentCostFilter.and("material", "=", map.get("material"));
        if ("A".equals(dimension)) {
            return recentCostFilter;
        }
        if ("B".equals(dimension) || "C".equals(dimension)) {
            Object calRangeId;
            String[] dividebasis = this.calOrgDividebasisMap.get(calOrg);
            StringBuilder key = new StringBuilder();
            key.append(costAccountId);
            if (dividebasis != null) {
                for (String string : dividebasis) {
                    key.append("_");
                    key.append(map.get(string));
                }
            }
            if ((calRangeId = this.divdebasisValuesCalRangeIdMap.get(key.toString())) == null) {
                calRangeId = this.calOrgCalRangeIdMap.get(calOrg);
                for (String dim : dividebasis) {
                    Object dimValue = map.get(dim);
                    if (dimValue == null || "".equals(dimValue) || !(dimValue instanceof Long) || ((Long)dimValue).compareTo(0L) == 0) continue;
                    recentCostFilter.and(dim, "=", dimValue);
                }
            } else {
                recentCostFilter.and("calrange", "=", calRangeId);
            }
            if ("B".equals(dimension)) {
                return recentCostFilter;
            }
            if (calRangeId != null) {
                Object materialId = map.get("material");
                String calRangeIdMaterial = calRangeId.toString() + "_" + materialId;
                String[] calDimensions = this.calRangeMaterialDimensionMap.get(calRangeIdMaterial);
                if (calDimensions == null) {
                    String groupLongNum = this.materialGroupLongNumMap.get(materialId);
                    String calRangeIdMaterialGroup = calRangeId.toString() + "_" + groupLongNum;
                    calDimensions = this.calRangeMatGroupDimensionMap.get(calRangeIdMaterialGroup);
                    if (calDimensions == null) {
                        for (Map.Entry<String, String[]> entryMap : this.calRangeMatGroupDimensionMap.entrySet()) {
                            String calRangeGroup = entryMap.getKey();
                            if (!calRangeIdMaterialGroup.startsWith(calRangeGroup)) continue;
                            calDimensions = entryMap.getValue();
                        }
                    }
                    if (calDimensions == null) {
                        calDimensions = this.calRangeDimensionMap.get(calRangeId);
                    }
                }
                if (calDimensions != null) {
                    for (String dim : calDimensions) {
                        Object dimValue = map.get(dim);
                        if (dimValue != null && !"".equals(dimValue)) {
                            recentCostFilter.and(dim, "=", dimValue);
                            continue;
                        }
                        if (!this.get_scm_price_null2zero.booleanValue() || !map.containsKey(dim) || !(rowMeta.getField(dim).getDataType() instanceof LongType)) continue;
                        QFilter q = new QFilter(dim, "=", (Object)0).or(dim, "=", null);
                        if (recentCostFilter == null) {
                            recentCostFilter = q;
                            continue;
                        }
                        recentCostFilter.and(q);
                    }
                }
            }
        }
        return recentCostFilter;
    }

    private void buildMaterialGroup() {
        QFilter materialGroupFilter = new QFilter("material", "in", this.materialIds);
        materialGroupFilter.and("standard", "=", (Object)730148448254487552L);
        try (DataSet materialGroupDetail = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bd_materialgroupdetail", (String)"material,group.longnumber", (QFilter[])materialGroupFilter.toArray(), null);){
            for (Row row : materialGroupDetail) {
                Object materialId = row.get("material");
                String groupLongNum = row.getString("group.longnumber");
                this.materialGroupLongNumMap.put(materialId, groupLongNum);
            }
        }
    }

    private void buildCalDimension() {
        String[] dividebasis = CommonSettingHelper.getDivideBasis();
        HashSet<String> dividebasisSet = new HashSet<String>(16);
        for (String string : dividebasis) {
            dividebasisSet.add("entry." + string + " as " + string);
        }
        HashSet<Object> calRangeIds = new HashSet<Object>(16);
        QFilter calRangeFilter = new QFilter("costaccount", "in", this.calOrgCostAccountMap.values());
        calRangeFilter.and("status", "=", (Object)Character.valueOf('C'));
        calRangeFilter.and("enable", "=", (Object)Character.valueOf('1'));
        Throwable throwable = null;
        try (DataSet calRangeDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_bd_calrange", (String)("id,headcalorg,costaccount,caldimension.caldimension,entry.id," + String.join((CharSequence)",", dividebasisSet)), (QFilter[])calRangeFilter.toArray(), null);){
            for (Row row : calRangeDataSet) {
                Object calorg = row.get("headcalorg");
                Object costaccount = row.get("costaccount");
                Object calRangeId = row.get("id");
                String calDimension = row.getString("caldimension.caldimension");
                Long calRangeEntryId = row.getLong("entry.id");
                if (calRangeEntryId == null || calRangeEntryId.equals(0L)) {
                    this.calOrgCalRangeIdMap.put(calorg, calRangeId);
                    this.costAccountCalRangeIdMap.put(costaccount, calRangeId);
                } else {
                    String[] currentdividebasis;
                    StringBuilder key = new StringBuilder();
                    key.append(costaccount);
                    for (String div : currentdividebasis = this.calOrgDividebasisMap.get(calorg)) {
                        key.append("_");
                        key.append(row.getString(div));
                    }
                    this.divdebasisValuesCalRangeIdMap.put(key.toString(), calRangeId);
                }
                if (StringUtils.isNotEmpty((String)calDimension)) {
                    this.calRangeDimensionMap.put(calRangeId, calDimension.split(","));
                    this.calRangeDimensionStrMap.put(calRangeId, calDimension);
                }
                calRangeIds.add(calRangeId);
            }
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throw throwable2;
        }
        QFilter materialDimensionFilter = new QFilter("calrange", "in", calRangeIds);
        materialDimensionFilter.and("status", "=", (Object)Character.valueOf('C'));
        materialDimensionFilter.and("enable", "=", (Object)Character.valueOf('1'));
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_bd_materialdimension", (String)"calrange,entry.material,entry.materialgroup.longnumber,entry.caldimension.caldimension", (QFilter[])materialDimensionFilter.toArray(), null);
        Object object = null;
        try {
            for (Row row : dataSet) {
                String calrangeId = row.getString("calrange");
                Long materialId = row.getLong("entry.material");
                String materailGroupLongNum = row.getString("entry.materialgroup.longnumber");
                String calDimension = row.getString("entry.caldimension.caldimension");
                if (materialId != 0L && StringUtils.isNotEmpty((String)calDimension)) {
                    this.calRangeMaterialDimensionMap.put(calrangeId + "_" + materialId.toString(), calDimension.split(","));
                    this.calRangeMaterialDimensionStrMap.put(calrangeId + "_" + materialId.toString(), calDimension);
                    continue;
                }
                if (!StringUtils.isNotEmpty((String)materailGroupLongNum) || !StringUtils.isNotEmpty((String)calDimension)) continue;
                this.calRangeMatGroupDimensionMap.put(calrangeId + "_" + materailGroupLongNum, calDimension.split(","));
                this.calRangeMatGroupDimensionStrMap.put(calrangeId + "_" + materailGroupLongNum, calDimension);
            }
        }
        catch (Throwable throwable4) {
            object = throwable4;
            throw throwable4;
        }
        finally {
            if (dataSet != null) {
                if (object != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable5) {
                        ((Throwable)object).addSuppressed(throwable5);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
    }

    private void buildCostAccountAndDividebasis() {
        QFilter costAccountFilter = new QFilter("enable", "=", (Object)Character.valueOf('1'));
        if (this.calOrgs == null || this.calOrgs.isEmpty()) {
            costAccountFilter.and(QFilter.of((String)"1<>1", (Object[])new Object[0]));
        } else {
            costAccountFilter.and("calorg", "in", this.calOrgs);
        }
        if (!this.costAccountIds.isEmpty()) {
            costAccountFilter.and("id", "in", this.costAccountIds);
        }
        DataSet costAccountDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_bd_costaccount", (String)"id,calorg,dividebasis.dividebasis,ismainaccount,calpolicy.currency", (QFilter[])costAccountFilter.toArray(), null);
        for (Row row : costAccountDataSet) {
            Object id = row.get("id");
            Object calorg = row.get("calorg");
            String divdebasis = row.getString("dividebasis.dividebasis");
            boolean mainaccount = row.getBoolean("ismainaccount");
            Object currencyId = row.get("calpolicy.currency");
            Object notMainCostAccount = this.calOrgCostAccountMap.get(calorg);
            if (notMainCostAccount != null && !mainaccount) continue;
            this.calOrgCostAccountMap.put(calorg, id);
            this.calOrgCurrencyMap.put(calorg, currencyId);
            this.calOrgDividebasisMap.put(calorg, divdebasis.split(","));
            this.costAccount2DividebasisMap.put(id, divdebasis);
        }
        for (Object costAccountId : this.calOrgCostAccountMap.values()) {
            this.costAccountIds.add((Long)costAccountId);
        }
    }

    private void buildEntityCalOrgAndMaterial(Map<Object, Map<String, Object>> paramsMap) {
        for (Map.Entry<Object, Map<String, Object>> entryMap : paramsMap.entrySet()) {
            Object owner;
            Map<String, Object> map = entryMap.getValue();
            if (map == null) continue;
            Object entryId = entryMap.getKey();
            Object calOrg = map.get("calorg");
            if (calOrg == null && (calOrg = map.get("owner")) != null) {
                map.put("calorg", calOrg);
            }
            if ((owner = map.get("owner")) == null && (owner = map.get("calorg")) != null) {
                map.put("owner", owner);
            }
            Object material = map.get("material");
            Object storageorgunit = map.get("storageorgunit");
            String entity = (String)map.get("entityobject");
            Date bookdate = (Date)map.get("bookdate");
            Long costAccount = (Long)map.get("costaccount");
            Object entryid = entryMap.getKey();
            if (calOrg != null) {
                this.calOrgs.add(calOrg);
                this.entyrIdCalOrgMap.put(entryId, calOrg);
            }
            if (material != null) {
                this.materialIds.add(material);
            }
            if (storageorgunit != null) {
                this.storageorgunitIds.add(storageorgunit);
            }
            if (StringUtils.isNotEmpty((String)entity)) {
                this.entityObjects.add(entity);
            }
            if (bookdate != null && (this.maxBookdate == null || bookdate.after(this.maxBookdate))) {
                this.maxBookdate = bookdate;
            }
            if (costAccount != null) {
                this.costAccountIds.add(costAccount);
            }
            Long entryLongId = null;
            if (entryid instanceof Integer) {
                entryLongId = Long.valueOf(entryid.toString());
            } else if (entryid instanceof Long) {
                entryLongId = (Long)entryid;
            }
            if (entryLongId != null) {
                this.entryids.add(entryLongId);
                map.put("entryid", entryLongId);
                continue;
            }
            WriteLogHelper.writeInfoLog((Log)log, (String)"priceInterFaceKeyNotLongType", (Object[])new Object[0]);
        }
    }
}

