/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.datacheck;

import kd.bos.dataentity.resource.ResManager;

public enum AlarmLevel {
    WARNING("A", AlarmLevel.getWarning()),
    ERROR("B", AlarmLevel.getError());

    private String value;
    private String name;

    private AlarmLevel(String value, String desc) {
        this.value = value;
        this.name = desc;
    }

    private static String getWarning() {
        return ResManager.loadKDString((String)"\u8b66\u544a", (String)"AlarmLevel_1", (String)"fi-cal-business", (Object[])new Object[0]);
    }

    private static String getError() {
        return ResManager.loadKDString((String)"\u5931\u8d25", (String)"AlarmLevel_2", (String)"fi-cal-business", (Object[])new Object[0]);
    }

    public String getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public static AlarmLevel getByValue(String value) {
        for (AlarmLevel level : AlarmLevel.values()) {
            if (!level.value.equals(value)) continue;
            return level;
        }
        return null;
    }
}

