/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.datacheck;

import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cal.business.datacheck.DataCheckTask;
import kd.fi.cal.business.datacheck.DataCheckTaskEntry;
import kd.fi.cal.business.datacheck.ExceptionObj;
import kd.fi.cal.business.datacheck.ResultStatus;
import kd.fi.cal.business.datacheck.RunningStatus;

public class DataCheckResult {
    private static final String RUNNING_STATUS = "A";
    private static final String COMPLETED_STATUS = "B";
    private DynamicObject result = BusinessDataServiceHelper.newDynamicObject((String)"cal_datacheck_result");

    public DataCheckResult(DataCheckTask task) {
        this.result.set("checkplan", (Object)task.getPlanId());
        this.result.set("checkplantype", (Object)task.getPlanType());
        this.result.set("checktask", (Object)task.getTaskId());
        this.result.set("user", (Object)RequestContext.get().getUserId());
        this.result.set("checktime", (Object)new Date());
        this.result.set("status", (Object)RUNNING_STATUS);
        this.result.set("calorg", (Object)task.getCalorg());
        this.result.set("costaccount", (Object)task.getCostaccount());
        this.result.set("owner", (Object)task.getOwner());
        this.result.set("purpose", (Object)task.getPurpose());
        DynamicObjectCollection col = this.result.getDynamicObjectCollection("entryentity");
        int seq = 1;
        for (DataCheckTaskEntry entry : task.getCheckTaskEntry()) {
            DynamicObject resultEntry = col.addNew();
            resultEntry.set("seq", (Object)seq);
            resultEntry.set("checkitem", (Object)entry.getCheckItemId());
            resultEntry.set("runingstatus", (Object)RunningStatus.WAITING.getValue());
            ++seq;
        }
        this.updateDB();
    }

    public void beginRun(Long checkItemId) {
        for (DynamicObject resultEntry : this.result.getDynamicObjectCollection("entryentity")) {
            if (!checkItemId.equals(resultEntry.getLong("checkitem_id"))) continue;
            resultEntry.set("runingstatus", (Object)RunningStatus.RUNNING.getValue());
        }
        this.updateDB();
    }

    public void dealRuntimeException(Long checkItemId, String description, boolean isLastItem) {
        this.updateCheckResult(checkItemId, ResultStatus.EXCEPTION, RunningStatus.COMPLETED, description, null, isLastItem);
    }

    public void afterRun(Long checkItemId, ResultStatus status, String description, List<ExceptionObj> exceptionList, boolean isLastItem) {
        this.updateCheckResult(checkItemId, status, RunningStatus.COMPLETED, description, exceptionList, isLastItem);
    }

    private void updateCheckResult(Long checkItemId, ResultStatus status, RunningStatus runStatus, String description, List<ExceptionObj> exceptionList, boolean isLastItem) {
        for (DynamicObject resultEntry : this.result.getDynamicObjectCollection("entryentity")) {
            if (!checkItemId.equals(resultEntry.getLong("checkitem_id"))) continue;
            if (status != null) {
                resultEntry.set("entrystatus", (Object)status.getValue());
            }
            if (runStatus != null) {
                resultEntry.set("runingstatus", (Object)runStatus.getValue());
            }
            if (ResultStatus.SUCCESS == status) {
                description = ResManager.loadKDString((String)"\u6570\u636e\u6821\u9a8c\u6210\u529f\u3002", (String)"DataCheckResult_0", (String)"fi-cal-business", (Object[])new Object[0]);
            }
            resultEntry.set("description", (Object)description);
            if (exceptionList == null || exceptionList.isEmpty()) break;
            DynamicObjectCollection resultDetail = resultEntry.getDynamicObjectCollection("subentryentity");
            int seq = 1;
            for (ExceptionObj obj : exceptionList) {
                DynamicObject detail = resultDetail.addNew();
                detail.set("seq", (Object)seq);
                detail.set("objid", (Object)obj.getId());
                detail.set("objtype", (Object)obj.getEntityType());
                String desc = obj.getDescription();
                if (!StringUtils.isEmpty((String)desc) && desc.length() > 500) {
                    desc = desc.substring(0, 499);
                }
                detail.set("objdes", (Object)desc);
                detail.set("extralinfo", (Object)obj.getExtralInfo());
                detail.set("isrepaired", (Object)false);
                ++seq;
            }
        }
        if (isLastItem) {
            this.result.set("status", (Object)COMPLETED_STATUS);
        }
        this.updateDB();
    }

    private void updateDB() {
        try (TXHandle handle = TX.requiresNew();){
            this.result = (DynamicObject)SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.result})[0];
        }
    }

    public DynamicObject getResult() {
        return this.result;
    }
}

