/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.datacheck;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.AlgoContext;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.api.MessageChannels;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.fi.cal.business.datacheck.AlarmLevel;
import kd.fi.cal.business.datacheck.DataCheckParam;
import kd.fi.cal.business.datacheck.DataCheckResult;
import kd.fi.cal.business.datacheck.DataCheckTask;
import kd.fi.cal.business.datacheck.DataCheckTaskEntry;
import kd.fi.cal.business.datacheck.ExceptionObj;
import kd.fi.cal.business.datacheck.ResultStatus;
import kd.fi.cal.business.datacheck.item.IDataCheck;
import kd.fi.cal.common.util.CommonUtils;

public class DataCheckTaskExecutor {
    private static final Log logger = LogFactory.getLog(DataCheckTaskExecutor.class);
    private static final String CUSTOMPLUGINNAME = "CustomDataCheck";

    public DataCheckResult commitSync(DataCheckTask task, DataCheckParam param) {
        DataCheckResult result = new DataCheckResult(task);
        List<DataCheckTaskEntry> entryList = task.getCheckTaskEntry();
        HashSet<String> resultStatusSet = new HashSet<String>(16);
        int size = entryList.size();
        for (int i = 0; i < size; ++i) {
            boolean isLastItem = i == size - 1;
            DataCheckTaskEntry entry = entryList.get(i);
            logger.info("\u5b58\u8d27\u6838\u7b97\u68c0\u67e5\u9879" + entry.getPlugin() + "-start");
            Long startTime = System.currentTimeMillis();
            List<ExceptionObj> objList = null;
            result.beginRun(entry.getCheckItemId());
            IDataCheck dataCheck = null;
            try {
                dataCheck = entry.createDataCheck();
                if (entry.getPlugin().contains(CUSTOMPLUGINNAME)) {
                    param.setCurrentItemId(entry.getCheckItemId());
                }
                try (AlgoContext context = Algo.newContext();){
                    objList = dataCheck.collectExceptionObj(param);
                }
            }
            catch (Throwable e) {
                String msg = null;
                if (e instanceof ClassNotFoundException) {
                    msg = ResManager.loadKDString((String)"\u5de1\u68c0\u8ba1\u5212\u7684\u68c0\u67e5\u4efb\u52a1\u4e2d\u7684\u68c0\u67e5\u9879\u914d\u7f6e\u7684\u63d2\u4ef6\u4e0d\u5b58\u5728\u3002", (String)"DataCheckTaskExecutor_0", (String)"fi-cal-business", (Object[])new Object[0]);
                    result.dealRuntimeException(entry.getCheckItemId(), msg, isLastItem);
                } else if (e instanceof KDBizException) {
                    msg = CommonUtils.getLogMessage((Throwable)e, (int)160);
                    result.dealRuntimeException(entry.getCheckItemId(), msg, isLastItem);
                } else {
                    msg = CommonUtils.getLogMessage((Throwable)e, (int)160);
                    result.dealRuntimeException(entry.getCheckItemId(), e.getClass().getName() + ":" + msg, isLastItem);
                }
                if (dataCheck != null) {
                    logger.error("\u5b58\u8d27\u6838\u7b97\u68c0\u67e5\u9879\u68c0\u67e5\u63d2\u4ef6" + dataCheck.getClass().getName() + "\u8fd0\u884c\u5f02\u5e38", e);
                }
                resultStatusSet.add(ResultStatus.EXCEPTION.getValue());
                continue;
            }
            ResultStatus status = null;
            if (objList == null || objList.isEmpty()) {
                status = ResultStatus.SUCCESS;
                result.afterRun(entry.getCheckItemId(), status, entry.getTips(), objList, isLastItem);
            } else {
                status = AlarmLevel.ERROR == entry.getAlarmLevel() ? ResultStatus.ERROR : ResultStatus.WARNING;
                result.afterRun(entry.getCheckItemId(), status, entry.getTips(), objList, isLastItem);
            }
            resultStatusSet.add(status.getValue());
            logger.info("\u5b58\u8d27\u6838\u7b97\u68c0\u67e5\u9879" + entry.getPlugin() + "-end-" + (System.currentTimeMillis() - startTime) / 1000L + "s");
        }
        this.sendMsgAfterCheck(param, resultStatusSet, result);
        return result;
    }

    public DataCheckResult commitSync(DataCheckTask task, List<DataCheckParam> paramList) {
        DataCheckResult result = new DataCheckResult(task);
        List<DataCheckTaskEntry> entryList = task.getCheckTaskEntry();
        int size = entryList.size();
        HashSet<String> resultStatusSet = new HashSet<String>(16);
        for (int i = 0; i < size; ++i) {
            boolean isLastItem = i == size - 1;
            DataCheckTaskEntry entry = entryList.get(i);
            logger.info("\u5b58\u8d27\u6838\u7b97\u68c0\u67e5\u9879" + entry.getPlugin() + "-start");
            Long startTime = System.currentTimeMillis();
            List<ExceptionObj> objList = null;
            result.beginRun(entry.getCheckItemId());
            IDataCheck dataCheck = null;
            try {
                dataCheck = entry.createDataCheck();
                if (entry.getPlugin().contains(CUSTOMPLUGINNAME)) {
                    for (DataCheckParam dataCheckParam : paramList) {
                        dataCheckParam.setCurrentItemId(entry.getCheckItemId());
                    }
                }
                Throwable throwable = null;
                try (AlgoContext context = Algo.newContext();){
                    objList = dataCheck.collectExceptionObj(paramList);
                }
                catch (Throwable throwable2) {
                    Throwable throwable3 = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable e) {
                Object var14_20 = null;
                if (e instanceof ClassNotFoundException) {
                    String string = ResManager.loadKDString((String)"\u5de1\u68c0\u8ba1\u5212\u7684\u68c0\u67e5\u4efb\u52a1\u4e2d\u7684\u68c0\u67e5\u9879\u914d\u7f6e\u7684\u63d2\u4ef6\u4e0d\u5b58\u5728\u3002", (String)"DataCheckTaskExecutor_0", (String)"fi-cal-business", (Object[])new Object[0]);
                    result.dealRuntimeException(entry.getCheckItemId(), string, isLastItem);
                } else {
                    String string = CommonUtils.getLogMessage((Throwable)e, (int)160);
                    result.dealRuntimeException(entry.getCheckItemId(), e.getClass().getName() + ":" + string, isLastItem);
                }
                if (dataCheck != null) {
                    logger.error("\u5b58\u8d27\u6838\u7b97\u68c0\u67e5\u9879\u68c0\u67e5\u63d2\u4ef6" + dataCheck.getClass().getName() + "\u8fd0\u884c\u5f02\u5e38", e);
                }
                resultStatusSet.add(ResultStatus.EXCEPTION.getValue());
                continue;
            }
            ResultStatus status = null;
            if (objList == null || objList.isEmpty()) {
                status = ResultStatus.SUCCESS;
                result.afterRun(entry.getCheckItemId(), status, entry.getTips(), objList, isLastItem);
            } else {
                status = AlarmLevel.ERROR == entry.getAlarmLevel() ? ResultStatus.ERROR : ResultStatus.WARNING;
                result.afterRun(entry.getCheckItemId(), status, entry.getTips(), objList, isLastItem);
            }
            resultStatusSet.add(status.getValue());
            logger.info("\u5b58\u8d27\u6838\u7b97\u68c0\u67e5\u9879" + entry.getPlugin() + "-end-" + (System.currentTimeMillis() - startTime) / 1000L + "s");
        }
        this.sendMsgAfterCheck(paramList.get(0), resultStatusSet, result);
        return result;
    }

    private void sendMsgAfterCheck(DataCheckParam param, Set<String> resultStatusSet, DataCheckResult result) {
        String formId;
        Set<Long> msgReceiverIds = param.getMsgReceiver();
        String msgStatus = param.getMsgStatus();
        if (msgReceiverIds == null || msgReceiverIds.isEmpty() || msgStatus == null || msgStatus.trim().isEmpty()) {
            return;
        }
        Long resultId = result.getResult().getLong("id");
        DataSet resultDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_datacheck_result", (String)"checktime,checktask.name,user.name", (QFilter[])new QFilter("id", "=", (Object)resultId).toArray(), null);
        String checkTimeStr = "";
        String taskName = "";
        String checkUserName = "";
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        for (Row row : resultDs) {
            checkTimeStr = sdf.format(row.getDate("checktime"));
            taskName = row.getString("checktask.name");
            checkUserName = row.getString("user.name");
        }
        boolean isSend = false;
        String msgTitle = null;
        String msgContent = null;
        String successTitle = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u5de1\u68c0\u201c%2$s\u201d\u68c0\u67e5\u6210\u529f\u3002", (String)"DataCheckTaskExecutor_1", (String)"fi-cal-business", (Object[])new Object[0]), checkTimeStr, taskName);
        String successMsg = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u5de1\u68c0\u201c%2$s\u201d\u68c0\u67e5\u6210\u529f\u3002\u68c0\u67e5\u7528\u6237\u201c%3$s\u201d\u8bf7\u5230\u201c\u8d22\u52a1\u4e91>\u5b58\u8d27\u6838\u7b97>\u540e\u53f0\u76d1\u63a7>\u68c0\u67e5\u7ed3\u679c\u201d\u67e5\u770b\u8be6\u7ec6\u4fe1\u606f\u8fdb\u884c\u5904\u7406\u3002", (String)"DataCheckTaskExecutor_4", (String)"fi-cal-business", (Object[])new Object[0]), checkTimeStr, taskName, checkUserName);
        String otherTitle = ResManager.loadKDString((String)"\u201c%1$s\u201d\u5de1\u68c0\u201c%2$s\u201d\u53d1\u73b0\u6709\u201c%3$s\u201d\u6570\u636e\uff0c\u8bf7\u5904\u7406\u3002", (String)"DataCheckTaskExecutor_2", (String)"fi-cal-business", (Object[])new Object[0]);
        String otherMsg = ResManager.loadKDString((String)"\u201c%1$s\u201d\u5de1\u68c0\u201c%2$s\u201d\u53d1\u73b0\u6709\u201c%3$s\u201d\u6570\u636e\uff0c\u68c0\u67e5\u7528\u6237\u201c%4$s\u201d\u8bf7\u5230\u201c\u8d22\u52a1\u4e91>\u5b58\u8d27\u6838\u7b97>\u540e\u53f0\u76d1\u63a7>\u68c0\u67e5\u7ed3\u679c\u201d\u67e5\u770b\u8be6\u7ec6\u4fe1\u606f\u8fdb\u884c\u5904\u7406\u3002", (String)"DataCheckTaskExecutor_3", (String)"fi-cal-business", (Object[])new Object[0]);
        if (resultStatusSet.size() == 1 && resultStatusSet.contains(ResultStatus.SUCCESS.getValue())) {
            if (msgStatus.contains(ResultStatus.SUCCESS.getValue())) {
                isSend = true;
                msgTitle = successTitle;
                msgContent = successMsg;
            }
        } else {
            for (String resultStatus : resultStatusSet) {
                if (!msgStatus.contains(resultStatus)) continue;
                isSend = true;
                break;
            }
            if (isSend) {
                String levelName = "";
                if (resultStatusSet.contains(ResultStatus.EXCEPTION.getValue())) {
                    levelName = ResultStatus.EXCEPTION.getName();
                } else if (resultStatusSet.contains(ResultStatus.ERROR.getValue())) {
                    levelName = ResultStatus.ERROR.getName();
                } else if (resultStatusSet.contains(ResultStatus.WARNING.getValue())) {
                    levelName = ResultStatus.WARNING.getName();
                }
                msgTitle = String.format(otherTitle, checkTimeStr, taskName, levelName);
                msgContent = String.format(otherMsg, checkTimeStr, taskName, levelName, checkUserName);
            }
        }
        if (!isSend || msgTitle == null) {
            return;
        }
        MessageInfo msgInfo = new MessageInfo();
        msgInfo.setUserIds(Arrays.asList(msgReceiverIds.toArray(new Long[0])));
        msgInfo.setNotifyType(MessageChannels.MC.getNumber());
        msgInfo.setTitle(msgTitle);
        msgInfo.setContent(msgContent);
        String mobFormId = formId = "cal_datacheck_result";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("src", "cal");
        Map builMessageUrl = MessageCenterServiceHelper.builMessageUrl((String)formId, (String)mobFormId, (Long)resultId, paramMap);
        String url = (String)builMessageUrl.get("data");
        msgInfo.setContentUrl(url);
        msgInfo.setBizDataId(resultId);
        msgInfo.setEntityNumber(formId);
        MessageCenterServiceHelper.sendMessage((MessageInfo)msgInfo);
    }

    public void commit(final DataCheckTask task, final DataCheckParam param) {
        ThreadPools.executeOnce((String)"kd.fi.cal.business.datacheck.DataCheckTaskExecutor", (Runnable)new Runnable(){

            @Override
            public void run() {
                DataCheckTaskExecutor.this.commitSync(task, param);
            }
        });
    }
}

