/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.datacheck;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cal.business.datacheck.AlarmLevel;
import kd.fi.cal.business.datacheck.DataCheckTask;
import kd.fi.cal.business.datacheck.DataCheckTaskEntry;

public class DataCheckTaskFactory {
    public static DataCheckTask createDataCheckTask(Long taskId) {
        DynamicObject taskObj = BusinessDataServiceHelper.loadSingleFromCache((Object)taskId, (String)"cal_datacheck_task");
        if (taskObj == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5de1\u68c0\u8ba1\u5212\u8fd0\u884c\u5931\u8d25\uff0c\u8bf7\u5148\u9009\u62e9\u68c0\u67e5\u4efb\u52a1\u3002", (String)"DataCheckPlanRunPlugin_0", (String)"fi-cal-opplugin", (Object[])new Object[0]));
        }
        DataCheckTask task = new DataCheckTask();
        task.setTaskId(taskObj.getLong("id"));
        HashMap<Object, AlarmLevel> levelMap = new HashMap<Object, AlarmLevel>();
        for (DynamicObject taskEntryObj : taskObj.getDynamicObjectCollection("entryentity")) {
            if (!taskEntryObj.getBoolean("entryenable")) continue;
            levelMap.put(taskEntryObj.getDynamicObject("checkitem").getPkValue(), AlarmLevel.getByValue(taskEntryObj.getString("level")));
        }
        Map checkItemMap = BusinessDataServiceHelper.loadFromCache((String)"cal_datacheck_item", (String)"plugin,tips", (QFilter[])new QFilter("id", "in", levelMap.keySet()).toArray());
        for (Map.Entry checkItemEntry : checkItemMap.entrySet()) {
            DynamicObject checkItem = (DynamicObject)checkItemEntry.getValue();
            Long checkItemId = (Long)checkItemEntry.getKey();
            task.addDataCheckTaskEntry(new DataCheckTaskEntry(checkItemId, checkItem.getString("plugin"), checkItem.getString("tips"), (AlarmLevel)((Object)levelMap.get(checkItemId))));
        }
        return task;
    }
}

