/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.datacheck;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cal.business.datacheck.ExceptionObj;
import kd.fi.cal.business.datacheck.ResultStatus;
import kd.fi.cal.business.datacheck.item.IDataRepair;

public class DataRepairExecutor {
    private static final Log logger = LogFactory.getLog(DataRepairExecutor.class);

    public void repairErrorData(Long checkResultId) {
        DynamicObject checkResult = BusinessDataServiceHelper.loadSingle((Object)checkResultId, (String)"cal_datacheck_result", (String)"entryentity.checkitem.plugin,entryentity.checkitem.iserroritem,entryentity.entrystatus,entryentity.subentryentity.objid,entryentity.subentryentity.objtype,entryentity.subentryentity.objdes,entryentity.subentryentity.extralinfo,entryentity.subentryentity.isrepaired");
        this.repairErrorData(checkResult);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{checkResult});
    }

    public void repairErrorData(DynamicObject checkResult) {
        for (DynamicObject resultEntry : checkResult.getDynamicObjectCollection("entryentity")) {
            if (!ResultStatus.ERROR.getValue().equals(resultEntry.getString("entrystatus"))) continue;
            IDataRepair repair = null;
            try {
                repair = this.createDataRepair(resultEntry.getDynamicObject("checkitem").getString("plugin"));
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                logger.error("\u521d\u59cb\u5316\u6570\u636e\u4fee\u590d\u63d2\u4ef6\u51fa\u73b0\u5f02\u5e38" + e.getClass().getName() + ":", (Throwable)e);
                continue;
            }
            ArrayList<ExceptionObj> exObjList = new ArrayList<ExceptionObj>();
            for (DynamicObject resultDetail : resultEntry.getDynamicObjectCollection("subentryentity")) {
                if (resultDetail.getBoolean("isrepaired")) continue;
                ExceptionObj obj = new ExceptionObj(resultDetail.getLong("objid"), resultDetail.getString("objtype"));
                obj.setDescription(resultDetail.getString("objdes"));
                obj.setExtralInfo(resultDetail.getString("extralinfo"));
                exObjList.add(obj);
                resultDetail.set("isrepaired", (Object)true);
            }
            if (exObjList.size() > 0) {
                repair.dealExceptionObj(exObjList);
            }
            resultEntry.set("entrystatus", (Object)ResultStatus.REPAIRED.getValue());
        }
    }

    public void repairErrorData(String plugin, List<ExceptionObj> exObjList) {
        IDataRepair repair = null;
        try {
            repair = this.createDataRepair(plugin);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            logger.error("\u521d\u59cb\u5316\u6570\u636e\u4fee\u590d\u63d2\u4ef6\u51fa\u73b0\u5f02\u5e38" + e.getClass().getName() + ":", (Throwable)e);
            String msg = String.format(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u6570\u636e\u4fee\u590d\u63d2\u4ef6\u201c%1$s\u201d\u51fa\u73b0\u5f02\u5e38\uff0c\u8be6\u60c5\u8bf7\u8054\u7cfb\u5f00\u53d1\u4eba\u5458\u67e5\u770b\u540e\u53f0\u65e5\u5fd7\u5206\u6790\u3002", (String)"DataRepairExecutor_2", (String)"fi-cal-business", (Object[])new Object[0]), plugin);
            throw new KDBizException(msg);
        }
        repair.dealExceptionObj(exObjList);
    }

    private IDataRepair createDataRepair(String plugin) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class<?> clazz = Class.forName(plugin);
        IDataRepair obj = (IDataRepair)clazz.newInstance();
        return obj;
    }
}

