/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.datacheck.helper;

import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.fi.cal.business.datacheck.DataCheckParam;

public class DiffAllocationCheckHelper {
    public static String getSelectFieldsStr(String billEntityNumber, String fields, String preFlag, Integer type) {
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)billEntityNumber);
        StringBuilder sb = new StringBuilder();
        for (String field : fields.split(",")) {
            IDataEntityProperty property = entityType.findProperty(field);
            if (property == null) continue;
            IDataEntityType parentProp = property.getParent();
            boolean isEntryProp = parentProp instanceof EntryType;
            sb.append(',');
            if (isEntryProp) {
                sb.append(parentProp.getName());
                sb.append('.');
            }
            sb.append(field);
            if (type != 1) continue;
            sb.append(" as ");
            sb.append(preFlag);
            sb.append(field);
        }
        return sb.substring(1);
    }

    public static Set<Long> getAllValidCostAccount() {
        QFilter filter = new QFilter("status", "=", (Object)"C");
        filter.and("enable", "=", (Object)true);
        DynamicObject[] costAccountCol = BusinessDataServiceHelper.load((String)"cal_bd_costaccount", (String)"id", (QFilter[])filter.toArray());
        HashSet<Long> costAccount = new HashSet<Long>(costAccountCol.length);
        for (DynamicObject costAccountObj : costAccountCol) {
            costAccount.add(costAccountObj.getLong("id"));
        }
        return costAccount;
    }

    public static QFilter getCommonFilter(String entityNum, DataCheckParam param, Long costAccount) {
        QFilter filter = null;
        filter = costAccount == null ? new QFilter("id", "=", (Object)-1) : new QFilter(DiffAllocationCheckHelper.getSelectFieldsStr(entityNum, "costaccount", "", 0), "=", (Object)costAccount);
        if (param.getStorageOrgUnit() != null && !param.getStorageOrgUnit().isEmpty()) {
            filter.and(DiffAllocationCheckHelper.getSelectFieldsStr(entityNum, "storageorgunit", "", 0), "in", param.getStorageOrgUnit());
        }
        if (param.getMaterial() != null && !param.getMaterial().isEmpty()) {
            filter.and(DiffAllocationCheckHelper.getSelectFieldsStr(entityNum, "material", "", 0), "in", param.getMaterial());
        }
        if (param.getWarehouse() != null && !param.getWarehouse().isEmpty()) {
            filter.and(DiffAllocationCheckHelper.getSelectFieldsStr(entityNum, "warehouse", "", 0), "in", param.getWarehouse());
        }
        if (param.getLocation() != null && !param.getLocation().isEmpty()) {
            filter.and(DiffAllocationCheckHelper.getSelectFieldsStr(entityNum, "location", "", 0), "in", param.getLocation());
        }
        if (param.getInvtype() != null && !param.getInvtype().isEmpty()) {
            filter.and(DiffAllocationCheckHelper.getSelectFieldsStr(entityNum, "invtype", "", 0), "in", param.getInvtype());
        }
        if (param.getInvstatus() != null && !param.getInvstatus().isEmpty()) {
            filter.and(DiffAllocationCheckHelper.getSelectFieldsStr(entityNum, "invstatus", "", 0), "in", param.getInvstatus());
        }
        if (param.getProject() != null && !param.getProject().isEmpty()) {
            filter.and(DiffAllocationCheckHelper.getSelectFieldsStr(entityNum, "project", "", 0), "in", param.getProject());
        }
        return filter;
    }
}

