/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.datacheck.helper;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.OrmInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.business.datacheck.DataCheckParam;
import kd.fi.cal.business.datacheck.ExceptionObj;
import kd.fi.cal.common.helper.PeriodHelper;

public class InvBillCloseAccountCheckHelper {
    public Map<String, Map<Long, Date>> getBeginEndDateMap(DataCheckParam param, Set<Long> ownerIds) {
        Date startDate = param.getStartDate();
        Date endDate = param.getEndDate();
        if (ownerIds == null) {
            ownerIds = new HashSet<Long>(16);
        }
        HashMap<String, Map<Long, Date>> startEndDateMap = new HashMap<String, Map<Long, Date>>(16);
        HashMap<Long, Date> beginDateMap = new HashMap<Long, Date>(16);
        HashMap<Long, Date> endDateMap = new HashMap<Long, Date>(16);
        if (startDate == null && endDate == null) {
            DynamicObjectCollection costAccounts;
            Set<Long> accountIds = param.getCostAccount();
            if (accountIds == null || accountIds.isEmpty()) {
                QFilter q = new QFilter("enable", "=", (Object)"1");
                if (!ownerIds.isEmpty()) {
                    q.and("calorg", "in", ownerIds);
                }
                costAccounts = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"id,calorg", (QFilter[])q.toArray());
            } else {
                costAccounts = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"id,calorg", (QFilter[])new QFilter("id", "in", accountIds).toArray());
            }
            accountIds = new HashSet<Long>(16);
            for (DynamicObject costAccount : costAccounts) {
                accountIds.add(costAccount.getLong("id"));
            }
            if (accountIds.isEmpty()) {
                return startEndDateMap;
            }
            Map accountCrtPeriodMap = PeriodHelper.getCurrentPeriods(accountIds);
            ownerIds.clear();
            for (DynamicObject costAccount : costAccounts) {
                Long accountId = costAccount.getLong("id");
                DynamicObject crtPeriod = (DynamicObject)accountCrtPeriodMap.get(accountId);
                if (crtPeriod == null) continue;
                Long orgId = costAccount.getLong("calorg");
                ownerIds.add(orgId);
                Date orgBeginDate = (Date)beginDateMap.get(orgId);
                Date orgEndDate = (Date)endDateMap.get(orgId);
                Date crtBeginDate = crtPeriod.getDate("begindate");
                Date crtEndDate = crtPeriod.getDate("enddate");
                if (orgBeginDate == null) {
                    orgBeginDate = crtBeginDate;
                } else if (orgBeginDate.after(crtBeginDate)) {
                    orgBeginDate = crtBeginDate;
                }
                if (orgEndDate == null) {
                    orgEndDate = crtEndDate;
                } else if (orgEndDate.before(crtEndDate)) {
                    orgEndDate = crtEndDate;
                }
                beginDateMap.put(orgId, orgBeginDate);
                endDateMap.put(orgId, orgEndDate);
            }
            startEndDateMap.put("startdate", beginDateMap);
            startEndDateMap.put("enddate", endDateMap);
        }
        return startEndDateMap;
    }

    public void addExpObjByInvInterfaceResult(Map map, List<ExceptionObj> exceptiodObjList, String errorString) {
        ArrayList<OrmInput> rangesIO = new ArrayList<OrmInput>(16);
        RowMeta rowMeta = new RowMeta(new Field[]{new Field("billno", (DataType)DataType.StringType), new Field("bizobject", (DataType)DataType.StringType)});
        for (Map.Entry entry : map.entrySet()) {
            String entityNum = (String)entry.getKey();
            Set billIdSet = (Set)entry.getValue();
            QFilter billQ = new QFilter("id", "in", (Object)billIdSet);
            OrmInput rangeIO = new OrmInput(this.getClass().getName(), entityNum, "billno,'" + entityNum + "' as bizobject", billQ.toArray(), rowMeta);
            rangesIO.add(rangeIO);
        }
        Algo algo = Algo.create((String)this.getClass().getName());
        DataSet invDataSet = algo.createDataSet((Input[])rangesIO.toArray(new OrmInput[rangesIO.size()]));
        invDataSet = invDataSet.orderBy(new String[]{"bizobject"});
        for (Row row : invDataSet) {
            String entityNum = row.getString("bizobject");
            String billNo = row.getString("billno");
            ExceptionObj exceptionObj = new ExceptionObj(0L, entityNum);
            exceptionObj.setDescription(errorString + billNo);
            exceptiodObjList.add(exceptionObj);
        }
    }
}

