/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.datacheck.item;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.business.calculate.billgroup.CostAccountGroupRecordHelper;
import kd.fi.cal.business.datacheck.DataCheckParam;
import kd.fi.cal.business.datacheck.ExceptionObj;
import kd.fi.cal.business.datacheck.item.IDataCheck;
import kd.fi.cal.business.datacheck.item.IDataRepair;
import kd.fi.cal.common.helper.AcctGroupModelHelper;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.common.util.CommonUtils;

public class AcctBillGroupRecordCheck
implements IDataRepair,
IDataCheck {
    private static final String DLOCK_KEY = "cal_CheckAcctBillGrouploc#";

    @Override
    public void dealExceptionObj(List<ExceptionObj> exceptionList) {
        try (TXHandle handler = TX.requiresNew();){
            new CostAccountGroupRecordHelper().refreshGroupRecordByTime();
        }
    }

    @Override
    public List<ExceptionObj> collectExceptionObj(List<DataCheckParam> paramList) {
        ArrayList<ExceptionObj> finalExceptionList = new ArrayList<ExceptionObj>(16);
        if (AcctGroupModelHelper.isNewGroupModel()) {
            return finalExceptionList;
        }
        for (DataCheckParam param : paramList) {
            ArrayList<ExceptionObj> exceptionObjList = new ArrayList<ExceptionObj>(16);
            List<ExceptionObj> exceptionObj = this.collectExceptionObj(param);
            if (exceptionObj != null && !exceptionObj.isEmpty()) {
                exceptionObjList.addAll(exceptionObj);
            }
            HashSet<String> descSet = new HashSet<String>(16);
            for (ExceptionObj obj : exceptionObjList) {
                String desc = obj.getDescription();
                if (descSet.contains(desc)) continue;
                descSet.add(desc);
                finalExceptionList.add(obj);
            }
        }
        return finalExceptionList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ExceptionObj> collectExceptionObj(DataCheckParam param) {
        DLock lock = null;
        ArrayList<ExceptionObj> exceptions = null;
        if (AcctGroupModelHelper.isNewGroupModel()) {
            return exceptions;
        }
        try {
            ExceptionObj exception;
            String errorMsg;
            lock = DLock.create((String)DLOCK_KEY);
            if (!lock.tryLock()) {
                ArrayList<ExceptionObj> arrayList = exceptions;
                return arrayList;
            }
            this.repairGroupRecord(param.getCostAccount());
            HashMap<Long, String> costAccoutNameMap = new HashMap<Long, String>(16);
            Set<Long> costAccountIds = param.getCostAccount();
            Set<Long> calorgIds = param.getCalorg();
            QFilter filter = new QFilter("enable", "=", (Object)"1");
            if (costAccountIds != null && !costAccountIds.isEmpty()) {
                filter.and("id", "in", costAccountIds);
            }
            if (calorgIds != null && calorgIds.size() > 0) {
                filter.and("calorg", "in", calorgIds);
            }
            DynamicObjectCollection costAccounts = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"id,number", (QFilter[])filter.toArray());
            costAccountIds = new HashSet<Long>(costAccounts.size());
            for (DynamicObject costaccount : costAccounts) {
                costAccountIds.add(costaccount.getLong("id"));
                costAccoutNameMap.put(costaccount.getLong("id"), costaccount.getString("number"));
            }
            StringBuilder strCostAccountIds = new StringBuilder();
            int mark = 1;
            for (Long costAccountId : costAccountIds) {
                if (mark == 1) {
                    strCostAccountIds.append(costAccountId);
                } else {
                    strCostAccountIds.append(",").append(costAccountId);
                }
                ++mark;
            }
            Date beginDate = new Date();
            Date endDate = new Date();
            Object[] dates = new Object[2];
            HashSet notInitCostAccounts = new HashSet(16);
            for (Long costAccountId : costAccountIds) {
                DynamicObject period = PeriodHelper.getCurrentPeriod((Long)costAccountId);
                if (period == null) {
                    notInitCostAccounts.add(costAccoutNameMap.get(costAccountId));
                    continue;
                }
                if (period.getDate("begindate").before(beginDate)) {
                    beginDate = period.getDate("begindate");
                }
                if (!period.getDate("enddate").after(endDate)) continue;
                endDate = period.getDate("enddate");
            }
            dates[0] = beginDate;
            dates[1] = endDate;
            String checkSql = "select count(1) as fcount from t_cal_groupbillrecord g inner join t_cal_grouprecordentry ge on g.fid = ge.fid left join t_cal_accountgrouprecord ag  on ag.fbizgrouprecordid = g.fid left join t_cal_calcostrecord cr on ge.fbillid = cr.fcalbillid where ag.fid is null and ge.fbookdate >= ? and ge.fbookdate < ? and cr.fbillstatus = 'C' and cr.fcostaccountid in (" + strCostAccountIds + ")";
            DataSet errorData = DB.queryDataSet((String)"", (DBRoute)CommonUtils.getCalDBRouteKey(), (String)checkSql, (Object[])dates);
            int errorCount = 0;
            if (!errorData.isEmpty()) {
                for (Row row : errorData) {
                    errorCount = row.getInteger("fcount");
                }
            }
            if (errorCount != 0) {
                errorMsg = String.format(ResManager.loadKDString((String)"\u5b58\u5728%1$s\u6761\u8d26\u7c3f\u7ea7\u6210\u7ec4\u5173\u7cfb\u6709\u95ee\u9898\uff0c\u8bf7\u8054\u7cfb\u7814\u53d1\u4eba\u5458\u8fdb\u884c\u4fee\u590d\u3002", (String)"AcctBillGroupRecordCheck_3", (String)"fi-cal-business", (Object[])new Object[0]), errorCount);
                exception = new ExceptionObj(0L, "cal_account_grouprecord");
                exception.setDescription(errorMsg);
                exceptions = new ArrayList(2);
                exceptions.add(exception);
            }
            if (!notInitCostAccounts.isEmpty()) {
                if (exceptions == null) {
                    exceptions = new ArrayList(2);
                }
                errorMsg = ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u201c{0}\u201d\u672a\u7ed3\u675f\u521d\u59cb\u5316\u3002", (String)"AcctBillGroupRecordCheck_1", (String)"fi-cal-business", (Object[])new Object[0]);
                errorMsg = MessageFormat.format(errorMsg, String.join((CharSequence)"\u3011,\u3010", notInitCostAccounts));
                exception = new ExceptionObj(0L, "cal_account_grouprecord");
                exception.setDescription(errorMsg);
                exceptions.add(exception);
            }
        }
        catch (Throwable e) {
            String msg = CommonUtils.getLogMessage((Throwable)e, (int)160);
            exceptions = new ArrayList<ExceptionObj>(1);
            ExceptionObj exception = new ExceptionObj(0L, "cal_account_grouprecord");
            exception.setDescription(msg);
            exceptions.add(exception);
        }
        finally {
            if (lock != null) {
                lock.close();
            }
        }
        return exceptions;
    }

    private void repairGroupRecord(Set<Long> costAccounts) {
        QFilter filter = new QFilter("entry.costaccount.enable", "=", (Object)"1");
        filter.and("entry.isenabled", "=", (Object)true);
        if (costAccounts != null && !costAccounts.isEmpty()) {
            filter.and("entry.costaccount.id", "in", costAccounts);
        }
        HashSet<String> costAccountIds = new HashSet<String>(16);
        HashSet<String> periodIdStr = new HashSet<String>(16);
        Date mindate = null;
        Date maxdate = null;
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_sysctrlentity", (String)"entry.costaccount,entry.currentperiod.enddate,entry.currentperiod.begindate,entry.currentperiod", (QFilter[])filter.toArray(), null);){
            for (Row row : ds) {
                costAccountIds.add(row.getString("entry.costaccount"));
                periodIdStr.add(row.getString("entry.currentperiod"));
                Date begindate = row.getDate("entry.currentperiod.begindate");
                Date enddate = row.getDate("entry.currentperiod.enddate");
                if (mindate == null || mindate.after(begindate)) {
                    mindate = begindate;
                }
                if (maxdate != null && !maxdate.before(enddate)) continue;
                maxdate = enddate;
            }
        }
        mindate = new Date(0L);
        new CostAccountGroupRecordHelper().repairAndRefreshGroupRecordByTime(costAccountIds, periodIdStr, mindate, maxdate);
    }
}

