/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.datacheck.item;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.business.datacheck.DataCheckParam;
import kd.fi.cal.business.datacheck.ExceptionObj;
import kd.fi.cal.business.datacheck.item.DataEntityDataCheck;
import kd.fi.cal.common.helper.AccountingSysHelper;
import kd.fi.cal.common.helper.PeriodHelper;

public class ApCloseAccountDataCheck
extends DataEntityDataCheck {
    private boolean isEmptyAccount = false;
    private Map<Long, String> orgNameMap = new HashMap<Long, String>(16);
    private Set<Long> allOwnerIds = new HashSet<Long>(16);
    Map<Long, Set<Long>> calOrgAndOwnerMap = new HashMap<Long, Set<Long>>(16);
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");

    @Override
    protected String getDataEntityType() {
        return "cal_costrecord_subentity";
    }

    @Override
    protected Set<String> getSelectedFields() {
        return null;
    }

    @Override
    public List<ExceptionObj> collectExceptionObj(DataCheckParam param) {
        ArrayList<ExceptionObj> exceptiodObjList = new ArrayList<ExceptionObj>(16);
        Set<Long> orgIds = param.getCalorg();
        Set<Long> accountIds = param.getCostAccount();
        List<Object> orgIdList = new ArrayList(16);
        boolean bl = this.isEmptyAccount = accountIds == null || accountIds.isEmpty();
        if (!this.isEmptyAccount) {
            HashMap<Long, Long> orgAndAccountMap = new HashMap<Long, Long>(16);
            HashMap<Long, String> accountNameMap = new HashMap<Long, String>(16);
            HashSet<Long> accountIdSet = new HashSet<Long>(16);
            DataSet accountDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_bd_costaccount", (String)"calorg,calorg.name as calorgname,id,name as accountname", (QFilter[])new QFilter("id", "in", accountIds).toArray(), null);
            for (Row row : accountDs.copy()) {
                orgIdList.add(row.getLong("calorg"));
                accountIdSet.add(row.getLong("id"));
                orgAndAccountMap.put(row.getLong("calorg"), row.getLong("id"));
                accountNameMap.put(row.getLong("id"), row.getString("accountname"));
            }
            this.initCalOrgOwnerMap(orgIdList);
            if (this.calOrgAndOwnerMap.isEmpty()) {
                return exceptiodObjList;
            }
            Map accountPeriodMap = PeriodHelper.getCurrentPeriods(accountIdSet);
            Map<Long, Date> aporgCloseDateMap = this.getApOrgCloseDate();
            for (Map.Entry<Long, Set<Long>> calOrgAndOwnerEntry : this.calOrgAndOwnerMap.entrySet()) {
                Long accountOrgId = calOrgAndOwnerEntry.getKey();
                Long accountId = (Long)orgAndAccountMap.get(accountOrgId);
                Set<Long> owners = calOrgAndOwnerEntry.getValue();
                for (Long owner : owners) {
                    Date calCrtDate;
                    DynamicObject crtPeriod = (DynamicObject)accountPeriodMap.get(orgAndAccountMap.get(accountOrgId));
                    Date apCloseDate = aporgCloseDateMap.get(owner);
                    if (apCloseDate == null) {
                        apCloseDate = aporgCloseDateMap.get(accountOrgId);
                    }
                    if (crtPeriod == null || apCloseDate == null || (calCrtDate = crtPeriod.getDate("begindate")).before(apCloseDate)) continue;
                    ExceptionObj exceptionObj = new ExceptionObj(0L, "");
                    String errorMsg = String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u3010%1$s\u3011\u8bb0\u8d26\u8303\u56f4\u4e0b\u7ed3\u7b97\u7ec4\u7ec7\u3010%2$s\u3011\u5e94\u4ed8\u672a\u5173\u8d26\uff0c\u6210\u672c\u8d26\u7c3f\u3010%3$s\u3011\u5f53\u524d\u671f\u95f4\u7b2c\u4e00\u5929\u3010%4$s\u3011\uff0c\u5e94\u4ed8\u5173\u8d26\u65e5\u671f\u3010%5$s\u3011\u3002", (String)"ApCloseAccountDataCheck_1", (String)"fi-cal-business", (Object[])new Object[0]), this.orgNameMap.get(accountOrgId), this.orgNameMap.get(owner), accountNameMap.get(accountId), this.sdf.format(calCrtDate), this.sdf.format(apCloseDate));
                    exceptionObj.setDescription(errorMsg);
                    exceptiodObjList.add(exceptionObj);
                }
            }
        } else {
            if (orgIds == null || orgIds.isEmpty()) {
                orgIdList = this.getAllOrgs();
            } else {
                orgIdList.addAll(orgIds);
            }
            if (orgIdList == null || orgIdList.isEmpty()) {
                return exceptiodObjList;
            }
            QFilter accountQ = new QFilter("calorg", "in", orgIdList);
            accountQ.and("enable", "=", (Object)Boolean.TRUE);
            DataSet enableAccountDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_bd_costaccount", (String)"calorg", (QFilter[])accountQ.toArray(), null);
            orgIdList = new ArrayList(16);
            for (Row row : enableAccountDs) {
                orgIdList.add(row.getLong("calorg"));
            }
            if (orgIdList == null || orgIdList.isEmpty()) {
                return exceptiodObjList;
            }
            this.initCalOrgOwnerMap(orgIdList);
            if (this.calOrgAndOwnerMap.isEmpty()) {
                return exceptiodObjList;
            }
            HashMap<Long, Date> ownerCloseDateMap = new HashMap<Long, Date>(16);
            HashMap<Long, String> ownerAccountNameMap = new HashMap<Long, String>(16);
            this.getMainAccountCrtPeriod(this.allOwnerIds, ownerCloseDateMap, ownerAccountNameMap);
            if (ownerCloseDateMap.isEmpty()) {
                return exceptiodObjList;
            }
            Map<Long, Date> aporgCloseDateMap = this.getApOrgCloseDate();
            for (Map.Entry<Long, Set<Long>> calOrgAndOwnerEntry : this.calOrgAndOwnerMap.entrySet()) {
                Long accountOrgId = calOrgAndOwnerEntry.getKey();
                Set<Long> owners = calOrgAndOwnerEntry.getValue();
                for (Long owner : owners) {
                    String errorMsg;
                    ExceptionObj exceptionObj;
                    Date calCloseDate;
                    if (owner.compareTo(accountOrgId) == 0) {
                        calCloseDate = (Date)ownerCloseDateMap.get(owner);
                        Date apCloseDate = aporgCloseDateMap.get(owner);
                        if (apCloseDate == null || calCloseDate == null || calCloseDate.before(apCloseDate)) continue;
                        ExceptionObj exceptionObj2 = new ExceptionObj(0L, "");
                        String errorMsg2 = String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u3010%1$s\u3011\u8bb0\u8d26\u8303\u56f4\u4e0b\u7ed3\u7b97\u7ec4\u7ec7\u3010%2$s\u3011\u5e94\u4ed8\u672a\u5173\u8d26\uff0c\u6838\u7b97\u4e3b\u8d26\u7c3f\u5f53\u524d\u671f\u95f4\u7b2c\u4e00\u5929\u3010%3$s\u3011\uff0c\u5e94\u4ed8\u5173\u8d26\u65e5\u671f\u3010%4$s\u3011\u3002", (String)"ApCloseAccountDataCheck_0", (String)"fi-cal-business", (Object[])new Object[0]), this.orgNameMap.get(owner), this.orgNameMap.get(owner), this.sdf.format(calCloseDate), this.sdf.format(apCloseDate));
                        exceptionObj2.setDescription(errorMsg2);
                        exceptiodObjList.add(exceptionObj2);
                        continue;
                    }
                    calCloseDate = (Date)ownerCloseDateMap.get(accountOrgId);
                    Date ownerCloseDate = (Date)ownerCloseDateMap.get(owner);
                    Date apCloseDate = aporgCloseDateMap.get(owner);
                    if (apCloseDate == null) {
                        apCloseDate = aporgCloseDateMap.get(accountOrgId);
                    }
                    if (apCloseDate != null && calCloseDate != null && !calCloseDate.before(apCloseDate)) {
                        exceptionObj = new ExceptionObj(0L, "");
                        errorMsg = String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u3010%1$s\u3011\u8bb0\u8d26\u8303\u56f4\u4e0b\u7ed3\u7b97\u7ec4\u7ec7\u3010%2$s\u3011\u5e94\u4ed8\u672a\u5173\u8d26\uff0c\u6210\u672c\u8d26\u7c3f\u3010%3$s\u3011\u5f53\u524d\u671f\u95f4\u7b2c\u4e00\u5929\u3010%4$s\u3011\uff0c\u5e94\u4ed8\u5173\u8d26\u65e5\u671f\u3010%5$s\u3011\u3002", (String)"ApCloseAccountDataCheck_1", (String)"fi-cal-business", (Object[])new Object[0]), this.orgNameMap.get(accountOrgId), this.orgNameMap.get(owner), ownerAccountNameMap.get(accountOrgId), this.sdf.format(calCloseDate), this.sdf.format(apCloseDate));
                        exceptionObj.setDescription(errorMsg);
                        exceptiodObjList.add(exceptionObj);
                    }
                    if (apCloseDate == null || ownerCloseDate == null || ownerCloseDate.before(apCloseDate)) continue;
                    exceptionObj = new ExceptionObj(0L, "");
                    errorMsg = String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u3010%1$s\u3011\u8bb0\u8d26\u8303\u56f4\u4e0b\u7ed3\u7b97\u7ec4\u7ec7\u3010%2$s\u3011\u5e94\u4ed8\u672a\u5173\u8d26\uff0c\u6210\u672c\u8d26\u7c3f\u3010%3$s\u3011\u5f53\u524d\u671f\u95f4\u7b2c\u4e00\u5929\u3010%4$s\u3011\uff0c\u5e94\u4ed8\u5173\u8d26\u65e5\u671f\u3010%5$s\u3011\u3002", (String)"ApCloseAccountDataCheck_1", (String)"fi-cal-business", (Object[])new Object[0]), this.orgNameMap.get(accountOrgId), this.orgNameMap.get(owner), ownerAccountNameMap.get(owner), this.sdf.format(ownerCloseDate), this.sdf.format(apCloseDate));
                    exceptionObj.setDescription(errorMsg);
                    exceptiodObjList.add(exceptionObj);
                }
            }
        }
        return exceptiodObjList;
    }

    @Override
    public List<ExceptionObj> collectExceptionObj(DataSet dataSet, DataCheckParam param) {
        return null;
    }

    private Map<Long, Date> getApOrgCloseDate() {
        HashMap<Long, Date> aporgCloseDateMap = new HashMap<Long, Date>(16);
        QFilter apQFilter = new QFilter("isfinishinit", "=", (Object)true);
        apQFilter.and("org", "in", this.allOwnerIds);
        DataSet apCloseTableDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"ap_closeaccount", (String)"org.id as orgid,org.name as orgname,currentdate", (QFilter[])apQFilter.toArray(), null);
        for (Row row : apCloseTableDs) {
            aporgCloseDateMap.put(row.getLong("orgid"), row.getDate("currentdate"));
        }
        return aporgCloseDateMap;
    }

    private void initCalOrgOwnerMap(List<Long> orgIdList) {
        Set<Long> ownerIdSet;
        String calorgName;
        String ownerName;
        Long calorgId;
        Long ownerId;
        DynamicObjectCollection accSysColl = AccountingSysHelper.getAccountingSysColls(orgIdList, null);
        DataSet ownerAccountDs = AccountingSysHelper.getAccountingSysDataSetByOwners(orgIdList);
        for (DynamicObject accSysInfo : accSysColl) {
            ownerId = accSysInfo.getLong("ownerid");
            calorgId = accSysInfo.getLong("calorgid");
            ownerName = accSysInfo.getString("ownername");
            calorgName = accSysInfo.getString("calorgname");
            ownerIdSet = this.calOrgAndOwnerMap.get(calorgId);
            if (ownerIdSet == null) {
                ownerIdSet = new HashSet<Long>(16);
            }
            this.allOwnerIds.add(ownerId);
            this.allOwnerIds.add(calorgId);
            ownerIdSet.add(ownerId);
            ownerIdSet.add(calorgId);
            this.calOrgAndOwnerMap.put(calorgId, ownerIdSet);
            this.orgNameMap.put(ownerId, ownerName);
            this.orgNameMap.put(calorgId, calorgName);
        }
        for (Row row : ownerAccountDs) {
            ownerId = row.getLong("owner");
            calorgId = row.getLong("calorgid");
            ownerName = row.getString("ownername");
            calorgName = row.getString("calorgname");
            ownerIdSet = this.calOrgAndOwnerMap.get(calorgId);
            if (ownerIdSet == null) {
                ownerIdSet = new HashSet<Long>(16);
            }
            this.allOwnerIds.add(ownerId);
            this.allOwnerIds.add(calorgId);
            ownerIdSet.add(ownerId);
            ownerIdSet.add(calorgId);
            this.calOrgAndOwnerMap.put(calorgId, ownerIdSet);
            this.orgNameMap.put(ownerId, ownerName);
            this.orgNameMap.put(calorgId, calorgName);
        }
    }

    private void getMainAccountCrtPeriod(Set<Long> orgIds, Map<Long, Date> calorgCloseDateMap, Map<Long, String> ownerAccountNameMap) {
        QFilter filter = new QFilter("org", "in", orgIds);
        filter.and("entry.costaccount.ismainaccount", "=", (Object)Boolean.TRUE);
        String fields = "org,entry.currentperiod.begindate,entry.costaccount.name";
        DataSet sysPeriod = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_sysctrlentity", (String)fields, (QFilter[])new QFilter[]{filter}, null);
        for (Row row : sysPeriod) {
            Long orgId = row.getLong("org");
            calorgCloseDateMap.put(orgId, row.getDate("entry.currentperiod.begindate"));
            ownerAccountNameMap.put(orgId, row.getString("entry.costaccount.name"));
        }
    }

    private List<Long> getAllOrgs() {
        ArrayList<Long> orgIds = new ArrayList<Long>(16);
        QFilter q = new QFilter("ismainaccount", "=", (Object)Boolean.TRUE);
        q.and("enable", "=", (Object)Boolean.TRUE);
        DataSet accountDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_bd_costaccount", (String)"calorg", (QFilter[])q.toArray(), null);
        accountDs = accountDs.groupBy(new String[]{"calorg"}).finish();
        for (Row row : accountDs) {
            orgIds.add(row.getLong("calorg"));
        }
        return orgIds;
    }
}

