/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.datacheck.item;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.fi.cal.business.balance.BalanceDimFieldParser;
import kd.fi.cal.business.datacheck.DataCheckParam;
import kd.fi.cal.business.datacheck.item.DataEntityDataCheck;
import kd.fi.cal.common.constant.DataCheckConstant;

public abstract class BalanceDataCheck
extends DataEntityDataCheck {
    protected final BalanceDimFieldParser parser = new BalanceDimFieldParser();

    @Override
    protected String getDataEntityType() {
        if (this.isNewBalance) {
            return "cal_bal";
        }
        return "cal_balance";
    }

    @Override
    protected Set<String> getSelectedFields() {
        Set<String> fields = this.parser.getBalanceFields(true, true);
        this.addSelectedFields(fields);
        return fields;
    }

    protected void addSelectedFields(Set<String> fields) {
    }

    @Override
    protected QFilter analyseCostAccountFilter(DataCheckParam param) {
        IDataEntityProperty accountProperty = this.entityType.findProperty("costaccount");
        Set<Long> costaccount = param.getCostAccount();
        if (accountProperty == null) {
            return null;
        }
        if (costaccount == null || costaccount.isEmpty()) {
            costaccount = this.getAllValidCostAccount();
        }
        ArrayList<QFilter> fList = new ArrayList<QFilter>(costaccount.size());
        String costAccountName = this.analyseFieldName(accountProperty);
        for (Long costAccountId : costaccount) {
            QFilter filter = new QFilter(costAccountName, "=", (Object)costAccountId);
            DynamicObject period = this.getCurrentPeriod(costAccountId);
            if (period == null) continue;
            filter = filter.and("period", "=", (Object)(period.getInt("periodyear") * 100 + period.getInt("periodnumber")));
            fList.add(filter);
        }
        if (fList.isEmpty()) {
            return new QFilter("id", "=", (Object)0);
        }
        QFilter firstFilter = (QFilter)fList.get(0);
        for (int i = 1; i < fList.size(); ++i) {
            firstFilter = firstFilter.or((QFilter)fList.get(i));
        }
        return firstFilter;
    }

    protected StringBuilder getExceptionDesc(Row row, StringBuilder middle, boolean balDetailCheck) {
        StringBuilder exceptionDesc = new StringBuilder();
        if (!balDetailCheck) {
            exceptionDesc.append(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\uff1a", (String)"BalanceDataCheck_2", (String)"fi-cal-business", (Object[])new Object[0])).append(row.get("calorgnumber")).append("+").append(row.get("calorgname")).append(DataCheckConstant.SEPERATOR);
        }
        exceptionDesc.append(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\uff1a", (String)"BalanceDataCheck_3", (String)"fi-cal-business", (Object[])new Object[0])).append(row.get("costaccountnumber")).append("+").append(row.get("costaccountname")).append(DataCheckConstant.SEPERATOR);
        exceptionDesc.append(ResManager.loadKDString((String)"\u671f\u95f4\uff1a", (String)"BalanceDataCheck_0", (String)"fi-cal-business", (Object[])new Object[0]));
        Integer period = row.getInteger("period");
        if (period == null || period == 0) {
            exceptionDesc.append(this.getNullZhString());
        } else {
            exceptionDesc.append(period).append(DataCheckConstant.SEPERATOR);
        }
        exceptionDesc.append(ResManager.loadKDString((String)"\u7269\u6599\uff1a", (String)"BalanceDataCheck_4", (String)"fi-cal-business", (Object[])new Object[0])).append(row.get("materialnumber")).append("+").append(row.get("materialname")).append(DataCheckConstant.SEPERATOR);
        if (middle != null) {
            exceptionDesc.append(", ");
            exceptionDesc.append((CharSequence)middle);
        }
        if (!balDetailCheck) {
            Object fieldValue;
            exceptionDesc.append(ResManager.loadKDString((String)"\u5176\u4ed6\u4fe1\u606f\uff1a", (String)"BalanceDataCheck_5", (String)"fi-cal-business", (Object[])new Object[0]));
            LinkedHashMap sortMap = new LinkedHashMap();
            sortMap.put(ResManager.loadKDString((String)"\u5e93\u5b58\u7ec4\u7ec7", (String)"BalanceDataCheck_6", (String)"fi-cal-business", (Object[])new Object[0]), null);
            sortMap.put(ResManager.loadKDString((String)"\u4ed3\u5e93", (String)"BalanceDataCheck_7", (String)"fi-cal-business", (Object[])new Object[0]), null);
            sortMap.put(ResManager.loadKDString((String)"\u4ed3\u4f4d", (String)"BalanceDataCheck_8", (String)"fi-cal-business", (Object[])new Object[0]), null);
            sortMap.put(ResManager.loadKDString((String)"\u5e93\u5b58\u7c7b\u578b", (String)"BalanceDataCheck_9", (String)"fi-cal-business", (Object[])new Object[0]), null);
            sortMap.put(ResManager.loadKDString((String)"\u5e93\u5b58\u72b6\u6001", (String)"BalanceDataCheck_10", (String)"fi-cal-business", (Object[])new Object[0]), null);
            Set<String> dimFields = this.parser.getDimFields();
            for (String string : dimFields) {
                if (string.equals("assist") || string.equals("owner") || string.equals("ownertype") || string.equals("costaccount") || string.equals("material") || (fieldValue = row.get(this.parser.getFieldDisplayField(string))) == null || fieldValue instanceof String && ((String)fieldValue).trim().isEmpty()) continue;
                String fieldDisplayName = this.parser.getFieldName(string);
                sortMap.put(fieldDisplayName, fieldValue);
            }
            for (Map.Entry entry : sortMap.entrySet()) {
                fieldValue = entry.getValue();
                if (fieldValue == null || fieldValue instanceof String && ((String)fieldValue).trim().isEmpty()) continue;
                exceptionDesc.append((String)entry.getKey()).append(DataCheckConstant.COLON_ZH).append(entry.getValue()).append(DataCheckConstant.SEPERATOR);
            }
        }
        return exceptionDesc;
    }

    private String getNullZhString() {
        return ResManager.loadKDString((String)"\u7a7a", (String)"BalanceDataCheck_1", (String)"fi-cal-business", (Object[])new Object[0]);
    }
}

