/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.datacheck.item;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.input.OrmInput;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.fi.cal.business.datacheck.DataCheckParam;
import kd.fi.cal.business.datacheck.ExceptionObj;
import kd.fi.cal.business.datacheck.item.BalanceDataCheck;
import kd.fi.cal.business.datacheck.item.IDataRepair;

public class BalanceDetailDataCheck
extends BalanceDataCheck
implements IDataRepair {
    @Override
    public void dealExceptionObj(List<ExceptionObj> exceptionList) {
    }

    @Override
    protected String getDataEntityType() {
        if (this.isNewBalance) {
            return "cal_bal";
        }
        return "cal_balance";
    }

    @Override
    protected Set<String> getSelectedFields() {
        Set<String> selectedFields = super.getSelectedFields();
        selectedFields.add("id");
        selectedFields.add("periodendactualcost");
        selectedFields.add("periodendstandardcost");
        return selectedFields;
    }

    @Override
    public List<ExceptionObj> collectExceptionObj(DataSet dataSet, DataCheckParam param) {
        if (this.isNewBalance) {
            return null;
        }
        ArrayList<ExceptionObj> list = new ArrayList<ExceptionObj>();
        ExceptionObj exceObj = null;
        JSONObject json = null;
        HashSet<Long> balids = new HashSet<Long>(16);
        for (Row row : dataSet.copy()) {
            balids.add(row.getLong("id"));
        }
        ArrayList<OrmInput> detailInputs = new ArrayList<OrmInput>(16);
        HashSet<Long> tempIds = new HashSet<Long>(16);
        for (Long balid : balids) {
            tempIds.add(balid);
            if (tempIds.size() <= 10000) continue;
            QFilter filter = new QFilter("balid", "in", tempIds);
            OrmInput input = new OrmInput(this.getClass().getName(), "cal_balance_detail", "id, balid, periodendactualcost as subactualcost, periodendstandardcost as substandardcost", filter.toArray());
            detailInputs.add(input);
            tempIds = new HashSet(10000);
        }
        if (!tempIds.isEmpty()) {
            QFilter filter = new QFilter("balid", "in", tempIds);
            OrmInput input = new OrmInput(this.getClass().getName(), "cal_balance_detail", "id, balid, periodendactualcost as subactualcost, periodendstandardcost as substandardcost", filter.toArray());
            detailInputs.add(input);
        }
        if (detailInputs.isEmpty()) {
            return list;
        }
        DataSet balanceDataSet = Algo.create((String)this.getClass().getName()).createDataSet(detailInputs.toArray(new Input[0])).groupBy("balid".split(",")).sum("subactualcost").sum("substandardcost").finish().select("balid, subactualcost, substandardcost");
        DataSet resultDataSet = dataSet.join(balanceDataSet, JoinType.LEFT).on("id", "balid").select(dataSet.getRowMeta().getFieldNames(), "subactualcost,substandardcost".split(",")).finish();
        for (Row row : resultDataSet) {
            StringBuilder middle;
            String s1;
            Long balid = row.getLong("id");
            BigDecimal actualcost = BigDecimal.ZERO;
            BigDecimal subactualcost = BigDecimal.ZERO;
            BigDecimal standardcost = BigDecimal.ZERO;
            BigDecimal substandardcost = BigDecimal.ZERO;
            if (row.getBigDecimal("periodendactualcost") != null) {
                actualcost = row.getBigDecimal("periodendactualcost");
            }
            if (row.getBigDecimal("subactualcost") != null) {
                subactualcost = row.getBigDecimal("subactualcost");
            }
            if (row.getBigDecimal("periodendstandardcost") != null) {
                standardcost = row.getBigDecimal("periodendstandardcost");
            }
            if (row.getBigDecimal("substandardcost") != null) {
                substandardcost = row.getBigDecimal("substandardcost");
            }
            if (actualcost.compareTo(subactualcost) != 0) {
                exceObj = new ExceptionObj(balid, "cal_balance");
                s1 = ResManager.loadKDString((String)"\u5355\u53f7\uff1a%1$s\u7684\u6838\u7b97\u4f59\u989d\u5355\u5b9e\u9645\u6210\u672c\u662f\uff1a%2$s\uff0c\u7ed3\u8f6c\u660e\u7ec6\u4e4b\u548c\u4e3a\uff1a%3$s", (String)"BalanceDetailDataCheck_0", (String)"fi-cal-business", (Object[])new Object[0]);
                s1 = String.format(s1, balid, actualcost, subactualcost);
                middle = new StringBuilder().append(s1);
                exceObj.setDescription(super.getExceptionDesc(row, middle, false).toString());
                json = new JSONObject();
                json.put("balid", (Object)balid);
                json.put("actualcost", (Object)actualcost);
                json.put("subactualcost", (Object)subactualcost);
                exceObj.setExtralInfo(SerializationUtils.toJsonString((Object)json));
                list.add(exceObj);
            }
            if (standardcost.compareTo(substandardcost) == 0) continue;
            exceObj = new ExceptionObj(balid, "cal_balance");
            s1 = ResManager.loadKDString((String)"\u5355\u53f7\uff1a%1$s\u7684\u6838\u7b97\u4f59\u989d\u5355\u6807\u51c6\u6210\u672c\u662f\uff1a%2$s\uff0c\u7ed3\u8f6c\u660e\u7ec6\u4e4b\u548c\u4e3a\uff1a%3$s", (String)"BalanceDetailDataCheck_1", (String)"fi-cal-business", (Object[])new Object[0]);
            s1 = String.format(s1, balid, standardcost, substandardcost);
            middle = new StringBuilder().append(s1);
            exceObj.setDescription(super.getExceptionDesc(row, middle, false).toString());
            json = new JSONObject();
            json.put("balid", (Object)balid);
            json.put("standardcost", (Object)standardcost);
            json.put("substandardcost", (Object)substandardcost);
            exceObj.setExtralInfo(SerializationUtils.toJsonString((Object)json));
            list.add(exceObj);
        }
        return list;
    }

    @Override
    protected void addDataCheckFilter(List<QFilter> fList) {
        super.addDataCheckFilter(fList);
    }

    private String[] getBalanceSelectedFiled() {
        Set<String> dimWithNameFields = this.parser.getBalanceFields(true, true);
        dimWithNameFields.add("periodendactualcost");
        return dimWithNameFields.toArray(new String[0]);
    }
}

