/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.datacheck.item;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.business.datacheck.DataCheckParam;
import kd.fi.cal.business.datacheck.ExceptionObj;
import kd.fi.cal.business.datacheck.item.BalanceDataCheck;
import kd.fi.cal.business.datacheck.item.DataEntityDataCheck;
import org.apache.commons.lang.StringUtils;

public class BalanceUpdateRecordCheck
extends BalanceDataCheck {
    @Override
    protected void addSelectedFields(Set<String> fields) {
        fields.add("periodinqty as inqty");
        fields.add("periodinactualcost as incost");
        fields.add("periodissueqty as outqty");
        fields.add("periodissueactualcost as outcost");
    }

    @Override
    public List<ExceptionObj> collectExceptionObj(DataSet dataSet, DataCheckParam param) {
        Set<String> dimFields = this.parser.getDimFields();
        ArrayList<String> groupByFields = new ArrayList<String>();
        groupByFields.addAll(dimFields);
        groupByFields.add("period");
        DataSet recordSet = this.buildBalanceUpdateRecoordSet(param, dimFields);
        recordSet = recordSet.groupBy(groupByFields.toArray(new String[groupByFields.size()])).sum("inqty", "rinqty").sum("outqty", "routqty").sum("incost", "rincost").sum("outcost", "routcost").finish();
        JoinDataSet tempDataSet = dataSet.join(recordSet, JoinType.LEFT);
        for (String dimField : dimFields) {
            tempDataSet = tempDataSet.on(dimField, dimField);
        }
        DataSet balanceUpdateSet = tempDataSet.select(dataSet.getRowMeta().getFieldNames(), new String[]{"rinqty", "routqty", "rincost", "routcost"}).finish();
        ArrayList<ExceptionObj> objList = new ArrayList<ExceptionObj>();
        while (balanceUpdateSet.hasNext()) {
            BigDecimal routcost;
            Row row = balanceUpdateSet.next();
            BigDecimal inqty = row.getBigDecimal("inqty") == null ? BigDecimal.ZERO : row.getBigDecimal("inqty");
            BigDecimal outqty = row.getBigDecimal("outqty") == null ? BigDecimal.ZERO : row.getBigDecimal("outqty");
            BigDecimal incost = row.getBigDecimal("incost") == null ? BigDecimal.ZERO : row.getBigDecimal("incost");
            BigDecimal outcost = row.getBigDecimal("outcost") == null ? BigDecimal.ZERO : row.getBigDecimal("outcost");
            BigDecimal rinqty = row.getBigDecimal("rinqty") == null ? BigDecimal.ZERO : row.getBigDecimal("rinqty");
            BigDecimal routqty = row.getBigDecimal("routqty") == null ? BigDecimal.ZERO : row.getBigDecimal("routqty");
            BigDecimal rincost = row.getBigDecimal("rincost") == null ? BigDecimal.ZERO : row.getBigDecimal("rincost");
            BigDecimal bigDecimal = routcost = row.getBigDecimal("routcost") == null ? BigDecimal.ZERO : row.getBigDecimal("routcost");
            if (inqty.compareTo(rinqty) == 0 && outqty.compareTo(routqty) == 0 && incost.compareTo(rincost) == 0 && outcost.compareTo(routcost) == 0) continue;
            ExceptionObj obj = new ExceptionObj(row.getLong("id"), "cal_balance");
            String errorMsg = String.format(ResManager.loadKDString((String)"\u4f59\u989d\u8868\u6536\u5165\u6570\u91cf\uff1a%1$s \u6d41\u6c34\u6536\u5165\u6570\u91cf\uff1a%2$s  \u4f59\u989d\u8868\u53d1\u51fa\u6570\u91cf\uff1a%3$s  \u6d41\u6c34\u53d1\u51fa\u6570\u91cf\uff1a%4$s  \u4f59\u989d\u8868\u6536\u5165\u6210\u672c\uff1a%5$s  \u6d41\u6c34\u6536\u5165\u6210\u672c\uff1a%6$s \u4f59\u989d\u8868\u53d1\u51fa\u6210\u672c\uff1a%7$s  \u6d41\u6c34\u53d1\u51fa\u6210\u672c\uff1a%8$s  ", (String)"BalanceUpdateRecordCheck_0", (String)"fi-cal-business", (Object[])new Object[0]), inqty.stripTrailingZeros().toPlainString(), rinqty.stripTrailingZeros().toPlainString(), outqty.stripTrailingZeros().toPlainString(), routqty.stripTrailingZeros().toPlainString(), incost.stripTrailingZeros().toPlainString(), rincost.stripTrailingZeros().toPlainString(), outcost.stripTrailingZeros().toPlainString(), routcost.stripTrailingZeros().toPlainString());
            StringBuilder execDesc = this.getExceptionDesc(row, new StringBuilder(errorMsg), false);
            obj.setDescription(execDesc.toString());
            objList.add(obj);
        }
        return objList;
    }

    private DataSet buildBalanceUpdateRecoordSet(DataCheckParam param, Set<String> dimFields) {
        DataEntityDataCheck recordCheck = new DataEntityDataCheck(){

            @Override
            protected String getDataEntityType() {
                return "cal_balance_updaterecord";
            }

            @Override
            protected Set<String> getSelectedFields() {
                return null;
            }

            @Override
            public List<ExceptionObj> collectExceptionObj(DataSet dataSet, DataCheckParam param) {
                return null;
            }
        };
        List<QFilter> filterList = recordCheck.analyseBizRangeFilter(param);
        String fields = StringUtils.join(dimFields, (String)",");
        fields = fields + ",period,case when inorout = 'IN' then baseqty else 0 end as inqty,case when inorout = 'IN' then 0 else baseqty end as outqty,case when inorout = 'IN' then actualcost else 0 end as incost,case when inorout = 'IN' then 0 else actualcost end as outcost";
        return QueryServiceHelper.queryDataSet((String)BalanceUpdateRecordCheck.class.getName(), (String)"cal_balance_updaterecord", (String)fields, (QFilter[])filterList.toArray(new QFilter[filterList.size()]), null);
    }
}

