/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.datacheck.item;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.input.OrmInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.business.datacheck.DataCheckParam;
import kd.fi.cal.business.datacheck.ExceptionObj;
import kd.fi.cal.business.datacheck.item.DataEntityDataCheck;
import kd.fi.cal.common.helper.PeriodHelper;

public class CalOutAdjustStatusCheck
extends DataEntityDataCheck {
    private static final String[] ADJUSTBILL_CREATETYPE = new String[]{"G", "H", "K"};

    @Override
    public List<ExceptionObj> collectExceptionObj(List<DataCheckParam> paramList) {
        DataSet costAdjustDataSet = this.createCostAdjustBizDataSet(paramList);
        if (costAdjustDataSet.isEmpty()) {
            return null;
        }
        HashSet<Long> costAccountIdSet = new HashSet<Long>(16);
        for (DataCheckParam param : paramList) {
            costAccountIdSet.addAll(param.getCostAccount());
        }
        return this.dealExceptionObject(costAdjustDataSet, costAccountIdSet);
    }

    @Override
    public List<ExceptionObj> collectExceptionObj(DataCheckParam param) {
        DataSet costAdjustDataSet = this.createCostAdjustBizDataSet(param);
        if (costAdjustDataSet.isEmpty()) {
            return null;
        }
        Set<Long> costAccountIdSet = param.getCostAccount();
        if (costAccountIdSet == null || costAccountIdSet.isEmpty()) {
            costAccountIdSet = new HashSet<Long>(16);
            DynamicObjectCollection costAccounts = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"id", (QFilter[])new QFilter("enable", "=", (Object)Boolean.TRUE).toArray());
            for (DynamicObject costAccount : costAccounts) {
                costAccountIdSet.add(costAccount.getLong("id"));
            }
        }
        return this.dealExceptionObject(costAdjustDataSet, costAccountIdSet);
    }

    private List<ExceptionObj> dealExceptionObject(DataSet dataSet, Set<Long> costAccountIdSet) {
        ArrayList<ExceptionObj> exceptiodObjList = new ArrayList<ExceptionObj>(16);
        HashSet<String> billNoSet = new HashSet<String>(32);
        String entityName = EntityMetadataCache.getDataEntityType((String)"cal_costadjust_subentity").getDisplayName().getLocaleValue();
        Map currentPeriods = PeriodHelper.getCurrentPeriods(costAccountIdSet);
        for (Row row : dataSet) {
            ExceptionObj exceptionObj;
            String msg;
            Long curPeriodid;
            boolean isCur;
            StringBuilder errorMsg = new StringBuilder();
            Long costAccountId = row.getLong("costaccount");
            Long periodId = row.getLong("periodid");
            boolean bl = isCur = periodId.compareTo(curPeriodid = Long.valueOf(((DynamicObject)currentPeriods.get(costAccountId)).getLong("id"))) == 0;
            if (!isCur) continue;
            String billStatus = row.getString("billstatus");
            String costaccountnumber = row.getString("costaccountnumber");
            String billno = row.getString("billno");
            String accountBillkey = billno + "_" + costAccountId;
            if ("A".equals(billStatus)) {
                if (billNoSet.contains(accountBillkey)) continue;
                billNoSet.add(accountBillkey);
                msg = ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u201c%1$s\u201d\u4e0b\u5b58\u5728\u6682\u5b58\u7684%2$s\uff0c\u5355\u53f7\u4e3a\uff1a%3$s\u3002", (String)"CalOutAdjustStatusCheck_5", (String)"fi-cal-business", (Object[])new Object[0]);
                msg = String.format(msg, costaccountnumber, entityName, billno);
                errorMsg.append(msg);
                exceptionObj = new ExceptionObj(row.getLong("id"), "cal_costadjust_subentity");
                exceptionObj.setDescription(errorMsg.toString());
                exceptiodObjList.add(exceptionObj);
            }
            if (!"B".equals(billStatus) || billNoSet.contains(accountBillkey)) continue;
            billNoSet.add(accountBillkey);
            msg = ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u201c%1$s\u201d\u4e0b\u5b58\u5728\u63d0\u4ea4\u7684%2$s\uff0c\u5355\u53f7\u4e3a\uff1a%3$s\u3002", (String)"CalOutAdjustStatusCheck_6", (String)"fi-cal-business", (Object[])new Object[0]);
            msg = String.format(msg, costaccountnumber, entityName, billno);
            errorMsg.append(msg);
            exceptionObj = new ExceptionObj(row.getLong("id"), "cal_costadjust_subentity");
            exceptionObj.setDescription(errorMsg.toString());
            exceptiodObjList.add(exceptionObj);
        }
        return exceptiodObjList;
    }

    public DataSet createCostAdjustBizDataSet(List<DataCheckParam> paramList) {
        ArrayList<OrmInput> rangesIO = new ArrayList<OrmInput>(paramList.size());
        for (DataCheckParam param : paramList) {
            OrmInput rangeIO;
            Long periodId = param.getPeriodId();
            Set<Long> costAccountIdSet = param.getCostAccount();
            QFilter filter = null;
            filter = param.isNeedCalculatedLater() ? new QFilter("period.id", ">=", (Object)periodId) : new QFilter("period.id", "=", (Object)periodId);
            filter.and("costaccount.id", "in", costAccountIdSet);
            filter.and("createtype", "not in", (Object)ADJUSTBILL_CREATETYPE);
            filter.and("difftype", "=", (Object)"B");
            if (param.isAllMaterial()) {
                rangeIO = new OrmInput(this.getClass().getName(), "cal_costadjust_subentity", this.getCostAdjustBizField(), filter.toArray());
            } else {
                QFilter mFilter = filter.copy();
                mFilter.and("entryentity.material.id", "in", param.getMaterial());
                rangeIO = new OrmInput(this.getClass().getName(), "cal_costadjust_subentity", this.getCostAdjustBizField(), mFilter.toArray());
            }
            rangesIO.add(rangeIO);
        }
        Algo algo = Algo.create((String)this.getClass().getName());
        DataSet unionDataSet = algo.createDataSet((Input[])rangesIO.toArray(new OrmInput[rangesIO.size()]));
        return unionDataSet;
    }

    public DataSet createCostAdjustBizDataSet(DataCheckParam param) {
        List<QFilter> fList = this.analyseBizRangeFilter(param);
        fList.add(new QFilter("createtype", "not in", (Object)ADJUSTBILL_CREATETYPE));
        fList.add(new QFilter("difftype", "=", (Object)"B"));
        return QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costadjust_subentity", (String)this.getCostAdjustBizField(), (QFilter[])fList.toArray(new QFilter[0]), null);
    }

    private String getCostAdjustBizField() {
        return "id,costaccount,period as periodid,billstatus,costaccount.name as costaccountname,costaccount.number as costaccountnumber,billno";
    }

    @Override
    protected String getDataEntityType() {
        return "cal_costadjust_subentity";
    }

    @Override
    protected Set<String> getSelectedFields() {
        return null;
    }

    @Override
    public List<ExceptionObj> collectExceptionObj(DataSet dataSet, DataCheckParam param) {
        return null;
    }
}

