/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.datacheck.item;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.input.OrmInput;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.business.datacheck.DataCheckParam;
import kd.fi.cal.business.datacheck.ExceptionObj;
import kd.fi.cal.business.datacheck.item.DataEntityDataCheck;

public class CalOutAdjustVoucherCheck
extends DataEntityDataCheck {
    private static final String[] ADJUSTBILL_CREATETYPE = new String[]{"F", "N", "V", "B-A2"};

    @Override
    public List<ExceptionObj> collectExceptionObj(List<DataCheckParam> paramList) {
        DataSet costAdjustDataSet = this.createCostAdjustBizDataSet(paramList);
        if (costAdjustDataSet.isEmpty()) {
            return null;
        }
        return this.dealExceptionObject(costAdjustDataSet);
    }

    @Override
    public List<ExceptionObj> collectExceptionObj(DataCheckParam param) {
        DataSet costAdjustDataSet = this.createCostAdjustBizDataSet(param);
        if (costAdjustDataSet.isEmpty()) {
            return null;
        }
        return this.dealExceptionObject(costAdjustDataSet);
    }

    public DataSet createCostAdjustBizDataSet(List<DataCheckParam> paramList) {
        ArrayList<OrmInput> rangesIO = new ArrayList<OrmInput>(paramList.size());
        for (DataCheckParam param : paramList) {
            OrmInput rangeIO;
            Long periodId = param.getPeriodId();
            Set<Long> costAccountIdSet = param.getCostAccount();
            QFilter filter = null;
            filter = param.isNeedCalculatedLater() ? new QFilter("period.id", ">=", (Object)periodId) : new QFilter("period.id", "=", (Object)periodId);
            filter.and("costaccount.id", "in", costAccountIdSet);
            filter.and("createtype", "in", (Object)ADJUSTBILL_CREATETYPE);
            filter.and("difftype", "=", (Object)"B");
            if (param.isAllMaterial()) {
                rangeIO = new OrmInput(this.getClass().getName(), "cal_costadjust_subentity", this.getCostAdjustBizField(), filter.toArray());
            } else {
                QFilter mFilter = filter.copy();
                mFilter.and("entryentity.material.id", "in", param.getMaterial());
                rangeIO = new OrmInput(this.getClass().getName(), "cal_costadjust_subentity", this.getCostAdjustBizField(), mFilter.toArray());
            }
            rangesIO.add(rangeIO);
        }
        Algo algo = Algo.create((String)this.getClass().getName());
        DataSet unionDataSet = algo.createDataSet((Input[])rangesIO.toArray(new OrmInput[rangesIO.size()]));
        return unionDataSet;
    }

    public DataSet createCostAdjustBizDataSet(DataCheckParam Param) {
        List<QFilter> fList = this.analyseBizRangeFilter(Param);
        fList.add(new QFilter("createtype", "in", (Object)ADJUSTBILL_CREATETYPE));
        fList.add(new QFilter("difftype", "=", (Object)"B"));
        return QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costadjust_subentity", (String)this.getCostAdjustBizField(), (QFilter[])fList.toArray(new QFilter[0]), null);
    }

    private List<ExceptionObj> dealExceptionObject(DataSet dataSet) {
        ArrayList<ExceptionObj> exceptiodObjList = new ArrayList<ExceptionObj>(16);
        HashSet<String> billNoSet = new HashSet<String>(32);
        for (Row row : dataSet) {
            String billno = row.getString("billno");
            String costaccountName = row.getString("costaccountnumber");
            if (billNoSet.contains(billno) || !row.getBoolean("isvoucher").booleanValue()) continue;
            billNoSet.add(billno);
            String errorMsg = String.format(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u201c%1$s\u201d\u5b58\u5728\u5df2\u751f\u6210\u51ed\u8bc1\u7684\u524d\u671f\u51fa\u5e93\u6210\u672c\u8c03\u6574\u6216\u6210\u7ec4\u6210\u672c\u8c03\u6574\u7c7b\u578b\u7684\u6210\u672c\u8c03\u6574\u5355\u201c%2$s\u201d\u3002", (String)"CalOutAdjustVoucherCheck_1", (String)"fi-cal-business", (Object[])new Object[0]), costaccountName, billno);
            ExceptionObj exceptionObj = new ExceptionObj(row.getLong("id"), "cal_costadjust_subentity");
            exceptionObj.setDescription(errorMsg);
            exceptiodObjList.add(exceptionObj);
        }
        return exceptiodObjList;
    }

    private String getCostAdjustBizField() {
        return "id,costaccount,period as periodid,billstatus,costaccount.name as costaccountname,costaccount.number as costaccountnumber,billno,createtype,isvoucher";
    }

    @Override
    protected String getDataEntityType() {
        return "cal_costadjust_subentity";
    }

    @Override
    protected Set<String> getSelectedFields() {
        return null;
    }

    @Override
    public List<ExceptionObj> collectExceptionObj(DataSet dataSet, DataCheckParam param) {
        return null;
    }
}

