/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.datacheck.item;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.util.StringUtils;
import kd.fi.cal.business.datacheck.ExceptionObj;
import kd.fi.cal.business.datacheck.item.CalOutBalanceEndZeroCostCheck;
import kd.fi.cal.common.helper.CalBalanceModelHelper;

public class CalOutBalanceEndNegCostCheck
extends CalOutBalanceEndZeroCostCheck {
    @Override
    protected List<ExceptionObj> dealExceptionObject(DataSet dataSet) {
        String balanceEntity = CalBalanceModelHelper.isNewBalance() ? "cal_bal" : "cal_balance";
        MainEntityType entitytype = EntityMetadataCache.getDataEntityType((String)balanceEntity);
        ArrayList<ExceptionObj> exceptiodObjList = new ArrayList<ExceptionObj>(16);
        dataSet = dataSet.filter("periodendqty <> 0 or periodendactualcost <> 0");
        dataSet = dataSet.select("caldimensionstr,calrangenumber,costaccount,costaccountnumber,material,materialnumber,case when periodendqty != 0 then periodendactualcost/periodendqty else 0 end as periodendprice");
        dataSet = dataSet.filter("periodendprice < 0");
        String nullstr = ResManager.loadKDString((String)"\u4e3a\u7a7a", (String)"CalOutBalanceEndNegCostCheck_02", (String)"fi-cal-business", (Object[])new Object[0]);
        for (Row row : dataSet) {
            String[] caldimensionsAll;
            String costaccountnumber = row.getString("costaccountnumber");
            String materialnumber = row.getString("materialnumber");
            String calrangenumber = row.getString("calrangenumber");
            BigDecimal periodEndPrice = row.getBigDecimal("periodendprice");
            if (periodEndPrice.compareTo(BigDecimal.ZERO) == 0) {
                periodEndPrice = BigDecimal.ZERO;
            }
            String caldimensionstr = row.getString("caldimensionstr");
            StringBuilder caldimensionSb = new StringBuilder();
            if (StringUtils.isNotEmpty((String)caldimensionstr) && !"0".equals(caldimensionstr) && (caldimensionsAll = caldimensionstr.split(",")) != null && caldimensionsAll.length > 0) {
                for (String caldimensions : caldimensionsAll) {
                    IDataEntityProperty pro;
                    String[] caldimensionvs;
                    if (StringUtils.isEmpty((String)caldimensions) || null == (caldimensionvs = caldimensions.split(":")) || caldimensionvs.length == 0 || !StringUtils.isNotEmpty((String)caldimensionvs[0]) || (pro = entitytype.findProperty(caldimensionvs[0])) == null) continue;
                    caldimensionSb.append(pro.getDisplayName());
                    caldimensionSb.append(":");
                    if (StringUtils.isBlank((String)caldimensionvs[1]) || "null".equals(caldimensionvs[1])) {
                        caldimensionSb.append(nullstr);
                        caldimensionSb.append(";");
                        continue;
                    }
                    caldimensionSb.append(caldimensionvs[1]);
                    caldimensionSb.append(";");
                }
            }
            String msg = " ";
            if (caldimensionSb.length() > 0) {
                caldimensionstr = caldimensionSb.toString();
                msg = String.format(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u201c%1$s\u201d\u6838\u7b97\u8303\u56f4\u201c%2$s\u201d\u6838\u7b97\u7ef4\u5ea6\u201c%3$s\u201d\u4e0b\u5b58\u5728\u671f\u672b\u7ed3\u5b58\u5355\u4f4d\u5b9e\u9645\u6210\u672c\u201c%4$s\u201d\u5c0f\u4e8e0\u7684\u7269\u6599\u201c%5$s\u3002\u201d", (String)"CalOutBalanceEndNegCostCheck_0", (String)"fi-cal-business", (Object[])new Object[0]), costaccountnumber, calrangenumber, caldimensionstr, periodEndPrice, materialnumber);
            } else {
                msg = String.format(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u201c%1$s\u201d\u6838\u7b97\u8303\u56f4\u201c%2$s\u201d\u4e0b\u5b58\u5728\u671f\u672b\u7ed3\u5b58\u5355\u4f4d\u5b9e\u9645\u6210\u672c\u201c%3$s\u201d\u5c0f\u4e8e0\u7684\u7269\u6599\u201c%4$s\u201d\u3002", (String)"CalOutBalanceEndNegCostCheck_01", (String)"fi-cal-business", (Object[])new Object[0]), costaccountnumber, calrangenumber, periodEndPrice, materialnumber);
            }
            ExceptionObj exceptionObj = new ExceptionObj(0L, "cal_balance");
            exceptionObj.setDescription(msg);
            exceptiodObjList.add(exceptionObj);
        }
        return exceptiodObjList;
    }
}

