/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.datacheck.item;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.input.OrmInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.business.datacheck.DataCheckParam;
import kd.fi.cal.business.datacheck.ExceptionObj;
import kd.fi.cal.business.datacheck.item.BalanceDataCheck;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.helper.CalBalanceModelHelper;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.common.util.CommonUtils;

public class CalOutBalanceEndQtyCheck
extends BalanceDataCheck {
    private boolean balCompress = CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.CAL_BAL_DATA_COMPRESSION);

    @Override
    public List<ExceptionObj> collectExceptionObj(List<DataCheckParam> param) {
        DataSet balanceDataSet = this.createBalanceDataSet(param, this.getDataEntityType());
        if (balanceDataSet == null) {
            return null;
        }
        return this.dealExceptionObject(balanceDataSet);
    }

    @Override
    public List<ExceptionObj> collectExceptionObj(DataCheckParam param) {
        DataSet balanceDataSet = this.createBalanceDataSet(param, this.getDataEntityType());
        if (balanceDataSet == null) {
            return null;
        }
        return this.dealExceptionObject(balanceDataSet);
    }

    private DataSet createBalanceDataSet(List<DataCheckParam> paramList, String entityName) {
        int periodNumber;
        ArrayList<OrmInput> rangesIO = new ArrayList<OrmInput>(paramList.size());
        HashSet<Long> periodId = new HashSet<Long>(16);
        for (DataCheckParam param : paramList) {
            periodId.add(param.getPeriodId());
        }
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"bd_period", (String)"id,periodyear,periodnumber", (QFilter[])new QFilter("id", "in", periodId).toArray(), null);
        HashMap<Long, Integer> periodNumberMap = new HashMap<Long, Integer>(16);
        for (DynamicObject info : coll) {
            periodNumber = info.getInt("periodyear") * 100 + info.getInt("periodnumber");
            periodNumberMap.put(info.getLong("id"), periodNumber);
        }
        for (DataCheckParam param : paramList) {
            OrmInput rangeIO;
            periodNumber = (Integer)periodNumberMap.get(param.getPeriodId());
            QFilter filter = new QFilter("period", "<=", (Object)periodNumber);
            filter.and("endperiod", ">", (Object)periodNumber);
            filter.and("costaccount.id", "in", param.getCostAccount());
            if (param.getCalRangeId() != null) {
                filter.and("calrange", "=", (Object)param.getCalRangeId());
            }
            if (param.isAllMaterial()) {
                rangeIO = new OrmInput(this.getClass().getName(), entityName, this.getBalanceField(), filter.toArray());
            } else {
                QFilter mFilter = filter.copy();
                mFilter.and("material", "in", param.getMaterial());
                rangeIO = new OrmInput(this.getClass().getName(), entityName, this.getBalanceField(), mFilter.toArray());
            }
            rangesIO.add(rangeIO);
        }
        Algo algo = Algo.create((String)this.getClass().getName());
        DataSet unionDataSet = algo.createDataSet((Input[])rangesIO.toArray(new OrmInput[rangesIO.size()]));
        if (this.isNewBalance) {
            String[] groupSelect = (CalBalanceModelHelper.getDimFields((boolean)false) + ",calorg,caldimension,caldimensionstr,calrange,calrangenumber,costaccountnumber,dividebasis,dividebasisstr,materialnumber").split(",");
            unionDataSet = !this.balCompress ? unionDataSet.groupBy(groupSelect).max("periodendqty").finish() : unionDataSet.groupBy(groupSelect).sum("periodendqty").finish();
        }
        return this.groupByRangeAndDimension(unionDataSet);
    }

    private DataSet createBalanceDataSet(DataCheckParam param, String entityName) {
        Set<Long> costAccountIdSet = param.getCostAccount();
        Set<Long> calOrgIdSet = param.getCalorg();
        if (costAccountIdSet == null || costAccountIdSet.isEmpty()) {
            if (calOrgIdSet != null && !calOrgIdSet.isEmpty()) {
                QFilter q = new QFilter("calorg", "in", calOrgIdSet);
                q.and("enable", "=", (Object)Character.valueOf('1'));
                DataSet accountSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_bd_costaccount", (String)"id", (QFilter[])q.toArray(), null);
                costAccountIdSet = new HashSet<Long>(16);
                for (Row account : accountSet) {
                    costAccountIdSet.add(account.getLong("id"));
                    param.setCostAccount(costAccountIdSet);
                }
            } else {
                return null;
            }
        }
        List<QFilter> fList = this.analyseBizRangeFilter(param);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)entityName, (String)this.getBalanceField(), (QFilter[])fList.toArray(new QFilter[0]), null);
        if (this.isNewBalance) {
            String[] groupSelect = (CalBalanceModelHelper.getDimFields((boolean)false) + ",calorg,caldimension,caldimensionstr,calrange,calrangenumber,costaccountnumber,dividebasis,dividebasisstr,materialnumber").split(",");
            dataSet = !this.balCompress ? dataSet.groupBy(groupSelect).max("periodendqty").finish() : dataSet.groupBy(groupSelect).sum("periodendqty").finish();
        }
        return this.groupByRangeAndDimension(dataSet);
    }

    private DataSet groupByRangeAndDimension(DataSet dataSet) {
        HashSet<Long> calRangeSet = new HashSet<Long>(16);
        DataSet finalDataSet = null;
        for (DynamicObject[] row : dataSet.copy()) {
            long calRangeId = row.getLong("calRange");
            if (calRangeId == 0L) continue;
            calRangeSet.add(calRangeId);
        }
        if (calRangeSet.isEmpty()) {
            return finalDataSet;
        }
        DynamicObject[] calRanges = BusinessDataServiceHelper.load((String)"cal_bd_calrange", (String)"id,entry.id", (QFilter[])new QFilter("id", "in", calRangeSet).toArray());
        calRangeSet.clear();
        for (DynamicObject calRange : calRanges) {
            if (!calRange.getDynamicObjectCollection("entry").isEmpty()) continue;
            calRangeSet.add(calRange.getLong("id"));
        }
        if (!calRangeSet.isEmpty()) {
            DataSet divideDataSet = dataSet.copy().filter(new QFilter("calrange", "in", calRangeSet).toString());
            DataSet calRangeDataSet = dataSet.filter(new QFilter("calrange", "not in", calRangeSet).toString());
            divideDataSet = this.handleDivideDataSet(divideDataSet);
            calRangeDataSet = this.handleCalRangeDataSet(calRangeDataSet);
            finalDataSet = divideDataSet != null && calRangeDataSet != null ? calRangeDataSet.union(divideDataSet) : (divideDataSet != null ? divideDataSet : calRangeDataSet);
        } else {
            finalDataSet = this.handleCalRangeDataSet(dataSet);
        }
        return finalDataSet;
    }

    private DataSet handleDivideDataSet(DataSet dataSet) {
        DataSet divideDataSet = dataSet.copy().groupBy(new String[]{"dividebasis", "dividebasisstr", "caldimension", "caldimensionstr"}).finish().select(new String[]{"dividebasis", "dividebasisstr", "caldimension", "caldimensionstr"});
        DataSet unionDataSet = null;
        ArrayList<DataSet> allDataSet = new ArrayList<DataSet>(16);
        for (Row row : divideDataSet) {
            DataSet copyDivideDataSet = dataSet.copy();
            long caldimensionid = row.getLong("caldimension");
            long dividebasisid = row.getLong("dividebasis");
            String caldimensionStr = row.getString("caldimensionstr");
            String dividebasisStr = row.getString("dividebasisstr");
            copyDivideDataSet = copyDivideDataSet.filter("dividebasis = " + dividebasisid + " and caldimension = " + caldimensionid);
            StringBuilder groupFields = new StringBuilder();
            groupFields.append("costaccount,costaccountnumber,calrangenumber,material,materialnumber,");
            groupFields.append(CommonUtils.trimComma((String)dividebasisStr));
            if (caldimensionid != 0L && caldimensionStr != null) {
                groupFields.append(',');
                groupFields.append(CommonUtils.trimComma((String)caldimensionStr));
            }
            copyDivideDataSet = copyDivideDataSet.groupBy(groupFields.toString().split(",")).sum("periodendqty").finish();
            copyDivideDataSet = copyDivideDataSet.select("calrangenumber,costaccount,costaccountnumber,material,materialnumber,periodendqty");
            if (unionDataSet == null) {
                unionDataSet = copyDivideDataSet;
                continue;
            }
            allDataSet.add(copyDivideDataSet);
        }
        if (unionDataSet != null && !allDataSet.isEmpty()) {
            unionDataSet = unionDataSet.union(allDataSet.toArray(new DataSet[0]));
        }
        return unionDataSet;
    }

    private DataSet handleCalRangeDataSet(DataSet dataSet) {
        DataSet dimensionDataSet = dataSet.copy().groupBy(new String[]{"caldimension", "caldimensionstr"}).finish().select(new String[]{"caldimension", "caldimensionstr"});
        DataSet unionDataSet = null;
        ArrayList<DataSet> allDataSet = new ArrayList<DataSet>(16);
        for (Row row : dimensionDataSet) {
            DataSet copyCalRangeDataSet = dataSet.copy();
            long caldimensionid = row.getLong("caldimension");
            String caldimensionStr = row.getString("caldimensionstr");
            copyCalRangeDataSet = copyCalRangeDataSet.filter("caldimension = " + caldimensionid);
            StringBuilder groupFields = new StringBuilder();
            groupFields.append("costaccount,costaccountnumber,calrange,calrangenumber,material,materialnumber");
            if (caldimensionid != 0L && caldimensionStr != null) {
                groupFields.append(',');
                groupFields.append(CommonUtils.trimComma((String)caldimensionStr));
            }
            copyCalRangeDataSet = copyCalRangeDataSet.groupBy(groupFields.toString().split(",")).sum("periodendqty").finish();
            copyCalRangeDataSet = copyCalRangeDataSet.select("calrangenumber,costaccount,costaccountnumber,material,materialnumber,periodendqty");
            if (unionDataSet == null) {
                unionDataSet = copyCalRangeDataSet;
                continue;
            }
            allDataSet.add(copyCalRangeDataSet);
        }
        if (unionDataSet != null && !allDataSet.isEmpty()) {
            unionDataSet = unionDataSet.union(allDataSet.toArray(new DataSet[0]));
        }
        return unionDataSet;
    }

    @Override
    protected QFilter analyseCostAccountFilter(DataCheckParam param) {
        if (!"cal_balance".equals(this.entityType.getName()) && !"cal_bal".equals(this.entityType.getName())) {
            return super.analyseCostAccountFilter(param);
        }
        IDataEntityProperty accountProperty = this.entityType.findProperty("costaccount");
        Set<Long> costaccount = param.getCostAccount();
        if (accountProperty == null) {
            return null;
        }
        if (costaccount == null || costaccount.isEmpty()) {
            costaccount = this.getAllValidCostAccount();
        }
        ArrayList<QFilter> fList = new ArrayList<QFilter>(costaccount.size());
        String costAccountName = this.analyseFieldName(accountProperty);
        for (Long costAccountId : costaccount) {
            QFilter filter = new QFilter(costAccountName, "=", (Object)costAccountId);
            DynamicObject period = this.getCurrentPeriod(costAccountId);
            if (period == null) continue;
            filter = filter.and("period", "<=", (Object)(period.getInt("periodyear") * 100 + period.getInt("periodnumber")));
            filter = filter.and("endperiod", ">", (Object)(period.getInt("periodyear") * 100 + period.getInt("periodnumber")));
            fList.add(filter);
        }
        if (fList.isEmpty()) {
            return new QFilter("id", "=", (Object)0);
        }
        QFilter firstFilter = (QFilter)fList.get(0);
        for (int i = 1; i < fList.size(); ++i) {
            firstFilter = firstFilter.or((QFilter)fList.get(i));
        }
        return firstFilter;
    }

    private List<ExceptionObj> dealExceptionObject(DataSet dataSet) {
        ArrayList<ExceptionObj> exceptiodObjList = new ArrayList<ExceptionObj>(16);
        dataSet = dataSet.select("calrangenumber,costaccount,costaccountnumber,material,materialnumber,periodendqty");
        dataSet = dataSet.filter("periodendqty < 0");
        for (Row row : dataSet) {
            String costaccountnumber = row.getString("costaccountnumber");
            String materialnumber = row.getString("materialnumber");
            String calrangenumber = row.getString("calrangenumber");
            BigDecimal periodEndQty = row.getBigDecimal("periodendqty");
            String errmsg = String.format(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u201c%1$s\u201d\u6838\u7b97\u8303\u56f4\u201c%2$s\u201d\u4e0b\u5b58\u5728\u671f\u672b\u7ed3\u5b58\u6570\u91cf\u201c%3$s\u201d\u5c0f\u4e8e0\u7684\u7269\u6599\u201c%4$s\u201d\u3002", (String)"CalOutBalanceEndQtyCheck_0", (String)"fi-cal-business", (Object[])new Object[0]), costaccountnumber, calrangenumber, periodEndQty, materialnumber);
            ExceptionObj exceptionObj = new ExceptionObj(0L, "cal_balance");
            exceptionObj.setDescription(errmsg);
            exceptiodObjList.add(exceptionObj);
        }
        return exceptiodObjList;
    }

    private String getBalanceField() {
        String selectFields = "";
        String moreFields = ",calorg,caldimension,caldimension.caldimension as caldimensionstr,calrange,calrange.number as calrangenumber,costaccount.number as costaccountnumber,costaccount.dividebasis as dividebasis,costaccount.dividebasis.dividebasis as dividebasisstr,material.number as materialnumber,periodendqty";
        if (this.isNewBalance) {
            moreFields = moreFields.replaceAll("periodendqty", "baseqty_bal as periodendqty");
            selectFields = CalBalanceModelHelper.getDimFields((boolean)true) + moreFields;
        } else {
            selectFields = String.join((CharSequence)",", CalBalanceModelHelper.getAllDimField()) + moreFields;
        }
        return selectFields;
    }

    @Override
    protected String getDataEntityType() {
        if (this.isNewBalance) {
            return "cal_bal";
        }
        return "cal_balance";
    }

    @Override
    public List<ExceptionObj> collectExceptionObj(DataSet dataSet, DataCheckParam param) {
        return null;
    }
}

