/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.datacheck.item;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.input.OrmInput;
import kd.bos.config.client.util.StringUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.business.datacheck.DataCheckParam;
import kd.fi.cal.business.datacheck.ExceptionObj;
import kd.fi.cal.business.datacheck.funtion.DealCaldimensionCheckFuncion;
import kd.fi.cal.business.datacheck.item.BalanceDataCheck;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.helper.CalBalanceModelHelper;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.common.helper.WriteLogHelper;
import kd.fi.cal.common.util.CommonUtils;

public class CalOutBalanceEndZeroCostCheck
extends BalanceDataCheck {
    private static final Log logger = LogFactory.getLog(CalOutBalanceEndZeroCostCheck.class);
    private boolean balCompress = CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.CAL_BAL_DATA_COMPRESSION);

    @Override
    public List<ExceptionObj> collectExceptionObj(List<DataCheckParam> param) {
        DataSet balanceDataSet = this.createBalanceDataSet(param, this.getDataEntityType());
        if (balanceDataSet == null) {
            return null;
        }
        return this.dealExceptionObject(balanceDataSet);
    }

    @Override
    public List<ExceptionObj> collectExceptionObj(DataCheckParam param) {
        DataSet balanceDataSet = this.createBalanceDataSet(param, this.getDataEntityType());
        if (balanceDataSet == null) {
            return null;
        }
        return this.dealExceptionObject(balanceDataSet);
    }

    private DataSet createBalanceDataSet(List<DataCheckParam> paramList, String entityName) {
        int periodNumber;
        ArrayList<OrmInput> rangesIO = new ArrayList<OrmInput>(paramList.size());
        HashSet<Long> periodId = new HashSet<Long>(16);
        for (DataCheckParam param : paramList) {
            periodId.add(param.getPeriodId());
        }
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"bd_period", (String)"id,periodyear,periodnumber", (QFilter[])new QFilter("id", "in", periodId).toArray(), null);
        HashMap<Long, Integer> periodNumberMap = new HashMap<Long, Integer>(16);
        for (DynamicObject info : coll) {
            periodNumber = info.getInt("periodyear") * 100 + info.getInt("periodnumber");
            periodNumberMap.put(info.getLong("id"), periodNumber);
        }
        for (DataCheckParam param : paramList) {
            OrmInput rangeIO;
            periodNumber = (Integer)periodNumberMap.get(param.getPeriodId());
            QFilter filter = new QFilter("period", "<=", (Object)periodNumber);
            filter.and("endperiod", ">", (Object)periodNumber);
            filter.and("costaccount.id", "in", param.getCostAccount());
            if (param.getCalRangeId() != null) {
                filter.and("calrange", "=", (Object)param.getCalRangeId());
            }
            if (param.isAllMaterial()) {
                rangeIO = new OrmInput(this.getClass().getName(), entityName, this.getBalanceField(), filter.toArray());
            } else {
                QFilter mFilter = filter.copy();
                mFilter.and("material", "in", param.getMaterial());
                rangeIO = new OrmInput(this.getClass().getName(), entityName, this.getBalanceField(), mFilter.toArray());
            }
            rangesIO.add(rangeIO);
        }
        Algo algo = Algo.create((String)this.getClass().getName());
        DataSet unionDataSet = algo.createDataSet((Input[])rangesIO.toArray(new OrmInput[rangesIO.size()]));
        if (this.isNewBalance) {
            OrmInput dimfieldstr = unionDataSet.getRowMeta().getFieldNames();
            StringBuilder dimfieldSb = new StringBuilder();
            if (dimfieldstr != null && ((String[])dimfieldstr).length > 0) {
                for (String dimfield : dimfieldstr) {
                    if (!StringUtils.isNotEmpty((String)dimfield) || "periodendqty".equals(dimfield) || "periodendactualcost".equals(dimfield) || "costsubelement".equals(dimfield) || "costsubelementnumber".equals(dimfield) || "costelement".equals(dimfield) || "costelementnumber".equals(dimfield)) continue;
                    dimfieldSb.append(dimfield);
                    dimfieldSb.append(",");
                }
            }
            String dimSelects = dimfieldSb.substring(0, dimfieldSb.length() - 1);
            String[] groupSelect = dimSelects.split(",");
            unionDataSet = !this.balCompress ? unionDataSet.groupBy(groupSelect).max("periodendqty").sum("periodendactualcost").finish() : unionDataSet.groupBy(groupSelect).sum("periodendqty").sum("periodendactualcost").finish();
        }
        return this.groupByRangeAndDimension(unionDataSet);
    }

    private DataSet createBalanceDataSet(DataCheckParam param, String entityName) {
        List<QFilter> fList = this.analyseBizRangeFilter(param);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)entityName, (String)this.getBalanceField(), (QFilter[])fList.toArray(new QFilter[0]), null);
        if (this.isNewBalance) {
            String[] dimfieldstr = dataSet.getRowMeta().getFieldNames();
            StringBuilder dimfieldSb = new StringBuilder();
            if (dimfieldstr != null && dimfieldstr.length > 0) {
                for (String dimfield : dimfieldstr) {
                    if (!StringUtils.isNotEmpty((String)dimfield) || "periodendqty".equals(dimfield) || "periodendactualcost".equals(dimfield) || "costsubelement".equals(dimfield) || "costsubelementnumber".equals(dimfield) || "costelement".equals(dimfield) || "costelementnumber".equals(dimfield)) continue;
                    dimfieldSb.append(dimfield);
                    dimfieldSb.append(",");
                }
            }
            String dimSelects = dimfieldSb.substring(0, dimfieldSb.length() - 1);
            String[] groupSelect = dimSelects.split(",");
            dataSet = !this.balCompress ? dataSet.groupBy(groupSelect).max("periodendqty").sum("periodendactualcost").finish() : dataSet.groupBy(groupSelect).sum("periodendqty").sum("periodendactualcost").finish();
        }
        return this.groupByRangeAndDimension(dataSet);
    }

    private DataSet groupByRangeAndDimension(DataSet dataSet) {
        HashSet<Long> calRangeSet = new HashSet<Long>(16);
        DataSet finalDataSet = null;
        HashSet<Long> auxptyIds = new HashSet<Long>(16);
        for (Row row : dataSet.copy()) {
            Long auxptyId;
            long calRangeId = row.getLong("calRange");
            if (calRangeId != 0L) {
                calRangeSet.add(calRangeId);
            }
            if ((auxptyId = row.getLong("assist")) == 0L) continue;
            auxptyIds.add(auxptyId);
        }
        if (calRangeSet.isEmpty()) {
            return finalDataSet;
        }
        Map<Long, String> auxValueNameMap = CalOutBalanceEndZeroCostCheck.getAuxValueNameMap(auxptyIds);
        DynamicObject[] calRanges = BusinessDataServiceHelper.load((String)"cal_bd_calrange", (String)"id,entry.id", (QFilter[])new QFilter("id", "in", calRangeSet).toArray());
        calRangeSet.clear();
        for (DynamicObject calRange : calRanges) {
            if (!calRange.getDynamicObjectCollection("entry").isEmpty()) continue;
            calRangeSet.add(calRange.getLong("id"));
        }
        if (!calRangeSet.isEmpty()) {
            DataSet[] dataSetArray = dataSet.splitByFilter(new String[]{new QFilter("calrange", "in", calRangeSet).toString(), new QFilter("calrange", "not in", calRangeSet).toString()}, false);
            DataSet divideDataSet = dataSetArray[0];
            DataSet calRangeDataSet = dataSetArray[1];
            divideDataSet = this.handleDivideDataSet(divideDataSet, auxValueNameMap);
            calRangeDataSet = this.handleCalRangeDataSet(calRangeDataSet, auxValueNameMap);
            finalDataSet = divideDataSet != null && calRangeDataSet != null ? calRangeDataSet.union(divideDataSet) : (divideDataSet != null ? divideDataSet : calRangeDataSet);
        } else {
            finalDataSet = this.handleCalRangeDataSet(dataSet, auxValueNameMap);
        }
        return finalDataSet;
    }

    private DataSet handleDivideDataSet(DataSet dataSet, Map<Long, String> auxValueNameMap) {
        DataSet divideDataSet = dataSet.copy().groupBy(new String[]{"dividebasis", "dividebasisstr", "caldimension", "caldimensionstr"}).finish().select(new String[]{"dividebasis", "dividebasisstr", "caldimension", "caldimensionstr"});
        HashMap<Integer, Long> dimensionIdMap = new HashMap<Integer, Long>(16);
        HashMap<Integer, String> dimensionStrMap = new HashMap<Integer, String>(16);
        HashMap<Integer, String> divideStrMap = new HashMap<Integer, String>(16);
        ArrayList<String> filterList = new ArrayList<String>(16);
        int i = 0;
        for (Row row : divideDataSet) {
            long caldimensionid = row.getLong("caldimension");
            long dividebasisid = row.getLong("dividebasis");
            filterList.add(QFilter.of((String)("dividebasis = " + dividebasisid + " and caldimension = " + caldimensionid), (Object[])new Object[0]).toString());
            dimensionIdMap.put(i, caldimensionid);
            dimensionStrMap.put(i, row.getString("caldimensionstr"));
            divideStrMap.put(i, row.getString("dividebasisstr"));
            ++i;
        }
        if (filterList.isEmpty()) {
            return null;
        }
        DataSet[] dataSetArray = dataSet.splitByFilter(filterList.toArray(new String[0]), false);
        String nullstr = ResManager.loadKDString((String)"\u4e3a\u7a7a", (String)"CalOutBalanceEndNegCostCheck_02", (String)"fi-cal-business", (Object[])new Object[0]);
        int j = 0;
        DataSet unionDataSet = null;
        for (DataSet elementDataSet : dataSetArray) {
            Long caldimensionid = (Long)dimensionIdMap.get(j);
            String caldimensionStr = (String)dimensionStrMap.get(j);
            String dividebasisStr = (String)divideStrMap.get(j);
            StringBuilder groupFields = new StringBuilder();
            groupFields.append("costaccount,costaccountnumber,calrangenumber,material,materialnumber,caldimensionstr,");
            if (StringUtils.isNotEmpty((String)dividebasisStr)) {
                groupFields.append(CommonUtils.trimComma((String)dividebasisStr));
            }
            if (caldimensionid != 0L && StringUtils.isNotEmpty((String)caldimensionStr)) {
                groupFields.append(',');
                groupFields.append(CommonUtils.trimComma((String)caldimensionStr));
            }
            elementDataSet = elementDataSet.map((MapFunction)new DealCaldimensionCheckFuncion(elementDataSet.getRowMeta(), nullstr, auxValueNameMap));
            elementDataSet = elementDataSet.groupBy(groupFields.toString().split(",")).sum("periodendqty").sum("periodendactualcost").finish();
            elementDataSet = elementDataSet.select("caldimensionstr,calrangenumber,costaccount,costaccountnumber,material,materialnumber,periodendqty,periodendactualcost");
            unionDataSet = unionDataSet == null ? elementDataSet : unionDataSet.union(elementDataSet);
            ++j;
        }
        return unionDataSet;
    }

    private DataSet handleCalRangeDataSet(DataSet dataSet, Map<Long, String> auxValueNameMap) {
        DataSet dimensionDataSet = dataSet.copy().groupBy(new String[]{"caldimension", "caldimensionstr"}).finish().select(new String[]{"caldimension", "caldimensionstr"});
        HashMap<Integer, Long> dimensionIdMap = new HashMap<Integer, Long>(16);
        HashMap<Integer, String> dimensionStrMap = new HashMap<Integer, String>(16);
        ArrayList<String> filterList = new ArrayList<String>(16);
        int i = 0;
        for (Row row : dimensionDataSet) {
            long caldimensionid = row.getLong("caldimension");
            filterList.add(QFilter.of((String)("caldimension = " + caldimensionid), (Object[])new Object[0]).toString());
            dimensionIdMap.put(i, caldimensionid);
            dimensionStrMap.put(i, row.getString("caldimensionstr"));
            ++i;
        }
        if (filterList.isEmpty()) {
            return null;
        }
        DataSet[] dataSetArray = dataSet.splitByFilter(filterList.toArray(new String[0]), false);
        int j = 0;
        DataSet unionDataSet = null;
        String nullstr = ResManager.loadKDString((String)"\u4e3a\u7a7a", (String)"CalOutBalanceEndNegCostCheck_02", (String)"fi-cal-business", (Object[])new Object[0]);
        for (DataSet elementDataSet : dataSetArray) {
            Long caldimensionid = (Long)dimensionIdMap.get(j);
            String caldimensionStr = (String)dimensionStrMap.get(j);
            StringBuilder groupFields = new StringBuilder();
            groupFields.append("costaccount,costaccountnumber,calrange,calrangenumber,material,materialnumber,caldimensionstr");
            if (caldimensionid != 0L && StringUtils.isNotEmpty((String)caldimensionStr)) {
                groupFields.append(',');
                groupFields.append(CommonUtils.trimComma((String)caldimensionStr));
            }
            elementDataSet = elementDataSet.map((MapFunction)new DealCaldimensionCheckFuncion(elementDataSet.getRowMeta(), nullstr, auxValueNameMap));
            elementDataSet = elementDataSet.groupBy(groupFields.toString().split(",")).sum("periodendqty").sum("periodendactualcost").finish();
            elementDataSet = elementDataSet.select("caldimensionstr,calrangenumber,costaccount,costaccountnumber,material,materialnumber,periodendqty,periodendactualcost");
            unionDataSet = unionDataSet == null ? elementDataSet : unionDataSet.union(elementDataSet);
            ++j;
        }
        return unionDataSet;
    }

    @Override
    protected QFilter analyseCostAccountFilter(DataCheckParam param) {
        if (!"cal_balance".equals(this.entityType.getName()) && !"cal_bal".equals(this.entityType.getName())) {
            return super.analyseCostAccountFilter(param);
        }
        IDataEntityProperty accountProperty = this.entityType.findProperty("costaccount");
        Set<Long> costaccount = param.getCostAccount();
        if (accountProperty == null) {
            return null;
        }
        if (costaccount == null || costaccount.isEmpty()) {
            costaccount = this.getAllValidCostAccount();
        }
        ArrayList<QFilter> fList = new ArrayList<QFilter>(costaccount.size());
        String costAccountName = this.analyseFieldName(accountProperty);
        for (Long costAccountId : costaccount) {
            QFilter filter = new QFilter(costAccountName, "=", (Object)costAccountId);
            DynamicObject period = this.getCurrentPeriod(costAccountId);
            if (period == null) continue;
            filter = filter.and("period", "<=", (Object)(period.getInt("periodyear") * 100 + period.getInt("periodnumber")));
            filter = filter.and("endperiod", ">", (Object)(period.getInt("periodyear") * 100 + period.getInt("periodnumber")));
            fList.add(filter);
        }
        if (fList.isEmpty()) {
            return new QFilter("id", "=", (Object)0);
        }
        QFilter firstFilter = (QFilter)fList.get(0);
        for (int i = 1; i < fList.size(); ++i) {
            firstFilter = firstFilter.or((QFilter)fList.get(i));
        }
        return firstFilter;
    }

    protected List<ExceptionObj> dealExceptionObject(DataSet dataSet) {
        ArrayList<ExceptionObj> exceptiodObjList = new ArrayList<ExceptionObj>(16);
        dataSet = dataSet.filter("periodendqty <> 0 or periodendactualcost <> 0");
        dataSet = dataSet.select("calrangenumber,costaccount,costaccountnumber,material,materialnumber,case when periodendqty != 0 then periodendactualcost/periodendqty else 0 end as periodendprice");
        dataSet = dataSet.filter("periodendprice = 0");
        for (Row row : dataSet) {
            String costaccountnumber = row.getString("costaccountnumber");
            String materialnumber = row.getString("materialnumber");
            String calrangenumber = row.getString("calrangenumber");
            BigDecimal periodEndPrice = row.getBigDecimal("periodendprice");
            if (periodEndPrice.compareTo(BigDecimal.ZERO) == 0) {
                periodEndPrice = BigDecimal.ZERO;
            }
            String errmsg = String.format(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u201c%1$s\u201d\u6838\u7b97\u8303\u56f4\u201c%2$s\u201d\u4e0b\u5b58\u5728\u671f\u672b\u7ed3\u5b58\u5355\u4f4d\u5b9e\u9645\u6210\u672c\u201c%3$s\u201d\u7b49\u4e8e0\u7684\u7269\u6599\u201c%4$s\u201d\u3002", (String)"CalOutBalanceEndQtyCheck_2", (String)"fi-cal-business", (Object[])new Object[0]), costaccountnumber, calrangenumber, periodEndPrice, materialnumber);
            ExceptionObj exceptionObj = new ExceptionObj(0L, "cal_balance");
            exceptionObj.setDescription(errmsg);
            exceptiodObjList.add(exceptionObj);
        }
        return exceptiodObjList;
    }

    private String getBalanceField() {
        String selectFields = "";
        String moreFields = "calorg,caldimension,caldimension.caldimension as caldimensionstr,calrange,calrange.number as calrangenumber,costaccount.dividebasis as dividebasis,costaccount.dividebasis.dividebasis as dividebasisstr,periodendqty,periodendactualcost";
        if (this.isNewBalance) {
            moreFields = moreFields.replaceAll("periodendqty", "baseqty_bal as periodendqty");
            moreFields = moreFields.replaceAll("periodendactualcost", "actualcost_bal as periodendactualcost");
            String dimfieldstr = CalBalanceModelHelper.getDimFields((boolean)true);
            HashSet<String> dimfieldSet = new HashSet<String>(16);
            if (StringUtils.isNotEmpty((String)dimfieldstr)) {
                String[] dimfields;
                for (String dimfield : dimfields = dimfieldstr.split(",")) {
                    if (!StringUtils.isNotEmpty((String)dimfield)) continue;
                    dimfieldSet.add(dimfield);
                }
            }
            String dimSelects = this.getDetailDimFieldsAndBaseName("cal_bal", dimfieldSet);
            selectFields = dimSelects + moreFields;
        } else {
            String dimSelects = this.getDetailDimFieldsAndBaseName("cal_balance", CalBalanceModelHelper.getBalanceDimField());
            selectFields = dimSelects + moreFields;
        }
        return selectFields;
    }

    @Override
    protected String getDataEntityType() {
        if (this.isNewBalance) {
            return "cal_bal";
        }
        return "cal_balance";
    }

    @Override
    public List<ExceptionObj> collectExceptionObj(DataSet dataSet, DataCheckParam param) {
        return null;
    }

    public String getDetailDimFieldsAndBaseName(String entityType, Set<String> dimFieldSet) {
        StringBuilder fieldsStr = new StringBuilder();
        MainEntityType detailEntityType = MetadataServiceHelper.getDataEntityType((String)entityType);
        for (String fieldKey : dimFieldSet) {
            if (!(detailEntityType.findProperty(fieldKey).getParent() instanceof MainEntityType)) continue;
            fieldsStr.append(fieldKey).append(" as ").append(fieldKey).append(',');
            if (!(detailEntityType.findProperty(fieldKey) instanceof BasedataProp) || detailEntityType.findProperty(fieldKey) instanceof FlexProp) continue;
            fieldsStr.append(fieldKey).append(".number as ").append(fieldKey).append("number").append(',');
        }
        return fieldsStr.toString();
    }

    public static Map<Long, String> getAuxValueNameMap(Set<Long> auxptyIds) {
        HashMap<Long, String> auxValueNameMap = new HashMap<Long, String>(16);
        DynamicObjectCollection auxPropObj = QueryServiceHelper.query((String)"bd_flexauxprop", (String)"id,value", (QFilter[])new QFilter[]{new QFilter("id", "in", auxptyIds)});
        HashSet auxptyTypes = new HashSet(16);
        HashSet<Long> auxptyValue = new HashSet<Long>(16);
        HashMap<Long, String> auxptyMap = new HashMap<Long, String>(16);
        for (DynamicObject aux : auxPropObj) {
            if (StringUtils.isEmpty((String)aux.getString("value"))) continue;
            JSONObject value = (JSONObject)JSON.parse((String)aux.getString("value"));
            for (Map.Entry val : value.entrySet()) {
                auxptyTypes.add(val.getKey());
                try {
                    auxptyValue.add(Long.parseLong(val.getValue().toString()));
                }
                catch (Exception e) {
                    WriteLogHelper.writeErrorLog((Log)logger, (String)"CalOutBalanceEndZeroCostCheck-getAuxValueNameMap", (Throwable)e);
                }
                auxptyMap.put(aux.getLong("id"), aux.getString("value"));
            }
        }
        DynamicObjectCollection auxProptys = QueryServiceHelper.query((String)"bd_auxproperty", (String)"flexfield,name,valuesource", (QFilter[])new QFilter[]{new QFilter("flexfield", "in", auxptyTypes)});
        HashMap<String, String> typeNameMap = new HashMap<String, String>(16);
        HashSet<String> valuesourceSet = new HashSet<String>(16);
        for (DynamicObject aux : auxProptys) {
            typeNameMap.put(aux.getString("flexfield"), aux.getString("name"));
            String valuesource = aux.getString("valuesource");
            if (StringUtils.isBlank((String)valuesource)) continue;
            valuesourceSet.add(valuesource);
        }
        HashMap<Long, String> auxpValueMap = new HashMap<Long, String>(16);
        for (String valuesource : valuesourceSet) {
            DynamicObjectCollection auxProptyValues = QueryServiceHelper.query((String)valuesource, (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "in", auxptyValue)});
            for (DynamicObject aux : auxProptyValues) {
                auxpValueMap.put(aux.getLong("id"), aux.getString("name"));
            }
        }
        for (Long auxpropId : auxptyIds) {
            String auxValueStr = (String)auxptyMap.get(auxpropId);
            JSONObject value = (JSONObject)JSON.parse((String)auxValueStr);
            if (value == null) continue;
            StringBuilder auxStr = new StringBuilder();
            for (Map.Entry val : value.entrySet()) {
                try {
                    auxStr.append((String)typeNameMap.get(val.getKey())).append(';').append((String)auxpValueMap.get(Long.parseLong(val.getValue().toString()))).append(';');
                }
                catch (Exception e) {
                    auxStr.append(val.getValue());
                    auxStr.append(";");
                    WriteLogHelper.writeErrorLog((Log)logger, (String)"CalOutBalanceEndZeroCostCheck-getAuxValueNameMap", (Throwable)e);
                }
            }
            String auxStrss = null;
            if (auxStr.length() > 0) {
                auxStrss = auxStr.substring(0, auxStr.length() - 1);
            }
            auxValueNameMap.put(auxpropId, auxStrss);
        }
        return auxValueNameMap;
    }
}

