/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.datacheck.item;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.business.datacheck.DataCheckParam;
import kd.fi.cal.business.datacheck.ExceptionObj;
import kd.fi.cal.business.datacheck.item.DataEntityDataCheck;

public class CalOutEstimateStatusCheck
extends DataEntityDataCheck {
    private Map<Long, Set<Long>> calorgMapPeriod = null;
    private Map<Long, DynamicObject> periodMap = new HashMap<Long, DynamicObject>();

    @Override
    public List<ExceptionObj> collectExceptionObj(List<DataCheckParam> paramList) {
        ArrayList<ExceptionObj> exceptiodObjList = new ArrayList<ExceptionObj>(16);
        this.initPeriodMap(paramList);
        for (Map.Entry<Long, Set<Long>> calorgMapPeriod : this.getCalorgMapPeriod(paramList).entrySet()) {
            Long calOrgId = calorgMapPeriod.getKey();
            for (Long periodId : calorgMapPeriod.getValue()) {
                DynamicObject periodObj = this.periodMap.get(periodId);
                QFilter q = new QFilter("estimatedate", ">=", (Object)periodObj.getDate("begindate"));
                q.and("estimatedate", "<=", (Object)periodObj.getDate("enddate"));
                q.and("calorg", "=", (Object)calOrgId);
                q.and("billstatus", "<>", (Object)"C");
                DynamicObjectCollection coll = QueryServiceHelper.query((String)"cal_costestimatebill", (String)"id,billno", (QFilter[])q.toArray());
                for (DynamicObject bill : coll) {
                    String msg = String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u5904\u7406\u5f53\u671f\u8d39\u7528\u6682\u4f30\u5355\uff0c\u8fdb\u884c\u8d39\u7528\u6682\u4f30\u6216\u8005\u4e0a\u67e5\u6682\u4f30\u5e94\u4ed8\u5355\u505a\u53cd\u5ba1\u6838\u64cd\u4f5c\uff1a%1$s", (String)"CalOutEstimateStatusCheck_0", (String)"fi-cal-business", (Object[])new Object[0]), bill.getString("billno"));
                    ExceptionObj exceptionObj = new ExceptionObj(bill.getLong("id"), "cal_costestimatebill");
                    exceptionObj.setDescription(msg);
                    exceptiodObjList.add(exceptionObj);
                }
            }
        }
        return exceptiodObjList;
    }

    @Override
    public List<ExceptionObj> collectExceptionObj(DataCheckParam param) {
        ArrayList<ExceptionObj> exceptiodObjList = new ArrayList<ExceptionObj>(16);
        List<QFilter> fList = this.analyseBizRangeFilter(param);
        fList.add(new QFilter("billstatus", "<>", (Object)"C"));
        if (param.getStartDate() != null && param.getEndDate() != null) {
            QFilter dateQ = new QFilter("estimatedate", ">=", (Object)param.getStartDate());
            dateQ.and("estimatedate", "<=", (Object)param.getEndDate());
            fList.add(dateQ);
        }
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"cal_costestimatebill", (String)"id,billno", (QFilter[])fList.toArray(new QFilter[0]));
        for (DynamicObject bill : coll) {
            String msg = String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u5904\u7406\u5f53\u671f\u8d39\u7528\u6682\u4f30\u5355\uff0c\u8fdb\u884c\u8d39\u7528\u6682\u4f30\u6216\u8005\u4e0a\u67e5\u6682\u4f30\u5e94\u4ed8\u5355\u505a\u53cd\u5ba1\u6838\u64cd\u4f5c\uff1a%1$s", (String)"CalOutEstimateStatusCheck_0", (String)"fi-cal-business", (Object[])new Object[0]), bill.getString("billno"));
            ExceptionObj exceptionObj = new ExceptionObj(bill.getLong("id"), "cal_costestimatebill");
            exceptionObj.setDescription(msg);
            exceptiodObjList.add(exceptionObj);
        }
        return exceptiodObjList;
    }

    public Map<Long, Set<Long>> getCalorgMapPeriod(List<DataCheckParam> paramList) {
        if (this.calorgMapPeriod == null) {
            this.calorgMapPeriod = new HashMap<Long, Set<Long>>(paramList.size());
            for (DataCheckParam param : paramList) {
                Long calOrgId = param.getCalorg().iterator().next();
                Long periodId = param.getPeriodId();
                Set periodIdSet = this.calorgMapPeriod.computeIfAbsent(calOrgId, k -> new HashSet());
                periodIdSet.add(periodId);
            }
        }
        return this.calorgMapPeriod;
    }

    private void initPeriodMap(List<DataCheckParam> paramList) {
        DynamicObject[] periods;
        HashSet<Long> periodIdSet = new HashSet<Long>(16);
        for (DataCheckParam param : paramList) {
            periodIdSet.add(param.getPeriodId());
        }
        for (DynamicObject period : periods = BusinessDataServiceHelper.load((String)"bd_period", (String)"id,begindate,enddate,periodyear,periodnumber", (QFilter[])new QFilter("id", "in", periodIdSet).toArray())) {
            this.periodMap.put(period.getLong("id"), period);
        }
    }

    @Override
    protected String getDataEntityType() {
        return "cal_costestimatebill";
    }

    @Override
    protected Set<String> getSelectedFields() {
        return null;
    }

    @Override
    public List<ExceptionObj> collectExceptionObj(DataSet dataSet, DataCheckParam param) {
        return null;
    }
}

