/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.datacheck.item;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.input.OrmInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.business.datacheck.DataCheckParam;
import kd.fi.cal.business.datacheck.ExceptionObj;
import kd.fi.cal.business.datacheck.item.DataEntityDataCheck;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.common.helper.SCMHelper;

public class CalOutRecordStatusCheck
extends DataEntityDataCheck {
    @Override
    public List<ExceptionObj> collectExceptionObj(List<DataCheckParam> paramList) {
        DataSet costRecordDataSet = this.createCostRecordBizDataSet(paramList);
        if (costRecordDataSet.isEmpty()) {
            return null;
        }
        HashSet<Long> costAccountIdSet = new HashSet<Long>(16);
        for (DataCheckParam param : paramList) {
            costAccountIdSet.addAll(param.getCostAccount());
        }
        return this.dealExceptionObject(costRecordDataSet, costAccountIdSet);
    }

    @Override
    public List<ExceptionObj> collectExceptionObj(DataCheckParam param) {
        DataSet costRecordDataSet = this.createCostRecordBizDataSet(param);
        if (costRecordDataSet.isEmpty()) {
            return null;
        }
        Set<Long> costAccountIdSet = param.getCostAccount();
        if (costAccountIdSet == null || costAccountIdSet.isEmpty()) {
            costAccountIdSet = new HashSet<Long>(16);
            DynamicObjectCollection costAccounts = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"id", (QFilter[])new QFilter("enable", "=", (Object)Boolean.TRUE).toArray());
            for (DynamicObject costAccount : costAccounts) {
                costAccountIdSet.add(costAccount.getLong("id"));
            }
        }
        return this.dealExceptionObject(costRecordDataSet, costAccountIdSet);
    }

    private DataSet createCostRecordBizDataSet(List<DataCheckParam> paramList) {
        Set calInvSchemeIdSet = SCMHelper.getCalInvSchemes();
        Set calInvTypeIdSet = SCMHelper.getCalInvTypes();
        Set noUpdateBalBizTypeSet = CommonSettingHelper.getNotUpdBalBizType();
        ArrayList<OrmInput> rangesIO = new ArrayList<OrmInput>(paramList.size());
        for (DataCheckParam param : paramList) {
            OrmInput rangeIO;
            QFilter filter = null;
            if (param.isNeedCalculatedLater()) {
                filter = new QFilter("period.id", ">=", (Object)param.getPeriodId());
                filter.and("bookdate", ">=", (Object)param.getStartDate());
            } else {
                filter = new QFilter("period.id", "=", (Object)param.getPeriodId());
                filter.and("bookdate", ">=", (Object)param.getStartDate());
                filter.and("bookdate", "<=", (Object)param.getEndDate());
            }
            filter.and("costaccount.id", "in", param.getCostAccount());
            if (param.getCalRangeId() != null) {
                filter.and("entry.calrange", "=", (Object)param.getCalRangeId());
            }
            filter.and("isinitbill", "=", (Object)Boolean.FALSE);
            filter.and("issplitcreate", "=", (Object)Boolean.FALSE);
            filter.and("invscheme", "in", (Object)calInvSchemeIdSet);
            filter.and("entry.invtype", "in", (Object)calInvTypeIdSet);
            filter.and("biztype", "not in", (Object)noUpdateBalBizTypeSet);
            filter.and("billstatus", "!=", (Object)"C");
            if (param.isAllMaterial()) {
                rangeIO = new OrmInput(this.getClass().getName(), "cal_costrecord_subentity", this.getCostRecordBizField(), filter.toArray());
            } else {
                QFilter mFilter = filter.copy();
                mFilter.and("entry.material.id", "in", param.getMaterial());
                rangeIO = new OrmInput(this.getClass().getName(), "cal_costrecord_subentity", this.getCostRecordBizField(), mFilter.toArray());
            }
            rangesIO.add(rangeIO);
        }
        Algo algo = Algo.create((String)this.getClass().getName());
        DataSet unionDataSet = algo.createDataSet((Input[])rangesIO.toArray(new OrmInput[rangesIO.size()]));
        return unionDataSet;
    }

    private DataSet createCostRecordBizDataSet(DataCheckParam param) {
        Set calInvSchemeIdSet = SCMHelper.getCalInvSchemes();
        Set calInvTypeIdSet = SCMHelper.getCalInvTypes();
        Set noUpdateBalBizTypeSet = CommonSettingHelper.getNotUpdBalBizType();
        List<QFilter> fList = this.analyseBizRangeFilter(param);
        QFilter otherQ = new QFilter("isinitbill", "=", (Object)Boolean.FALSE);
        otherQ.and("issplitcreate", "=", (Object)Boolean.FALSE);
        otherQ.and("invscheme", "in", (Object)calInvSchemeIdSet);
        otherQ.and("entry.invtype", "in", (Object)calInvTypeIdSet);
        otherQ.and("biztype", "not in", (Object)noUpdateBalBizTypeSet);
        otherQ.and("billstatus", "!=", (Object)"C");
        fList.add(otherQ);
        return QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord_subentity", (String)this.getCostRecordBizField(), (QFilter[])fList.toArray(new QFilter[0]), null);
    }

    private List<ExceptionObj> dealExceptionObject(DataSet dataSet, Set<Long> costAccountIdSet) {
        ArrayList<ExceptionObj> exceptiodObjList = new ArrayList<ExceptionObj>(16);
        HashSet<String> billNoSet = new HashSet<String>(32);
        String entityName = EntityMetadataCache.getDataEntityType((String)"cal_costrecord_subentity").getDisplayName().getLocaleValue();
        Map currentPeriods = PeriodHelper.getCurrentPeriods(costAccountIdSet);
        Set<String> allIgnoreChargeOffBills = this.getIgnoreChargeOffBills(dataSet.copy());
        for (Row row : dataSet) {
            ExceptionObj exceptionObj;
            String msg;
            Long curPeriodid;
            boolean isCur;
            StringBuilder errorMsg = new StringBuilder();
            Long costAccountId = row.getLong("costaccount");
            Long periodId = row.getLong("periodid");
            boolean bl = isCur = periodId.compareTo(curPeriodid = Long.valueOf(((DynamicObject)currentPeriods.get(costAccountId)).getLong("id"))) == 0;
            if (!isCur) continue;
            String billStatus = row.getString("billstatus");
            String costaccountnumber = row.getString("costaccountnumber");
            String billno = row.getString("billno");
            String accountBillkey = billno + "_" + costAccountId;
            if ("A".equals(billStatus)) {
                if (billNoSet.contains(accountBillkey)) continue;
                billNoSet.add(accountBillkey);
                msg = ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u3010%1$s\u3011\u4e0b\u5b58\u5728\u6682\u5b58\u7684%1$s\uff0c\u5355\u53f7\u4e3a\uff1a", (String)"CalOutAdjustStatusCheck_3", (String)"fi-cal-business", (Object[])new Object[0]);
                msg = String.format(msg, costaccountnumber, entityName);
                errorMsg.append(msg).append(billno);
                exceptionObj = new ExceptionObj(row.getLong("id"), "cal_costrecord_subentity");
                exceptionObj.setDescription(errorMsg.toString());
                exceptiodObjList.add(exceptionObj);
            }
            if (!"B".equals(billStatus) || billNoSet.contains(accountBillkey) || allIgnoreChargeOffBills.contains(accountBillkey)) continue;
            billNoSet.add(accountBillkey);
            msg = ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u3010%1$s\u3011\u4e0b\u5b58\u5728\u63d0\u4ea4\u7684%1$s\uff0c\u5355\u53f7\u4e3a\uff1a", (String)"CalOutAdjustStatusCheck_4", (String)"fi-cal-business", (Object[])new Object[0]);
            msg = String.format(msg, costaccountnumber, entityName);
            errorMsg.append(msg).append(billno);
            exceptionObj = new ExceptionObj(row.getLong("id"), "cal_costrecord_subentity");
            exceptionObj.setDescription(errorMsg.toString());
            exceptiodObjList.add(exceptionObj);
        }
        return exceptiodObjList;
    }

    private Set<String> getIgnoreChargeOffBills(DataSet dataSet) {
        HashMap<Long, String> billIdAndAccountKeyMap = new HashMap<Long, String>(16);
        HashSet<Long> chargeOffBillSet = new HashSet<Long>(16);
        HashSet<Long> chargeOffedBillSet = new HashSet<Long>(16);
        HashSet<String> allIgnoreChargeOffBills = new HashSet<String>(16);
        for (Row row : dataSet) {
            String billStatus = row.getString("billstatus");
            if (!"B".equals(billStatus)) continue;
            Long billId = row.getLong("id");
            Boolean isChargeOff = row.getBoolean("ischargeoff");
            Boolean isChargeOffed = row.getBoolean("ischargeoffed");
            if (!isChargeOff.booleanValue() && !isChargeOffed.booleanValue()) continue;
            if (isChargeOff.booleanValue()) {
                chargeOffBillSet.add(billId);
            }
            if (isChargeOffed.booleanValue()) {
                chargeOffedBillSet.add(billId);
            }
            String billNo = row.getString("billno");
            Long costAccountId = row.getLong("costaccount");
            String accountBillkey = billNo + "_" + costAccountId;
            billIdAndAccountKeyMap.put(billId, accountBillkey);
        }
        Set<Long> fatherBillIdSet = this.hasSubmitSonBillIdset(chargeOffedBillSet);
        Set<Long> sonBillIdSet = this.hasSubmitFatherBillIdset(chargeOffBillSet);
        fatherBillIdSet.addAll(sonBillIdSet);
        for (Long billId : fatherBillIdSet) {
            allIgnoreChargeOffBills.add((String)billIdAndAccountKeyMap.get(billId));
        }
        return allIgnoreChargeOffBills;
    }

    private Set<Long> hasSubmitSonBillIdset(Set<Long> idSet) {
        QFilter q = new QFilter("entry.srcbillid", "in", idSet);
        q.and("ischargeoff", "=", (Object)Boolean.TRUE);
        q.and("billstatus", "=", (Object)"B");
        HashSet<Long> fatherBillIdSet = new HashSet<Long>(16);
        DynamicObjectCollection chargeOffRecordColl = QueryServiceHelper.query((String)"cal_costrecord", (String)"entry.srcbillid", (QFilter[])q.toArray());
        for (DynamicObject info : chargeOffRecordColl) {
            fatherBillIdSet.add(info.getLong("entry.srcbillid"));
        }
        return fatherBillIdSet;
    }

    private Set<Long> hasSubmitFatherBillIdset(Set<Long> idSet) {
        HashSet<Long> sonBillIdSet = new HashSet<Long>(16);
        QFilter q = new QFilter("id", "in", idSet);
        HashMap<Long, Long> srcBillAndSonBillIdMap = new HashMap<Long, Long>(16);
        DynamicObjectCollection chargeOffRecordColl = QueryServiceHelper.query((String)"cal_costrecord", (String)"id,entry.srcbillid", (QFilter[])q.toArray());
        for (DynamicObject info : chargeOffRecordColl) {
            srcBillAndSonBillIdMap.put(info.getLong("entry.srcbillid"), info.getLong("id"));
        }
        if (srcBillAndSonBillIdMap.isEmpty()) {
            return sonBillIdSet;
        }
        QFilter chargeoffedQ = new QFilter("id", "in", srcBillAndSonBillIdMap.keySet());
        q.and("ischargeoffed", "=", (Object)Boolean.TRUE);
        q.and("billstatus", "=", (Object)"B");
        DynamicObjectCollection chargeOffedRecordColl = QueryServiceHelper.query((String)"cal_costrecord", (String)"id", (QFilter[])chargeoffedQ.toArray());
        for (DynamicObject info : chargeOffedRecordColl) {
            Long sonBillId = (Long)srcBillAndSonBillIdMap.get(info.getLong("id"));
            sonBillIdSet.add(sonBillId);
        }
        return sonBillIdSet;
    }

    private String getCostRecordBizField() {
        return "id,ischargeoff,ischargeoffed,costaccount,period as periodid,billstatus,costaccount.number as costaccountnumber,billno";
    }

    @Override
    protected String getDataEntityType() {
        return "cal_costrecord_subentity";
    }

    @Override
    protected Set<String> getSelectedFields() {
        return null;
    }

    @Override
    public List<ExceptionObj> collectExceptionObj(DataSet dataSet, DataCheckParam param) {
        return null;
    }
}

