/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.datacheck.item;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.input.OrmInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.business.datacheck.DataCheckParam;
import kd.fi.cal.business.datacheck.ExceptionObj;
import kd.fi.cal.business.datacheck.item.DataEntityDataCheck;
import kd.fi.cal.common.enums.AccountTypeEnum;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.common.helper.SCMHelper;

public class CalOutRecordVoucherCheck
extends DataEntityDataCheck {
    @Override
    public List<ExceptionObj> collectExceptionObj(List<DataCheckParam> paramList) {
        DataSet costRecordDataSet = this.createCostRecordBizDataSet(paramList);
        if (costRecordDataSet.isEmpty()) {
            return null;
        }
        HashSet<Long> costAccountIdSet = new HashSet<Long>(16);
        for (DataCheckParam param : paramList) {
            costAccountIdSet.addAll(param.getCostAccount());
        }
        boolean voucherDutGat = false;
        if (paramList != null && paramList.size() > 0) {
            voucherDutGat = paramList.get(0).isVoucherDutWeighteDavgat();
        }
        return this.dealExceptionObject(costRecordDataSet, costAccountIdSet, voucherDutGat);
    }

    @Override
    public List<ExceptionObj> collectExceptionObj(DataCheckParam param) {
        DataSet costRecordDataSet = this.createCostRecordBizDataSet(param);
        if (costRecordDataSet.isEmpty()) {
            return null;
        }
        Set<Long> costAccountIdSet = param.getCostAccount();
        if (costAccountIdSet == null || costAccountIdSet.isEmpty()) {
            costAccountIdSet = new HashSet<Long>(16);
            DynamicObjectCollection costAccounts = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"id", (QFilter[])new QFilter("enable", "=", (Object)Boolean.TRUE).toArray());
            for (DynamicObject costAccount : costAccounts) {
                costAccountIdSet.add(costAccount.getLong("id"));
            }
        }
        return this.dealExceptionObject(costRecordDataSet, costAccountIdSet, false);
    }

    private DataSet createCostRecordBizDataSet(List<DataCheckParam> paramList) {
        Set calInvSchemeIdSet = SCMHelper.getCalInvSchemes();
        Set calInvTypeIdSet = SCMHelper.getCalInvTypes();
        Set noUpdateBalBizTypeSet = CommonSettingHelper.getNotUpdBalBizType();
        ArrayList<OrmInput> rangesIO = new ArrayList<OrmInput>(paramList.size());
        for (DataCheckParam param : paramList) {
            OrmInput rangeIO;
            QFilter filter = null;
            if (param.isNeedCalculatedLater()) {
                filter = new QFilter("period.id", ">=", (Object)param.getPeriodId());
                filter.and("bookdate", ">=", (Object)param.getStartDate());
            } else {
                filter = new QFilter("period.id", "=", (Object)param.getPeriodId());
                filter.and("bookdate", ">=", (Object)param.getStartDate());
                filter.and("bookdate", "<=", (Object)param.getEndDate());
            }
            filter.and("costaccount.id", "in", param.getCostAccount());
            if (param.getCalRangeId() != null) {
                filter.and("entry.calrange", "=", (Object)param.getCalRangeId());
            }
            filter.and("isinitbill", "=", (Object)Boolean.FALSE);
            filter.and("issplitcreate", "=", (Object)Boolean.FALSE);
            filter.and("invscheme", "in", (Object)calInvSchemeIdSet);
            filter.and("entry.invtype", "in", (Object)calInvTypeIdSet);
            filter.and("biztype", "not in", (Object)noUpdateBalBizTypeSet);
            QFilter billStatusf = new QFilter("billstatus", "=", (Object)"C");
            filter.and(billStatusf);
            if (param.isAllMaterial()) {
                rangeIO = new OrmInput(this.getClass().getName(), "cal_costrecord_subentity", this.getCostRecordBizField(), filter.toArray());
            } else {
                QFilter mFilter = filter.copy();
                mFilter.and("entry.material.id", "in", param.getMaterial());
                rangeIO = new OrmInput(this.getClass().getName(), "cal_costrecord_subentity", this.getCostRecordBizField(), mFilter.toArray());
            }
            rangesIO.add(rangeIO);
        }
        Algo algo = Algo.create((String)this.getClass().getName());
        DataSet unionDataSet = algo.createDataSet((Input[])rangesIO.toArray(new OrmInput[rangesIO.size()]));
        return unionDataSet;
    }

    private DataSet createCostRecordBizDataSet(DataCheckParam param) {
        Set calInvSchemeIdSet = SCMHelper.getCalInvSchemes();
        Set calInvTypeIdSet = SCMHelper.getCalInvTypes();
        Set noUpdateBalBizTypeSet = CommonSettingHelper.getNotUpdBalBizType();
        List<QFilter> fList = this.analyseBizRangeFilter(param);
        QFilter otherQ = new QFilter("isinitbill", "=", (Object)Boolean.FALSE);
        otherQ.and("issplitcreate", "=", (Object)Boolean.FALSE);
        otherQ.and("invscheme", "in", (Object)calInvSchemeIdSet);
        otherQ.and("entry.invtype", "in", (Object)calInvTypeIdSet);
        otherQ.and("biztype", "not in", (Object)noUpdateBalBizTypeSet);
        QFilter billStatusf = new QFilter("billstatus", "=", (Object)"C");
        otherQ.and(billStatusf);
        fList.add(otherQ);
        return QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord_subentity", (String)this.getCostRecordBizField(), (QFilter[])fList.toArray(new QFilter[0]), null);
    }

    private List<ExceptionObj> dealExceptionObject(DataSet dataSet, Set<Long> costAccountIdSet, boolean voucherDutGat) {
        ArrayList<ExceptionObj> exceptiodObjList = new ArrayList<ExceptionObj>(16);
        Map currentPeriods = PeriodHelper.getCurrentPeriods(costAccountIdSet);
        HashSet<String> billNoSet = new HashSet<String>(32);
        for (Row row : dataSet) {
            boolean isCur;
            StringBuilder errorMsg = new StringBuilder();
            boolean isfivoucher = row.getBoolean("isfivoucher");
            String costaccountnumber = row.getString("costaccountnumber");
            String billno = row.getString("billno");
            String calBillType = row.getString("calbilltype");
            Long costAccountId = row.getLong("costaccount");
            Long periodId = row.getLong("periodid");
            Long curPeriodid = ((DynamicObject)currentPeriods.get(costAccountId)).getLong("id");
            String accountType = row.getString("accounttype");
            if (voucherDutGat && StringUtils.isNotEmpty((CharSequence)accountType) && (AccountTypeEnum.ADD_AVERAGE.getValue().equals(accountType) || AccountTypeEnum.SPECIAL_ACCT.getValue().equals(accountType))) continue;
            boolean bl = isCur = periodId.compareTo(curPeriodid) == 0;
            if (!isCur) continue;
            String accountBillkey = billno + "_" + costAccountId;
            if (!"OUT".equals(calBillType) || !isfivoucher || billNoSet.contains(accountBillkey)) continue;
            billNoSet.add(accountBillkey);
            String calOutRecordVoucherCheck_0 = ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u3010%1$s\u3011\u4e0b\u5b58\u5728\u5df2\u751f\u6210\u51ed\u8bc1\u7684\u51fa\u5e93\u6838\u7b97\u6210\u672c\u8bb0\u5f55\uff0c\u5355\u53f7\u4e3a\uff1a", (String)"CalOutRecordVoucherCheck_0", (String)"fi-cal-business", (Object[])new Object[0]);
            calOutRecordVoucherCheck_0 = String.format(calOutRecordVoucherCheck_0, costaccountnumber);
            errorMsg.append(calOutRecordVoucherCheck_0).append(billno);
            ExceptionObj exceptionObj = new ExceptionObj(row.getLong("id"), "cal_costrecord_subentity");
            exceptionObj.setDescription(errorMsg.toString());
            exceptiodObjList.add(exceptionObj);
        }
        return exceptiodObjList;
    }

    private String getCostRecordBizField() {
        return "id,costaccount,billstatus,period as periodid,costaccount.number as costaccountnumber,billno,isfivoucher,calbilltype,entry.accounttype as accounttype";
    }

    @Override
    protected String getDataEntityType() {
        return "cal_costrecord_subentity";
    }

    @Override
    protected Set<String> getSelectedFields() {
        return null;
    }

    @Override
    public List<ExceptionObj> collectExceptionObj(DataSet dataSet, DataCheckParam param) {
        return null;
    }
}

