/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.datacheck.item;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.input.OrmInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QEmptyValue;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.business.calculate.bizbillgroup.BizGroupRecordBuilder;
import kd.fi.cal.business.datacheck.DataCheckParam;
import kd.fi.cal.business.datacheck.ExceptionObj;
import kd.fi.cal.business.datacheck.item.DataEntityDataCheck;
import kd.fi.cal.common.helper.AcctGroupModelHelper;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.common.helper.SCMHelper;

public class CalOutRecordZeroCostCheck
extends DataEntityDataCheck {
    private Set<Long> groupRecordIdSet = null;
    private static final int SPLIT_SIZE = 5000;

    @Override
    public List<ExceptionObj> collectExceptionObj(List<DataCheckParam> paramList) {
        DataSet billGroupRecordDataSet = this.createBillGroupDataSet(paramList);
        DataSet costRecordDataSet = this.createCostRecordBizDataSet(paramList);
        costRecordDataSet = costRecordDataSet.leftJoin(billGroupRecordDataSet).on("entryid", "groupentryid").select(new String[]{"id", "costaccount", "periodid", "costaccountnumber", "billno", "actualcost", "unitactualcost", "baseqty", "calbilltype", "ispresent"}, new String[]{"groupid"}).finish();
        boolean isNeed = paramList.get(0).isNeedCalculatedLater();
        HashSet<Long> costAccountIdSet = new HashSet<Long>(16);
        for (DataCheckParam param : paramList) {
            costAccountIdSet.addAll(param.getCostAccount());
        }
        return this.dealExceptionObject(billGroupRecordDataSet, costRecordDataSet, costAccountIdSet, isNeed);
    }

    @Override
    public List<ExceptionObj> collectExceptionObj(DataCheckParam param) {
        DataSet billGroupRecordDataSet = this.createBillGroupDataSet(param);
        DataSet costRecordDataSet = this.createCostRecordBizDataSet(param);
        costRecordDataSet = costRecordDataSet.leftJoin(billGroupRecordDataSet).on("entryid", "groupentryid").select(new String[]{"id", "costaccount", "periodid", "costaccountnumber", "billno", "actualcost", "unitactualcost", "baseqty", "calbilltype", "ispresent"}, new String[]{"groupid"}).finish();
        boolean isNeed = false;
        Set<Long> costAccountIdSet = param.getCostAccount();
        if (costAccountIdSet == null || costAccountIdSet.isEmpty()) {
            costAccountIdSet = new HashSet<Long>(16);
            DynamicObjectCollection costAccounts = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"id", (QFilter[])new QFilter("enable", "=", (Object)Boolean.TRUE).toArray());
            for (DynamicObject costAccount : costAccounts) {
                costAccountIdSet.add(costAccount.getLong("id"));
            }
        }
        return this.dealExceptionObject(billGroupRecordDataSet, costRecordDataSet, costAccountIdSet, isNeed);
    }

    private List<ExceptionObj> dealExceptionObject(DataSet billGroupRecordDataSet, DataSet costRecordDataSet, Set<Long> costAccountIdSet, boolean isNeed) {
        ArrayList<ExceptionObj> exceptiodObjList = new ArrayList<ExceptionObj>(16);
        Map currentPeriods = PeriodHelper.getCurrentPeriods(costAccountIdSet);
        HashSet<String> billNoSet = new HashSet<String>(32);
        for (Row row : costRecordDataSet) {
            Long curPeriodid;
            boolean isCur;
            StringBuilder errorMsg = new StringBuilder();
            Long costAccountId = row.getLong("costaccount");
            Long periodId = row.getLong("periodid");
            boolean bl = isCur = periodId.compareTo(curPeriodid = Long.valueOf(((DynamicObject)currentPeriods.get(costAccountId)).getLong("id"))) == 0;
            if (!isCur) continue;
            String costaccountnumber = row.getString("costaccountnumber");
            String billno = row.getString("billno");
            String accountBillkey = billno + "_" + costAccountId;
            String groupid = row.getString("groupid");
            boolean isInGroup = groupid != null;
            boolean isUnitActualCostCorrect = false;
            BigDecimal actualCost = row.getBigDecimal("actualcost");
            BigDecimal qty = row.getBigDecimal("baseqty");
            BigDecimal unitActualCost = row.getBigDecimal("unitactualcost");
            int result = unitActualCost.compareTo(BigDecimal.ZERO);
            isUnitActualCostCorrect = result < 0 ? false : (result == 0 ? (actualCost.compareTo(BigDecimal.ZERO) == 0 || qty.compareTo(BigDecimal.ZERO) == 0 ? false : actualCost.signum() == qty.signum()) : true);
            if (isInGroup || !"IN".equals(row.getString("calbilltype")) || row.getBoolean("ispresent").booleanValue() || isUnitActualCostCorrect || billNoSet.contains(accountBillkey)) continue;
            billNoSet.add(accountBillkey);
            String calOutAdjustStatusCheck_0 = ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u201c%1$s\u201d\u7684\u5165\u5e93\u7c7b\u578b\u6838\u7b97\u6210\u672c\u8bb0\u5f55\uff0c\u5b58\u5728\u5206\u5f55\u5355\u4f4d\u5b9e\u9645\u6210\u672c\u5c0f\u4e8e\u7b49\u4e8e0\u7684\u8bb0\u5f55\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"CalOutRecordZeroCostCheck_0", (String)"fi-cal-business", (Object[])new Object[0]);
            calOutAdjustStatusCheck_0 = String.format(calOutAdjustStatusCheck_0, costaccountnumber);
            errorMsg.append(calOutAdjustStatusCheck_0).append(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\u4e3a\uff1a", (String)"CalOutRecordZeroCostCheck_1", (String)"fi-cal-business", (Object[])new Object[0])).append(billno);
            ExceptionObj exceptionObj = new ExceptionObj(row.getLong("id"), "cal_costrecord_subentity");
            exceptionObj.setDescription(errorMsg.toString());
            exceptiodObjList.add(exceptionObj);
        }
        return exceptiodObjList;
    }

    public DataSet createBillGroupDataSet(Object param) {
        if (AcctGroupModelHelper.isBizGroupModel()) {
            Map<Long, Set<Object>> costAccount2MaterialidMap = param instanceof DataCheckParam ? this.getCostAccountMaterialMap((DataCheckParam)param) : this.getCostAccountMaterialMap(((List)param).toArray(new DataCheckParam[0]));
            DataSet groupDS = new BizGroupRecordBuilder().getAllGroupRecordDataSetByCostAccount(costAccount2MaterialidMap);
            groupDS = groupDS.select("groupid,costfields,costcolumn,iscompleted,type as grouptype,costrecordentryid as groupentryid");
            return groupDS;
        }
        DataSet finalDataSet = null;
        if (this.groupRecordIdSet == null) {
            this.groupRecordIdSet = new HashSet<Long>(16);
            DataSet groupIdDataSet = param instanceof DataCheckParam ? this.getGroupRecordDataSet((DataCheckParam)param) : this.getGroupRecordDataSet((List)param);
            if (groupIdDataSet == null) {
                return null;
            }
            while (groupIdDataSet.hasNext()) {
                this.groupRecordIdSet.add(groupIdDataSet.next().getLong("id"));
            }
        }
        HashSet<Long> tempIdSet = new HashSet<Long>(16);
        for (Long groupid : this.groupRecordIdSet) {
            if (tempIdSet.size() >= 5000) {
                DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_account_grouprecord", (String)"TO_CHAR(id) as groupid,groupsetting.costfields as costfields,groupsetting.costcolumn as costcolumn,iscompleted,entryentity.type as grouptype,entryentity.costrecordentryid as groupentryid", (QFilter[])new QFilter("id", "in", tempIdSet).toArray(), null);
                finalDataSet = finalDataSet == null ? dataSet : finalDataSet.union(dataSet);
                tempIdSet = new HashSet();
            }
            tempIdSet.add(groupid);
        }
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_account_grouprecord", (String)"TO_CHAR(id) as groupid,groupsetting.costfields as costfields,groupsetting.costcolumn as costcolumn,iscompleted,entryentity.type as grouptype,entryentity.costrecordentryid as groupentryid", (QFilter[])new QFilter("id", "in", tempIdSet).toArray(), null);
        finalDataSet = finalDataSet == null ? dataSet : finalDataSet.union(dataSet);
        return finalDataSet;
    }

    private Map<Long, Set<Object>> getCostAccountMaterialMap(DataCheckParam ... params) {
        HashMap<Long, Set<Object>> costAccount2MaterialidMap = new HashMap<Long, Set<Object>>(16);
        for (DataCheckParam param : params) {
            Set<Long> costAccounts = param.getCostAccount();
            Set<Long> calorgs = param.getCalorg();
            Set<Long> materials = param.getMaterial();
            HashSet<Long> materialObjs = new HashSet<Long>();
            if (materials != null) {
                materialObjs = new HashSet(16);
                for (Long material : materials) {
                    materialObjs.add(material);
                }
            }
            if (costAccounts == null || costAccounts.isEmpty()) {
                costAccounts = new HashSet<Long>(16);
                if (calorgs != null && !calorgs.isEmpty()) {
                    QFilter filter = new QFilter("enable", "=", (Object)true);
                    filter.and("calorg", "in", calorgs);
                    try (DataSet ds = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_bd_costaccount", (String)"id", (QFilter[])filter.toArray(), null);){
                        for (Row row : ds) {
                            costAccounts.add(row.getLong("id"));
                        }
                    }
                }
            }
            for (Long costAccount : costAccounts) {
                Set curMaterialids = (Set)costAccount2MaterialidMap.get(costAccount);
                if (curMaterialids == null) {
                    costAccount2MaterialidMap.put(costAccount, materialObjs);
                    continue;
                }
                if (curMaterialids.isEmpty() || materialObjs.isEmpty()) {
                    curMaterialids.clear();
                    continue;
                }
                curMaterialids.addAll(materialObjs);
            }
        }
        return costAccount2MaterialidMap;
    }

    private DataSet createCostRecordBizDataSet(List<DataCheckParam> paramList) {
        Set calInvSchemeIdSet = SCMHelper.getCalInvSchemes();
        Set calInvTypeIdSet = SCMHelper.getCalInvTypes();
        Set noUpdateBalBizTypeSet = CommonSettingHelper.getNotUpdBalBizType();
        Object[] zeroInOutBizTypeIds = CommonSettingHelper.getZeroInOutBizTypeIds();
        ArrayList<OrmInput> rangesIO = new ArrayList<OrmInput>(paramList.size());
        for (DataCheckParam param : paramList) {
            OrmInput rangeIO;
            QFilter filter = null;
            if (param.isNeedCalculatedLater()) {
                filter = new QFilter("period.id", ">=", (Object)param.getPeriodId());
                filter.and("bookdate", ">=", (Object)param.getStartDate());
            } else {
                filter = new QFilter("period.id", "=", (Object)param.getPeriodId());
                filter.and("bookdate", ">=", (Object)param.getStartDate());
                filter.and("bookdate", "<=", (Object)param.getEndDate());
            }
            filter.and("costaccount.id", "in", param.getCostAccount());
            if (param.getCalRangeId() != null) {
                filter.and("entry.calrange", "=", (Object)param.getCalRangeId());
            }
            filter.and("isinitbill", "=", (Object)Boolean.FALSE);
            filter.and("issplitcreate", "=", (Object)Boolean.FALSE);
            filter.and("invscheme", "in", (Object)calInvSchemeIdSet);
            filter.and("entry.invtype", "in", (Object)calInvTypeIdSet);
            filter.and("biztype", "not in", (Object)noUpdateBalBizTypeSet);
            if (zeroInOutBizTypeIds.length > 0) {
                filter.and("biztype", "not in", (Object)zeroInOutBizTypeIds);
            }
            QFilter billStatusf = new QFilter("billstatus", "=", (Object)"C");
            filter.and(billStatusf);
            filter.and("entry.ispresent", "=", (Object)Boolean.FALSE);
            filter.and("invscheme.zerocost", "=", (Object)Boolean.FALSE);
            QFilter costPriceSourceFilter = new QFilter("entry.costpricesource", "=", (Object)QEmptyValue.value);
            filter.and(costPriceSourceFilter);
            if (param.isAllMaterial()) {
                rangeIO = new OrmInput(this.getClass().getName(), "cal_costrecord_subentity", this.getCostRecordBizField(), filter.toArray());
            } else {
                QFilter mFilter = filter.copy();
                mFilter.and("entry.material.id", "in", param.getMaterial());
                rangeIO = new OrmInput(this.getClass().getName(), "cal_costrecord_subentity", this.getCostRecordBizField(), mFilter.toArray());
            }
            rangesIO.add(rangeIO);
        }
        Algo algo = Algo.create((String)this.getClass().getName());
        DataSet unionDataSet = algo.createDataSet((Input[])rangesIO.toArray(new OrmInput[rangesIO.size()]));
        return unionDataSet;
    }

    private DataSet createCostRecordBizDataSet(DataCheckParam param) {
        Set calInvSchemeIdSet = SCMHelper.getCalInvSchemes();
        Set calInvTypeIdSet = SCMHelper.getCalInvTypes();
        Set noUpdateBalBizTypeSet = CommonSettingHelper.getNotUpdBalBizType();
        Object[] zeroInOutBizTypeIds = CommonSettingHelper.getZeroInOutBizTypeIds();
        this.entityType = MetadataServiceHelper.getDataEntityType((String)"cal_costrecord_subentity");
        List<QFilter> fList = this.analyseBizRangeFilter(param);
        QFilter otherQ = new QFilter("isinitbill", "=", (Object)Boolean.FALSE);
        otherQ.and("issplitcreate", "=", (Object)Boolean.FALSE);
        otherQ.and("invscheme", "in", (Object)calInvSchemeIdSet);
        otherQ.and("entry.invtype", "in", (Object)calInvTypeIdSet);
        otherQ.and("biztype", "not in", (Object)noUpdateBalBizTypeSet);
        if (zeroInOutBizTypeIds.length > 0) {
            otherQ.and("biztype", "not in", (Object)zeroInOutBizTypeIds);
        }
        QFilter billStatusf = new QFilter("billstatus", "=", (Object)"C");
        otherQ.and(billStatusf);
        otherQ.and("entry.ispresent", "=", (Object)Boolean.FALSE);
        otherQ.and("invscheme.zerocost", "=", (Object)Boolean.FALSE);
        QFilter costPriceSourceFilter = new QFilter("entry.costpricesource", "=", (Object)QEmptyValue.value);
        otherQ.and(costPriceSourceFilter);
        fList.add(otherQ);
        return QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord_subentity", (String)this.getCostRecordBizField(), (QFilter[])fList.toArray(new QFilter[0]), null);
    }

    private DataSet getGroupRecordDataSet(List<DataCheckParam> paramList) {
        DataSet groupIdDataSet = null;
        ArrayList<DataSet> groupIdDataSets = new ArrayList<DataSet>(16);
        for (DataCheckParam param : paramList) {
            QFilter filter = new QFilter("entryentity.costaccount", "in", param.getCostAccount());
            if (param.isNeedCalculatedLater()) {
                filter.and("entryentity.period", ">=", (Object)param.getPeriodId());
            } else {
                filter.and("entryentity.period", "=", (Object)param.getPeriodId());
            }
            filter.and("entryentity.type", "=", (Object)"1");
            if (param.isAllMaterial()) {
                DataSet col = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_account_grouprecord", (String)"id", (QFilter[])filter.toArray(), null);
                if (groupIdDataSet == null) {
                    groupIdDataSet = col;
                    continue;
                }
                groupIdDataSets.add(col);
                continue;
            }
            QFilter mfilter = filter.copy();
            mfilter = mfilter.and("entryentity.material.id", "in", param.getMaterial());
            DataSet col = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_account_grouprecord", (String)"id", (QFilter[])mfilter.toArray(), null);
            if (groupIdDataSet == null) {
                groupIdDataSet = col;
                continue;
            }
            groupIdDataSets.add(col);
        }
        if (groupIdDataSet != null && !groupIdDataSets.isEmpty()) {
            groupIdDataSet = groupIdDataSet.union(groupIdDataSets.toArray(new DataSet[0]));
        }
        return groupIdDataSet;
    }

    private DataSet getGroupRecordDataSet(DataCheckParam param) {
        this.entityType = MetadataServiceHelper.getDataEntityType((String)"cal_account_grouprecord");
        List<QFilter> fList = this.analyseBizRangeFilter(param);
        QFilter otherQ = new QFilter("entryentity.type", "=", (Object)"1");
        fList.add(otherQ);
        DataSet groupIdDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_account_grouprecord", (String)"id", (QFilter[])fList.toArray(new QFilter[0]), null);
        return groupIdDataSet;
    }

    private String getCostRecordBizField() {
        return "id,entry.id as entryid,costaccount,period as periodid,billstatus,costaccount.number as costaccountnumber,billno,entry.actualcost as actualcost,entry.unitactualcost as unitactualcost,entry.baseqty as baseqty,entry.ispresent as ispresent,calbilltype";
    }

    @Override
    protected String getDataEntityType() {
        return "cal_costrecord_subentity";
    }

    @Override
    protected Set<String> getSelectedFields() {
        return null;
    }

    @Override
    public List<ExceptionObj> collectExceptionObj(DataSet dataSet, DataCheckParam param) {
        return null;
    }
}

