/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.datacheck.item;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.business.datacheck.DataCheckParam;
import kd.fi.cal.business.datacheck.ExceptionObj;
import kd.fi.cal.business.datacheck.item.DataEntityDataCheck;

public class CalOutRevenueRecognitionCheck
extends DataEntityDataCheck {
    @Override
    public List<ExceptionObj> collectExceptionObj(List<DataCheckParam> paramList) {
        ArrayList<ExceptionObj> result = new ArrayList<ExceptionObj>();
        DataSet resultDs = null;
        for (DataCheckParam dataCheckParam : paramList) {
            ArrayList<Long> orgList = new ArrayList<Long>(dataCheckParam.getCalorg());
            DataSet revDataSet = this.getRevDataSet((Long)orgList.get(0), dataCheckParam.getStartDate(), dataCheckParam.getEndDate());
            if (revDataSet == null || revDataSet.isEmpty()) continue;
            if (resultDs == null) {
                resultDs = revDataSet;
                continue;
            }
            resultDs = resultDs.union(revDataSet);
        }
        if (resultDs != null && !resultDs.isEmpty()) {
            resultDs = resultDs.groupBy(new String[]{"id", "billno"}).finish();
            for (Row next : resultDs) {
                ExceptionObj exceptionObj = new ExceptionObj(next.getLong("id"), "ar_revcfmbill");
                exceptionObj.setDescription(String.format(ResManager.loadKDString((String)"\u5e94\u6536\u5355\u636e\u68c0\u67e5\u5f02\u5e38\uff0c\u5355\u636e\u201c%1$s\u201d\u7684\u6536\u5165\u786e\u8ba4\u5355\u5df2\u7ecf\u751f\u6210\u51ed\u8bc1\u3002", (String)"CalOutRevenueRecognitionCheck_1", (String)"fi-cal-business", (Object[])new Object[0]), next.getString("billno")));
                result.add(exceptionObj);
            }
        }
        return result;
    }

    @Override
    public List<ExceptionObj> collectExceptionObj(DataCheckParam param) {
        ArrayList<ExceptionObj> result = new ArrayList<ExceptionObj>();
        DynamicObjectCollection dynamicObjects = CalOutRevenueRecognitionCheck.getSysCtrlEntity(param.getCalorg(), param.getCostAccount());
        DataSet revDataSet = null;
        for (DynamicObject dynamicObject : dynamicObjects) {
            DataSet dataSet;
            Date startDate = param.getStartDate();
            Date endDate = param.getEndDate();
            if (startDate == null && endDate == null) {
                startDate = dynamicObject.getDate("startDate");
                endDate = dynamicObject.getDate("endDate");
            }
            if ((dataSet = this.getRevDataSet(dynamicObject.getLong("org"), startDate, endDate)) == null || dataSet.isEmpty()) continue;
            if (revDataSet == null) {
                revDataSet = dataSet;
                continue;
            }
            revDataSet = revDataSet.union(dataSet);
        }
        if (revDataSet != null && !revDataSet.isEmpty()) {
            for (Row next : revDataSet) {
                ExceptionObj exceptionObj = new ExceptionObj(next.getLong("id"), "ar_revcfmbill");
                exceptionObj.setDescription(String.format(ResManager.loadKDString((String)"\u5e94\u6536\u5355\u636e\u68c0\u67e5\u5f02\u5e38\uff0c\u5355\u636e\u201c%1$s\u201d\u7684\u6536\u5165\u786e\u8ba4\u5355\u5df2\u7ecf\u751f\u6210\u51ed\u8bc1\u3002", (String)"CalOutRevenueRecognitionCheck_1", (String)"fi-cal-business", (Object[])new Object[0]), next.getString("billno")));
                result.add(exceptionObj);
            }
        }
        return result;
    }

    private DataSet getRevDataSet(long calOrg, Date startDate, Date endDate) {
        QFilter salOutFilter = new QFilter("bookdate", ">=", (Object)startDate);
        salOutFilter.and(new QFilter("bookdate", "<=", (Object)endDate));
        salOutFilter.and(new QFilter("org", "in", (Object)calOrg));
        salOutFilter.and(new QFilter("billentry.verifyqty", "!=", (Object)BigDecimal.ZERO));
        salOutFilter.and(new QFilter("billentry.logisticsbill", "=", (Object)Boolean.FALSE));
        DataSet calOutDataSet = QueryServiceHelper.queryDataSet((String)"CalOutRevenueRecognitionChecksSalOut", (String)"im_saloutbill", (String)"id", (QFilter[])new QFilter[]{salOutFilter}, null);
        if (!calOutDataSet.isEmpty()) {
            HashSet<Long> salOutBillIds = new HashSet<Long>();
            for (Row next : calOutDataSet) {
                salOutBillIds.add(next.getLong("id"));
            }
            QFilter verFilter = new QFilter("org", "in", (Object)calOrg);
            verFilter.and(new QFilter("billtype", "=", (Object)"im_saloutbill"));
            verFilter.and(new QFilter("entry.e_billtype", "=", (Object)"ar_revcfmbill"));
            verFilter.and(new QFilter("billid", "in", salOutBillIds));
            DataSet verifyRecordDs = QueryServiceHelper.queryDataSet((String)"CalOutRevenueRecognitionCheckVerRecode", (String)"ar_verifyrecord", (String)"entry.e_billid as id", (QFilter[])new QFilter[]{verFilter}, null);
            if (!verifyRecordDs.isEmpty()) {
                HashSet<Long> revCfmIds = new HashSet<Long>();
                for (Row next : verifyRecordDs) {
                    revCfmIds.add(next.getLong("id"));
                }
                QFilter cfmFilter = new QFilter("id", "in", revCfmIds);
                cfmFilter.and(new QFilter("billstatus", "=", (Object)"C"));
                cfmFilter.and(new QFilter("hadwrittenoff", "=", (Object)Boolean.FALSE));
                cfmFilter.and(new QFilter("iswrittenoff", "=", (Object)Boolean.FALSE));
                cfmFilter.and(new QFilter("verifystatus", "=", (Object)"verified"));
                cfmFilter.and(new QFilter("isvoucher", "in", (Object)Boolean.TRUE));
                return QueryServiceHelper.queryDataSet((String)"CalOutRevenueRecognitionCheckVerRev", (String)"ar_revcfmbill", (String)"id,billno", (QFilter[])new QFilter[]{cfmFilter}, null);
            }
        }
        return null;
    }

    @Override
    protected String getDataEntityType() {
        return "ar_revcfmbill";
    }

    @Override
    protected Set<String> getSelectedFields() {
        return null;
    }

    @Override
    public List<ExceptionObj> collectExceptionObj(DataSet dataSet, DataCheckParam param) {
        return null;
    }

    public static DynamicObjectCollection getSysCtrlEntity(Set<Long> orgs, Set<Long> costAccounts) {
        Object retValue = null;
        QFilter filter = new QFilter("org", "in", orgs);
        filter.and("entry.costaccount.id", "in", costAccounts);
        String fields = "org,entry.costaccount as costaccount,entry.currentperiod.begindate as startDate,entry.currentperiod.enddate as endDate";
        return QueryServiceHelper.query((String)"cal_sysctrlentity", (String)fields, (QFilter[])new QFilter[]{filter});
    }
}

