/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.datacheck.item;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.input.OrmInput;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.fi.cal.business.datacheck.DataCheckParam;
import kd.fi.cal.business.datacheck.ExceptionObj;
import kd.fi.cal.business.datacheck.item.IDataCheck;
import kd.fi.cal.common.helper.CalBalanceModelHelper;

public class CalRecentBalanceCostDiffCheck
implements IDataCheck {
    @Override
    public List<ExceptionObj> collectExceptionObj(DataCheckParam param) {
        ArrayList<DataCheckParam> paramList = new ArrayList<DataCheckParam>(16);
        paramList.add(param);
        ArrayList<ExceptionObj> exceptionObjList = new ArrayList<ExceptionObj>(16);
        this.checkCalBalRecentCost(paramList, exceptionObjList);
        return exceptionObjList;
    }

    @Override
    public List<ExceptionObj> collectExceptionObj(List<DataCheckParam> paramList) {
        ArrayList<ExceptionObj> exceptionObjList = new ArrayList<ExceptionObj>(16);
        this.checkCalBalRecentCost(paramList, exceptionObjList);
        return exceptionObjList;
    }

    private List<ExceptionObj> checkCalBalRecentCost(List<DataCheckParam> paramList, List<ExceptionObj> exceptionObjList) {
        ArrayList<OrmInput> calbalOrmInputs = new ArrayList<OrmInput>(16);
        ArrayList<OrmInput> recentOrmInputs = new ArrayList<OrmInput>(16);
        boolean isNewBalance = CalBalanceModelHelper.isNewBalance();
        for (DataCheckParam param : paramList) {
            Set<Long> costAccountIdSet;
            Set<Long> calorgIdSet = param.getCalorg();
            QFilter balfilter = QFilter.of((String)"1=1", (Object[])new Object[0]);
            QFilter recentfilter = QFilter.of((String)"1=1", (Object[])new Object[0]);
            if (calorgIdSet != null && calorgIdSet.size() > 0) {
                balfilter.and("calorg", "in", calorgIdSet);
                recentfilter.and("calorg", "in", calorgIdSet);
            }
            if ((costAccountIdSet = param.getCostAccount()) != null && costAccountIdSet.size() > 0) {
                balfilter.and("costaccount", "in", costAccountIdSet);
                recentfilter.and("calorg", "in", calorgIdSet);
            }
            balfilter.and("endperiod", "=", (Object)999999);
            OrmInput calbalOrmInput = null;
            calbalOrmInput = isNewBalance ? new OrmInput(this.getClass().getName(), "cal_bal", this.getCalBalBizField(), balfilter.toArray()) : new OrmInput(this.getClass().getName(), "cal_balance", this.getCalBalanceBizField(), balfilter.toArray());
            calbalOrmInputs.add(calbalOrmInput);
            OrmInput recentOrmInput = new OrmInput(this.getClass().getName(), "cal_recentcost", this.getRecentCostBizField(), recentfilter.toArray());
            recentOrmInputs.add(recentOrmInput);
        }
        Algo algo = Algo.create((String)this.getClass().getName());
        DataSet calbalanceDataSet = algo.createDataSet((Input[])calbalOrmInputs.toArray(new OrmInput[calbalOrmInputs.size()]));
        DataSet recentCostDataSet = algo.createDataSet((Input[])recentOrmInputs.toArray(new OrmInput[recentOrmInputs.size()]));
        calbalanceDataSet = calbalanceDataSet.groupBy(new String[]{"material", "materialnumber", "costaccount", "costaccountnumber", "calorg", "calorgnumber"}).sum("periodendactualcost").finish();
        recentCostDataSet = recentCostDataSet.groupBy(new String[]{"material", "materialnumber", "costaccount", "costaccountnumber", "calorg", "calorgnumber"}).sum("recentcost").finish();
        DataSet allDataSet = calbalanceDataSet.leftJoin(recentCostDataSet).on("material", "material").on("costaccount", "costaccount").on("calorg", "calorg").select(new String[]{"materialnumber", "costaccountnumber", "calorgnumber", "periodendactualcost"}, new String[]{"recentcost"}).finish();
        allDataSet = allDataSet.filter("recentcost is null or periodendactualcost <> recentcost");
        for (Row row : allDataSet) {
            StringBuilder errorMsg = new StringBuilder();
            String costaccountnumber = row.getString("costaccountnumber");
            String materialnumber = row.getString("materialnumber");
            String calorgnumber = row.getString("calorgnumber");
            String errmsg = String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u3010%1$s\u3011\u6210\u672c\u8d26\u7c3f\u3010%2$s\u3011\u4e0b\u5b58\u5728\u4f59\u989d\u8868\u7ed3\u5b58\u91d1\u989d\u4e0e\u6700\u8fd1\u53ca\u65f6\u7ed3\u8f6c\u6210\u672c\u4e0d\u4e00\u81f4\u7684\u7269\u6599\u3010%3$s\u3011", (String)"CalRecentBalanceCostDiffCheck_0", (String)"fi-cal-business", (Object[])new Object[0]), calorgnumber, costaccountnumber, materialnumber);
            errorMsg.append(errmsg);
            ExceptionObj exceptionObj = isNewBalance ? new ExceptionObj(0L, "cal_bal") : new ExceptionObj(0L, "cal_balance");
            exceptionObj.setDescription(errorMsg.toString());
            exceptionObjList.add(exceptionObj);
        }
        return exceptionObjList;
    }

    private String getCalBalanceBizField() {
        return "material,material.number as materialnumber,costaccount,costaccount.number as costaccountnumber,calorg,calorg.number as calorgnumber,periodendactualcost";
    }

    private String getRecentCostBizField() {
        return "material,material.number as materialnumber,costaccount,costaccount.number as costaccountnumber,calorg,calorg.number as calorgnumber,recentcost";
    }

    private String getCalBalBizField() {
        return "material,material.number as materialnumber,costaccount,costaccount.number as costaccountnumber,calorg,calorg.number as calorgnumber,actualcost_bal as periodendactualcost";
    }
}

