/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.datacheck.item;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.business.datacheck.DataCheckParam;
import kd.fi.cal.business.datacheck.ExceptionObj;
import kd.fi.cal.business.datacheck.item.DataEntityDataCheck;
import kd.fi.cal.business.datacheck.item.IDataRepair;

public class CostAdjustBillDataCheck
extends DataEntityDataCheck
implements IDataRepair {
    @Override
    public void dealExceptionObj(List<ExceptionObj> exceptionList) {
    }

    @Override
    protected String getDataEntityType() {
        return "cal_costadjust_subentity";
    }

    @Override
    protected void addDataCheckFilter(List<QFilter> fList) {
        super.addDataCheckFilter(fList);
        QFilter qFilter = new QFilter("billstatus", "=", (Object)Character.valueOf('C'));
        fList.add(qFilter);
    }

    @Override
    protected Set<String> getSelectedFields() {
        String str = "id,costaccount as costaccountid,calorg as calorgid,billno,entryentity.id as entryid,entryentity.adjustamt as adjustamt, entryentity.subentryentity.sub_adjustamt as subadjustamt,billstatus";
        return new HashSet<String>(Arrays.asList(str.split(",")));
    }

    @Override
    public List<ExceptionObj> collectExceptionObj(DataSet dataSet, DataCheckParam param) {
        ArrayList<ExceptionObj> list = new ArrayList<ExceptionObj>();
        ExceptionObj exceObj = null;
        String str = "id,costaccountid,calorgid,billno,entryid,adjustamt";
        DataSet adjustamtDataSet = dataSet.copy().groupBy(str.split(",")).finish().select(str);
        DataSet subadjustamtDataSet = dataSet.copy().groupBy(new String[]{"id", "costaccountid", "calorgid", "billno", "entryid"}).sum("subadjustamt").finish().select("id,costaccountid,calorgid,billno,entryid,subadjustamt");
        dataSet = adjustamtDataSet.join(subadjustamtDataSet).on("id", "id").on("billno", "billno").on("entryid", "entryid").on("costaccountid", "costaccountid").on("calorgid", "calorgid").select(str.split(","), new String[]{"subadjustamt"}).finish();
        DataSet costaccountDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_bd_costaccount", (String)"id,number as costaccountnumber", null, null);
        DataSet calorgDaSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bos_org", (String)"id,number as calorgnumber", null, null);
        str = str + ",subadjustamt";
        dataSet = dataSet.leftJoin(costaccountDataSet).on("costaccountid", "id").select(str.split(","), new String[]{"costaccountnumber"}).finish();
        str = str + ",costaccountnumber";
        dataSet = dataSet.leftJoin(calorgDaSet).on("calorgid", "id").select(str.split(","), new String[]{"calorgnumber"}).finish();
        for (Row row : dataSet) {
            Long id = row.getLong("id");
            String billno = row.getString("billno");
            String calorgnumber = row.getString("calorgnumber");
            String costaccountnumber = row.getString("costaccountnumber");
            BigDecimal adjustamt = BigDecimal.ZERO;
            BigDecimal subadjustamt = BigDecimal.ZERO;
            if (row.getBigDecimal("adjustamt") != null) {
                adjustamt = row.getBigDecimal("adjustamt");
            }
            if (row.getBigDecimal("subadjustamt") != null) {
                subadjustamt = row.getBigDecimal("subadjustamt");
            }
            if (adjustamt.compareTo(subadjustamt) == 0) continue;
            exceObj = new ExceptionObj(id, "cal_costadjust_subentity");
            String msg = String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\uff1a%1$s\uff0c\u6210\u672c\u8d26\u7c3f\uff1a%2$s\uff0c\u5355\u636e\u7f16\u53f7\uff1a%3$s \u7684\u8c03\u6574\u91d1\u989d\uff1a%4$s\uff0c\u660e\u7ec6\u5b9e\u9645\u6210\u672c(\u4e4b\u548c)\uff1a%5$s", (String)"CostAdjustBillDataCheck_5", (String)"fi-cal-business", (Object[])new Object[0]), calorgnumber, costaccountnumber, billno, adjustamt, subadjustamt);
            exceObj.setDescription(msg);
            list.add(exceObj);
        }
        return list;
    }
}

