/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.datacheck.item;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.fi.cal.business.datacheck.DataCheckParam;
import kd.fi.cal.business.datacheck.ExceptionObj;
import kd.fi.cal.business.datacheck.item.DataEntityDataCheck;
import kd.fi.cal.business.datacheck.item.IDataRepair;
import kd.fi.cal.common.util.CommonUtils;

public class CostReocrdDataCheck
extends DataEntityDataCheck
implements IDataRepair {
    @Override
    public void dealExceptionObj(List<ExceptionObj> exceptionList) {
        if (exceptionList.isEmpty()) {
            return;
        }
        ArrayList updateActuaCostList = new ArrayList();
        DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)this.getUpdateCostRecordSql(), updateActuaCostList);
    }

    private String getUpdateCostRecordSql() {
        return " update t_cal_calcostrecordentry set factualcost =  ?   where fentryid = ? ";
    }

    @Override
    protected String getDataEntityType() {
        return "cal_costrecord_subentity";
    }

    @Override
    protected Set<String> getSelectedFields() {
        String str = "id,billno,issplitcreate,bizentityobject,calorg.number,costaccount.number,entry.id,entry.Seq,entry.materialcost,entry.fee,entry.processcost,entry.manufacturecost,entry.resource,entry.actualcost,entry.subentrycostelement.sub_actualcost,entry.standardcost,entry.subentrycostelement.sub_standardcost";
        return new HashSet<String>(Arrays.asList(str.split(",")));
    }

    @Override
    protected void addDataCheckFilter(List<QFilter> fList) {
        super.addDataCheckFilter(fList);
        QFilter billStatus = new QFilter("billstatus", "=", (Object)"C");
        fList.add(billStatus);
    }

    @Override
    public List<ExceptionObj> collectExceptionObj(DataSet dataSet, DataCheckParam param) {
        dataSet = dataSet.groupBy("id,billno,issplitcreate,bizentityobject,calorg.number,costaccount.number,entry.id,entry.Seq,entry.materialcost,entry.fee,entry.processcost,entry.manufacturecost,entry.resource,entry.actualcost,entry.standardcost".split(",")).sum("entry.subentrycostelement.sub_actualcost").sum("entry.subentrycostelement.sub_standardcost").finish();
        return this.getResults(dataSet);
    }

    private List<ExceptionObj> getResults(DataSet dataSet) {
        ArrayList<ExceptionObj> resultObj = new ArrayList<ExceptionObj>();
        BigDecimal materialCost = null;
        BigDecimal fee = null;
        BigDecimal processCost = null;
        BigDecimal manufactureCost = null;
        BigDecimal resource = null;
        BigDecimal actualCost = null;
        BigDecimal subActualcost = null;
        BigDecimal standardCost = null;
        BigDecimal subStandardcost = null;
        for (Row row : dataSet) {
            boolean isDetailEntryStandardCondition;
            materialCost = row.getBigDecimal("entry.materialcost");
            materialCost = materialCost == null ? BigDecimal.ZERO : materialCost;
            fee = row.getBigDecimal("entry.fee");
            fee = fee == null ? BigDecimal.ZERO : fee;
            processCost = row.getBigDecimal("entry.processcost");
            processCost = processCost == null ? BigDecimal.ZERO : processCost;
            manufactureCost = row.getBigDecimal("entry.manufacturecost");
            manufactureCost = manufactureCost == null ? BigDecimal.ZERO : manufactureCost;
            resource = row.getBigDecimal("entry.resource");
            resource = resource == null ? BigDecimal.ZERO : resource;
            actualCost = row.getBigDecimal("entry.actualcost");
            actualCost = actualCost == null ? BigDecimal.ZERO : actualCost;
            subActualcost = row.getBigDecimal("entry.subentrycostelement.sub_actualcost");
            subActualcost = subActualcost == null ? BigDecimal.ZERO : subActualcost;
            boolean isEntryCondition = materialCost.add(fee).add(processCost).add(manufactureCost).add(resource).compareTo(actualCost) == 0;
            boolean isDetailEntryCondition = actualCost.compareTo(subActualcost) == 0;
            boolean isPruinBill = this.getPurinBillCondition(row);
            standardCost = row.getBigDecimal("entry.standardcost");
            standardCost = standardCost == null ? BigDecimal.ZERO : standardCost;
            subStandardcost = row.getBigDecimal("entry.subentrycostelement.sub_standardcost");
            subStandardcost = subStandardcost == null ? BigDecimal.ZERO : subStandardcost;
            boolean bl = isDetailEntryStandardCondition = standardCost.compareTo(subStandardcost) == 0;
            if (isPruinBill && isEntryCondition || !isPruinBill && isEntryCondition && isDetailEntryCondition && isDetailEntryStandardCondition) continue;
            ExceptionObj exceptionObj = new ExceptionObj(row.getLong("entry.id"), this.getDataEntityType());
            String errorMsg = String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\uff1a%1$s\uff0c\u6210\u672c\u8d26\u7c3f\uff1a%2$s\uff0c\u6838\u7b97\u6210\u672c\u8bb0\u5f55\uff1a\u5355\u636e\u7f16\u53f7(%3$s)\uff0c\u884c\u5e8f\u53f7(%4$s),\u6750\u6599\u6210\u672c(%5$s),\u52a0\u5de5\u8d39(%6$s),\u8d39\u7528(%7$s),\u8d44\u6e90(%8$s),\u5236\u9020\u8d39(%9$s),\u5b9e\u9645\u6210\u672c(%10$s),\u6807\u51c6\u6210\u672c(%11$s)", (String)"CostReocrdDataCheck_9", (String)"fi-cal-business", (Object[])new Object[0]), row.getString("calorg.number"), row.getString("costaccount.number"), row.getString("billno"), row.getString("entry.Seq"), materialCost.stripTrailingZeros().toPlainString(), processCost.stripTrailingZeros().toPlainString(), fee.stripTrailingZeros().toPlainString(), resource.stripTrailingZeros().toPlainString(), manufactureCost.stripTrailingZeros().toPlainString(), actualCost.stripTrailingZeros().toPlainString(), standardCost.stripTrailingZeros().toPlainString());
            exceptionObj.setExtralInfo("CostReocrdDataCheck");
            if (!isPruinBill) {
                errorMsg = String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\uff1a%1$s\uff0c\u6210\u672c\u8d26\u7c3f\uff1a%2$s\uff0c\u6838\u7b97\u6210\u672c\u8bb0\u5f55\uff1a\u5355\u636e\u7f16\u53f7(%3$s)\uff0c\u884c\u5e8f\u53f7(%4$s),\u6750\u6599\u6210\u672c(%5$s),\u52a0\u5de5\u8d39(%6$s),\u8d39\u7528(%7$s),\u8d44\u6e90(%8$s),\u5236\u9020\u8d39(%9$s),\u5b9e\u9645\u6210\u672c(%10$s),\u6807\u51c6\u6210\u672c(%11$s),\u6210\u672c\u5b50\u8981\u7d20\u5b9e\u9645\u6210\u672c\u4e4b\u548c(%12$s)\uff0c\u6210\u672c\u5b50\u8981\u7d20\u6807\u51c6\u6210\u672c\u4e4b\u548c(%13$s)", (String)"CostReocrdDataCheck_8", (String)"fi-cal-business", (Object[])new Object[0]), row.getString("calorg.number"), row.getString("costaccount.number"), row.getString("billno"), row.getString("entry.Seq"), materialCost.stripTrailingZeros().toPlainString(), processCost.stripTrailingZeros().toPlainString(), fee.stripTrailingZeros().toPlainString(), resource.stripTrailingZeros().toPlainString(), manufactureCost.stripTrailingZeros().toPlainString(), actualCost.stripTrailingZeros().toPlainString(), standardCost.stripTrailingZeros().toPlainString(), subActualcost.stripTrailingZeros().toPlainString(), subStandardcost.stripTrailingZeros().toPlainString());
            }
            exceptionObj.setDescription(errorMsg);
            resultObj.add(exceptionObj);
        }
        return resultObj;
    }

    private boolean getPurinBillCondition(Row row) {
        boolean issplitcreate = row.getBoolean("issplitcreate");
        String bizentityobject = row.getString("bizentityobject");
        return issplitcreate && ("im_purinbill".equals(bizentityobject) || "im_mdc_ominbill".equals(bizentityobject) || "im_ospurinbill".equals(bizentityobject));
    }
}

