/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.datacheck.item;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.property.BasedataProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.business.datacheck.DataCheckParam;
import kd.fi.cal.business.datacheck.ExceptionObj;
import kd.fi.cal.business.datacheck.item.DataEntityDataCheck;
import kd.fi.cal.common.helper.AccountingSysHelper;
import kd.fi.cal.common.util.CommonUtils;

public class CustomDataCheck
extends DataEntityDataCheck {
    private static final String CUSTOMFILTER = "customfilter_tag";
    private static final String BIZOBJECT = "bizobject";
    private static final String EXPMSGFIELDS = "expmsgfields";
    private static final Long ORGCFG_ID = 919459934649712640L;
    private String[] msgFields;

    @Override
    public List<ExceptionObj> collectExceptionObj(DataCheckParam param) {
        Long itemId = param.getCurrentItemId();
        DynamicObject item = BusinessDataServiceHelper.loadSingle((Object)itemId, (String)"cal_datacheck_item", (String)"ids,bizobject,customfilter_tag,expmsgfields");
        this.entityType = MetadataServiceHelper.getDataEntityType((String)item.getDynamicObject(BIZOBJECT).getString("number"));
        this.msgFields = CommonUtils.trimComma((String)item.getString(EXPMSGFIELDS).trim()).split(",");
        List<QFilter> fList = this.analyseBizRangeFilter(param);
        QFilter cuntomQ = this.getCustomQfilter(item);
        QFilter bookdateQ = this.getDateQfilter(param);
        fList.add(cuntomQ);
        if (bookdateQ != null) {
            fList.add(bookdateQ);
        }
        QFilter[] filterArr = fList.toArray(new QFilter[fList.size()]);
        String selectFields = this.getCustomSelectFields(item);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)this.entityType.getName(), (String)selectFields, (QFilter[])filterArr, null);
        return this.collectExceptionObj(dataSet, param);
    }

    @Override
    public List<ExceptionObj> collectExceptionObj(DataSet dataSet, DataCheckParam param) {
        dataSet = dataSet.groupBy(dataSet.getRowMeta().getFieldNames()).finish();
        ArrayList<ExceptionObj> resultObj = new ArrayList<ExceptionObj>();
        if (!dataSet.isEmpty()) {
            HashMap<String, String> fieldDisNameMap = new HashMap<String, String>(16);
            for (String fieldName : this.msgFields) {
                DynamicProperty fieldEntity = this.entityType.getProperty(fieldName);
                String fieldDisplayName = fieldEntity.getDisplayName().getLocaleValue();
                fieldDisNameMap.put(fieldName, fieldDisplayName);
            }
            for (Row row : dataSet) {
                StringBuilder sBuilder = new StringBuilder();
                for (String fieldName : this.msgFields) {
                    sBuilder.append((String)fieldDisNameMap.get(fieldName)).append(" \uff1a");
                    if (row.get(fieldName) == null) {
                        sBuilder.append('\uff1b');
                        continue;
                    }
                    sBuilder.append(row.get(fieldName)).append('\uff1b');
                }
                ExceptionObj exceptionObj = new ExceptionObj(row.getLong("id"), this.entityType.getName());
                exceptionObj.setDescription(CommonUtils.trimBySign((String)sBuilder.toString(), (String)"\uff1b"));
                resultObj.add(exceptionObj);
            }
        }
        return resultObj;
    }

    private String getCustomSelectFields(DynamicObject item) {
        StringBuilder selectBuilder = new StringBuilder();
        for (String field : this.msgFields) {
            DynamicProperty fieldEntity = this.entityType.getProperty(field);
            if (fieldEntity instanceof BasedataProp) {
                if (field.contains("org") || "material".equals(field) || "warehouse".equals(field) || "location".equals(field) || field.contains("account")) {
                    selectBuilder.append(field).append(".number as ").append(field).append(',');
                    continue;
                }
                selectBuilder.append(field).append(".name as ").append(field).append(',');
                continue;
            }
            selectBuilder.append(field).append(",");
        }
        return "id," + CommonUtils.trimComma((String)selectBuilder.toString());
    }

    private QFilter getCustomQfilter(DynamicObject item) {
        String filterStr = item.getString(CUSTOMFILTER);
        CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)filterStr, CRCondition.class);
        FilterCondition filterCondition = condition.getFilterCondition();
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)this.entityType.getName());
        FilterBuilder filterBuilder = new FilterBuilder(mainEntityType, filterCondition);
        filterBuilder.buildFilter();
        QFilter baseQ = filterBuilder.getQFilter();
        String experss = condition.getExpression();
        if (!"".equals(experss)) {
            String[] subExpressArray = experss.split(" ");
            StringBuilder newExperss = new StringBuilder();
            for (String subExpress : subExpressArray) {
                String nameHead = subExpress.split("\\.")[0];
                IDataEntityProperty fieldProperty = mainEntityType.findProperty(nameHead);
                if (fieldProperty != null && fieldProperty.getParent() instanceof EntryType) {
                    EntryType entry = (EntryType)fieldProperty.getParent();
                    String entryName = entry.getName();
                    subExpress = entryName + "." + subExpress;
                }
                newExperss.append(subExpress);
                newExperss.append(' ');
            }
            QFilter expressFilter = QFilter.of((String)newExperss.toString().trim(), (Object[])new Object[0]);
            if (baseQ != null) {
                baseQ.and(expressFilter);
            } else {
                baseQ = expressFilter;
            }
        }
        return baseQ;
    }

    private QFilter getDateQfilter(DataCheckParam param) {
        QFilter dateQ = null;
        IDataEntityProperty bookDateProperty = this.entityType.findProperty("bookdate");
        if (bookDateProperty != null) {
            Date startDate = param.getStartDate();
            Date endDate = param.getEndDate();
            if (startDate != null && endDate != null) {
                dateQ = new QFilter("bookdate", ">=", (Object)startDate);
                dateQ.and("bookdate", "<=", (Object)endDate);
            }
        }
        return dateQ;
    }

    @Override
    protected String getDataEntityType() {
        return "cal_costrecord";
    }

    @Override
    protected Set<String> getSelectedFields() {
        return null;
    }

    @Override
    protected QFilter analyseCostAccountFilter(DataCheckParam param) {
        if (!"cal_balance".equals(this.entityType.getName())) {
            return super.analyseCostAccountFilter(param);
        }
        IDataEntityProperty accountProperty = this.entityType.findProperty("costaccount");
        Set<Long> costaccount = param.getCostAccount();
        if (accountProperty == null) {
            return null;
        }
        if (costaccount == null || costaccount.isEmpty()) {
            costaccount = this.getAllValidCostAccount();
        }
        ArrayList<QFilter> fList = new ArrayList<QFilter>(costaccount.size());
        String costAccountName = this.analyseFieldName(accountProperty);
        for (Long costAccountId : costaccount) {
            QFilter filter = new QFilter(costAccountName, "=", (Object)costAccountId);
            DynamicObject period = this.getCurrentPeriod(costAccountId);
            if (period == null) continue;
            filter = filter.and("period", "<=", (Object)(period.getInt("periodyear") * 100 + period.getInt("periodnumber")));
            filter = filter.and("endperiod", ">", (Object)(period.getInt("periodyear") * 100 + period.getInt("periodnumber")));
            fList.add(filter);
        }
        if (fList.isEmpty()) {
            return new QFilter("id", "=", (Object)0);
        }
        QFilter firstFilter = (QFilter)fList.get(0);
        for (int i = 1; i < fList.size(); ++i) {
            firstFilter = firstFilter.or((QFilter)fList.get(i));
        }
        return firstFilter;
    }

    @Override
    protected QFilter analyseCalOrgFilter(DataCheckParam param) {
        Set<Long> orgIds = param.getCalorg();
        Set<Long> accountIds = param.getCostAccount();
        String entityName = this.entityType.getName();
        String fieldName = null;
        IDataEntityProperty calorgProperty = this.entityType.findProperty("calorg");
        if (calorgProperty == null) {
            String selectFileds;
            DynamicObjectCollection accountSysColls;
            DynamicObject orgCFG = BusinessDataServiceHelper.loadSingle((Object)ORGCFG_ID, (String)"cal_fieldmapconfig");
            DynamicObjectCollection orgCFGEntrys = orgCFG.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : orgCFGEntrys) {
                if (!entityName.equals(entry.getString("billtype.number"))) continue;
                fieldName = entry.getString("billfield");
                break;
            }
            if (orgIds == null || orgIds.isEmpty()) {
                orgIds = new HashSet<Long>(16);
                QFilter accountQ = new QFilter("enable", "=", (Object)"1");
                if (accountIds != null && !accountIds.isEmpty()) {
                    accountQ.and("id", "in", accountIds);
                }
                DynamicObjectCollection costAccounts = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"calorg", (QFilter[])accountQ.toArray());
                for (DynamicObject costAccount : costAccounts) {
                    orgIds.add(costAccount.getLong("calorg"));
                }
            }
            if (!(accountSysColls = AccountingSysHelper.getAccountingSysColls(new ArrayList<Long>(orgIds), (String)(selectFileds = "number,bizorgentry.bizacctorg.number,bizorgentry.bizorg.number,bizorgentry.bizorg as ownerid"))).isEmpty()) {
                for (DynamicObject accountSysColl : accountSysColls) {
                    orgIds.add(accountSysColl.getLong("ownerid"));
                }
            }
        } else {
            fieldName = "calorg";
        }
        if (orgIds == null || orgIds.isEmpty()) {
            return null;
        }
        if (fieldName == null) {
            return null;
        }
        IDataEntityProperty property = this.entityType.findProperty(fieldName);
        if (property == null) {
            return null;
        }
        String name = this.analyseFieldName(property);
        return new QFilter(name, "in", orgIds);
    }
}

