/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.datacheck.item;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.business.balance.BalanceDimFieldParser;
import kd.fi.cal.business.datacheck.DataCheckParam;
import kd.fi.cal.business.datacheck.ExceptionObj;
import kd.fi.cal.business.datacheck.item.IDataCheck;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.helper.CalBalanceModelHelper;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.common.helper.PeriodHelper;
import org.apache.commons.lang.StringUtils;

public abstract class DataEntityDataCheck
implements IDataCheck {
    protected MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)this.getDataEntityType());
    protected boolean isNewBalance = CalBalanceModelHelper.isNewBalance();
    private Map<Long, DynamicObject> costAccountPeriodMap;

    protected abstract String getDataEntityType();

    protected abstract Set<String> getSelectedFields();

    public abstract List<ExceptionObj> collectExceptionObj(DataSet var1, DataCheckParam var2);

    protected DynamicObject getCurrentPeriod(Long costAccountId) {
        DynamicObject period;
        if (this.costAccountPeriodMap == null) {
            this.costAccountPeriodMap = new HashMap<Long, DynamicObject>();
        }
        if ((period = this.costAccountPeriodMap.get(costAccountId)) == null) {
            period = PeriodHelper.getCurrentPeriod((Long)costAccountId);
            this.costAccountPeriodMap.put(costAccountId, period);
        }
        return period;
    }

    @Override
    public List<ExceptionObj> collectExceptionObj(DataCheckParam param) {
        List<QFilter> fList = this.analyseBizRangeFilter(param);
        this.addDataCheckFilter(fList);
        QFilter[] filterArr = fList.toArray(new QFilter[fList.size()]);
        DataSet dataSet = null;
        if (this.isNewBalance && "cal_bal".equals(this.getDataEntityType())) {
            BalanceDimFieldParser parser = new BalanceDimFieldParser();
            Set<String> dimSelects = parser.getDimFieldsWithBaseNameNotAs(true, true);
            Set<String> dimGroups = parser.getDimAliasWithBaseNameNotAs(true, true);
            dimGroups.add("calorg");
            dimGroups.add("calorg.name");
            dimGroups.add("calorg.number");
            dimGroups.add("period");
            dimGroups.add("endperiod");
            String select = String.join((CharSequence)",", dimSelects) + ",id,calorg,calorg.name,calorg.number,period,endperiod,baseqty as periodbeginqty,baseqty_in as periodinqty,baseqty_out as periodissueqty,baseqty_bal as periodendqty,actualcost as periodbeginactualcost,actualcost_in as periodinactualcost,actualcost_out as periodissueactualcost,actualcost_bal as periodendactualcost,standardcost as beginstandardcost,standardcost_in as periodinstandardcost,standardcost_out as periodissuestandardcost,standardcost_bal as periodendstandardcost";
            dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)this.getDataEntityType(), (String)select, (QFilter[])filterArr, null);
            boolean balCompress = CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.CAL_BAL_DATA_COMPRESSION);
            dataSet = !balCompress ? dataSet.groupBy(dimGroups.toArray(new String[0])).max("periodbeginqty").max("periodinqty").max("periodissueqty").max("periodendqty").max("id").sum("periodbeginactualcost").sum("periodinactualcost").sum("periodissueactualcost").sum("periodendactualcost").sum("beginstandardcost").sum("periodinstandardcost").sum("periodissuestandardcost").sum("periodendstandardcost").finish().select(StringUtils.join(this.getSelectedFields(), (String)",")) : dataSet.groupBy(dimGroups.toArray(new String[0])).sum("periodbeginqty").sum("periodinqty").sum("periodissueqty").sum("periodendqty").max("id").sum("periodbeginactualcost").sum("periodinactualcost").sum("periodissueactualcost").sum("periodendactualcost").sum("beginstandardcost").sum("periodinstandardcost").sum("periodissuestandardcost").sum("periodendstandardcost").finish().select(StringUtils.join(this.getSelectedFields(), (String)","));
        } else {
            dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)this.getDataEntityType(), (String)StringUtils.join(this.getSelectedFields(), (String)","), (QFilter[])filterArr, null);
        }
        return this.collectExceptionObj(dataSet, param);
    }

    @Override
    public List<ExceptionObj> collectExceptionObj(List<DataCheckParam> paramList) {
        ArrayList<ExceptionObj> finalExceptionList = new ArrayList<ExceptionObj>(16);
        HashSet<String> descSet = new HashSet<String>(16);
        for (DataCheckParam param : paramList) {
            ArrayList<ExceptionObj> exceptionObjList = new ArrayList<ExceptionObj>(16);
            List<ExceptionObj> exceptionObj = this.collectExceptionObj(param);
            if (exceptionObj != null && !exceptionObj.isEmpty()) {
                exceptionObjList.addAll(exceptionObj);
            }
            for (ExceptionObj obj : exceptionObjList) {
                String desc = obj.getDescription();
                if (descSet.contains(desc)) continue;
                descSet.add(desc);
                finalExceptionList.add(obj);
            }
        }
        return finalExceptionList;
    }

    protected List<QFilter> analyseBizRangeFilter(DataCheckParam param) {
        QFilter mversionFilter;
        QFilter projectFilter;
        QFilter invstatusFilter;
        QFilter invtypeFilter;
        QFilter locationFilter;
        QFilter warehouseFilter;
        QFilter materialFilter;
        QFilter storageOrgFilter;
        QFilter calOrgFilter;
        ArrayList<QFilter> fList = new ArrayList<QFilter>();
        QFilter costAccountFilter = this.analyseCostAccountFilter(param);
        if (costAccountFilter != null) {
            fList.add(costAccountFilter);
        }
        if ((calOrgFilter = this.analyseCalOrgFilter(param)) != null) {
            fList.add(calOrgFilter);
        }
        if ((storageOrgFilter = this.analyseStorageOrgFilter(param)) != null) {
            fList.add(storageOrgFilter);
        }
        if ((materialFilter = this.analyseMaterialFilter(param)) != null) {
            fList.add(materialFilter);
        }
        if ((warehouseFilter = this.analyseWarehouseFilter(param)) != null) {
            fList.add(warehouseFilter);
        }
        if ((locationFilter = this.analyseLocationFilter(param)) != null) {
            fList.add(locationFilter);
        }
        if ((invtypeFilter = this.analyseInvtypeFilter(param)) != null) {
            fList.add(invtypeFilter);
        }
        if ((invstatusFilter = this.analyseInvstatusFilter(param)) != null) {
            fList.add(invstatusFilter);
        }
        if ((projectFilter = this.analyseInvstatusFilter(param)) != null) {
            fList.add(projectFilter);
        }
        if ((mversionFilter = this.analyseMversionFilter(param)) != null) {
            fList.add(mversionFilter);
        }
        return fList;
    }

    protected void addDataCheckFilter(List<QFilter> fList) {
    }

    protected QFilter analyseCostAccountFilter(DataCheckParam param) {
        IDataEntityProperty accountProperty = this.entityType.findProperty("costaccount");
        Set<Long> costaccount = param.getCostAccount();
        if (accountProperty == null) {
            return null;
        }
        if (costaccount == null || costaccount.isEmpty()) {
            costaccount = this.getAllValidCostAccount();
        }
        ArrayList<QFilter> fList = new ArrayList<QFilter>(costaccount.size());
        IDataEntityProperty periodProperty = this.entityType.findProperty("period");
        IDataEntityProperty bookdateProperty = this.entityType.findProperty("bookdate");
        boolean hasPeriod = periodProperty != null;
        boolean hasBookdate = bookdateProperty != null;
        String periodName = null;
        if (hasPeriod) {
            periodName = this.analyseFieldName(periodProperty);
        }
        String costAccountName = this.analyseFieldName(accountProperty);
        for (Long costAccountId : costaccount) {
            DynamicObject period;
            QFilter filter = new QFilter(costAccountName, "=", (Object)costAccountId);
            if (param.getStartDate() != null && param.getEndDate() != null) {
                if (hasBookdate) {
                    String bookdateName = this.analyseFieldName(bookdateProperty);
                    filter = filter.and(bookdateName, ">=", (Object)param.getStartDate());
                    filter = filter.and(bookdateName, "<=", (Object)param.getEndDate());
                } else if (hasPeriod) {
                    period = this.getCurrentPeriod(costAccountId);
                    if (period == null) {
                        fList.add(filter);
                        continue;
                    }
                    filter = filter.and(periodName, "=", (Object)period.getLong("id"));
                }
            } else if (hasPeriod) {
                period = this.getCurrentPeriod(costAccountId);
                if (period == null) {
                    fList.add(filter);
                    continue;
                }
                filter = filter.and(periodName, "=", (Object)period.getLong("id"));
                if (!hasBookdate) {
                    fList.add(filter);
                    continue;
                }
                String bookdateName = this.analyseFieldName(bookdateProperty);
                filter = filter.and(bookdateName, ">=", (Object)period.getDate("begindate"));
                filter = filter.and(bookdateName, "<=", (Object)period.getDate("enddate"));
            }
            fList.add(filter);
        }
        if (fList.isEmpty()) {
            return new QFilter("id", "=", (Object)0);
        }
        QFilter firstFilter = (QFilter)fList.get(0);
        for (int i = 1; i < fList.size(); ++i) {
            firstFilter = firstFilter.or((QFilter)fList.get(i));
        }
        return firstFilter;
    }

    protected final Set<Long> getAllValidCostAccount() {
        QFilter filter = new QFilter("status", "=", (Object)"C");
        filter.and("enable", "=", (Object)true);
        DynamicObject[] costAccountCol = BusinessDataServiceHelper.load((String)"cal_bd_costaccount", (String)"id", (QFilter[])filter.toArray());
        HashSet<Long> costAccount = new HashSet<Long>(costAccountCol.length);
        for (DynamicObject costAccountObj : costAccountCol) {
            costAccount.add(costAccountObj.getLong("id"));
        }
        return costAccount;
    }

    protected QFilter analyseCalOrgFilter(DataCheckParam param) {
        return this.analyseFieldFilter("calorg", param.getCalorg());
    }

    protected QFilter analyseStorageOrgFilter(DataCheckParam param) {
        return this.analyseFieldFilter("storageorgunit", param.getStorageOrgUnit());
    }

    protected QFilter analyseMaterialFilter(DataCheckParam param) {
        if (param.getMaterial() != null && !param.getMaterial().isEmpty()) {
            param.getMaterial().add(0L);
        }
        return this.analyseFieldFilter("material", param.getMaterial());
    }

    protected QFilter analyseWarehouseFilter(DataCheckParam param) {
        return this.analyseFieldFilter("warehouse", param.getWarehouse());
    }

    protected QFilter analyseLocationFilter(DataCheckParam param) {
        return this.analyseFieldFilter("location", param.getLocation());
    }

    protected QFilter analyseInvtypeFilter(DataCheckParam param) {
        return this.analyseFieldFilter("invtype", param.getInvtype());
    }

    protected QFilter analyseInvstatusFilter(DataCheckParam param) {
        return this.analyseFieldFilter("invstatus", param.getInvstatus());
    }

    protected QFilter analyseProjectFilter(DataCheckParam param) {
        return this.analyseFieldFilter("project", param.getProject());
    }

    protected QFilter analyseMversionFilter(DataCheckParam param) {
        return this.analyseFieldFilter("mversion", param.getMversion());
    }

    private QFilter analyseFieldFilter(String fieldName, Set<Long> values) {
        IDataEntityProperty property = this.entityType.findProperty(fieldName);
        if (property == null || values == null || values.isEmpty()) {
            return null;
        }
        String name = this.analyseFieldName(property);
        return new QFilter(name, "in", values);
    }

    protected String analyseFieldName(IDataEntityProperty property) {
        String name = property.getName();
        IDataEntityType parentProperty = property.getParent();
        if (parentProperty instanceof SubEntryType) {
            IDataEntityType entryProp = parentProperty.getParent();
            name = entryProp.getName() + "." + parentProperty.getName() + "." + name;
        } else if (parentProperty instanceof EntryType) {
            name = parentProperty.getName() + "." + name;
        }
        return name;
    }
}

