/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.datacheck.item;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.ReduceGroupFunction;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.business.calculate.bizbillgroup.BizGroupRecordBuilder;
import kd.fi.cal.business.datacheck.DataCheckParam;
import kd.fi.cal.business.datacheck.ExceptionObj;
import kd.fi.cal.business.datacheck.funtion.DealAlgoNoUpdateCalFields;
import kd.fi.cal.business.datacheck.funtion.DiffActCostIsAllGroupFunction;
import kd.fi.cal.business.datacheck.helper.DiffAllocationCheckHelper;
import kd.fi.cal.business.datacheck.item.IDataCheck;
import kd.fi.cal.common.helper.AcctGroupModelHelper;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.common.helper.ParamsHelper;
import kd.fi.cal.common.helper.PeriodHelper;

public class DiffActCostIsConsistentCheck
implements IDataCheck {
    private static Log logger = LogFactory.getLog(DiffActCostIsConsistentCheck.class);

    @Override
    public List<ExceptionObj> collectExceptionObj(DataCheckParam param) {
        if (param.getCostAccount() == null || param.getCostAccount().isEmpty()) {
            param.setCostAccount(DiffAllocationCheckHelper.getAllValidCostAccount());
        }
        ArrayList<ExceptionObj> result = new ArrayList<ExceptionObj>();
        BigDecimal range = CalDbParamServiceHelper.getBigDecimal((String)"alloc_diff_range");
        HashSet<String> logTotalInComeDiffTotalInComeQtyZeroKeys = new HashSet<String>(16);
        ArrayList<List<Object>> logCheckInfos = new ArrayList<List<Object>>(16);
        HashSet<Long> logOrgIds = new HashSet<Long>(16);
        HashSet logEntryIdSet = new HashSet(500);
        for (Long costAccount : param.getCostAccount()) {
            long calOrg = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)"calorg", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)costAccount)}).getLong("calorg");
            if (param.getCalorg() != null && param.getCalorg().size() > 0 && !param.getCalorg().contains(calOrg)) continue;
            if (ParamsHelper.getAppParam((long)calOrg, (String)"diffalloccols") == null) {
                logOrgIds.add(calOrg);
                continue;
            }
            Integer amtPrecision = this.getCurrencyByCostAccountId(costAccount);
            if (amtPrecision == null) continue;
            ArrayList<Long> invBillIdList = new ArrayList<Long>(50000);
            HashSet<Object> materials = new HashSet<Object>(1000);
            String diffAllocDims = (ParamsHelper.getAppParam((long)calOrg, (String)"diffalloccols").toString() + "costaccount,material").substring(1);
            DataSet costRecordDs = this.getCostRecordDataSet(param, costAccount, diffAllocDims);
            DataSet currentInQtyDs = costRecordDs.filter("queuetype = '0'").groupBy(diffAllocDims.split(",")).sum("baseqty").finish().select(diffAllocDims + ",0 as periodBeginQty,baseqty as inQty,0 as outQty,0 as periodBeginDiff,0 as inDiff,0 as outDiff");
            DataSet currentOutQtyDs = costRecordDs.filter("queuetype = '1'").groupBy(diffAllocDims.split(",")).sum("baseqty").finish().select(diffAllocDims + ",0 as periodBeginQty,0 as inQty,baseqty as outQty,0 as periodBeginDiff,0 as inDiff,0 as outDiff");
            DataSet stdCostDiffDs = this.getStdCostDiffBillDataSet(param, costAccount, diffAllocDims);
            DataSet checkGroupDs = stdCostDiffDs.copy().filter("queuetype ='1'");
            HashMap<String, Long> allocDimsIdMap = new HashMap<String, Long>(500);
            for (Row row : checkGroupDs.copy()) {
                StringBuilder key = new StringBuilder();
                for (String field : diffAllocDims.split(",")) {
                    key.append(row.getString(field)).append("@");
                }
                allocDimsIdMap.put(key.substring(0, key.toString().length() - 1), row.getLong("entryid"));
                if (!"W".equals(row.getString("createtype"))) continue;
                invBillIdList.add(row.getLong("invbillentryid"));
                materials.add(row.getLong("material"));
            }
            HashSet<String> allGroupDims = new HashSet<String>(100);
            DataSet groupDs = this.getGroupDataSet(invBillIdList, costAccount, materials);
            if (groupDs != null) {
                DataSet calcAmtDs = checkGroupDs.leftJoin(groupDs).on("invbillentryid", "costrecordentryid").select(stdCostDiffDs.getRowMeta().getFieldNames(), new String[]{"groupid"}).finish();
                calcAmtDs = calcAmtDs.groupBy(diffAllocDims.split(",")).reduceGroup((ReduceGroupFunction)new DiffActCostIsAllGroupFunction(diffAllocDims, calcAmtDs.getRowMeta(), allGroupDims));
                int n = calcAmtDs.count("groupid", false);
            }
            DataSet inAdjustAmtDs = stdCostDiffDs.filter("queuetype = '0'").groupBy(diffAllocDims.split(",")).sum("adjustamt").finish().select(diffAllocDims + ",0 as periodBeginQty,0 as inQty,0 as outQty,0 as periodBeginDiff,adjustamt as inDiff,0 as outDiff");
            DataSet outAdjustAmtDs = stdCostDiffDs.filter("queuetype = '1'").groupBy(diffAllocDims.split(",")).sum("adjustamt").finish().select(diffAllocDims + ",0 as periodBeginQty,0 as inQty,0 as outQty,0 as periodBeginDiff,0 as inDiff,adjustamt as outDiff");
            DataSet qtyCalBalDs = this.getCalBalDataSet(param, costAccount, diffAllocDims, true);
            DataSet diffCalBalDs = this.getCalBalDataSet(param, costAccount, diffAllocDims, false);
            DataSet resultDS = qtyCalBalDs.union(diffCalBalDs).union(currentInQtyDs).union(currentOutQtyDs).union(inAdjustAmtDs).union(outAdjustAmtDs);
            resultDS = resultDS.groupBy(diffAllocDims.split(",")).sum("periodBeginQty").sum("inQty").sum("outQty").sum("periodBeginDiff").sum("inDiff").sum("outDiff").finish();
            HashSet<Long> entryIdList = new HashSet<Long>(500);
            HashMap<Long, BigDecimal> outDiffMap = new HashMap<Long, BigDecimal>(16);
            HashMap<Long, BigDecimal> balanceDiffMap = new HashMap<Long, BigDecimal>(16);
            for (Row row : resultDS) {
                StringBuilder key = new StringBuilder();
                for (String field : diffAllocDims.split(",")) {
                    key.append(row.getString(field)).append("@");
                }
                String dimsKey = key.substring(0, key.toString().length() - 1);
                if (allGroupDims.contains(dimsKey)) continue;
                BigDecimal currentInDiff = this.getZeroValue(row, "inDiff");
                BigDecimal calcDiff = this.getZeroValue(row, "outDiff");
                BigDecimal beginQtyDiff = this.getZeroValue(row, "periodBeginQty");
                BigDecimal beginCostDiff = this.getZeroValue(row, "periodBeginDiff");
                BigDecimal currentInQty = this.getZeroValue(row, "inQty");
                BigDecimal currentOutQty = this.getZeroValue(row, "outQty");
                BigDecimal totalInComeDiff = beginCostDiff.add(currentInDiff);
                BigDecimal totalInComeQty = beginQtyDiff.add(currentInQty);
                if (totalInComeDiff.compareTo(BigDecimal.ZERO) == 0 || totalInComeQty.compareTo(BigDecimal.ZERO) == 0) {
                    logTotalInComeDiffTotalInComeQtyZeroKeys.add(dimsKey);
                    continue;
                }
                BigDecimal diffRate = totalInComeDiff.divide(totalInComeQty, 10, 4);
                BigDecimal resultDiffAmt = diffRate.multiply(currentOutQty).setScale((int)amtPrecision, 4);
                BigDecimal balanceDiffAmt = diffRate.multiply(beginQtyDiff.add(currentInQty).subtract(currentOutQty)).setScale((int)amtPrecision, 4);
                BigDecimal sysBalanceDiffAmt = totalInComeDiff.subtract(calcDiff).setScale((int)amtPrecision, 4);
                BigDecimal diff = calcDiff.subtract(resultDiffAmt).abs();
                BigDecimal balDiff = balanceDiffAmt.subtract(sysBalanceDiffAmt).abs();
                if (diff.compareTo(range) <= 0 && balDiff.compareTo(range) <= 0) continue;
                Object[] infos = new Object[]{diffAllocDims, dimsKey, calcDiff, resultDiffAmt, beginQtyDiff, beginCostDiff, currentInQty, currentOutQty, currentInDiff};
                logCheckInfos.add(Arrays.asList(infos));
                Long entryId = (Long)allocDimsIdMap.get(dimsKey);
                if (entryId == null) continue;
                entryIdList.add(entryId);
                outDiffMap.put(entryId, calcDiff.subtract(resultDiffAmt).setScale((int)amtPrecision, 4));
                balanceDiffMap.put(entryId, sysBalanceDiffAmt.subtract(balanceDiffAmt).setScale((int)amtPrecision, 4));
            }
            if (entryIdList.isEmpty()) continue;
            QFilter filter = new QFilter("entryentity.id", "in", entryIdList);
            logEntryIdSet.addAll(entryIdList);
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)"DiffActCostIsConsistentCheck_errorMsg", (String)"cal_stdcostdiffbill", (String)"id,calorg.number calorg,costaccount.number costaccount,period.number periodnumber,entryentity.id entryid,entryentity.material.number material,entryentity.storageorgunit.number storageorgunit,entryentity.tracknumber.number tracknumber,entryentity.configuredcode.number configuredcode,entryentity.noupdatecalfields noupdatecalfields", (QFilter[])new QFilter[]{filter}, null);
            dataSet = dataSet.groupBy(new String[]{"material"}).reduceGroup((ReduceGroupFunction)new DealAlgoNoUpdateCalFields(dataSet.getRowMeta()));
            for (Row row : dataSet) {
                ExceptionObj exceptionObj = new ExceptionObj(row.getLong("id"), "cal_stdcostdiffbill");
                exceptionObj.setDescription(String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\uff1a%1$s\uff0c\u6210\u672c\u8d26\u7c3f\uff1a%2$s\uff0c\u671f\u95f4\uff1a%3$s\uff0c\u7269\u6599\uff1a%4$s\uff0c\u5e93\u5b58\u7ec4\u7ec7\uff1a%5$s\uff0c\u8ddf\u8e2a\u53f7\uff1a%6$s\uff0c\u914d\u7f6e\u53f7\uff1a%7$s\uff0c\u53d1\u51fa\u5dee\u5f02\u5dee\u989d\uff1a%8$s\uff0c\u7ed3\u5b58\u5dee\u5f02\u5dee\u989d\uff1a%9$s\u3002", (String)"DiffActCostIsConsistentCheck_1", (String)"fi-cal-business", (Object[])new Object[0]), row.getString("calorg"), row.getString("costaccount"), row.getString("periodnumber"), row.getString("material"), row.getString("storageorgunit"), row.getString("tracknumber") == null ? ResManager.loadKDString((String)"\u7a7a", (String)"DiffActCostIsConsistentCheck_2", (String)"fi-cal-business", (Object[])new Object[0]) : row.getString("tracknumber"), row.getString("configuredcode") == null ? ResManager.loadKDString((String)"\u7a7a", (String)"DiffActCostIsConsistentCheck_2", (String)"fi-cal-business", (Object[])new Object[0]) : row.getString("configuredcode"), outDiffMap.get(row.getLong("entryid")), balanceDiffMap.get(row.getLong("entryid"))));
                result.add(exceptionObj);
            }
        }
        logger.info("DiffActCostIsConsistentCheck_\u6838\u7b97\u7ec4\u7ec7\u672a\u8bbe\u7f6e\u5206\u644a\u7ef4\u5ea6==>{}", logOrgIds);
        logger.info("\u603b\u6536\u5165\u5dee\u5f02\u6216\u603b\u6536\u5165\u6570\u91cf\u4e3a0\uff0c\u7ef4\u5ea6key==>{}", logTotalInComeDiffTotalInComeQtyZeroKeys);
        logger.info("\u5b9e\u9645\u6210\u672c\u4e0d\u4e00\u81f4\u7684\u5dee\u5f02\u5355\u5206\u5f55ID==>{}", logEntryIdSet);
        logger.info("DiffActCostIsConsistentCheck_\u5dee\u5f02\u5206\u644a\u7ef4\u5ea6,\u7ef4\u5ea6key,\u5dee\u5f02\u5355\u51fa\u5e93\u5dee\u5f02\u6c47\u603b,\u8ba1\u7b97\u51fa\u6765\u7684\u5dee\u5f02,\u671f\u521d\u6570\u91cf,\u671f\u521d\u6536\u5165\u5dee\u5f02,\u672c\u671f\u6536\u5165\u6570\u91cf,\u672c\u671f\u53d1\u51fa\u6570\u91cf,\u672c\u671f\u6536\u5165\u5dee\u5f02==>{}", logCheckInfos);
        return result;
    }

    private DataSet getCalBalDataSet(DataCheckParam param, Long costAccount, String diffAllocDims, boolean isQty) {
        QFilter filter = this.getCommonFilter("cal_bal", param, costAccount);
        if (isQty) {
            filter.and("costsubelement.id", "=", (Object)773175233367685120L);
        }
        String selectFieldsStr = DiffAllocationCheckHelper.getSelectFieldsStr("cal_bal", diffAllocDims, "", 1);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"DiffActCostIsConsistentCheck_getCostRecordDataSet", (String)"cal_bal", (String)(selectFieldsStr + ",baseqty_bal as baseqty,costdiff_bal as costdiff"), (QFilter[])new QFilter[]{filter}, null);
        dataSet = dataSet.groupBy(diffAllocDims.split(",")).sum("baseqty").sum("costdiff").finish();
        dataSet = isQty ? dataSet.groupBy(diffAllocDims.split(",")).sum("baseqty").finish().select(diffAllocDims + ",baseqty as periodBeginQty,0 as inQty,0 as outQty,0 as periodBeginDiff,0 as inDiff,0 as outDiff") : dataSet.groupBy(diffAllocDims.split(",")).sum("costdiff").finish().select(diffAllocDims + ",0 as periodBeginQty,0 as inQty,0 as outQty,costdiff periodBeginDiff,0 as inDiff,0 as outDiff");
        return dataSet;
    }

    private DataSet getCostRecordDataSet(DataCheckParam param, Long costAccount, String diffAllocDims) {
        QFilter filter = this.getCommonFilter("cal_costrecord_subentity", param, costAccount);
        filter.and("isinitbill", "=", (Object)false);
        filter.and("issplitcreate", "=", (Object)false);
        filter.and("entry.accounttype", "=", (Object)"D");
        filter.and("billstatus", "=", (Object)"C");
        String selectFieldsStr = DiffAllocationCheckHelper.getSelectFieldsStr("cal_costrecord_subentity", diffAllocDims, "", 1);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"DiffActCostIsConsistentCheck_getCostRecordDataSet", (String)"cal_costrecord_subentity", (String)(selectFieldsStr + ",entry.noupdatecalfields noupdatecalfields,entry.queuetype as queuetype,entry.baseqty * entry.signnum  as baseqty"), (QFilter[])new QFilter[]{filter}, null);
        dataSet = dataSet.groupBy(new String[]{"material"}).reduceGroup((ReduceGroupFunction)new DealAlgoNoUpdateCalFields(dataSet.getRowMeta()));
        dataSet = dataSet.groupBy((diffAllocDims + ",queuetype").split(",")).sum("baseqty").finish();
        return dataSet;
    }

    private DataSet getStdCostDiffBillDataSet(DataCheckParam param, Long costAccount, String diffAllocDims) {
        QFilter filter = this.getCommonFilter("cal_stdcostdiffbill", param, costAccount);
        filter.and("billstatus", "=", (Object)"C");
        filter.and("isupdatecost", "=", (Object)true);
        filter.and("createtype", "!=", (Object)"G");
        String selectFieldsStr = DiffAllocationCheckHelper.getSelectFieldsStr("cal_stdcostdiffbill", diffAllocDims, "", 1);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"DiffActCostIsConsistentCheck_getStdCostDiffBillDataSet", (String)"cal_stdcostdiffbill", (String)(selectFieldsStr + ",createtype,biztype,entryentity.noupdatecalfields noupdatecalfields,entryentity.invbillentryid invbillentryid,entryentity.queuetype queuetype,entryentity.id entryid,entryentity.adjustamt*entryentity.signnum adjustamt"), (QFilter[])new QFilter[]{filter}, null);
        dataSet = dataSet.groupBy(new String[]{"material"}).reduceGroup((ReduceGroupFunction)new DealAlgoNoUpdateCalFields(dataSet.getRowMeta()));
        return dataSet;
    }

    private QFilter getCommonFilter(String entityNum, DataCheckParam param, Long costAccount) {
        QFilter filter = DiffAllocationCheckHelper.getCommonFilter(entityNum, param, costAccount);
        if ("cal_bal".equals(entityNum)) {
            DynamicObject currentPeriod = null;
            currentPeriod = param.getStartDate() != null && param.getEndDate() != null ? this.getPeriodByAccountAndDate(costAccount, param.getStartDate(), param.getEndDate()) : PeriodHelper.getCurrentPeriod((Long)costAccount);
            if (currentPeriod != null) {
                int period = currentPeriod.getInt("periodyear") * 100 + currentPeriod.getInt("periodnumber");
                filter.and("period", "<", (Object)period);
                filter.and("endperiod", ">=", (Object)period);
            } else {
                filter.and("id", "=", (Object)-1);
            }
        } else if (param.getStartDate() != null && param.getEndDate() != null) {
            filter.and("bookdate", ">=", (Object)param.getStartDate());
            filter.and("bookdate", "<=", (Object)param.getEndDate());
        } else {
            DynamicObject period = PeriodHelper.getCurrentPeriod((Long)costAccount);
            if (period != null) {
                filter.and("bookdate", ">=", (Object)period.getDate("begindate"));
                filter.and("bookdate", "<=", (Object)period.getDate("enddate"));
            }
        }
        return filter;
    }

    @Override
    public List<ExceptionObj> collectExceptionObj(List<DataCheckParam> param) {
        return null;
    }

    public Integer getCurrencyByCostAccountId(long costAccountId) {
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)"calpolicy.currency.amtprecision as amtprecision", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)costAccountId)});
        if (dynamicObject == null) {
            return null;
        }
        return dynamicObject.getInt("amtprecision");
    }

    private DataSet getGroupDataSet(List<Long> invBillIdList, Long costAccount, Set<Object> materials) {
        if (AcctGroupModelHelper.isBizGroupModel()) {
            HashMap<Long, Set<Object>> paramMap = new HashMap<Long, Set<Object>>(16);
            paramMap.put(costAccount, materials);
            BizGroupRecordBuilder groupHelper = new BizGroupRecordBuilder();
            DataSet ds = groupHelper.getAllGroupRecordDataSetByCostAccount(paramMap);
            return ds.filter("type == '1'");
        }
        DataSet result = null;
        for (List recordIds : Lists.partition(invBillIdList, (int)450000)) {
            QFilter grpFilter = new QFilter("entryentity.costrecordentryid", "in", (Object)recordIds);
            grpFilter.and("entryentity.type", "=", (Object)"1");
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)"DiffActCostIsConsistentCheck_getGroupDataSet", (String)"cal_account_grouprecord", (String)"entryentity.costrecordentryid costrecordentryid,id groupid", (QFilter[])new QFilter[]{grpFilter}, null);
            if (result == null) {
                result = dataSet;
                continue;
            }
            result = result.union(dataSet);
        }
        return result;
    }

    private BigDecimal getZeroValue(Row row, String field) {
        BigDecimal bigDecimal = row.getBigDecimal(field);
        if (bigDecimal == null) {
            return BigDecimal.ZERO;
        }
        return bigDecimal;
    }

    private DynamicObject getPeriodByAccountAndDate(Long costAccount, Date startDate, Date endDate) {
        DynamicObject dyo = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)"calpolicy,calpolicy.periodtype", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)costAccount)});
        QFilter qFilter = new QFilter("beginDate", "<=", (Object)startDate);
        qFilter.and("enddate", ">=", (Object)endDate);
        qFilter.and("periodtype", "=", (Object)dyo.getLong("calpolicy.periodtype"));
        qFilter.and("isadjustperiod", "=", (Object)Character.valueOf('0'));
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bd_period", (String)"id", (QFilter[])new QFilter[]{qFilter});
        if (dynamicObjects.size() != 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6839\u636e\u65e5\u671f\u8303\u56f4\u672a\u627e\u5230\u552f\u4e00\u7684\u4f1a\u8ba1\u671f\u95f4\uff0c\u8bf7\u8c03\u6574\u65e5\u671f\u8303\u56f4\u3002", (String)"DiffActCostIsConsistentCheck-1", (String)"fi-cal-business", (Object[])new Object[0]));
        }
        long id = ((DynamicObject)dynamicObjects.get(0)).getLong("id");
        return BusinessDataServiceHelper.loadSingle((Object)id, (String)"bd_period");
    }
}

