/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.datacheck.item;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.fi.cal.business.datacheck.DataCheckParam;
import kd.fi.cal.business.datacheck.ExceptionObj;
import kd.fi.cal.business.datacheck.item.DataEntityDataCheck;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.common.helper.CalDiffGroupSettingHelper;

public class DiffBillNoGroupCheck
extends DataEntityDataCheck {
    @Override
    protected String getDataEntityType() {
        return "cal_stdcostdiffbill";
    }

    @Override
    protected void addDataCheckFilter(List<QFilter> fList) {
        fList.add(new QFilter("billstatus", "=", (Object)"C"));
    }

    @Override
    protected Set<String> getSelectedFields() {
        HashSet<String> fields = new HashSet<String>(16);
        fields.add("id");
        fields.add("billtype.billformid as bizobject");
        fields.add("biztype");
        fields.add("calorg");
        fields.add("calorg.number as calorgnum");
        fields.add("costaccount.number as costaccountnum");
        fields.add("billno");
        return fields;
    }

    @Override
    public List<ExceptionObj> collectExceptionObj(DataSet dataSet, DataCheckParam param) {
        ArrayList<ExceptionObj> resultObj = new ArrayList<ExceptionObj>(16);
        String isgroupdiffbill = CalDbParamServiceHelper.getString((String)"isgroupdiffbill", null);
        if (isgroupdiffbill == null || !"true".equals(isgroupdiffbill)) {
            return resultObj;
        }
        CalDiffGroupSettingHelper groupSettingHelper = new CalDiffGroupSettingHelper();
        DynamicObjectCollection groupSettings = CalDiffGroupSettingHelper.getAllEnableSetting(null);
        if (groupSettings.isEmpty()) {
            return resultObj;
        }
        dataSet = dataSet.groupBy(new String[]{"id", "bizobject", "biztype", "calorg", "calorgnum", "costaccountnum", "billno"}).finish();
        block0: for (Row row : dataSet) {
            String bizObject = row.getString("bizobject");
            String bizType = row.getString("biztype");
            Long calorgId = row.getLong("calorg");
            for (DynamicObject groupSetting : groupSettings) {
                String settingBizObject = groupSetting.getString("bizentityobject.number");
                String settingBizType = groupSetting.getString("biztype");
                Long settingOrgId = groupSetting.getLong("orgentry.org");
                if (!settingBizObject.equals(bizObject) || !settingBizType.equals(bizType) || settingOrgId != null && Long.compare(settingOrgId, 0L) != 0 && Long.compare(settingOrgId, calorgId) != 0) continue;
                ExceptionObj exceptionObj = new ExceptionObj(row.getLong("id"), "cal_stdcostdiffbill");
                exceptionObj.setDescription(this.getErrorInfo(row, groupSetting));
                resultObj.add(exceptionObj);
                continue block0;
            }
        }
        return resultObj;
    }

    private String getErrorInfo(Row row, DynamicObject groupSetting) {
        String errorMsg = String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u201c%1$s\u201d\uff0c\u6210\u672c\u8d26\u7c3f\u201c %2$s\u201d\uff0c\u5355\u636e\u7f16\u53f7\u201c%3$s\u201d\uff0c\u7b26\u5408\u5dee\u5f02\u5355\u5408\u5e76\u914d\u7f6e\u201c %4$s\u201d\uff0c\u5374\u672a\u751f\u6210\u5408\u5e76\u5355\u3002", (String)"DiffGroupBillAdjustAmtCheck_11", (String)"fi-cal-business", (Object[])new Object[0]), row.getString("calorgnum"), row.getString("costaccountnum"), row.getString("billno"), groupSetting.getString("number"));
        return errorMsg;
    }
}

