/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.datacheck.item;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.business.datacheck.DataCheckParam;
import kd.fi.cal.business.datacheck.ExceptionObj;
import kd.fi.cal.business.datacheck.item.DataEntityDataCheck;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.common.helper.CalDiffGroupSettingHelper;
import kd.fi.cal.common.util.CommonUtils;

public class DiffGroupBillAdjustAmtCheck
extends DataEntityDataCheck {
    Set<String> amountFields;

    public DiffGroupBillAdjustAmtCheck() {
        new CalDiffGroupSettingHelper();
        this.amountFields = CalDiffGroupSettingHelper.getAmountFields();
    }

    @Override
    protected String getDataEntityType() {
        return "cal_costdiffgroupbill";
    }

    @Override
    protected Set<String> getSelectedFields() {
        new CalDiffGroupSettingHelper();
        Set select = CalDiffGroupSettingHelper.getAmountFields();
        select.add("id");
        select.add("calorg.number as calorgnum");
        select.add("costaccount.number as costaccountnum");
        select.add("billno");
        select.add("currency.amtprecision as amtprecision");
        return select;
    }

    @Override
    protected void addDataCheckFilter(List<QFilter> fList) {
        QFilter q = new QFilter("billstatus", "=", (Object)"C");
        fList.add(q);
        super.addDataCheckFilter(fList);
    }

    @Override
    public List<ExceptionObj> collectExceptionObj(DataSet dataSet, DataCheckParam param) {
        ArrayList<ExceptionObj> resultObj = new ArrayList<ExceptionObj>(16);
        String isgroupdiffbill = CalDbParamServiceHelper.getString((String)"isgroupdiffbill", null);
        if (isgroupdiffbill == null || !"true".equals(isgroupdiffbill)) {
            return resultObj;
        }
        HashSet<Long> groupDiffBillIds = new HashSet<Long>(16);
        for (Row row : dataSet.copy()) {
            groupDiffBillIds.add(row.getLong("id"));
        }
        if (groupDiffBillIds.isEmpty()) {
            return resultObj;
        }
        this.entityType = MetadataServiceHelper.getDataEntityType((String)"cal_stdcostdiffbill");
        List<QFilter> fList = this.analyseBizRangeFilter(param);
        fList.add(new QFilter("entryentity.groupdiffbillid", "in", groupDiffBillIds));
        StringBuilder selectFieldBuilder = new StringBuilder();
        selectFieldBuilder.append("entryentity.groupdiffbillid as groupdiffbillid,");
        for (String amountField : this.amountFields) {
            IDataEntityProperty fieldProperty = this.entityType.findProperty(amountField);
            if (fieldProperty.getParent() instanceof EntryType) {
                selectFieldBuilder.append(fieldProperty.getParent().getName());
                selectFieldBuilder.append('.');
                selectFieldBuilder.append(amountField);
                selectFieldBuilder.append(" as ");
            }
            selectFieldBuilder.append(amountField);
            selectFieldBuilder.append(',');
        }
        DataSet diffBillDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_stdcostdiffbill", (String)CommonUtils.trimComma((String)selectFieldBuilder.toString()), (QFilter[])fList.toArray(new QFilter[0]), null);
        GroupbyDataSet diffBillGroupDs = diffBillDs.groupBy(new String[]{"groupdiffbillid"});
        for (String string : this.amountFields) {
            diffBillGroupDs.sum(string);
        }
        diffBillDs = diffBillGroupDs.finish();
        HashMap diffBillMap = new HashMap(16);
        for (Row row : diffBillDs) {
            HashMap<String, BigDecimal> amtMap = (HashMap<String, BigDecimal>)diffBillMap.get(row.getLong("groupdiffbillid"));
            if (amtMap == null) {
                amtMap = new HashMap<String, BigDecimal>(16);
            }
            for (String amountField : this.amountFields) {
                amtMap.put(amountField, row.getBigDecimal(amountField));
            }
            diffBillMap.put(row.getLong("groupdiffbillid"), amtMap);
        }
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)"cal_costdiffgroupbill");
        for (Row row : dataSet) {
            Long groupDiffBillId = row.getLong("id");
            Map diffBillAmtMap = (Map)diffBillMap.get(groupDiffBillId);
            int amtprecision = row.getInteger("amtprecision");
            if (diffBillAmtMap == null) {
                ExceptionObj exceptionObj = new ExceptionObj(row.getLong("id"), "cal_stdcostdiffbill");
                String langugeMsg = String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u201c%1$s\u201d\uff0c\u6210\u672c\u8d26\u7c3f\u201c%2$s\u201d\uff0c\u5dee\u5f02\u5355\u5bf9\u5e94\u5408\u5e76\u5355\u5355\u636e\u201c%3$s\u201d\uff0c\u6839\u636e\u5408\u5e76\u5355\u672a\u83b7\u53d6\u5230\u5dee\u5f02\u5355\u6570\u636e\u3002", (String)"DiffGroupBillAdjustAmtCheck_5", (String)"fi-cal-business", (Object[])new Object[0]), row.getString("calorgnum"), row.getString("costaccountnum"), row.getString("billno"));
                exceptionObj.setDescription(langugeMsg);
                resultObj.add(exceptionObj);
                continue;
            }
            String amtMsg = null;
            for (String amountField : this.amountFields) {
                BigDecimal diffBillmt;
                BigDecimal diffGroupBillAmt = row.getBigDecimal(amountField).setScale(amtprecision, RoundingMode.HALF_UP);
                if (diffGroupBillAmt.compareTo(diffBillmt = ((BigDecimal)diffBillAmtMap.get(amountField)).setScale(amtprecision, RoundingMode.HALF_UP)) == 0) continue;
                if (amtMsg == null) {
                    amtMsg = "";
                }
                amtMsg = amtMsg + String.format(ResManager.loadKDString((String)"%1$s\uff1a\u5408\u5e76\u5355\uff08%2$s\uff09 \u5dee\u5f02\u5355\uff08%3$s\uff09", (String)"DiffGroupBillAdjustAmtCheck_7", (String)"fi-cal-business", (Object[])new Object[0]), mainEntityType.getProperty(amountField).getDisplayName(), diffGroupBillAmt.toString());
            }
            if (amtMsg == null) continue;
            amtMsg = String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\uff1a%1$s\uff0c\u6210\u672c\u8d26\u7c3f\uff1a%2$s\uff0c\u5dee\u5f02\u5355\u5bf9\u5e94\u5408\u5e76\u5355\u5355\u636e\u7f16\u53f7\uff1a%3$s\uff0c \u5b58\u5728\u5408\u5e76\u5355\u91d1\u989d\u4e0e\u5dee\u5f02\u5355\u91d1\u989d\u4e0d\u4e00\u81f4\u7684\u6570\u636e\uff1a%4$s", (String)"DiffGroupBillAdjustAmtCheck_6", (String)"fi-cal-business", (Object[])new Object[0]), row.getString("calorgnum"), row.getString("costaccountnum"), row.getString("billno"), amtMsg);
            ExceptionObj exceptionObj = new ExceptionObj(row.getLong("id"), "cal_stdcostdiffbill");
            exceptionObj.setDescription(amtMsg);
            resultObj.add(exceptionObj);
        }
        return resultObj;
    }
}

