/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.datacheck.item;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.ReduceGroupFunctionWithCollector;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.business.calculate.bizbillgroup.BizGroupRecordBuilder;
import kd.fi.cal.business.datacheck.DataCheckParam;
import kd.fi.cal.business.datacheck.ExceptionObj;
import kd.fi.cal.business.datacheck.funtion.DiffGroupBillDiffFunction;
import kd.fi.cal.business.datacheck.helper.DiffAllocationCheckHelper;
import kd.fi.cal.business.datacheck.item.IDataCheck;
import kd.fi.cal.common.helper.AcctGroupModelHelper;
import kd.fi.cal.common.helper.PeriodHelper;

public class DiffGroupBillDiffIsConsistentCheck
implements IDataCheck {
    private static Log logger = LogFactory.getLog(DiffGroupBillDiffIsConsistentCheck.class);
    private static final Integer batchSize = 450000;

    @Override
    public List<ExceptionObj> collectExceptionObj(DataCheckParam param) {
        if (param.getCostAccount() == null || param.getCostAccount().isEmpty()) {
            param.setCostAccount(DiffAllocationCheckHelper.getAllValidCostAccount());
        }
        ArrayList<ExceptionObj> result = new ArrayList<ExceptionObj>();
        for (Long costAccount : param.getCostAccount()) {
            long calOrg = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)"calorg", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)costAccount)}).getLong("calorg");
            if (param.getCalorg() != null && param.getCalorg().size() > 0 && !param.getCalorg().contains(calOrg)) continue;
            QFilter filter = this.getCommonFilter(param, costAccount);
            filter.and("createtype", "=", (Object)"W");
            filter.and("billstatus", "=", (Object)"C");
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"cal_stdcostdiffbill", (String)"entryentity.invbillentryid invbillentryid", (QFilter[])new QFilter[]{filter});
            List invEntryIds = dynamicObjects.stream().map(r -> r.getLong("invbillentryid")).collect(Collectors.toList());
            if (invEntryIds.isEmpty()) continue;
            List partition = Lists.partition(invEntryIds, (int)batchSize);
            for (List idList : partition) {
                DataSet periodDs;
                DataSet accountGrpDs = this.getGroupDataSet(idList, costAccount);
                if (accountGrpDs == null || (accountGrpDs = accountGrpDs.join(periodDs = accountGrpDs.copy().groupBy(new String[]{"groupid", "period"}).finish().groupBy(new String[]{"groupid"}).count("periodcount").finish().filter("periodcount = 1")).on("groupid", "groupid").select(accountGrpDs.getRowMeta().getFieldNames()).finish()).isEmpty()) continue;
                ArrayList<Long> recordIds = new ArrayList<Long>(16);
                for (Row row : accountGrpDs.copy()) {
                    recordIds.add(row.getLong("invbillentryid"));
                }
                QFilter stdFilter = new QFilter("entryentity.invbillentryid", "in", recordIds);
                stdFilter.and("createtype", "=", (Object)"W");
                stdFilter.and("billstatus", "=", (Object)"C");
                String stdSelFields = "calorg.number calorg,costaccount.number costaccount,period.number periodnumber,billno,entryentity.material.number material,entryentity.invbillentryid invbillentryid,entryentity.adjustamt adjustamt";
                DataSet stdBillDataset = QueryServiceHelper.queryDataSet((String)"DiffGroupBillDiffIsConsistentCheck_getTargetStdBill_2", (String)"cal_stdcostdiffbill", (String)stdSelFields, (QFilter[])new QFilter[]{stdFilter}, null);
                stdBillDataset = stdBillDataset.join(accountGrpDs).on("invbillentryid", "invbillentryid").select(stdBillDataset.getRowMeta().getFieldNames(), new String[]{"groupid", "iscompleted", "type", "weight", "baseqty"}).finish();
                stdBillDataset = stdBillDataset.groupBy(new String[]{"groupid"}).reduceGroup((ReduceGroupFunctionWithCollector)new DiffGroupBillDiffFunction(stdBillDataset.getRowMeta(), result));
                int totalCount = stdBillDataset.count("groupid", false);
                logger.info("DiffGroupBillDiffIsConsistentCheck_collectExceptionObj_count==>{}", (Object)totalCount);
            }
        }
        return result;
    }

    @Override
    public List<ExceptionObj> collectExceptionObj(List<DataCheckParam> param) {
        return null;
    }

    private QFilter getCommonFilter(DataCheckParam param, Long costAccount) {
        QFilter filter = DiffAllocationCheckHelper.getCommonFilter("cal_stdcostdiffbill", param, costAccount);
        if (param.getStartDate() != null && param.getEndDate() != null) {
            filter.and("bookdate", ">=", (Object)param.getStartDate());
            filter.and("bookdate", "<=", (Object)param.getEndDate());
        } else {
            DynamicObject period = PeriodHelper.getCurrentPeriod((Long)costAccount);
            if (period != null) {
                filter.and("bookdate", ">=", (Object)period.getDate("begindate"));
                filter.and("bookdate", "<=", (Object)period.getDate("enddate"));
            }
        }
        return filter;
    }

    private DataSet getGroupDataSet(List<Long> costRecordEntryId, Long costAccount) {
        if (AcctGroupModelHelper.isBizGroupModel()) {
            QFilter filter = new QFilter("entry.id", "in", costRecordEntryId);
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)"DiffGroupBillDiffIsConsistentCheck_getGroupDataSet", (String)"cal_costrecord", (String)"entry.material as material", (QFilter[])new QFilter[]{filter}, null);
            HashSet<Long> materials = new HashSet<Long>(1000);
            for (Row row : dataSet) {
                materials.add(row.getLong("material"));
            }
            if (materials.isEmpty()) {
                return null;
            }
            HashMap<Long, Set<Object>> paramMap = new HashMap<Long, Set<Object>>(16);
            paramMap.put(costAccount, materials);
            BizGroupRecordBuilder groupHelper = new BizGroupRecordBuilder();
            DataSet ds = groupHelper.getAllGroupRecordDataSetByCostAccount(paramMap);
            return ds.select("period,groupid,iscompleted,costrecordentryid as invbillentryid,type,weight,occupiedqty as baseqty");
        }
        QFilter grpFilter = new QFilter("entryentity.costrecordentryid", "in", costRecordEntryId);
        DynamicObjectCollection grpObjects = QueryServiceHelper.query((String)"cal_account_grouprecord", (String)"id", (QFilter[])new QFilter[]{grpFilter});
        Set groupIds = grpObjects.stream().map(r -> r.getLong("id")).collect(Collectors.toSet());
        if (groupIds.isEmpty()) {
            return null;
        }
        QFilter accountGrpFilter = new QFilter("id", "in", groupIds);
        String selectFields = "entryentity.period as period,id as groupid,iscompleted,entryentity.costrecordentryid invbillentryid,entryentity.type type,entryentity.weight weight,entryentity.occupiedqty baseqty";
        return QueryServiceHelper.queryDataSet((String)"DiffGroupBillDiffIsConsistentCheck_getTargetStdBill_1", (String)"cal_account_grouprecord", (String)selectFields, (QFilter[])new QFilter[]{accountGrpFilter}, null);
    }
}

