/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.datacheck.item;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.ReduceGroupFunction;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.business.datacheck.DataCheckParam;
import kd.fi.cal.business.datacheck.ExceptionObj;
import kd.fi.cal.business.datacheck.funtion.DealAlgoNoUpdateCalFields;
import kd.fi.cal.business.datacheck.helper.DiffAllocationCheckHelper;
import kd.fi.cal.business.datacheck.item.IDataCheck;
import kd.fi.cal.common.helper.ParamsHelper;
import kd.fi.cal.common.helper.PeriodHelper;

public class DiffNoGroupBillIsTransferCheck
implements IDataCheck {
    private static Log logger = LogFactory.getLog(DiffNoGroupBillIsTransferCheck.class);
    private static String[] diffTypes = new String[]{"diff_g", "diff_h", "diff_k", "diff_m", "diff_p", "diff_q", "diff_r", "diff_s", "diff_t", "diff_c"};
    private static final Integer batchSize = 200000;

    @Override
    public List<ExceptionObj> collectExceptionObj(DataCheckParam param) {
        if (param.getCostAccount() == null || param.getCostAccount().isEmpty()) {
            param.setCostAccount(DiffAllocationCheckHelper.getAllValidCostAccount());
        }
        ArrayList<ExceptionObj> result = new ArrayList<ExceptionObj>();
        HashSet<Long> logOrgIds = new HashSet<Long>(16);
        for (Long costAccount : param.getCostAccount()) {
            Map<String, BigDecimal> periodBeginDiffMap;
            Map<String, BigDecimal> curreyDiffMap;
            Set<String> dimsSet;
            long calOrg = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)"calorg", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)costAccount)}).getLong("calorg");
            if (param.getCalorg() != null && param.getCalorg().size() > 0 && !param.getCalorg().contains(calOrg)) continue;
            if (ParamsHelper.getAppParam((long)calOrg, (String)"diffalloccols") == null) {
                logOrgIds.add(calOrg);
                continue;
            }
            String diffAllocDims = (ParamsHelper.getAppParam((long)calOrg, (String)"diffalloccols").toString() + "costaccount,material").substring(1);
            DataSet resultDataSet = this.getRecordsDataSet(diffAllocDims, costAccount, param, dimsSet = this.mergeDiffMap(curreyDiffMap = this.getCurreyDiffMap(diffAllocDims, costAccount, param), periodBeginDiffMap = this.getPeriodBeginDiffMap(diffAllocDims, costAccount, param)));
            if (resultDataSet == null || resultDataSet.isEmpty()) continue;
            for (Row row : resultDataSet) {
                ExceptionObj exceptionObj = new ExceptionObj(row.getLong("id"), "cal_costrecord_subentity");
                String msg = String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u201c%1$s\u201d\uff0c\u6210\u672c\u8d26\u7c3f\u201c%2$s\u201d\uff0c\u671f\u95f4\u201c%3$s\u201d\uff0c\u7269\u6599\u201c%4$s\u201d\uff0c\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u5355\u53f7\u201c%5$s\u201d\u672a\u751f\u6210\u5dee\u5f02\u5355\u3002", (String)"DiffNoGroupBillIsTransferCheck_4", (String)"fi-cal-business", (Object[])new Object[0]), row.getString("calorg"), row.getString("costaccount"), row.getString("periodnumber"), row.getString("material"), row.getString("billno"));
                exceptionObj.setDescription(msg);
                result.add(exceptionObj);
            }
        }
        logger.info("DiffNoGroupBillIsTransferCheck_\u6838\u7b97\u7ec4\u7ec7\u672a\u8bbe\u7f6e\u5206\u644a\u7ef4\u5ea6==>{}", logOrgIds);
        return result;
    }

    private DataSet getRecordsDataSet(String diffAllocDims, Long costAccount, DataCheckParam param, Set<String> dimsSet) {
        QFilter filter = this.getCommonFilter("cal_costrecord_subentity", param, costAccount);
        filter.and("isinitbill", "=", (Object)false);
        filter.and("issplitcreate", "=", (Object)false);
        filter.and("entry.accounttype", "=", (Object)"D");
        filter.and("entry.queuetype", "=", (Object)"1");
        filter.and("billstatus", "=", (Object)"C");
        DataSet ds = QueryServiceHelper.queryDataSet((String)"DiffNoGroupBillIsTransferCheck_getRecordsDataSet", (String)"cal_costrecord_subentity", (String)"entry.id entryid", (QFilter[])new QFilter[]{filter}, null);
        ArrayList<Long> entryIdList = new ArrayList<Long>(50000);
        for (Row row : ds) {
            entryIdList.add(row.getLong("entryid"));
        }
        DataSet result = null;
        List partition = Lists.partition(entryIdList, (int)batchSize);
        for (List entryIds : partition) {
            String selectFieldsStr = DiffAllocationCheckHelper.getSelectFieldsStr("cal_costrecord_subentity", diffAllocDims, "", 1);
            DataSet recordDataSet = QueryServiceHelper.queryDataSet((String)"DiffNoGroupBillIsTransferCheck_getRecordsDataSet", (String)"cal_costrecord_subentity", (String)(selectFieldsStr + ",id,entry.noupdatecalfields noupdatecalfields,entry.id entryid"), (QFilter[])new QFilter[]{new QFilter("entry.id", "in", (Object)entryIds)}, null);
            HashSet<Long> recordEntryIds = new HashSet<Long>(16);
            for (Row row : recordDataSet.copy()) {
                recordEntryIds.add(row.getLong("entryid"));
            }
            QFilter groupFilter = new QFilter("entryentity.costrecordentryid", "in", recordEntryIds);
            groupFilter.and("entryentity.type", "=", (Object)"1");
            DataSet groupDataDet = QueryServiceHelper.queryDataSet((String)"DiffNoGroupBillIsTransferCheck_getRecordsDataSet_2", (String)"cal_account_grouprecord", (String)"entryentity.costrecordentryid recordid,entryentity.bizbillid bizbillid", (QFilter[])new QFilter[]{groupFilter}, null);
            recordDataSet = recordDataSet.leftJoin(groupDataDet).on("entryid", "recordid").select(recordDataSet.getRowMeta().getFieldNames(), new String[]{"bizbillid"}).finish();
            recordDataSet = recordDataSet.filter("bizbillid is null");
            recordDataSet = recordDataSet.groupBy(new String[]{"material"}).reduceGroup((ReduceGroupFunction)new DealAlgoNoUpdateCalFields(recordDataSet.getRowMeta()));
            ArrayList<Long> recordInfoIds = new ArrayList<Long>(16);
            for (Row row : recordDataSet) {
                StringBuilder key = new StringBuilder();
                for (String field : diffAllocDims.split(",")) {
                    key.append(row.getString(field)).append("@");
                }
                if (!dimsSet.contains(key.substring(0, key.toString().length() - 1))) continue;
                recordInfoIds.add(row.getLong("id"));
            }
            if (recordInfoIds.isEmpty()) continue;
            QFilter recordFilter = new QFilter("id", "in", recordInfoIds);
            recordFilter.and("entry.accounttype", "=", (Object)"D");
            recordFilter.and("billstatus", "=", (Object)"C");
            logger.info("DiffNoGroupBillIsTransferCheck_getRecordsDataSet recordInfoIds==>{}", recordInfoIds);
            DataSet recordDs = QueryServiceHelper.queryDataSet((String)"DiffNoGroupBillIsTransferCheck_getRecordsDataSet_3", (String)"cal_costrecord_subentity", (String)"id,billno,calorg.number calorg,costaccount.number costaccount,period.number periodnumber,entry.material.number material", (QFilter[])new QFilter[]{recordFilter}, null);
            QFilter stdFilter = new QFilter("entryentity.invbillid", "in", recordInfoIds);
            stdFilter.and("createtype", "=", (Object)"W");
            stdFilter.and("entryentity.accounttype", "=", (Object)"D");
            stdFilter.and("billstatus", "=", (Object)"C");
            DataSet stdDs = QueryServiceHelper.queryDataSet((String)"DiffNoGroupBillIsTransferCheck_getRecordsDataSet_4", (String)"cal_stdcostdiffbill", (String)"entryentity.invbillid invbillid,entryentity.invbillnum invbillnum", (QFilter[])new QFilter[]{stdFilter}, null);
            DataSet resultDs = recordDs.leftJoin(stdDs).on("id", "invbillid").select(recordDs.getRowMeta().getFieldNames(), new String[]{"invbillnum"}).finish();
            DataSet stdBillDs = resultDs.filter("invbillnum == null");
            if (stdBillDs.isEmpty()) continue;
            if (result == null) {
                result = stdBillDs;
                continue;
            }
            result = result.union(stdBillDs);
        }
        return result;
    }

    private Set<String> mergeDiffMap(Map<String, BigDecimal> curreyDiffMap, Map<String, BigDecimal> periodBeginDiffMap) {
        BigDecimal value;
        String key;
        HashSet<String> dimsSet = new HashSet<String>(16);
        for (Map.Entry<String, BigDecimal> entry : curreyDiffMap.entrySet()) {
            key = entry.getKey();
            value = entry.getValue();
            BigDecimal periodBegin = periodBeginDiffMap.get(key);
            if (periodBegin != null) {
                value = value.add(periodBegin);
            }
            if (value.compareTo(BigDecimal.ZERO) == 0) continue;
            dimsSet.add(key.substring(0, key.indexOf("diff") - 2));
        }
        for (Map.Entry<String, BigDecimal> entry : periodBeginDiffMap.entrySet()) {
            key = entry.getKey();
            value = entry.getValue();
            BigDecimal current = curreyDiffMap.get(key);
            if (current != null) {
                value = value.add(current);
            }
            if (value.compareTo(BigDecimal.ZERO) == 0) continue;
            dimsSet.add(key.substring(0, key.indexOf("diff") - 2));
        }
        logger.info("DiffNoGroupBillIsTransferCheck getPeriodBeginDiffMap dimsSet ==>{}", dimsSet);
        return dimsSet;
    }

    private Map<String, BigDecimal> getPeriodBeginDiffMap(String diffAllocDims, Long costAccount, DataCheckParam param) {
        HashMap<String, BigDecimal> periodBeginDiffMap = new HashMap<String, BigDecimal>(16);
        QFilter filter = this.getCommonFilter("cal_standcost_bal", param, costAccount);
        String selectFieldsStr = DiffAllocationCheckHelper.getSelectFieldsStr("cal_standcost_bal", diffAllocDims, "", 1);
        selectFieldsStr = selectFieldsStr + ",diff_g_bal diff_g,diff_h_bal diff_h,diff_k_bal diff_k,diff_p_bal diff_p,diff_q_bal diff_q,diff_r_bal diff_r,diff_m_bal diff_m,diff_s_bal diff_s,diff_t_bal diff_t,diff_c_bal diff_c";
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"DiffNoGroupBillIsTransferCheck_getCurreyDiffMap", (String)"cal_standcost_bal", (String)selectFieldsStr, (QFilter[])new QFilter[]{filter}, null);
        DataSet resultDs = dataSet.groupBy(diffAllocDims.split(",")).sum("diff_g").sum("diff_h").sum("diff_k").sum("diff_p").sum("diff_q").sum("diff_r").sum("diff_m").sum("diff_s").sum("diff_t").sum("diff_c").finish();
        resultDs = resultDs.filter("diff_g <> 0 or diff_h <> 0 or diff_k <> 0 or diff_p <> 0 or diff_q <> 0 or diff_r <> 0 or diff_m <> 0 or diff_s <> 0 or diff_t <> 0 or diff_c <> 0");
        for (Row row : resultDs) {
            StringBuilder key = new StringBuilder();
            for (String field : diffAllocDims.split(",")) {
                key.append(row.getString(field)).append("@");
            }
            for (String diffType : diffTypes) {
                if (row.getBigDecimal(diffType) == null || row.getBigDecimal(diffType).compareTo(BigDecimal.ZERO) == 0) continue;
                key.append("@").append(diffType);
                periodBeginDiffMap.put(key.toString(), row.getBigDecimal(diffType));
            }
        }
        logger.info("DiffNoGroupBillIsTransferCheck getPeriodBeginDiffMap map ==>{}", periodBeginDiffMap);
        return periodBeginDiffMap;
    }

    @Override
    public List<ExceptionObj> collectExceptionObj(List<DataCheckParam> param) {
        return null;
    }

    private Map<String, BigDecimal> getCurreyDiffMap(String diffAllocDims, Long costAccount, DataCheckParam param) {
        HashMap<String, BigDecimal> curreyDiffMap = new HashMap<String, BigDecimal>(16);
        QFilter filter = this.getCommonFilter("cal_stdcostdiffbill", param, costAccount);
        filter.and("entryentity.queuetype", "=", (Object)"0");
        filter.and("createtype", "not in", (Object)Sets.newHashSet((Object[])new String[]{"W", "G"}));
        filter.and("billstatus", "=", (Object)"C");
        String selectFieldsStr = DiffAllocationCheckHelper.getSelectFieldsStr("cal_stdcostdiffbill", diffAllocDims, "", 1);
        selectFieldsStr = selectFieldsStr + ",entryentity.noupdatecalfields noupdatecalfields,entryentity.diff_g diff_g,entryentity.diff_h diff_h,entryentity.diff_k diff_k,entryentity.diff_p diff_p,entryentity.diff_q diff_q,entryentity.diff_r diff_r,entryentity.diff_m diff_m,entryentity.diff_s diff_s,entryentity.diff_t diff_t,entryentity.diff_c diff_c";
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"DiffNoGroupBillIsTransferCheck_getCurreyDiffMap", (String)"cal_stdcostdiffbill", (String)selectFieldsStr, (QFilter[])new QFilter[]{filter}, null);
        dataSet = dataSet.groupBy(new String[]{"material"}).reduceGroup((ReduceGroupFunction)new DealAlgoNoUpdateCalFields(dataSet.getRowMeta()));
        DataSet resultDs = dataSet.groupBy(diffAllocDims.split(",")).sum("diff_g").sum("diff_h").sum("diff_k").sum("diff_p").sum("diff_q").sum("diff_r").sum("diff_m").sum("diff_s").sum("diff_t").sum("diff_c").finish();
        resultDs = resultDs.filter("diff_g <> 0 or diff_h <> 0 or diff_k <> 0 or diff_p <> 0 or diff_q <> 0 or diff_r <> 0 or diff_m <> 0 or diff_s <> 0 or diff_t <> 0 or diff_c <> 0");
        for (Row row : resultDs) {
            StringBuilder key = new StringBuilder();
            for (String field : diffAllocDims.split(",")) {
                key.append(row.getString(field)).append("@");
            }
            for (String diffType : diffTypes) {
                if (row.getBigDecimal(diffType).compareTo(BigDecimal.ZERO) == 0) continue;
                key.append("@").append(diffType);
                curreyDiffMap.put(key.toString(), row.getBigDecimal(diffType));
            }
        }
        logger.info("DiffNoGroupBillIsTransferCheck getCurreyDiffMap map ==>{}", curreyDiffMap);
        return curreyDiffMap;
    }

    private QFilter getCommonFilter(String entityNum, DataCheckParam param, Long costAccount) {
        QFilter filter = DiffAllocationCheckHelper.getCommonFilter(entityNum, param, costAccount);
        if ("cal_standcost_bal".equals(entityNum)) {
            DynamicObject currentPeriod = PeriodHelper.getCurrentPeriod((Long)costAccount);
            if (currentPeriod != null) {
                int period = currentPeriod.getInt("periodyear") * 100 + currentPeriod.getInt("periodnumber");
                filter.and("period", "<", (Object)period);
                filter.and("endperiod", ">=", (Object)period);
            } else {
                filter.and("id", "=", (Object)-1);
            }
        } else if (param.getStartDate() != null && param.getEndDate() != null) {
            filter.and("bookdate", ">=", (Object)param.getStartDate());
            filter.and("bookdate", "<=", (Object)param.getEndDate());
        } else {
            DynamicObject period = PeriodHelper.getCurrentPeriod((Long)costAccount);
            if (period != null) {
                filter.and("bookdate", ">=", (Object)period.getDate("begindate"));
                filter.and("bookdate", "<=", (Object)period.getDate("enddate"));
            }
        }
        return filter;
    }
}

