/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.datacheck.item;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.fi.cal.business.datacheck.DataCheckParam;
import kd.fi.cal.business.datacheck.ExceptionObj;
import kd.fi.cal.business.datacheck.item.IDataCheck;
import kd.fi.cal.common.util.CommonUtils;

public class DupliactiveFeeShareCostAdjustBillCheck
implements IDataCheck {
    private static final String SQL_NODATE = "SELECT  A.FFEESHAREFLAGID FFEESHAREFLAGID,MAX(A.fbillno) fbillno from t_cal_costadjustbill A join t_cal_costadjustbillentry B on A.fid= B.FID WHERE A.FCREATETYPE in ('D','I') group by A.FFEESHAREFLAGID,B.FINVBILLID,B.FINVBILLENTRYID,B.FSRCBILLENTRYID HAVING count(1) > 1";
    private static final String SQL_HASDATE = "SELECT A.FFEESHAREFLAGID FFEESHAREFLAGID,MAX(A.fbillno) fbillno from t_cal_costadjustbill A join t_cal_costadjustbillentry B on A.fid= B.FID WHERE A.FCREATETYPE in ('D','I') AND A.FBOOKDATE >= ? AND A.FBOOKDATE <= ? group by A.FFEESHAREFLAGID,B.FINVBILLID,B.FINVBILLENTRYID,B.FSRCBILLENTRYID HAVING count(1) > 1";

    @Override
    public List<ExceptionObj> collectExceptionObj(List<DataCheckParam> paramList) {
        ArrayList<ExceptionObj> exceptionObjList = new ArrayList<ExceptionObj>(16);
        for (DataCheckParam param : paramList) {
            List<ExceptionObj> exceptionObj = this.collectExceptionObj(param);
            if (exceptionObj == null || exceptionObj.isEmpty()) continue;
            exceptionObjList.addAll(exceptionObj);
        }
        return exceptionObjList;
    }

    @Override
    public List<ExceptionObj> collectExceptionObj(DataCheckParam param) {
        Date startDate = param.getStartDate();
        Date endDate = param.getEndDate();
        DataSet ds = null;
        ds = startDate != null && endDate != null ? DB.queryDataSet((String)this.getClass().getName(), (DBRoute)CommonUtils.getCalDBRouteKey(), (String)SQL_HASDATE, (Object[])new Object[]{startDate, endDate}) : DB.queryDataSet((String)this.getClass().getName(), (DBRoute)CommonUtils.getCalDBRouteKey(), (String)SQL_NODATE);
        ArrayList<ExceptionObj> excessiveBillNumbers = new ArrayList<ExceptionObj>(16);
        for (Row row : ds) {
            Long feeshareid = row.getLong("FFEESHAREFLAGID");
            String fbillno = row.getString("fbillno");
            ExceptionObj obj = new ExceptionObj(feeshareid, "cal_costadjust_subentity");
            obj.setDescription(fbillno);
            excessiveBillNumbers.add(obj);
        }
        return excessiveBillNumbers;
    }
}

