/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.datacheck.item;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.fi.cal.business.datacheck.DataCheckParam;
import kd.fi.cal.business.datacheck.ExceptionObj;
import kd.fi.cal.business.datacheck.item.IDataCheck;
import kd.fi.cal.common.util.CommonUtils;

public class DupliactiveFeeShareRecordCheck
implements IDataCheck {
    private static final String SQL = "SELECT max(A.fbillno) fbillno, max(A.fid) fid from t_cal_feerecord A join t_cal_feerecordentry B on A.fid= B.FID WHERE B.fismianbill ='1' group by B.fbillid,B.fbillentryid HAVING count(1) > 1";

    @Override
    public List<ExceptionObj> collectExceptionObj(List<DataCheckParam> paramList) {
        ArrayList<ExceptionObj> exceptionObjList = new ArrayList<ExceptionObj>(16);
        for (DataCheckParam param : paramList) {
            List<ExceptionObj> exceptionObj = this.collectExceptionObj(param);
            if (exceptionObj == null || exceptionObj.isEmpty()) continue;
            exceptionObjList.addAll(exceptionObj);
        }
        return exceptionObjList;
    }

    @Override
    public List<ExceptionObj> collectExceptionObj(DataCheckParam param) {
        DataSet ds = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)CommonUtils.getCalDBRouteKey(), (String)SQL);
        ArrayList<ExceptionObj> excessiveBillNumbers = new ArrayList<ExceptionObj>(16);
        for (Row row : ds) {
            Long feeshareid = row.getLong("fid");
            String fbillno = row.getString("fbillno");
            ExceptionObj obj = new ExceptionObj(feeshareid, "cal_feeshare_newrecord");
            obj.setDescription(fbillno);
            excessiveBillNumbers.add(obj);
        }
        return excessiveBillNumbers;
    }
}

