/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.datacheck.item;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.orm.query.QFilter;
import kd.fi.cal.business.datacheck.DataCheckParam;
import kd.fi.cal.business.datacheck.ExceptionObj;
import kd.fi.cal.business.datacheck.item.DataEntityDataCheck;

public class DuplicativeCostRecordDataCheck
extends DataEntityDataCheck {
    @Override
    protected String getDataEntityType() {
        return "cal_costrecord_subentity";
    }

    @Override
    protected Set<String> getSelectedFields() {
        HashSet<String> set = new HashSet<String>(16);
        set.add("id");
        set.add("costaccount");
        set.add("billnumber");
        set.add("bizentityobject");
        set.add("bizbillid");
        set.add("calbilltype");
        return set;
    }

    @Override
    public List<ExceptionObj> collectExceptionObj(DataSet dataSet, DataCheckParam param) {
        dataSet = dataSet.groupBy(new String[]{"id", "billnumber", "costaccount", "bizentityobject", "bizbillid", "calbilltype"}).finish();
        dataSet = dataSet.groupBy(new String[]{"billnumber", "costaccount", "bizentityobject", "bizbillid", "calbilltype"}).count("count").finish().where("count > 1");
        ArrayList<ExceptionObj> excessiveBillNumbers = new ArrayList<ExceptionObj>(16);
        for (Row row : dataSet) {
            Long bizbillid = row.getLong("bizbillid");
            String billnumber = row.getString("billnumber");
            String bizEntityObject = row.getString("bizentityobject");
            ExceptionObj obj = new ExceptionObj(bizbillid, bizEntityObject);
            obj.setDescription(billnumber);
            excessiveBillNumbers.add(obj);
        }
        return excessiveBillNumbers;
    }

    @Override
    protected void addDataCheckFilter(List<QFilter> fList) {
        super.addDataCheckFilter(fList);
        QFilter billStatus = new QFilter("billstatus", "=", (Object)"C");
        QFilter filter = new QFilter("issplitcreate", "=", (Object)false);
        fList.add(billStatus);
        fList.add(filter);
    }
}

