/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.datacheck.item;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.business.datacheck.DataCheckParam;
import kd.fi.cal.business.datacheck.ExceptionObj;
import kd.fi.cal.business.datacheck.item.DataEntityDataCheck;
import kd.fi.cal.common.util.CommonUtils;

public class ExcessiveCostRecordDataCheck
extends DataEntityDataCheck {
    @Override
    protected String getDataEntityType() {
        return "cal_costrecord_subentity";
    }

    @Override
    protected Set<String> getSelectedFields() {
        HashSet<String> set = new HashSet<String>(16);
        set.add("id");
        set.add("bookdate");
        set.add("bizentityobject");
        set.add("bizbillid");
        set.add("billnumber");
        return set;
    }

    @Override
    public List<ExceptionObj> collectExceptionObj(DataSet dataSet, DataCheckParam param) {
        HashMap<String, Map> map = new HashMap<String, Map>(16);
        for (Row row : dataSet) {
            String bizEntityObject = row.getString("bizentityobject");
            Long bizBillId = row.getLong("bizbillid");
            String billno = row.getString("billnumber");
            Map billMap = map.computeIfAbsent(bizEntityObject, k -> new HashMap(16));
            billMap.put(bizBillId, billno);
        }
        ArrayList<ExceptionObj> excessiveBillNumbers = new ArrayList<ExceptionObj>(16);
        for (Map.Entry stringMapEntry : map.entrySet()) {
            String bizEntityObject = (String)stringMapEntry.getKey();
            Map billnoMap = (Map)stringMapEntry.getValue();
            this.handleBizBill(bizEntityObject, billnoMap);
            for (Map.Entry bizId2Num : billnoMap.entrySet()) {
                ExceptionObj obj = new ExceptionObj((Long)bizId2Num.getKey(), bizEntityObject);
                obj.setDescription((String)bizId2Num.getValue());
                excessiveBillNumbers.add(obj);
            }
        }
        return excessiveBillNumbers;
    }

    private void handleBizBill(String bizEntityObject, Map<Long, String> billnoMap) {
        Set<Long> billIdSet = billnoMap.keySet();
        List setList = CommonUtils.getSplitList(billIdSet);
        for (Set idSet : setList) {
            QFilter bizBillFilter = new QFilter("id", "in", (Object)idSet);
            bizBillFilter.and("billstatus", "=", (Object)"C");
            DataSet bizBillDS = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)bizEntityObject, (String)"id", (QFilter[])bizBillFilter.toArray(), null);
            Throwable throwable = null;
            try {
                for (Row row : bizBillDS) {
                    billnoMap.remove(row.getLong("id"));
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (bizBillDS == null) continue;
                if (throwable != null) {
                    try {
                        bizBillDS.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                bizBillDS.close();
            }
        }
    }

    @Override
    protected void addDataCheckFilter(List<QFilter> fList) {
        super.addDataCheckFilter(fList);
        QFilter billStatus = new QFilter("billstatus", "=", (Object)"C");
        fList.add(billStatus);
    }
}

