/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.datacheck.item;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.OrmInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cal.business.calculate.bizbillgroup.BizGroupRecordBuilder;
import kd.fi.cal.business.datacheck.DataCheckParam;
import kd.fi.cal.business.datacheck.ExceptionObj;
import kd.fi.cal.business.datacheck.item.IDataCheck;
import kd.fi.cal.common.enums.CostAdjustBilCreateTypeEnum;
import kd.fi.cal.common.helper.AcctGroupModelHelper;
import kd.fi.cal.common.helper.DiffJsonEntryServiceHelper;
import kd.fi.cal.common.helper.PeriodHelper;

public class GroupBillCostDataCheck
implements IDataCheck {
    public static final String COSTRECORD_SELECT_FIELDS = "billno,costaccount,costaccount.number as costaccountnum,localcurrency.amtprecision as amtprecision,entry.id as entryid,entry.material.number as matnum,entry.materialcost as materialcost,entry.fee as fee,entry.processcost as processcost,entry.manufacturecost as manufacturecost,entry.resource as resource, entry.actualcost as actualcost,entry.subentrycostelement.costsubelement.name as costsubelementname,entry.subentrycostelement.costsubelement as costsubelement,entry.subentrycostelement.sub_actualcost as sub_actualcost,period";
    private Set<Long> enableCalByEleCAIds;
    private static final int SPLIT_SIZE = 500000;
    public static final String ADJUST_SELECT_FIELDS = "entryentity.invbillnum as billno,costaccount,costaccount.number as costaccountnum,currency.amtprecision as amtprecision,entryentity.invbillentryid as entryid,entryentity.material.number as matnum,entryentity.adjustamt as materialcost,0 as fee,0 as processcost,0 as manufacturecost,0 as resource, entryentity.adjustamt as actualcost,entryentity.subentryentity.costsubelement.name as costsubelementname,entryentity.subentryentity.costsubelement as costsubelement,entryentity.subentryentity.sub_adjustamt as sub_adjustamt,period";
    public static final String STDDIFF_SELECT_FIELDS = "entryentity.invbillnum as billno,costaccount as costaccount,costaccount.number as costaccountnum,currency.amtprecision as amtprecision,entryentity.invbillentryid as entryid,entryentity.material.number as matnum,entryentity.adjustamt as materialcost,0 as fee,0 as processcost,0 as manufacturecost,0 as resource, entryentity.adjustamt as actualcost,entryentity.subentryentity.costsubelement as costsubelement,entryentity.subentryentity.sub_adjustamt as sub_adjustamt,period as period";
    public static final String ADJUSTSTDDIFF_COMMON_SELECT_FIELDS = "billno,costaccount,costaccountnum,amtprecision,entryid,matnum,materialcost,fee,processcost,manufacturecost,resource,actualcost,costsubelementname,costsubelement,sub_adjustamt as sub_actualcost,period";

    @Override
    public List<ExceptionObj> collectExceptionObj(DataCheckParam param) {
        this.initCostAccountIds(param);
        DataSet acGroupRecDS = null;
        acGroupRecDS = AcctGroupModelHelper.isBizGroupModel() ? this.getAccGroupRecDSByBiz(param) : this.getAccGroupRecDS(param);
        DataSet costRecordDS = this.getCostRecordDS(acGroupRecDS.copy(), param);
        List<ExceptionObj> result = this.handleResult(acGroupRecDS, costRecordDS);
        return result;
    }

    private DataSet getAccGroupRecDSByBiz(DataCheckParam param) {
        Set<Long> costAccounts = param.getCostAccount();
        Set<Long> calorgs = param.getCalorg();
        Set<Long> materials = param.getMaterial();
        if (costAccounts == null || costAccounts.isEmpty()) {
            costAccounts = new HashSet<Long>(4);
            if (calorgs != null && !calorgs.isEmpty()) {
                QFilter filter = new QFilter("calorg", "in", calorgs);
                filter.and("enable", "=", (Object)"1");
                DataSet ds = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_bd_costaccount", (String)"id", (QFilter[])filter.toArray(), null);
                Object object = null;
                try {
                    for (Row row : ds) {
                        costAccounts.add(row.getLong("id"));
                    }
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (ds != null) {
                        if (object != null) {
                            try {
                                ds.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            ds.close();
                        }
                    }
                }
            }
        }
        HashSet<Long> materialObjs = null;
        if (materials != null && !materials.isEmpty()) {
            materialObjs = new HashSet<Long>(16);
            for (Long material : materials) {
                materialObjs.add(material);
            }
        }
        HashMap<Long, Set<Object>> costAccount2MaterialidMap = new HashMap<Long, Set<Object>>(4);
        for (Long costAccount : costAccounts) {
            costAccount2MaterialidMap.put(costAccount, materialObjs);
        }
        DataSet acGroupRecDS = new BizGroupRecordBuilder(Collections.singletonMap("needAfterGroup", false)).getAllGroupRecordDataSetByCostAccount(costAccount2MaterialidMap);
        acGroupRecDS = acGroupRecDS.where("iscompleted = true").select("groupid as id,costcolumn,costfields,type,costrecordentryid as receid,bookdate");
        return acGroupRecDS;
    }

    private DataSet getAccGroupRecDS(DataCheckParam param) {
        DataSet acIdDS = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_account_grouprecord", (String)"id", (QFilter[])this.getACFilter(param), null);
        ArrayList<OrmInput> inputs = new ArrayList<OrmInput>(16);
        int splitSize = 500000;
        HashSet<Long> tempIdSet = new HashSet<Long>(splitSize);
        String selectFields = "id,costcolumn,costfields,entryentity.type as type,entryentity.costrecordentryid as receid,entryentity.bookdate as bookdate";
        RowMeta rowMeta = ORM.create().createRowMeta("cal_account_grouprecord", selectFields);
        for (Row row : acIdDS) {
            if (tempIdSet.size() >= splitSize) {
                QFilter acFilter = new QFilter("id", "in", tempIdSet);
                OrmInput input = new OrmInput(this.getClass().getName(), "cal_account_grouprecord", selectFields, acFilter.toArray(), rowMeta);
                inputs.add(input);
                tempIdSet = new HashSet(splitSize);
            }
            tempIdSet.add(row.getLong("id"));
        }
        QFilter acFilter = new QFilter("id", "in", tempIdSet);
        OrmInput input = new OrmInput(this.getClass().getName(), "cal_account_grouprecord", selectFields, acFilter.toArray(), rowMeta);
        inputs.add(input);
        Algo algo = Algo.create((String)this.getClass().getName());
        return algo.createDataSet((Input[])inputs.toArray(new OrmInput[inputs.size()]));
    }

    private void initCostAccountIds(DataCheckParam param) {
        this.enableCalByEleCAIds = new HashSet<Long>();
        QFilter filter = new QFilter("calpolicy.calbycostelement", "=", (Object)true);
        Set<Long> costAccountIds = param.getCostAccount();
        Set<Long> calorgIds = param.getCalorg();
        if (costAccountIds != null && !costAccountIds.isEmpty()) {
            filter.and("id", "in", costAccountIds);
        }
        if (calorgIds != null && !calorgIds.isEmpty()) {
            filter.and("calorg", "in", calorgIds);
        }
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_bd_costaccount", (String)"id", (QFilter[])filter.toArray(), null);){
            for (Row row : ds) {
                this.enableCalByEleCAIds.add(row.getLong("id"));
            }
        }
    }

    @Override
    public List<ExceptionObj> collectExceptionObj(List<DataCheckParam> paramList) {
        ArrayList<ExceptionObj> finalExceptionList = new ArrayList<ExceptionObj>(16);
        for (DataCheckParam param : paramList) {
            ArrayList<ExceptionObj> exceptionObjList = new ArrayList<ExceptionObj>(16);
            List<ExceptionObj> exceptionObj = this.collectExceptionObj(param);
            if (exceptionObj != null && !exceptionObj.isEmpty()) {
                exceptionObjList.addAll(exceptionObj);
            }
            HashSet<String> descSet = new HashSet<String>(16);
            for (ExceptionObj obj : exceptionObjList) {
                String desc = obj.getDescription();
                if (descSet.contains(desc)) continue;
                descSet.add(desc);
                finalExceptionList.add(obj);
            }
        }
        return finalExceptionList;
    }

    private List<ExceptionObj> handleResult(DataSet acGroupRecDS, DataSet costRecordDS) {
        costRecordDS = costRecordDS.distinct();
        DataSet innerDS = acGroupRecDS.join(costRecordDS, JoinType.INNER).on("receid", "entryid").select(new String[]{"id", "type", "costcolumn", "costfields"}, new String[]{"entryid", "billno", "costaccount", "costaccountnum", "amtprecision", "matnum", "costsubelement", "costsubelementname", "materialcost", "fee", "processcost", "manufacturecost", "resource", "actualcost", "sub_actualcost", "period"}).finish();
        DataSet srcDS = innerDS.where("type = '0'").groupBy(new String[]{"id", "costsubelement", "costsubelementname", "costcolumn", "costfields"}).maxP("entryid", "billno").maxP("entryid", "amtprecision").maxP("entryid", "matnum").maxP("entryid", "costaccount").maxP("entryid", "costaccountnum").sum("materialcost").sum("fee").sum("processcost").sum("manufacturecost").sum("resource").sum("actualcost").sum("sub_actualcost").finish().select("id as srcid,costsubelement,costsubelementname,costcolumn,costfields,costaccount,costaccountnum,billno as srcbillno,amtprecision,matnum as srcmatnum,materialcost as srcmaterialcost,fee as srcfee,processcost as srcprocesscost,manufacturecost as srcmanufacturecost,resource as srcresource,actualcost as srcactualcost,sub_actualcost as srcsub_actualcost");
        DataSet destDS = innerDS.where("type = '1'").groupBy(new String[]{"id", "costsubelement", "costsubelementname", "costcolumn", "costfields"}).maxP("entryid", "billno").maxP("entryid", "matnum").sum("materialcost").sum("fee").sum("processcost").sum("manufacturecost").sum("resource").sum("actualcost").sum("sub_actualcost").max("period", "destperiod").maxP("period", "costaccount", "destcostaccount").finish().select("id as destid,costsubelement,costsubelementname,billno as destbillno,matnum as destmatnum,materialcost as destmaterialcost,fee as destfee,processcost as destprocesscost,manufacturecost as destmanufacturecost,resource as destresource,actualcost as destactualcost,sub_actualcost as destsub_actualcost,destperiod,destcostaccount");
        DataSet resDS = srcDS.join(destDS, JoinType.INNER).on("srcid", "destid").on("costsubelement", "costsubelement").on("costsubelementname", "costsubelementname").select(new String[]{"srcid", "costaccount", "costaccountnum", "costsubelement", "costsubelementname", "costcolumn", "costfields", "srcbillno", "amtprecision", "srcmatnum", "srcmaterialcost", "srcfee", "srcprocesscost", "srcmanufacturecost", "srcresource", "srcactualcost", "srcsub_actualcost"}, new String[]{"destbillno", "destmatnum", "destmaterialcost", "destfee", "destprocesscost", "destmanufacturecost", "destresource", "destactualcost", "destsub_actualcost", "destperiod", "destcostaccount"}).finish().where("(srcmaterialcost<>destmaterialcost and srcmaterialcost+destmaterialcost<>0) or (srcfee<>destfee and srcfee+destfee<>0) or (srcprocesscost<>destprocesscost and srcprocesscost+destprocesscost<>0) or (srcmanufacturecost<>destmanufacturecost and srcmanufacturecost+destmanufacturecost<>0) or (srcresource<>destresource and srcresource+destresource<>0) or (srcactualcost<>destactualcost and srcactualcost+destactualcost<>0)or (srcsub_actualcost<>destsub_actualcost and srcsub_actualcost+destsub_actualcost<>0)");
        ArrayList<ExceptionObj> result = new ArrayList<ExceptionObj>(16);
        String msg = ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u201c%7$s\u201d\uff0c\u6e90\u5355\u201c%1$s\u201d\u6e90\u7269\u6599\u201c%2$s\u201d\u6e90\u5355\u6210\u672c\u201c%3$s\u201d\u4e0e\u76ee\u6807\u5355\u201c%4$s\u201d\u76ee\u6807\u7269\u6599\u201c%5$s\u201d\u76ee\u6807\u6210\u672c\u201c%6$s\u201d\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u51fa\u5e93\u6838\u7b97\u62a5\u544a\u3002", (String)"GroupBillCostDataCheck_2", (String)"fi-cal-business", (Object[])new Object[0]);
        String msg2 = ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u201c%9$s\u201d\uff0c\u6e90\u5355\u201c%1$s\u201d\u6e90\u7269\u6599\u201c%2$s\u201d\u6e90\u5355\u201c%3$s\u201d\u5b50\u8981\u7d20\u6210\u672c\u201c%4$s\u201d\u4e0e\u76ee\u6807\u5355\u201c%5$s\u201d\u76ee\u6807\u7269\u6599\u201c%6$s\u201d\u76ee\u6807\u5355\u201c%7$s\u201d\u5b50\u8981\u7d20\u6210\u672c\u201c%8$s\u201d\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u51fa\u5e93\u6838\u7b97\u62a5\u544a\u3002", (String)"GroupBillCostDataCheck_3", (String)"fi-cal-business", (Object[])new Object[0]);
        HashMap<Object, String> srcCostaccountMap = new HashMap<Object, String>(16);
        HashMap<Object, String> srcBillnoMap = new HashMap<Object, String>(16);
        HashMap<Object, String> srcMaterialMap = new HashMap<Object, String>(16);
        HashMap<Object, Set> srcElementMap = new HashMap<Object, Set>(16);
        HashMap<Object, BigDecimal> srcCostMap = new HashMap<Object, BigDecimal>(16);
        HashMap<Object, String> destBillnoMap = new HashMap<Object, String>(16);
        HashMap<Object, String> destMaterialMap = new HashMap<Object, String>(16);
        HashMap<Object, Set> destElementMap = new HashMap<Object, Set>(16);
        HashMap<Object, BigDecimal> destCostMap = new HashMap<Object, BigDecimal>(16);
        HashMap<Object, Integer> amtprecisionMap = new HashMap<Object, Integer>(16);
        HashMap<Long, Long> costAcctIdCurPeriodIdMap = new HashMap<Long, Long>(16);
        for (Row row : resDS) {
            Long destCostAccountId = row.getLong("destcostaccount");
            Long destPeriodId = row.getLong("destperiod");
            long curPeriodId = this.getCurPeriodIdByCache(costAcctIdCurPeriodIdMap, destCostAccountId);
            if (curPeriodId != 0L && destPeriodId > curPeriodId) continue;
            Long costAccountId = row.getLong("costaccount");
            String costaccountnum = row.getString("costaccountnum");
            String costFields = row.getString("costfields").replace(" +", "");
            String costcolumns = row.getString("costcolumn");
            if (this.enableCalByEleCAIds.contains(costAccountId)) {
                BigDecimal destsub_actualcost;
                List<String> costSubElements = Arrays.asList(costFields.split(","));
                Long costsubelement = row.getLong("costsubelement");
                String string = row.getString("costsubelementname");
                BigDecimal srcsub_actualcost = row.getBigDecimal("srcsub_actualcost");
                if (srcsub_actualcost.compareTo(destsub_actualcost = row.getBigDecimal("destsub_actualcost")) == 0 || srcsub_actualcost.add(destsub_actualcost).compareTo(BigDecimal.ZERO) == 0 || !costSubElements.contains(costsubelement.toString())) continue;
                Object id = row.get("srcid");
                srcBillnoMap.put(id, row.getString("srcbillno"));
                srcMaterialMap.put(id, row.getString("srcmatnum"));
                Set srcSet = srcElementMap.computeIfAbsent(id, k -> new HashSet(16));
                srcSet.add(string);
                BigDecimal srcSumCost = (BigDecimal)srcCostMap.get(id);
                if (srcSumCost == null) {
                    srcSumCost = BigDecimal.ZERO;
                }
                srcSumCost = srcSumCost.add(srcsub_actualcost);
                srcCostMap.put(id, srcSumCost);
                destBillnoMap.put(id, row.getString("destbillno"));
                destMaterialMap.put(id, row.getString("destmatnum"));
                Set destSet = destElementMap.computeIfAbsent(id, k -> new HashSet(16));
                destSet.add(string);
                BigDecimal destSumCost = (BigDecimal)destCostMap.get(id);
                if (destSumCost == null) {
                    destSumCost = BigDecimal.ZERO;
                }
                destSumCost = destSumCost.add(destsub_actualcost);
                destCostMap.put(id, destSumCost);
                int amtprecision = row.getInteger("amtprecision");
                amtprecisionMap.put(id, amtprecision);
                srcCostaccountMap.put(id, costaccountnum);
                continue;
            }
            BigDecimal srcSumCost = BigDecimal.ZERO;
            BigDecimal destSumCost = BigDecimal.ZERO;
            for (String costcolumn : costcolumns.split(",")) {
                BigDecimal destCost;
                BigDecimal srcCost;
                if (StringUtils.isEmpty((String)(costcolumn = costcolumn.trim())) || (srcCost = row.getBigDecimal("src" + costcolumn)).compareTo(destCost = row.getBigDecimal("dest" + costcolumn)) == 0 || srcCost.add(destCost).compareTo(BigDecimal.ZERO) == 0) continue;
                srcSumCost = srcSumCost.add(srcCost);
                destSumCost = destSumCost.add(destCost);
            }
            if (srcSumCost.compareTo(destSumCost) == 0) continue;
            int n = row.getInteger("amtprecision");
            ExceptionObj exceptionObj = new ExceptionObj(0L, "cal_costrecord_subentity");
            String errmsg = String.format(msg, row.getString("srcbillno"), row.getString("srcmatnum"), srcSumCost.setScale(n, RoundingMode.HALF_UP).toPlainString(), row.getString("destbillno"), row.getString("destmatnum"), destSumCost.setScale(n, RoundingMode.HALF_UP).toPlainString(), costaccountnum);
            exceptionObj.setDescription(errmsg);
            result.add(exceptionObj);
        }
        for (Map.Entry entry : srcBillnoMap.entrySet()) {
            Object id = entry.getKey();
            String srcbillno = (String)entry.getValue();
            int amtprecision = (Integer)amtprecisionMap.get(id);
            ExceptionObj exceptionObj = new ExceptionObj(0L, "cal_costrecord_subentity");
            String errmsg = String.format(msg2, srcbillno, srcMaterialMap.get(id), String.join((CharSequence)",", (Iterable)srcElementMap.get(id)), ((BigDecimal)srcCostMap.get(id)).setScale(amtprecision, RoundingMode.HALF_UP).toPlainString(), destBillnoMap.get(id), destMaterialMap.get(id), String.join((CharSequence)",", (Iterable)destElementMap.get(id)), ((BigDecimal)destCostMap.get(id)).setScale(amtprecision, RoundingMode.HALF_UP).toPlainString(), srcCostaccountMap.get(id));
            exceptionObj.setDescription(errmsg);
            result.add(exceptionObj);
        }
        return result;
    }

    private long getCurPeriodIdByCache(Map<Long, Long> costAcctIdCurPeriodIdMap, Long destCostAccountId) {
        long curPeriodId = 0L;
        if (destCostAccountId != null) {
            Long cacheCurPeriodId = costAcctIdCurPeriodIdMap.get(destCostAccountId);
            if (cacheCurPeriodId == null) {
                DynamicObject curPeriodDyc = PeriodHelper.getCurrentPeriod((Long)destCostAccountId);
                if (curPeriodDyc != null) {
                    curPeriodId = curPeriodDyc.getLong("id");
                }
                costAcctIdCurPeriodIdMap.put(destCostAccountId, curPeriodId);
            } else {
                curPeriodId = cacheCurPeriodId;
            }
        }
        return curPeriodId;
    }

    private DataSet getCostRecordDS(DataSet copy, DataCheckParam param) {
        QFilter recFilter = this.getRecFilter(param, "cal_costrecord_subentity");
        ArrayList<OrmInput> inputs = new ArrayList<OrmInput>(16);
        ArrayList<OrmInput> adjustInputs = new ArrayList<OrmInput>(16);
        HashSet<Long> recEntryIds = new HashSet<Long>(16);
        Date minBookDate = null;
        Date maxBookDate = null;
        boolean hasNullBookdate = false;
        ArrayList<DataSet> costdiffbillDataSets = new ArrayList<DataSet>(16);
        for (Row row : copy) {
            Date bookDate = row.getDate("bookdate");
            if (bookDate != null) {
                if (minBookDate == null || bookDate.before(minBookDate)) {
                    minBookDate = bookDate;
                }
                if (maxBookDate == null || bookDate.after(maxBookDate)) {
                    maxBookDate = bookDate;
                }
            } else {
                hasNullBookdate = true;
            }
            recEntryIds.add(row.getLong("receid"));
            if (recEntryIds.size() < 100000) continue;
            QFilter filter = new QFilter("entry.id", "in", recEntryIds);
            filter.and("billstatus", "=", (Object)Character.valueOf('C'));
            filter.and(recFilter);
            OrmInput input = new OrmInput(this.getClass().getName(), "cal_costrecord_subentity", COSTRECORD_SELECT_FIELDS, filter.toArray());
            inputs.add(input);
            QFilter adjustFilter = new QFilter("entryentity.invbillentryid", "in", recEntryIds);
            adjustFilter.and("createtype", "=", (Object)CostAdjustBilCreateTypeEnum.CAL_OUT_GROUP.getValue());
            adjustFilter.and("billstatus", "=", (Object)Character.valueOf('C'));
            adjustFilter.and(this.getRecFilter(param, "cal_costadjust_subentity"));
            OrmInput adjustInput = new OrmInput(this.getClass().getName(), "cal_costadjust_subentity", ADJUST_SELECT_FIELDS, adjustFilter.toArray());
            adjustInputs.add(adjustInput);
            QFilter stddiffFilter = new QFilter("entryentity.invbillentryid", "in", recEntryIds);
            stddiffFilter.and("createtype", "=", (Object)"WW-A5");
            stddiffFilter.and("billstatus", "=", (Object)Character.valueOf('C'));
            stddiffFilter.and(this.getRecFilter(param, "cal_stdcostdiffbill"));
            DataSet costdiffbillDataSet = DiffJsonEntryServiceHelper.queryJsonSubEntryDataSet((String)this.getClass().getName(), (String)"cal_stdcostdiffbill", (String)STDDIFF_SELECT_FIELDS, (String)"entryentity.subentryentity", (QFilter[])stddiffFilter.toArray(), null);
            DataSet cadsubelementdataset = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cad_subelement", (String)"id,number,name", null, null);
            costdiffbillDataSet = costdiffbillDataSet.leftJoin(cadsubelementdataset).on("costsubelement", "id").select(costdiffbillDataSet.getRowMeta().getFieldNames(), new String[]{"name as costsubelementname"}).finish();
            costdiffbillDataSet = costdiffbillDataSet.select(ADJUSTSTDDIFF_COMMON_SELECT_FIELDS);
            costdiffbillDataSets.add(costdiffbillDataSet);
            recEntryIds = new HashSet(100000);
        }
        QFilter filter = new QFilter("entry.id", "in", recEntryIds);
        filter.and("billstatus", "=", (Object)Character.valueOf('C'));
        filter.and(recFilter);
        OrmInput input = new OrmInput(this.getClass().getName(), "cal_costrecord_subentity", COSTRECORD_SELECT_FIELDS, filter.toArray());
        inputs.add(input);
        QFilter adjustFilter = new QFilter("entryentity.invbillentryid", "in", recEntryIds);
        adjustFilter.and("createtype", "=", (Object)CostAdjustBilCreateTypeEnum.CAL_OUT_GROUP.getValue());
        adjustFilter.and("billstatus", "=", (Object)Character.valueOf('C'));
        adjustFilter.and(this.getRecFilter(param, "cal_costadjust_subentity"));
        OrmInput adjustInput = new OrmInput(this.getClass().getName(), "cal_costadjust_subentity", ADJUST_SELECT_FIELDS, adjustFilter.toArray());
        adjustInputs.add(adjustInput);
        QFilter stddiffFilter = new QFilter("entryentity.invbillentryid", "in", recEntryIds);
        stddiffFilter.and("createtype", "=", (Object)"WW-A5");
        stddiffFilter.and("billstatus", "=", (Object)Character.valueOf('C'));
        stddiffFilter.and(this.getRecFilter(param, "cal_stdcostdiffbill"));
        DataSet costdiffbillDataSet = DiffJsonEntryServiceHelper.queryJsonSubEntryDataSet((String)this.getClass().getName(), (String)"cal_stdcostdiffbill", (String)STDDIFF_SELECT_FIELDS, (String)"entryentity.subentryentity", (QFilter[])stddiffFilter.toArray(), null);
        DataSet cadsubelementdataset = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cad_subelement", (String)"id,number,name", null, null);
        costdiffbillDataSet = costdiffbillDataSet.leftJoin(cadsubelementdataset).on("costsubelement", "id").select(costdiffbillDataSet.getRowMeta().getFieldNames(), new String[]{"name as costsubelementname"}).finish();
        costdiffbillDataSet = costdiffbillDataSet.select(ADJUSTSTDDIFF_COMMON_SELECT_FIELDS);
        costdiffbillDataSets.add(costdiffbillDataSet);
        if (!hasNullBookdate && minBookDate != null) {
            recFilter.and("bookdate", ">=", (Object)minBookDate);
        }
        if (maxBookDate != null) {
            recFilter.and("bookdate", "<=", (Object)maxBookDate);
        }
        DataSet ds = Algo.create((String)this.getClass().getName()).createDataSet((Input[])inputs.toArray(new OrmInput[inputs.size()]));
        if (!adjustInputs.isEmpty()) {
            DataSet costadjustDataSet = Algo.create((String)this.getClass().getName()).createDataSet((Input[])adjustInputs.toArray(new OrmInput[adjustInputs.size()]));
            costadjustDataSet = costadjustDataSet.select(ADJUSTSTDDIFF_COMMON_SELECT_FIELDS);
            ds = ds.union(costadjustDataSet);
        }
        if (!costdiffbillDataSets.isEmpty()) {
            DataSet[] costdiffbillDatas = new DataSet[costdiffbillDataSets.size()];
            for (int i = 0; i < costdiffbillDataSets.size(); ++i) {
                costdiffbillDatas[i] = (DataSet)costdiffbillDataSets.get(i);
            }
            ds = ds.union(costdiffbillDatas);
        }
        return ds;
    }

    private QFilter getRecFilter(DataCheckParam param, String entity) {
        QFilter recFilter = QFilter.of((String)"1=1", (Object[])new Object[0]);
        Set<Long> costAccountIds = param.getCostAccount();
        Set<Long> calorgIds = param.getCalorg();
        Set<Long> storageorgunitIds = param.getStorageOrgUnit();
        Set<Long> invStatusIds = param.getInvstatus();
        Set<Long> invTypeIds = param.getInvtype();
        Set<Long> locationIds = param.getLocation();
        Set<Long> warehouseIds = param.getWarehouse();
        Set<Long> materailIds = param.getMaterial();
        Set<Long> mversionIds = param.getMversion();
        Set<Long> projectIds = param.getProject();
        if (costAccountIds != null && !costAccountIds.isEmpty()) {
            recFilter.and("costaccount", "in", costAccountIds);
        }
        if (calorgIds != null && !calorgIds.isEmpty()) {
            recFilter.and("calorg", "in", calorgIds);
        }
        if (storageorgunitIds != null && !storageorgunitIds.isEmpty()) {
            if ("cal_costadjust_subentity".equals(entity) || "cal_stdcostdiffbill".equals(entity)) {
                recFilter.and("entryentity.storageorgunit", "in", storageorgunitIds);
            } else {
                recFilter.and("storageorgunit", "in", storageorgunitIds);
            }
        }
        if (invStatusIds != null && !invStatusIds.isEmpty()) {
            if ("cal_costadjust_subentity".equals(entity) || "cal_stdcostdiffbill".equals(entity)) {
                recFilter.and("entryentity.invstatus", "in", invStatusIds);
            } else {
                recFilter.and("entry.invstatus", "in", invStatusIds);
            }
        }
        if (invTypeIds != null && !invTypeIds.isEmpty()) {
            if ("cal_costadjust_subentity".equals(entity) || "cal_stdcostdiffbill".equals(entity)) {
                recFilter.and("entryentity.invtype", "in", invTypeIds);
            } else {
                recFilter.and("entry.invtype", "in", invTypeIds);
            }
        }
        if (locationIds != null && !locationIds.isEmpty()) {
            if ("cal_costadjust_subentity".equals(entity) || "cal_stdcostdiffbill".equals(entity)) {
                recFilter.and("entryentity.location", "in", locationIds);
            } else {
                recFilter.and("entry.location", "in", locationIds);
            }
        }
        if (warehouseIds != null && !warehouseIds.isEmpty()) {
            if ("cal_costadjust_subentity".equals(entity) || "cal_stdcostdiffbill".equals(entity)) {
                recFilter.and("entryentity.warehouse", "in", warehouseIds);
            } else {
                recFilter.and("entry.warehouse", "in", warehouseIds);
            }
        }
        if (materailIds != null && !materailIds.isEmpty()) {
            if ("cal_costadjust_subentity".equals(entity) || "cal_stdcostdiffbill".equals(entity)) {
                recFilter.and("entryentity.material", "in", materailIds);
            } else {
                recFilter.and("entry.material", "in", materailIds);
            }
        }
        if (mversionIds != null && !mversionIds.isEmpty()) {
            if ("cal_costadjust_subentity".equals(entity) || "cal_stdcostdiffbill".equals(entity)) {
                recFilter.and("entryentity.mversion", "in", mversionIds);
            } else {
                recFilter.and("entry.mversion", "in", mversionIds);
            }
        }
        if (projectIds != null && !projectIds.isEmpty()) {
            if ("cal_costadjust_subentity".equals(entity) || "cal_stdcostdiffbill".equals(entity)) {
                recFilter.and("entryentity.project", "in", projectIds);
            } else {
                recFilter.and("entry.project", "in", projectIds);
            }
        }
        return recFilter;
    }

    private QFilter[] getACFilter(DataCheckParam param) {
        QFilter filter = new QFilter("groupsettingtype", "=", (Object)"cal_billgroupsetting");
        filter.and("iscompleted", "=", (Object)true);
        Set<Long> costAccounts = param.getCostAccount();
        Date startDate = param.getStartDate();
        Date endDate = param.getEndDate();
        Set<Long> calOrgs = param.getCalorg();
        QFilter periodFilter = null;
        if (calOrgs != null && !calOrgs.isEmpty()) {
            periodFilter = new QFilter("org", "in", calOrgs);
        }
        if (costAccounts != null && !costAccounts.isEmpty()) {
            filter.and("entryentity.costaccount", "in", costAccounts);
            if (periodFilter == null) {
                periodFilter = new QFilter("entry.costaccount", "in", costAccounts);
            } else {
                periodFilter.and("entry.costaccount", "in", costAccounts);
            }
        }
        if (startDate != null && endDate != null) {
            HashSet<Long> periods = new HashSet<Long>(16);
            QFilter dateFilter = new QFilter("begindate", "<=", (Object)endDate);
            dateFilter.and("enddate", ">=", (Object)startDate);
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bd_period", (String)"id", (QFilter[])dateFilter.toArray(), null);){
                for (Row row : dataSet) {
                    periods.add(row.getLong("id"));
                }
            }
            filter.and("entryentity.period", "in", periods);
        } else if (periodFilter != null) {
            periodFilter.and("entry.isenabled", "=", (Object)true);
            DynamicObjectCollection infos = QueryServiceHelper.query((String)"cal_sysctrlentity", (String)"entry.currentperiod", (QFilter[])periodFilter.toArray());
            HashSet<Long> periods = new HashSet<Long>(16);
            for (DynamicObject info : infos) {
                periods.add(info.getLong("entry.currentperiod"));
            }
            if (!periods.isEmpty()) {
                filter.and("entryentity.period", "in", periods);
            }
        }
        Set<Long> materialIds = param.getMaterial();
        if (materialIds != null && !materialIds.isEmpty()) {
            filter.and("entryentity.material", "in", materialIds);
        }
        return filter.toArray();
    }
}

