/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.datacheck.item;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.fi.cal.business.datacheck.DataCheckParam;
import kd.fi.cal.business.datacheck.ExceptionObj;
import kd.fi.cal.business.datacheck.helper.InvBillCloseAccountCheckHelper;
import kd.fi.cal.business.datacheck.item.DataEntityDataCheck;

public class InvBillOsPurinBillCheck
extends DataEntityDataCheck {
    private Map<Long, String> orgNumMap = new HashMap<Long, String>(4);

    @Override
    protected String getDataEntityType() {
        return "cal_costrecord_subentity";
    }

    @Override
    protected Set<String> getSelectedFields() {
        return null;
    }

    @Override
    public List<ExceptionObj> collectExceptionObj(DataCheckParam param) {
        Date startDate = param.getStartDate();
        Date endDate = param.getEndDate();
        Set<Long> ownerIds = param.getCalorg();
        if (ownerIds == null) {
            ownerIds = new HashSet<Long>(16);
        }
        Map<String, Map<Long, Date>> startEndDateMap = new InvBillCloseAccountCheckHelper().getBeginEndDateMap(param, ownerIds);
        Map<Long, Date> beginDateMap = startEndDateMap.get("startdate");
        Map<Long, Date> endDateMap = startEndDateMap.get("enddate");
        String errMsg = ResManager.loadKDString((String)"\u5e93\u5b58\u7ec4\u7ec7\uff1a%1$s\uff1b\u59d4\u5916\u91c7\u8d2d\u5165\u5e93\u5355\u53f7\uff1a%2$s", (String)"InvBillOsPurinBillCheck_0", (String)"fi-cal-business", (Object[])new Object[0]);
        ArrayList<ExceptionObj> exceptiodObjList = new ArrayList<ExceptionObj>(16);
        for (Long ownerId : ownerIds) {
            Map results;
            if (startDate == null && endDate == null) {
                startDate = beginDateMap.get(ownerId);
                endDate = endDateMap.get(ownerId);
            }
            if (startDate == null && endDate == null || (results = (Map)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"im", (String)"InvBillStatusService", (String)"chechOsPurinBill", (Object[])new Object[]{startDate, endDate, Collections.singletonList(ownerId), Integer.MAX_VALUE})) == null || results.size() <= 0) continue;
            for (Map.Entry longMapEntry : results.entrySet()) {
                Long osPurinbillid = (Long)longMapEntry.getKey();
                Map map = (Map)longMapEntry.getValue();
                String billno = (String)map.get("billno");
                Long orgId = Long.valueOf(map.get("org").toString());
                ExceptionObj exceptionObj = new ExceptionObj(0L, "im_ospurinbill");
                exceptionObj.setDescription(String.format(errMsg, this.getORgNum(orgId), billno));
                exceptionObj.setId(osPurinbillid);
                exceptiodObjList.add(exceptionObj);
            }
        }
        return exceptiodObjList;
    }

    private String getORgNum(Long orgId) {
        String orgNum = this.orgNumMap.get(orgId);
        if (orgNum == null) {
            DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((Object)orgId, (String)"bos_org");
            orgNum = org != null ? org.getString("number") : " ";
            this.orgNumMap.put(orgId, orgNum);
        }
        return orgNum;
    }

    @Override
    public List<ExceptionObj> collectExceptionObj(DataSet dataSet, DataCheckParam param) {
        return null;
    }
}

