/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.datacheck.item;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.fi.cal.business.datacheck.DataCheckParam;
import kd.fi.cal.business.datacheck.ExceptionObj;
import kd.fi.cal.business.datacheck.helper.InvBillCloseAccountCheckHelper;
import kd.fi.cal.business.datacheck.item.DataEntityDataCheck;

public class InvBillSettleCheck
extends DataEntityDataCheck {
    @Override
    protected String getDataEntityType() {
        return "cal_costrecord_subentity";
    }

    @Override
    protected Set<String> getSelectedFields() {
        return null;
    }

    @Override
    public List<ExceptionObj> collectExceptionObj(DataCheckParam param) {
        Date startDate = param.getStartDate();
        Date endDate = param.getEndDate();
        Set<Long> ownerIds = param.getCalorg();
        if (ownerIds == null) {
            ownerIds = new HashSet<Long>(16);
        }
        Map<String, Map<Long, Date>> startEndDateMap = new InvBillCloseAccountCheckHelper().getBeginEndDateMap(param, ownerIds);
        Map<Long, Date> beginDateMap = startEndDateMap.get("startdate");
        Map<Long, Date> endDateMap = startEndDateMap.get("enddate");
        ArrayList<ExceptionObj> exceptiodObjList = new ArrayList<ExceptionObj>(16);
        for (Long ownerId : ownerIds) {
            if (startDate == null && endDate == null) {
                startDate = beginDateMap.get(ownerId);
                endDate = endDateMap.get(ownerId);
            }
            if (startDate == null && endDate == null) continue;
            HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
            paramMap.put("beginDate", startDate);
            paramMap.put("endDate", endDate);
            paramMap.put("ownerId", ownerId);
            paramMap.put("settleStatus", "A");
            Map noSettlemap = (Map)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"im", (String)"InvBillStatusService", (String)"bizBillSettleCheck", (Object[])new Object[]{paramMap});
            if (noSettlemap.size() > 0) {
                String errorString = ResManager.loadKDString((String)"\u5b58\u5728\u672a\u7ed3\u7b97\u7684\u5355\u636e\uff1a", (String)"InvBillSettleCheck_0", (String)"fi-cal-business", (Object[])new Object[0]);
                new InvBillCloseAccountCheckHelper().addExpObjByInvInterfaceResult(noSettlemap, exceptiodObjList, errorString);
            }
            paramMap.put("settleStatus", "B");
            Map failSettlemap = (Map)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"im", (String)"InvBillStatusService", (String)"bizBillSettleCheck", (Object[])new Object[]{paramMap});
            if (failSettlemap.size() <= 0) continue;
            String errorString = ResManager.loadKDString((String)"\u5b58\u5728\u7ed3\u7b97\u5931\u8d25\u7684\u5355\u636e\uff1a", (String)"InvBillSettleCheck_1", (String)"fi-cal-business", (Object[])new Object[0]);
            new InvBillCloseAccountCheckHelper().addExpObjByInvInterfaceResult(failSettlemap, exceptiodObjList, errorString);
        }
        return exceptiodObjList;
    }

    @Override
    public List<ExceptionObj> collectExceptionObj(DataSet dataSet, DataCheckParam param) {
        return null;
    }
}

