/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.datacheck.item;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.fi.cal.business.datacheck.DataCheckParam;
import kd.fi.cal.business.datacheck.ExceptionObj;
import kd.fi.cal.business.datacheck.helper.InvBillCloseAccountCheckHelper;
import kd.fi.cal.business.datacheck.item.DataEntityDataCheck;
import org.apache.commons.lang.time.DateFormatUtils;

public class InvBillSubmitStatuCheck
extends DataEntityDataCheck {
    @Override
    protected String getDataEntityType() {
        return "cal_costrecord_subentity";
    }

    @Override
    protected Set<String> getSelectedFields() {
        return null;
    }

    @Override
    public List<ExceptionObj> collectExceptionObj(DataCheckParam param) {
        Date startDate = param.getStartDate();
        Date endDate = param.getEndDate();
        Set<Long> ownerIds = param.getCalorg();
        if (ownerIds == null) {
            ownerIds = new HashSet<Long>(16);
        }
        Map<String, Map<Long, Date>> startEndDateMap = new InvBillCloseAccountCheckHelper().getBeginEndDateMap(param, ownerIds);
        Map<Long, Date> beginDateMap = startEndDateMap.get("startdate");
        Map<Long, Date> endDateMap = startEndDateMap.get("enddate");
        ArrayList<ExceptionObj> exceptiodObjList = new ArrayList<ExceptionObj>(16);
        for (Long ownerId : ownerIds) {
            if (startDate == null && endDate == null) {
                startDate = beginDateMap.get(ownerId);
                endDate = endDateMap.get(ownerId);
            }
            if (startDate == null && endDate == null) continue;
            HashMap<String, Object> paramMap = new HashMap<String, Object>(ownerIds.size());
            paramMap.put("ownerId", ownerId);
            paramMap.put("beginDate", startDate);
            paramMap.put("endDate", endDate);
            paramMap.put("billStatus", "B");
            paramMap.put("isUpdate", "0");
            Map map = (Map)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"im", (String)"InvBillStatusService", (String)"bizBillStatusCheck", (Object[])new Object[]{paramMap});
            if (map.size() <= 0) continue;
            String errorMsg = null;
            errorMsg = startDate == null ? String.format(ResManager.loadKDString((String)"\u5728%1$s\u53ca\u4e4b\u524d\u5b58\u5728\u672a\u5ba1\u6838\u7684\u5355\u636e\uff1a", (String)"CloseAccountFacade_8", (String)"fi-cal-business", (Object[])new Object[0]), DateFormatUtils.format((Date)endDate, (String)"yyyy-MM-dd")) : String.format(ResManager.loadKDString((String)"\u4ece%1$s\u81f3%2$s\u5b58\u5728\u672a\u5ba1\u6838\u7684\u5355\u636e\uff1a", (String)"CloseAccountFacade_10", (String)"fi-cal-business", (Object[])new Object[0]), DateFormatUtils.format((Date)startDate, (String)"yyyy-MM-dd"), DateFormatUtils.format((Date)endDate, (String)"yyyy-MM-dd"));
            new InvBillCloseAccountCheckHelper().addExpObjByInvInterfaceResult(map, exceptiodObjList, errorMsg);
        }
        return exceptiodObjList;
    }

    @Override
    public List<ExceptionObj> collectExceptionObj(DataSet dataSet, DataCheckParam param) {
        return null;
    }
}

