/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.datacheck.item;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cal.business.datacheck.DataCheckParam;
import kd.fi.cal.business.datacheck.ExceptionObj;
import kd.fi.cal.business.datacheck.item.IDataCheck;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.helper.AccountingSysHelper;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.common.util.CommonUtils;
import kd.fi.cal.common.util.DateUtils;

public class MissingCostRecordDataCheck
implements IDataCheck {
    private static Log log = LogFactory.getLog(MissingCostRecordDataCheck.class);
    private static final int splitBookdateDay = CalDbParamServiceHelper.getInteger((String)CalDbParamConstant.SPILT_BOOKDATE_SIZE);

    @Override
    public List<ExceptionObj> collectExceptionObj(DataCheckParam param) {
        Set<Long> costAccountIds = param.getCostAccount();
        Set<Long> calOrgIds = param.getCalorg();
        Set<Long> invOrgIds = param.getStorageOrgUnit();
        calOrgIds = this.resolveCalOrgIds(costAccountIds, calOrgIds);
        Set<Long> ownIds = this.getOwnerIdsFromCalOrgIds(calOrgIds);
        Map<Long, Map<String, String>> calBillRuleMap = this.getCalBillRule();
        Map<String, Date> dateFilterMap = this.getStartEndDataMap(calOrgIds, costAccountIds, param);
        ArrayList<ExceptionObj> exceptionObjs = new ArrayList<ExceptionObj>(16);
        if (dateFilterMap == null) {
            for (Map<String, String> map : calBillRuleMap.values()) {
                DataSet bizBillDS = this.getBizBillDS(ownIds, invOrgIds, null, map);
                DataSet costRecordDS = this.getCostRecordDS(costAccountIds, calOrgIds, invOrgIds, null, map);
                this.handleExceptyionObj(bizBillDS, costRecordDS, exceptionObjs, map);
            }
        } else {
            List startDateEndDateList = DateUtils.getDateSpitFilters((Date)dateFilterMap.get("mindate"), (Date)dateFilterMap.get("maxdate"), (int)splitBookdateDay);
            for (int i = 0; i < startDateEndDateList.size(); ++i) {
                for (Map<String, String> map : calBillRuleMap.values()) {
                    DataSet bizBillDS = this.getBizBillDS(ownIds, invOrgIds, (Object[])startDateEndDateList.get(i), map);
                    DataSet costRecordDS = this.getCostRecordDS(costAccountIds, calOrgIds, invOrgIds, (Object[])startDateEndDateList.get(i), map);
                    this.handleExceptyionObj(bizBillDS, costRecordDS, exceptionObjs, map);
                }
            }
        }
        return exceptionObjs;
    }

    @Override
    public List<ExceptionObj> collectExceptionObj(List<DataCheckParam> paramList) {
        ArrayList<ExceptionObj> finalExceptionList = new ArrayList<ExceptionObj>(16);
        HashSet<String> descSet = new HashSet<String>(16);
        for (DataCheckParam param : paramList) {
            ArrayList<ExceptionObj> exceptionObjList = new ArrayList<ExceptionObj>(16);
            List<ExceptionObj> exceptionObj = this.collectExceptionObj(param);
            if (exceptionObj != null && !exceptionObj.isEmpty()) {
                exceptionObjList.addAll(exceptionObj);
            }
            for (ExceptionObj obj : exceptionObjList) {
                String desc = obj.getDescription();
                if (descSet.contains(desc)) continue;
                descSet.add(desc);
                finalExceptionList.add(obj);
            }
        }
        return finalExceptionList;
    }

    private Set<Long> getOwnerIdsFromCalOrgIds(Set<Long> calOrgIds) {
        if (calOrgIds == null || calOrgIds.isEmpty()) {
            return null;
        }
        DynamicObjectCollection infos = AccountingSysHelper.getAccountingSysColls(Arrays.asList(calOrgIds.toArray(new Long[0])), (String)"bizorgentry.bizorg,number,bizorgentry.bizacctorg.number,bizorgentry.bizorg.number");
        HashSet<Long> ownerIds = new HashSet<Long>(16);
        for (DynamicObject info : infos) {
            ownerIds.add(info.getLong("bizorgentry.bizorg"));
        }
        return ownerIds;
    }

    private Set<Long> resolveCalOrgIds(Set<Long> costAccountIds, Set<Long> calOrgIds) {
        if (costAccountIds == null || costAccountIds.isEmpty()) {
            return calOrgIds;
        }
        DynamicObjectCollection cas = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"calorg", (QFilter[])new QFilter("id", "in", costAccountIds).toArray());
        HashSet<Long> caCalorgIds = new HashSet<Long>(16);
        for (DynamicObject ca : cas) {
            caCalorgIds.add(ca.getLong("calorg"));
        }
        if (calOrgIds != null && !calOrgIds.isEmpty()) {
            caCalorgIds.retainAll(calOrgIds);
        }
        return caCalorgIds;
    }

    private void handleExceptyionObj(DataSet bizBillDS, DataSet costRecordDS, List<ExceptionObj> exceptionObjs, Map<String, String> map) {
        String bizEntityObject = map.get("sourcebill");
        DataSet resDS = bizBillDS.join(costRecordDS, JoinType.LEFT).on("id", "bizbillid").on("billstatus", "billstatus").select(bizBillDS.getRowMeta().getFieldNames(), new String[]{"bizbillid"}).finish().where("bizbillid is null").groupBy(new String[]{"orgnumber", "billno", "id"}).finish();
        for (Row row : resDS) {
            String orgnumber = row.getString("orgnumber");
            String billno = row.getString("billno");
            Long id = row.getLong("id");
            ExceptionObj obj = new ExceptionObj(id, bizEntityObject);
            obj.setDescription(orgnumber + "\uff1a" + billno);
            exceptionObjs.add(obj);
        }
    }

    private DataSet getCostRecordDS(Set<Long> costAccountIds, Set<Long> calOrgIds, Set<Long> invOrgIds, Object[] bookDateArray, Map<String, String> map) {
        String calbill = map.get("calbill");
        String bizEntityObject = map.get("sourcebill");
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(16);
        if ("cal_incalbill".equals(calbill)) {
            qFilters.add(new QFilter("calbilltype", "=", (Object)"IN"));
        } else {
            qFilters.add(new QFilter("calbilltype", "=", (Object)"OUT"));
        }
        if (costAccountIds != null && !costAccountIds.isEmpty()) {
            qFilters.add(new QFilter("costaccount", "in", costAccountIds));
        }
        if (calOrgIds != null && !calOrgIds.isEmpty()) {
            qFilters.add(new QFilter("calorg", "in", calOrgIds));
        }
        if (invOrgIds != null && !invOrgIds.isEmpty()) {
            qFilters.add(new QFilter("storageorgunit", "in", invOrgIds));
        }
        if (bookDateArray != null) {
            qFilters.add(new QFilter("bookdate", ">=", bookDateArray[0]));
            qFilters.add(new QFilter("bookdate", "<=", bookDateArray[1]));
        }
        qFilters.add(new QFilter("billtype.billformid", "=", (Object)bizEntityObject));
        qFilters.add(new QFilter("issplitcreate", "=", (Object)Boolean.FALSE));
        DataSet costRecordDS = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord", (String)"id,bizbillid,billstatus", (QFilter[])qFilters.toArray(new QFilter[0]), null).groupBy(new String[]{"id", "bizbillid", "billstatus"}).finish();
        return costRecordDS;
    }

    private DataSet getBizBillDS(Set<Long> ownIds, Set<Long> invOrgIds, Object[] bookDateArray, Map<String, String> map) {
        String bizEntityObject = map.get("sourcebill");
        MainEntityType metadatatype = MetadataServiceHelper.getDataEntityType((String)bizEntityObject);
        String filter_tag = map.get("filter_tag");
        String ownerKey = this.getRealField(map.get("owner"), metadatatype);
        String orgKey = map.get("org");
        if (StringUtils.isNotEmpty((String)orgKey)) {
            orgKey = CommonUtils.getFieldPath((String)map.get("sourcebill"), (String)orgKey);
        }
        String bookdateKey = map.get("bookdate");
        String billnoKey = map.get("billno");
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(16);
        if (ownIds != null && !ownIds.isEmpty()) {
            qFilters.add(new QFilter(ownerKey, "in", ownIds));
        } else {
            qFilters.add(QFilter.of((String)"1<>1", (Object[])new Object[0]));
        }
        if (invOrgIds != null && !invOrgIds.isEmpty()) {
            qFilters.add(new QFilter(orgKey, "in", invOrgIds));
        }
        if (bookDateArray != null) {
            qFilters.add(new QFilter(bookdateKey, ">=", bookDateArray[0]));
            qFilters.add(new QFilter(bookdateKey, "<=", bookDateArray[1]));
        }
        if (StringUtils.isNotEmpty((String)filter_tag)) {
            FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filter_tag, FilterCondition.class);
            FilterBuilder filterBuilder = new FilterBuilder(metadatatype, filterCondition);
            filterBuilder.buildFilter();
            List list = filterBuilder.getQFilters();
            qFilters.addAll(list);
        }
        if ("im_mdc_omfeedbill".equals(bizEntityObject) || "im_mdc_omreturnbill".equals(bizEntityObject) || "im_mdc_omoutbill".equals(bizEntityObject) || "im_mdc_omproorder".equals(bizEntityObject) || "im_mdc_omreturnorder".equals(bizEntityObject) || "im_mdc_omfeedorder".equals(bizEntityObject) || "im_mdc_mftmanuinbill".equals(bizEntityObject) || "im_mdc_mftreturnbill".equals(bizEntityObject) || "im_mdc_mftproorder".equals(bizEntityObject) || "im_mdc_mftreturnorder".equals(bizEntityObject) || "im_mdc_mftfeedorder".equals(bizEntityObject) || "im_ospurinbill".equals(bizEntityObject) || "im_osmaterialreqoutbill".equals(bizEntityObject)) {
            qFilters.add(new QFilter("billtype.billformid", "=", (Object)bizEntityObject));
        }
        try {
            DataSet bizBillDS = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)bizEntityObject, (String)("id," + orgKey + ".number as orgnumber," + billnoKey + " as billno,billstatus"), (QFilter[])qFilters.toArray(new QFilter[0]), null).groupBy(new String[]{"id", "orgnumber", "billno", "billstatus"}).finish();
            return bizBillDS;
        }
        catch (Exception e) {
            log.error("-----------\u6570\u636e\u5de1\u68c0\u4e1a\u52a1\u5bf9\u8c61\uff1a" + bizEntityObject + ",\u8fc7\u6ee4\u6761\u4ef6\uff1a" + qFilters, (Throwable)e);
            throw e;
        }
    }

    private String getRealField(String field, MainEntityType metadatatype) {
        IDataEntityProperty property;
        IDataEntityType parentyEntity;
        String entryKey = null;
        for (Map.Entry entryItem : metadatatype.getAllEntities().entrySet()) {
            EntityType entityType = (EntityType)entryItem.getValue();
            if (!(entityType instanceof EntryType) || entityType instanceof LinkEntryType || entityType instanceof SubEntryType) continue;
            entryKey = entityType.getName();
            break;
        }
        if ((parentyEntity = (property = metadatatype.findProperty(field)).getParent()) instanceof SubEntryType) {
            return entryKey + '.' + parentyEntity.getName() + '.' + field;
        }
        if (parentyEntity instanceof EntryType) {
            return entryKey + '.' + field;
        }
        return field;
    }

    private Map<String, Date> getStartEndDataMap(Set<Long> calOrgIds, Set<Long> costAccountIds, DataCheckParam param) {
        HashMap<String, Date> map = new HashMap<String, Date>(4);
        if (param.getStartDate() != null && param.getEndDate() != null) {
            map.put("mindate", param.getStartDate());
            map.put("maxdate", param.getEndDate());
            return map;
        }
        QFilter qFilter = null;
        if (calOrgIds != null && !calOrgIds.isEmpty()) {
            qFilter = new QFilter("org", "in", calOrgIds);
        }
        if (costAccountIds != null && !costAccountIds.isEmpty()) {
            if (qFilter == null) {
                qFilter = new QFilter("entry.costaccount", "in", costAccountIds);
            } else {
                qFilter.and("entry.costaccount", "in", costAccountIds);
            }
        }
        if (qFilter == null) {
            return null;
        }
        qFilter.and("entry.isenabled", "=", (Object)true);
        DynamicObjectCollection infos = QueryServiceHelper.query((String)"cal_sysctrlentity", (String)"entry.currentperiod.begindate,entry.currentperiod.enddate", (QFilter[])qFilter.toArray());
        Date minDate = null;
        Date maxDate = null;
        for (DynamicObject info : infos) {
            Date begindate = info.getDate("entry.currentperiod.begindate");
            Date enddate = info.getDate("entry.currentperiod.enddate");
            if (minDate == null || begindate.before(minDate)) {
                minDate = begindate;
            }
            if (maxDate != null && !enddate.after(maxDate)) continue;
            maxDate = enddate;
        }
        if (minDate == null || maxDate == null) {
            return null;
        }
        map.put("mindate", minDate);
        map.put("maxdate", maxDate);
        return map;
    }

    private Map<Long, Map<String, String>> getCalBillRule() {
        HashMap<Long, Map<String, String>> calBillRuleMap = new HashMap<Long, Map<String, String>>(16);
        QFilter ruleFilter = new QFilter("enable", "=", (Object)Character.valueOf('1'));
        ruleFilter.and("fieldmap.calfield", "in", (Object)new String[]{"owner", "org", "bookdate", "billno"});
        ruleFilter.and("calbill", "!=", (Object)"cal_initbill");
        try (DataSet calBillRules = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_calbillrule", (String)"id,calbill,sourcebill,filter_tag,fieldmap.calfield,fieldmap.sourcefield", (QFilter[])ruleFilter.toArray(), (String)"id");){
            for (Row row : calBillRules) {
                Long id = row.getLong("id");
                String calBill = row.getString("calbill");
                String sourcebill = row.getString("sourcebill");
                String filter_tag = row.getString("filter_tag");
                String calField = row.getString("fieldmap.calfield");
                String sourceField = row.getString("fieldmap.sourcefield");
                if (StringUtils.isEmpty((String)sourceField)) continue;
                Map map = calBillRuleMap.computeIfAbsent(id, k -> new HashMap());
                map.put("calbill", calBill);
                map.put("sourcebill", sourcebill);
                map.put("filter_tag", filter_tag);
                map.put(calField, sourceField);
            }
        }
        return calBillRuleMap;
    }
}

