/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.datacheck.item;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.orm.query.QFilter;
import kd.fi.cal.business.datacheck.DataCheckParam;
import kd.fi.cal.business.datacheck.ExceptionObj;
import kd.fi.cal.business.datacheck.item.BalanceDataCheck;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.common.util.ArrayUtils;

public class PeriodBeginLastEndCheckPlugin
extends BalanceDataCheck {
    @Override
    public List<ExceptionObj> collectExceptionObj(DataSet dataSet, DataCheckParam param) {
        JoinDataSet verifyDataSet = this.getJoinDataSet(dataSet);
        for (String calDimension : this.parser.getDimFields()) {
            verifyDataSet = verifyDataSet.on(calDimension, calDimension);
        }
        String[] nowFields = dataSet.getRowMeta().getFieldNames();
        String[] prevFields = this.endPeriodSelectedFields().split(",");
        ArrayList<String> nowList = new ArrayList<String>(50);
        List<String> prevList = Arrays.asList(prevFields);
        for (String nowfield : nowFields) {
            if (prevList.contains(nowfield)) continue;
            nowList.add(nowfield);
        }
        dataSet = verifyDataSet.select(this.endPeriodSelectedFields().split(","), nowList.toArray(new String[0])).finish().filter("periodendqty <> periodbeginqty or periodendstandardcost <> beginstandardcost or periodendactualcost <> periodbeginactualcost");
        ArrayList<ExceptionObj> exceptionObjs = new ArrayList<ExceptionObj>();
        for (Row row : dataSet) {
            ExceptionObj exceptionObj = new ExceptionObj(row.getLong("id"), this.getDataEntityType(), this.getExceptionDesc(row, null, false).toString());
            exceptionObjs.add(exceptionObj);
        }
        return exceptionObjs;
    }

    @Override
    protected QFilter analyseCostAccountFilter(DataCheckParam param) {
        IDataEntityProperty accountProperty = this.entityType.findProperty("costaccount");
        Set<Long> costaccount = param.getCostAccount();
        if (accountProperty == null) {
            return null;
        }
        if (costaccount == null || costaccount.isEmpty()) {
            costaccount = this.getAllValidCostAccount();
        }
        ArrayList<QFilter> fList = new ArrayList<QFilter>(costaccount.size());
        IDataEntityProperty periodProperty = this.entityType.findProperty("period");
        boolean hasPeriod = periodProperty != null;
        String costAccountName = this.analyseFieldName(accountProperty);
        for (Long costAccountId : costaccount) {
            QFilter filter = new QFilter(costAccountName, "=", (Object)costAccountId);
            if (hasPeriod) {
                DynamicObject period = this.getCurrentPeriod(costAccountId);
                if (period == null) continue;
                QFilter periodFilter = new QFilter("period", "=", (Object)(period.getInt("periodyear") * 100 + period.getInt("periodnumber")));
                periodFilter.or("endperiod", "=", (Object)(period.getInt("periodyear") * 100 + period.getInt("periodnumber")));
                filter = filter.and(periodFilter);
            }
            fList.add(filter);
        }
        if (fList.isEmpty()) {
            return new QFilter("id", "=", (Object)0);
        }
        QFilter firstFilter = (QFilter)fList.get(0);
        for (int i = 1; i < fList.size(); ++i) {
            firstFilter = firstFilter.or((QFilter)fList.get(i));
        }
        return firstFilter;
    }

    private String endPeriodSelectedFields() {
        return "periodendqty,periodendstandardcost,periodendactualcost";
    }

    private String[] beginPeriodSelectedFields() {
        Set<String> dimWithNameFields = this.parser.getBalanceFields(true, true);
        dimWithNameFields.add("periodbeginqty");
        dimWithNameFields.add("beginstandardcost");
        dimWithNameFields.add("periodbeginactualcost");
        return dimWithNameFields.toArray(new String[0]);
    }

    @Override
    protected void addSelectedFields(Set<String> fields) {
        if (this.isNewBalance) {
            String fieldStr = "INT(endperiod) as endperiod,periodendqty,periodbeginqty,periodendstandardcost,beginstandardcost,periodendactualcost,periodbeginactualcost";
            fields.addAll(Arrays.asList(fieldStr.split(",")));
        } else {
            String fieldStr = "endperiod,periodendqty,periodbeginqty,periodendstandardcost,beginstandardcost,periodendactualcost,periodbeginactualcost";
            fields.addAll(Arrays.asList(fieldStr.split(",")));
        }
    }

    private JoinDataSet getJoinDataSet(DataSet dataSet) {
        DataSet beforePeriodEndDs = dataSet;
        DataSet curPeriodDs = dataSet;
        boolean balCompress = CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.CAL_BAL_DATA_COMPRESSION);
        if (balCompress) {
            HashSet<String> dimGroups = new HashSet<String>(Arrays.asList(dataSet.getRowMeta().getFieldNames()));
            HashSet<String> qtyCostFields = new HashSet<String>(Arrays.asList("periodendqty", "periodendstandardcost", "periodendactualcost", "periodbeginqty", "beginstandardcost", "periodbeginactualcost"));
            dimGroups.removeAll(qtyCostFields);
            dimGroups.remove("endperiod");
            dimGroups.remove("period");
            dimGroups.remove("id");
            Object[] endGroupFields = dimGroups.toArray(new String[0]);
            endGroupFields = (String[])ArrayUtils.concatAll((Object[])endGroupFields, (Object[][])new String[][]{{"endperiod"}});
            beforePeriodEndDs = dataSet.copy().groupBy((String[])endGroupFields).sum("periodendqty").sum("periodendstandardcost").sum("periodendactualcost").max("id").finish();
            Object[] beginGroupFields = dimGroups.toArray(new String[0]);
            beginGroupFields = (String[])ArrayUtils.concatAll((Object[])beginGroupFields, (Object[][])new String[][]{{"period"}});
            curPeriodDs = dataSet.groupBy((String[])beginGroupFields).sum("periodbeginqty").sum("beginstandardcost").sum("periodbeginactualcost").max("id").finish();
        }
        JoinDataSet verifyDataSet = beforePeriodEndDs.join(curPeriodDs).on("endperiod", "period");
        return verifyDataSet;
    }
}

