/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.datacheck.item;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.orm.query.QFilter;
import kd.fi.cal.business.datacheck.DataCheckParam;
import kd.fi.cal.business.datacheck.ExceptionObj;
import kd.fi.cal.business.datacheck.item.BalanceDataCheck;

public class PeriodEndCheckPlugin
extends BalanceDataCheck {
    @Override
    public List<ExceptionObj> collectExceptionObj(DataSet dataSet, DataCheckParam param) {
        ArrayList<ExceptionObj> exceptionObjs = new ArrayList<ExceptionObj>();
        for (Row row : dataSet) {
            ExceptionObj exceptionObj = new ExceptionObj(row.getLong("id"), this.getDataEntityType(), this.getExceptionDesc(row, null, false).toString());
            exceptionObjs.add(exceptionObj);
        }
        return exceptionObjs;
    }

    @Override
    protected void addSelectedFields(Set<String> fields) {
        String selectedFields = "periodendqty,periodbeginqty,periodinqty,periodissueqty,periodendstandardcost,beginstandardcost,periodinstandardcost,periodissuestandardcost,periodendactualcost,periodbeginactualcost,periodinactualcost,periodissueactualcost";
        fields.addAll(Arrays.asList(selectedFields.split(",")));
    }

    @Override
    protected void addDataCheckFilter(List<QFilter> fList) {
        if (this.isNewBalance) {
            QFilter qFilter = new QFilter("baseqty_bal", "!=", (Object)"(baseqty + baseqty_in - baseqty_out)", true);
            qFilter.or(new QFilter("standardcost_bal", "!=", (Object)"(standardcost + standardcost_in - standardcost_out)", true));
            qFilter.or(new QFilter("actualcost_bal", "!=", (Object)"(actualcost + actualcost_in - actualcost_out)", true));
            fList.add(qFilter);
        } else {
            QFilter qFilter = new QFilter("periodendqty", "!=", (Object)"(periodbeginqty + periodinqty - periodissueqty)", true);
            qFilter.or(new QFilter("periodendstandardcost", "!=", (Object)"(beginstandardcost + periodinstandardcost - periodissuestandardcost)", true));
            qFilter.or(new QFilter("periodendactualcost", "!=", (Object)"(periodbeginactualcost + periodinactualcost - periodissueactualcost)", true));
            fList.add(qFilter);
        }
        super.addDataCheckFilter(fList);
    }
}

