/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.datacheck.item;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.OrmInput;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.business.datacheck.DataCheckParam;
import kd.fi.cal.business.datacheck.ExceptionObj;
import kd.fi.cal.business.datacheck.item.DataEntityDataCheck;
import kd.fi.cal.common.constant.DataCheckConstant;
import kd.fi.cal.common.enums.BosEntityObjEnum;

public class PurInUnwriteOffCheckPlugin
extends DataEntityDataCheck {
    @Override
    protected String getDataEntityType() {
        return "cal_costrecord";
    }

    @Override
    public List<ExceptionObj> collectExceptionObj(DataSet dataSet, DataCheckParam param) {
        DataSet dataSetCopy = dataSet.copy();
        HashSet<Long> bizBillids = new HashSet<Long>();
        for (Row row : dataSetCopy) {
            bizBillids.add(row.getLong("bizbillid"));
        }
        DataSet calInDataSet = this.getPurInBillDS(bizBillids);
        dataSet = dataSet.join(calInDataSet, JoinType.INNER).on("bizbillentryid", "calinbizbillentryid").select(this.getExceptionSelectedFields().split(","), new String[]{"calinmaterialcost"}).finish().where("materialcost <> calinmaterialcost");
        LinkedList<ExceptionObj> exceptionObjs = new LinkedList<ExceptionObj>();
        for (Row row : dataSet) {
            ExceptionObj exceptionObj = new ExceptionObj(row.getLong("entryid"), this.getDataEntityType());
            String msg = String.format(ResManager.loadKDString((String)"\u672a\u6838\u9500\u7684\u91c7\u8d2d\u5165\u5e93\u5355\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u6750\u6599\u6210\u672c\u201c%1$s\u201d\u5165\u5e93\u6838\u7b97\u5355\u6750\u6599\u6210\u672c\u201c%2$s\u201d\u3002", (String)"PurInUnwriteOffCheckPlugin_2", (String)"fi-cal-business", (Object[])new Object[0]), row.getBigDecimal("materialcost").stripTrailingZeros().toPlainString(), row.getBigDecimal("calinmaterialcost").stripTrailingZeros().toPlainString());
            exceptionObj.setDescription(DataCheckConstant.COSTACCOUNT + row.getString("costaccountnumber") + DataCheckConstant.SEPERATOR + DataCheckConstant.BILLNO + row.getString("billno") + DataCheckConstant.SEPERATOR + DataCheckConstant.MATERIAL_NAME + row.getString("materialnum") + DataCheckConstant.SEPERATOR + msg);
            exceptionObjs.add(exceptionObj);
        }
        return exceptionObjs;
    }

    private DataSet getPurInBillDS(Set<Long> bizBillids) {
        QFilter billTypesf = new QFilter("sourcebill.number", "=", (Object)"im_purinbill");
        QFilter mainFieldsf = new QFilter("fieldmap.sourcefield", "in", (Object)new String[]{"materialcost"});
        QFilter enablef = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter calbilltype = new QFilter("calbill", "=", (Object)"cal_incalbill");
        HashMap<Long, String> ruleid2FilterMap = new HashMap<Long, String>(4);
        HashMap<Long, Set> selectMap = new HashMap<Long, Set>(4);
        DataSet billRuleDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_calbillrule", (String)"id,filter_tag,sourcebill.number as srcbillnum,fieldmap.calfield as calfield,fieldmap.sourcefield as sourcefield", (QFilter[])new QFilter[]{billTypesf, mainFieldsf, enablef, calbilltype}, null);
        Object object = null;
        try {
            for (Row row : billRuleDs) {
                Long id = row.getLong("id");
                String calField = row.getString("calfield");
                String sourcefield = row.getString("sourcefield");
                String filter = row.getString("filter_tag");
                String fieldPath = this.getAllFieldPath("im_purinbill", sourcefield);
                Set selects = selectMap.computeIfAbsent(id, k -> new HashSet(16));
                selects.add(fieldPath + " as " + calField);
                ruleid2FilterMap.put(id, filter);
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (billRuleDs != null) {
                if (object != null) {
                    try {
                        billRuleDs.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    billRuleDs.close();
                }
            }
        }
        ArrayList<OrmInput> inputs = new ArrayList<OrmInput>(4);
        for (Map.Entry entry : selectMap.entrySet()) {
            Set selects = (Set)entry.getValue();
            Long ruleid = (Long)entry.getKey();
            String filter = (String)ruleid2FilterMap.get(ruleid);
            QFilter setFilter = QFilter.of((String)"1=1", (Object[])new Object[0]);
            if (StringUtils.isNotEmpty((CharSequence)filter)) {
                FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filter, FilterCondition.class);
                FilterBuilder filterBuilder = new FilterBuilder(EntityMetadataCache.getDataEntityType((String)"im_purinbill"), filterCondition);
                filterBuilder.buildFilter();
                setFilter = filterBuilder.getQFilter();
            }
            QFilter bizFilter = new QFilter("id", "in", bizBillids);
            OrmInput inBill = new OrmInput(this.getClass().getName(), "im_purinbill", "id as bizbillid,billentry.id as bizbillentryid," + String.join((CharSequence)",", selects), new QFilter[]{bizFilter, setFilter});
            inputs.add(inBill);
        }
        if (inputs.isEmpty()) {
            RowMeta rowMeta = ORM.create().createRowMeta("cal_incalbill", "bizbillid,entry.bizbillentryid as calinbizbillentryid,entry.materialcost as calinmaterialcost");
            DataSet dataSet = Algo.create((String)this.getClass().getName()).createDataSet(new ArrayList(16), rowMeta);
            return dataSet;
        }
        DataSet ds = Algo.create((String)this.getClass().getName()).createDataSet((Input[])inputs.toArray(new OrmInput[0]));
        return ds.select("bizbillid,bizbillentryid as calinbizbillentryid,materialcost as calinmaterialcost");
    }

    private String getAllFieldPath(String billEntityNum, String calField) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)billEntityNum);
        Map billAllFields = dataEntityType.getAllFields();
        IDataEntityProperty property = (IDataEntityProperty)billAllFields.get(calField);
        IDataEntityType parentProp = property.getParent();
        return this.getFieldPath(calField, parentProp);
    }

    private String getFieldPath(String field, IDataEntityType parentProp) {
        if (parentProp instanceof EntryType) {
            field = parentProp.getName() + "." + field;
            return this.getFieldPath(field, parentProp.getParent());
        }
        return field;
    }

    @Override
    protected Set<String> getSelectedFields() {
        String selectedFields = "id,billnumber,bizbillid,costaccount.number as costaccountnumber,billno,entry.id as entryid,entry.material as material,entry.material.number as materialnum,entry.material.name as materialname,entry.materialcost as materialcost,entry.bizbillentryid as bizbillentryid";
        return new HashSet<String>(Arrays.asList(selectedFields.split(",")));
    }

    private String getCalInSelectedFields() {
        return "bizbillno,entry.material as calinmaterial,entry.material.number as calinmaterialnum,entry.materialcost as calinmaterialcost,entry.bizbillentryid as calinbizbillentryid";
    }

    private String getExceptionSelectedFields() {
        return "id,billno,costaccountnumber,entryid,material,materialnum,materialcost";
    }

    @Override
    protected void addDataCheckFilter(List<QFilter> fList) {
        QFilter qFilter = new QFilter("bizentityobject", "=", (Object)BosEntityObjEnum.IM_PURINBILL.getValue());
        qFilter.and("issplit", "=", (Object)Character.valueOf('0'));
        qFilter.and("issplitcreate", "=", (Object)Character.valueOf('0'));
        fList.add(qFilter);
        super.addDataCheckFilter(fList);
    }
}

