/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.datacheck.item;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.Row;
import kd.bos.algo.input.OrmInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.extplugin.PluginProxy;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.fi.cal.business.datacheck.DataCheckParam;
import kd.fi.cal.business.datacheck.ExceptionObj;
import kd.fi.cal.business.datacheck.item.DataEntityDataCheck;
import kd.fi.cal.common.helper.AccountingSysHelper;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.common.helper.SynBizBillHelper;
import kd.fi.cal.common.util.DateUtils;
import kd.sdk.fi.cal.extpoint.writeoff.ICalWriteOffFilter;

public class PurNoWriteOffDataCheckPlugin
extends DataEntityDataCheck {
    private Set<Long> costAccountIdSet;
    private Set<Long> orgIds;
    private static final long SERVICE_ATTRIBUTE = 1194029484878120960L;
    private static final int splitBookdateDay = 10;

    @Override
    protected String getDataEntityType() {
        return "ap_verifyrecord";
    }

    @Override
    protected Set<String> getSelectedFields() {
        String selectedFields = "bizbillid";
        return new HashSet<String>(Arrays.asList(selectedFields.split(",")));
    }

    @Override
    public List<ExceptionObj> collectExceptionObj(DataCheckParam param) {
        this.costAccountIdSet = param.getCostAccount();
        Date beginDate = null;
        Date endDate = null;
        beginDate = param.getStartDate() != null ? param.getStartDate() : this.getBeginDate(param);
        if (beginDate == null) {
            return null;
        }
        if (param.getEndDate() == null) {
            Date now = TimeServiceHelper.now();
            endDate = DateUtils.getDayStartTime((Date)now);
        } else {
            endDate = param.getEndDate();
        }
        this.initOrgId(param);
        List startDateEndDateList = DateUtils.getDateSpitFilters((Date)beginDate, (Date)endDate, (int)10);
        ArrayList<ExceptionObj> exceptionObjs = new ArrayList<ExceptionObj>(16);
        for (int i = 0; i < startDateEndDateList.size(); ++i) {
            Date curEndDate;
            Object[] startDateEndDate = (Object[])startDateEndDateList.get(i);
            Date curStartDate = (Date)startDateEndDate[0];
            DataSet auxDataSet = this.getAuxBills(curStartDate, curEndDate = (Date)startDateEndDate[1], param);
            Map<String, Set<Long>> auxbillMap = this.getAuxBillMap(auxDataSet);
            if (auxbillMap.isEmpty()) continue;
            DataSet writeOffInfosData = this.getWriteOffData(auxbillMap);
            HashSet<Long> bizbillIds = new HashSet<Long>(16);
            for (Row row : writeOffInfosData.copy()) {
                bizbillIds.add(row.getLong("billid"));
            }
            if (bizbillIds.isEmpty()) continue;
            HashSet<Long> writeOffIds = new HashSet<Long>(16);
            DataSet writeOffCostRecord = this.getWriteOffCostRecord(bizbillIds);
            if (writeOffCostRecord != null) {
                JoinDataSet joinNoWriteOffData = writeOffInfosData.leftJoin(writeOffCostRecord);
                joinNoWriteOffData.on("id", "entry.writeoffid");
                DataSet noWriteOffData = joinNoWriteOffData.select(new String[]{"id"}, new String[]{"entry.writeoffid"}).finish().filter("entry.writeoffid is null");
                writeOffIds.clear();
                for (Row row : noWriteOffData) {
                    writeOffIds.add(row.getLong("id"));
                }
                if (writeOffIds == null || writeOffIds.isEmpty()) continue;
            }
            DynamicObject[] writeOffInfos = this.getWriteOffInfos(writeOffIds);
            writeOffInfos = SynBizBillHelper.checkBillsSync((DynamicObject[])writeOffInfos);
            exceptionObjs.addAll(this.getExceptionObj(writeOffInfos));
        }
        return exceptionObjs;
    }

    private Date getBeginDate(DataCheckParam param) {
        if (this.costAccountIdSet == null) {
            this.costAccountIdSet = new HashSet<Long>(16);
            QFilter q = new QFilter("entry.isenabled", "=", (Object)"1");
            DynamicObjectCollection sysctrlEntrys = QueryServiceHelper.query((String)"cal_sysctrlentity", (String)"entry.costaccount", (QFilter[])q.toArray());
            for (DynamicObject sysctrlEntry : sysctrlEntrys) {
                this.costAccountIdSet.add(sysctrlEntry.getLong("entry.costaccount"));
            }
        }
        if (this.costAccountIdSet.isEmpty()) {
            return null;
        }
        Date beginDate = null;
        DynamicObjectCollection sysPeriods = PeriodHelper.getSysCtrlEntity((Long[])this.costAccountIdSet.toArray(new Long[0]), (String)"entry.currentperiod.begindate");
        for (DynamicObject sysPeriod : sysPeriods) {
            Date nowBeginDate = sysPeriod.getDate("entry.currentperiod.begindate");
            if (nowBeginDate == null) continue;
            if (beginDate == null) {
                beginDate = nowBeginDate;
                continue;
            }
            if (!beginDate.after(nowBeginDate)) continue;
            beginDate = nowBeginDate;
        }
        return beginDate;
    }

    private DataSet getAuxBills(Date beginDate, Date endDate, DataCheckParam param) {
        Set<Long> matIds;
        QFilter q = new QFilter("bookdate", ">=", (Object)beginDate);
        q.and("bookdate", "<=", (Object)endDate);
        QFilter purInQ = q.copy();
        QFilter apQ = q;
        if (this.orgIds != null && !this.orgIds.isEmpty()) {
            purInQ.and(new QFilter("billentry.owner", "in", this.orgIds));
            apQ.and(new QFilter("org", "in", this.orgIds));
        }
        if ((matIds = param.getMaterial()) != null && !matIds.isEmpty()) {
            purInQ.and(new QFilter("billentry.material", "in", matIds));
            apQ.and(new QFilter("detailentry.material", "in", matIds));
        }
        purInQ.and(new QFilter("billentry.logisticsbill", "=", (Object)false));
        ArrayList<OrmInput> auxBillIOs = new ArrayList<OrmInput>(16);
        OrmInput purInBillIO = new OrmInput(this.getClass().getName(), "im_purinbill", "id,'im_purinbill' as bizobject", purInQ.toArray());
        OrmInput omInBillIO = new OrmInput(this.getClass().getName(), "im_mdc_ominbill", "id,'im_mdc_ominbill' as bizobject", purInQ.toArray());
        OrmInput osPurInBillIO = new OrmInput(this.getClass().getName(), "im_ospurinbill", "id,'im_ospurinbill' as bizobject", purInQ.toArray());
        OrmInput apBillIO = new OrmInput(this.getClass().getName(), "ap_finapbill", "id,'ap_finapbill' as bizobject", apQ.toArray());
        auxBillIOs.add(purInBillIO);
        auxBillIOs.add(omInBillIO);
        auxBillIOs.add(osPurInBillIO);
        auxBillIOs.add(apBillIO);
        Algo algo = Algo.create((String)this.getClass().getName());
        return algo.createDataSet((Input[])auxBillIOs.toArray(new OrmInput[auxBillIOs.size()]));
    }

    private Map<String, Set<Long>> getAuxBillMap(DataSet auxDataSet) {
        HashMap<String, Set<Long>> auxBillIdMap = new HashMap<String, Set<Long>>(16);
        for (Row row : auxDataSet) {
            Long billId = row.getLong("id");
            String bizObject = row.getString("bizobject");
            HashSet<Long> billIdSet = (HashSet<Long>)auxBillIdMap.get(bizObject);
            if (billIdSet == null) {
                billIdSet = new HashSet<Long>(16);
            }
            billIdSet.add(billId);
            auxBillIdMap.put(bizObject, billIdSet);
        }
        return auxBillIdMap;
    }

    private DynamicObject[] getWriteOffInfos(Set<Long> ids) {
        QFilter filter = new QFilter("id", "in", ids);
        String writeOffSelectors = "id,billno,org.number,entry.e_billno,verifyseq,billid,billentryid,billtype";
        DynamicObjectCollection apInfos = QueryServiceHelper.query((String)"ap_verifyrecord", (String)writeOffSelectors, (QFilter[])filter.toArray());
        return (DynamicObject[])apInfos.toArray((Object[])new DynamicObject[0]);
    }

    private DataSet getWriteOffData(Map<String, Set<Long>> auxBillIdMap) {
        QFilter writeoffQ = new QFilter("billtype", "in", (Object)new String[]{"im_purinbill", "im_mdc_ominbill", "im_ospurinbill"});
        writeoffQ.and("verifyrelation", "in", (Object)new String[]{"appurin", "appurreturn", "purself", "apomin", "apominreturn", "ominself", "purwrittenoff", "purreturnwrittenoff"});
        if (this.orgIds != null && !this.orgIds.isEmpty()) {
            writeoffQ.and("org", "in", this.orgIds);
        }
        writeoffQ.and("entry.e_iswrittenoff", "=", (Object)Boolean.FALSE);
        ArrayList<OrmInput> verifyRecordIOs = new ArrayList<OrmInput>(16);
        for (Map.Entry<String, Set<Long>> entry : auxBillIdMap.entrySet()) {
            QFilter q = writeoffQ.copy();
            q.and("entry.e_billtype", "=", (Object)entry.getKey());
            q.and("entry.e_billid", "in", entry.getValue());
            OrmInput verifyRecordIO = new OrmInput(this.getClass().getName(), "ap_verifyrecord", "id,billid", q.toArray());
            verifyRecordIOs.add(verifyRecordIO);
        }
        Algo algo = Algo.create((String)this.getClass().getName());
        return algo.createDataSet((Input[])verifyRecordIOs.toArray(new OrmInput[verifyRecordIOs.size()]));
    }

    private DataSet getWriteOffCostRecord(Set<Long> bizbillIds) {
        HashSet<Long> billIds = new HashSet<Long>(16);
        DataSet totalDataSet = null;
        HashSet<DataSet> costRecordsDataSets = new HashSet<DataSet>(16);
        QFilter extFilter = null;
        PluginProxy pluginProxy = PluginProxy.create(null, ICalWriteOffFilter.class, (String)"FI_CAL_WRITEOFF_QFILTER", null);
        List ext_filters = pluginProxy.callReplace(p -> {
            QFilter q = p.getExtQfilter();
            return q;
        });
        if (ext_filters != null && !ext_filters.isEmpty()) {
            extFilter = (QFilter)ext_filters.get(0);
        }
        for (Long id : bizbillIds) {
            billIds.add(id);
            if (billIds.size() < 50000) continue;
            QFilter costRecordQ = new QFilter("bizbillid", "in", billIds);
            costRecordQ.and("costaccount", "in", this.costAccountIdSet);
            costRecordQ.and("costaccount.accountcosttype", "!=", (Object)Character.valueOf('B'));
            if (extFilter != null) {
                costRecordQ.and(extFilter);
            }
            DataSet writeOffCostRecords = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord_subentity", (String)"entry.writeoffid", (QFilter[])costRecordQ.toArray(), null);
            if (totalDataSet == null) {
                totalDataSet = writeOffCostRecords;
            } else {
                costRecordsDataSets.add(writeOffCostRecords);
            }
            billIds.clear();
        }
        if (billIds.size() > 0) {
            QFilter costRecordQ = new QFilter("bizbillid", "in", billIds);
            costRecordQ.and("costaccount", "in", this.costAccountIdSet);
            if (extFilter != null) {
                costRecordQ.and(extFilter);
            }
            costRecordQ.and("costaccount.accountcosttype", "!=", (Object)Character.valueOf('B'));
            DataSet writeOffCostRecords = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord_subentity", (String)"entry.writeoffid", (QFilter[])costRecordQ.toArray(), null);
            if (totalDataSet == null) {
                totalDataSet = writeOffCostRecords;
            } else {
                costRecordsDataSets.add(writeOffCostRecords);
            }
            billIds.clear();
        }
        if (totalDataSet != null && !costRecordsDataSets.isEmpty()) {
            totalDataSet = totalDataSet.union(costRecordsDataSets.toArray(new DataSet[0]));
        }
        return totalDataSet;
    }

    private List<ExceptionObj> getExceptionObj(DynamicObject[] writeOffInfos) {
        LinkedList<ExceptionObj> exceptionObjs = new LinkedList<ExceptionObj>();
        HashMap<String, Long> infosNumberMap = new HashMap<String, Long>(writeOffInfos.length);
        for (DynamicObject Info : writeOffInfos) {
            StringBuilder sBuilder = new StringBuilder();
            sBuilder.append(Info.getString("org.number"));
            sBuilder.append(',');
            sBuilder.append(Info.getString("billno"));
            sBuilder.append(',');
            sBuilder.append(Info.getString("entry.e_billno"));
            sBuilder.append(',');
            sBuilder.append(Info.getString("verifyseq"));
            infosNumberMap.put(sBuilder.toString(), Info.getLong("id"));
        }
        for (Map.Entry entry : infosNumberMap.entrySet()) {
            String[] infoNumberArray = ((String)entry.getKey()).split(",");
            String errorMsg = String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u201c%1$s\u201d\uff0c\u6838\u9500\u8bb0\u5f55\u4e3b\u65b9\u5355\u636e\u201c%2$s\u201d\uff0c\u8f85\u65b9\u5355\u636e\u201c%3$s\u201d\uff0c\u6838\u9500\u5e8f\u53f7\u201c%4$s\u201d\uff0c\u6838\u7b97\u672a\u81ea\u52a8\u62c6\u5355\uff0c\u8bf7\u91cd\u65b0\u6267\u884c\u3002", (String)"PurNoWriteOffDataCheckPlugin_5", (String)"fi-cal-business", (Object[])new Object[0]), infoNumberArray[0], infoNumberArray[1], infoNumberArray[2], infoNumberArray[3]);
            ExceptionObj exceptionObj = new ExceptionObj((Long)entry.getValue(), this.getDataEntityType());
            exceptionObj.setDescription(errorMsg);
            exceptionObjs.add(exceptionObj);
        }
        return exceptionObjs;
    }

    private void initOrgId(DataCheckParam param) {
        this.orgIds = param.getCalorg();
        if (this.orgIds == null || this.orgIds.isEmpty()) {
            this.orgIds = new HashSet<Long>(16);
            QFilter accountQ = new QFilter("enable", "=", (Object)"1");
            if (this.costAccountIdSet != null && !this.costAccountIdSet.isEmpty()) {
                accountQ.and("id", "in", this.costAccountIdSet);
            }
            DynamicObjectCollection costAccounts = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"calorg", (QFilter[])accountQ.toArray());
            for (DynamicObject costAccount : costAccounts) {
                this.orgIds.add(costAccount.getLong("calorg"));
            }
        }
        if (this.orgIds == null || this.orgIds.isEmpty()) {
            return;
        }
        String selectFileds = "number,bizorgentry.bizacctorg.number,bizorgentry.bizorg.number,bizorgentry.bizorg as ownerid";
        DynamicObjectCollection accountSysColls = AccountingSysHelper.getAccountingSysColls(new ArrayList<Long>(this.orgIds), (String)selectFileds);
        if (!accountSysColls.isEmpty()) {
            for (DynamicObject accountSysColl : accountSysColls) {
                this.orgIds.add(accountSysColl.getLong("ownerid"));
            }
        }
    }

    @Override
    public List<ExceptionObj> collectExceptionObj(DataSet dataSet, DataCheckParam param) {
        return null;
    }
}

