/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.datacheck.item;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.datatype.BigDecimalType;
import kd.bos.algo.input.OrmInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.fi.cal.business.datacheck.DataCheckParam;
import kd.fi.cal.business.datacheck.ExceptionObj;
import kd.fi.cal.business.datacheck.item.DataEntityDataCheck;
import kd.fi.cal.common.constant.DataCheckConstant;
import kd.fi.cal.common.enums.BosEntityObjEnum;

public class RecordCostCheckPlugin
extends DataEntityDataCheck {
    private Map<Long, DynamicObject> accountPeriodMap = new HashMap<Long, DynamicObject>(16);

    @Override
    protected String getDataEntityType() {
        return "cal_costrecord";
    }

    @Override
    public List<ExceptionObj> collectExceptionObj(DataSet dataSet, DataCheckParam param) {
        LinkedList<ExceptionObj> exceptionObjs = new LinkedList<ExceptionObj>();
        HashMap<Long, HashSet<Long>> accountSrcBillIdMap = new HashMap<Long, HashSet<Long>>(16);
        DataSet dataSetCopy = dataSet.copy();
        dataSetCopy = dataSetCopy.groupBy(new String[]{"id", "costaccount"}).finish();
        for (Object row : dataSetCopy) {
            Long l = row.getLong("costaccount");
            Long billId = row.getLong("id");
            HashSet<Long> scrBillIdSet = (HashSet<Long>)accountSrcBillIdMap.get(l);
            if (scrBillIdSet == null) {
                scrBillIdSet = new HashSet<Long>(16);
            }
            scrBillIdSet.add(billId);
            accountSrcBillIdMap.put(l, scrBillIdSet);
        }
        if (accountSrcBillIdMap.isEmpty()) {
            return null;
        }
        ArrayList<OrmInput> subBillAIOs = new ArrayList<OrmInput>(this.accountPeriodMap.size());
        for (Map.Entry entry : this.accountPeriodMap.entrySet()) {
            Long accountId = (Long)entry.getKey();
            DynamicObject crtPeriod = (DynamicObject)entry.getValue();
            Long crtPeriodId = crtPeriod.getLong("id");
            Set scrBillIdSet = (Set)accountSrcBillIdMap.get(accountId);
            if (scrBillIdSet == null || scrBillIdSet.isEmpty()) continue;
            QFilter q = new QFilter("costaccount", "=", (Object)accountId);
            q.and("bizentityobject", "in", (Object)new String[]{"im_purinbill", "im_saloutbill"});
            q.and("writeoffperiod.id", "=", (Object)crtPeriodId);
            QFilter billAQ = q.copy().and("writeoffstatus", "=", (Object)Character.valueOf('A'));
            QFilter billBQ = q.copy().and("writeoffstatus", "=", (Object)Character.valueOf('B'));
            billAQ.and("entry.ancestorbillid", "in", (Object)scrBillIdSet);
            QFilter idQ = new QFilter("id", "in", (Object)scrBillIdSet);
            idQ.or("entry.ancestorbillid", "in", (Object)scrBillIdSet);
            billBQ.and(idQ);
            String selectFields = this.getSubBillSelectedFields();
            OrmInput billAIO = new OrmInput(this.getClass().getName(), "cal_costrecord_subentity", selectFields, billAQ.toArray());
            OrmInput billBIO = new OrmInput(this.getClass().getName(), "cal_costrecord_subentity", selectFields, billBQ.toArray());
            subBillAIOs.add(billAIO);
            subBillAIOs.add(billBIO);
        }
        Algo algo = Algo.create((String)this.getClass().getName());
        DataSet dataSet2 = algo.createDataSet((Input[])subBillAIOs.toArray(new OrmInput[subBillAIOs.size()]));
        dataSet2.getRowMeta().getField("subcost").setDataType((DataType)new BigDecimalType());
        DataSet dataSet3 = dataSet2.groupBy(new String[]{"ancestorentryid"}).sum("subcost").finish();
        dataSet = dataSet.leftJoin(dataSet3).on("entryid", "ancestorentryid").select(dataSet.getRowMeta().getFieldNames(), new String[]{"subcost"}).finish();
        dataSet = dataSet.select("entryid,bizentityobject,calorgnumber,costaccountnumber,billno,materialnumber,cost,case when subcost = null then 0 else subcost end as subcost");
        dataSet.getRowMeta().getField("subcost").setDataType((DataType)new BigDecimalType());
        dataSet = dataSet.filter("cost != subcost");
        for (Row row : dataSet) {
            String bizEntity = row.getString("bizentityobject");
            BigDecimal subCostSum = row.getBigDecimal("subcost");
            BigDecimal parentBillCost = row.getBigDecimal("cost");
            StringBuilder desc = new StringBuilder();
            desc.append(DataCheckConstant.CAL_ORG).append(row.getString("calorgnumber")).append(DataCheckConstant.SEPERATOR).append(DataCheckConstant.COSTACCOUNT).append(row.getString("costaccountnumber")).append(DataCheckConstant.SEPERATOR).append(DataCheckConstant.BILLNO).append(row.getString("billno")).append(DataCheckConstant.SEPERATOR).append(DataCheckConstant.MATERIAL_NAME).append(row.getString("materialnumber")).append(DataCheckConstant.SEPERATOR);
            if (BosEntityObjEnum.IM_PURINBILL.getValue().equals(bizEntity)) {
                desc.append(ResManager.loadKDString((String)"\u7236\u5355\u6750\u6599\u6210\u672c\uff1a", (String)"RecordCostCheckPlugin_2", (String)"fi-cal-business", (Object[])new Object[0])).append(parentBillCost.stripTrailingZeros().toPlainString()).append(DataCheckConstant.SEPERATOR).append(ResManager.loadKDString((String)"\u5b50\u5355\u6750\u6599\u6210\u672c\u4e4b\u548c\uff1a", (String)"RecordCostCheckPlugin_3", (String)"fi-cal-business", (Object[])new Object[0])).append(subCostSum.stripTrailingZeros().toPlainString());
            } else {
                desc.append(ResManager.loadKDString((String)"\u7236\u5355\u5b9e\u9645\u6210\u672c\uff1a", (String)"RecordCostCheckPlugin_0", (String)"fi-cal-business", (Object[])new Object[0])).append(parentBillCost.stripTrailingZeros().toPlainString()).append(DataCheckConstant.SEPERATOR).append(ResManager.loadKDString((String)"\u5b50\u5355\u5b9e\u9645\u6210\u672c\u4e4b\u548c\uff1a", (String)"RecordCostCheckPlugin_1", (String)"fi-cal-business", (Object[])new Object[0])).append(subCostSum.stripTrailingZeros().toPlainString());
            }
            ExceptionObj exceptionObj = new ExceptionObj(row.getLong("entryid"), this.getDataEntityType(), desc.toString());
            exceptionObjs.add(exceptionObj);
        }
        return exceptionObjs;
    }

    @Override
    protected Set<String> getSelectedFields() {
        String selectedFields = "id,entry.id as entryid,costaccount,costaccount.number as costaccountnumber,calorg.number as calorgnumber,billno,entry.material.number as materialnumber,bizentityobject,case when calbilltype = 'IN' then entry.materialcost else entry.actualcost end as cost";
        return new HashSet<String>(Arrays.asList(selectedFields.split(",")));
    }

    private String getSubBillSelectedFields() {
        return "entry.ancestorentryid as ancestorentryid,case when calbilltype = 'IN' then entry.materialcost else entry.actualcost end as subcost";
    }

    @Override
    protected void addDataCheckFilter(List<QFilter> fList) {
        QFilter qFilter = new QFilter("issplit", "=", (Object)Character.valueOf('1'));
        qFilter.and("issplitcreate", "=", (Object)Character.valueOf('0'));
        QFilter bizentityFilter = new QFilter("bizentityobject", "in", (Object)new String[]{"im_purinbill", "im_saloutbill"});
        fList.add(qFilter);
        fList.add(bizentityFilter);
        super.addDataCheckFilter(fList);
    }

    @Override
    protected QFilter analyseCostAccountFilter(DataCheckParam param) {
        IDataEntityProperty accountProperty = this.entityType.findProperty("costaccount");
        Set<Long> costaccount = param.getCostAccount();
        if (accountProperty == null) {
            return null;
        }
        if (costaccount == null || costaccount.isEmpty()) {
            costaccount = this.getAllValidCostAccount();
        }
        ArrayList<QFilter> fList = new ArrayList<QFilter>(costaccount.size());
        IDataEntityProperty periodProperty = this.entityType.findProperty("period");
        boolean hasPeriod = periodProperty != null;
        String periodName = null;
        if (hasPeriod) {
            periodName = this.analyseFieldName(periodProperty);
        }
        String costAccountName = this.analyseFieldName(accountProperty);
        for (Long costAccountId : costaccount) {
            QFilter filter = new QFilter(costAccountName, "=", (Object)costAccountId);
            if (hasPeriod) {
                DynamicObject period = this.getCurrentPeriod(costAccountId);
                if (period == null) continue;
                this.accountPeriodMap.put(costAccountId, period);
                filter = filter.and(periodName, "=", (Object)period.getLong("id"));
                IDataEntityProperty bookdateProperty = this.entityType.findProperty("bookdate");
                if (bookdateProperty == null) continue;
                String bookdateName = this.analyseFieldName(bookdateProperty);
                filter = filter.and(bookdateName, ">=", (Object)period.getDate("begindate"));
                filter = filter.and(bookdateName, "<=", (Object)period.getDate("enddate"));
            }
            fList.add(filter);
        }
        if (fList.isEmpty()) {
            return new QFilter("id", "=", (Object)0);
        }
        QFilter firstFilter = (QFilter)fList.get(0);
        for (int i = 1; i < fList.size(); ++i) {
            firstFilter = firstFilter.or((QFilter)fList.get(i));
        }
        return firstFilter;
    }
}

