/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.datacheck.item;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.input.OrmInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.business.datacheck.DataCheckParam;
import kd.fi.cal.business.datacheck.ExceptionObj;
import kd.fi.cal.business.datacheck.item.DataEntityDataCheck;
import kd.fi.cal.common.helper.PeriodHelper;

public class SettleAccountBillStatusCheck
extends DataEntityDataCheck {
    @Override
    public List<ExceptionObj> collectExceptionObj(DataCheckParam param) {
        List<ExceptionObj> exceptionObjs = new ArrayList<ExceptionObj>(16);
        Set<Long> accountIdSet = this.getCostAccountIdSet(param);
        if (accountIdSet == null || accountIdSet.isEmpty()) {
            return null;
        }
        Map accountPeriodMap = PeriodHelper.getCurrentPeriods(accountIdSet);
        ArrayList<OrmInput> billsIO = new ArrayList<OrmInput>(16);
        for (Map.Entry entry : accountPeriodMap.entrySet()) {
            Long costAccountId = (Long)entry.getKey();
            QFilter bookDateQ = this.getCheckQ(costAccountId, (DynamicObject)entry.getValue(), "bookdate");
            QFilter bizDateQ = this.getCheckQ(costAccountId, (DynamicObject)entry.getValue(), "bizdate");
            OrmInput adjustIO = new OrmInput(this.getClass().getName(), "cal_costadjust_subentity", "id,billno,'cal_costadjust_subentity' as billType", new QFilter[]{bookDateQ});
            OrmInput provIO = new OrmInput(this.getClass().getName(), "cal_price_provbill", "id,billno,'cal_price_provbill' as billType", new QFilter[]{bizDateQ});
            OrmInput revIO = new OrmInput(this.getClass().getName(), "cal_price_revbill", "id,billno,'cal_price_revbill' as billType", new QFilter[]{bizDateQ});
            billsIO.add(adjustIO);
            billsIO.add(provIO);
            billsIO.add(revIO);
        }
        Algo algo = Algo.create((String)this.getClass().getName());
        DataSet dataSet = algo.createDataSet((Input[])billsIO.toArray(new OrmInput[billsIO.size()]));
        if (!dataSet.isEmpty()) {
            exceptionObjs = this.getExceptionObj(dataSet, exceptionObjs);
        }
        return exceptionObjs;
    }

    private QFilter getCheckQ(Long costAccountId, DynamicObject currentPeriod, String dateName) {
        Date beginDate = currentPeriod.getDate("begindate");
        Date endDate = currentPeriod.getDate("enddate");
        QFilter q = new QFilter(dateName, ">=", (Object)beginDate);
        q.and(dateName, "<=", (Object)endDate);
        q.and("costaccount", "=", (Object)costAccountId);
        q.and("billstatus", "<>", (Object)"C");
        return q;
    }

    private List<ExceptionObj> getExceptionObj(DataSet dataSet, List<ExceptionObj> exceptionObjs) {
        HashMap<String, String> billTypeNameMap = new HashMap<String, String>(16);
        billTypeNameMap.put("cal_costadjust_subentity", this.getLocalName("cal_costadjust_subentity"));
        billTypeNameMap.put("cal_price_provbill", this.getLocalName("cal_price_provbill"));
        billTypeNameMap.put("cal_price_revbill", this.getLocalName("cal_price_revbill"));
        for (Row row : dataSet) {
            StringBuilder sBuilder = new StringBuilder();
            sBuilder.append(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5ba1\u6838\u7684", (String)"SettleAccountBillStatusCheck_1", (String)"fi-cal-business", (Object[])new Object[0]));
            String billType = row.getString("billtype");
            if ("cal_costadjust_subentity".equals(billType)) {
                sBuilder.append((String)billTypeNameMap.get(billType));
                sBuilder.append(ResManager.loadKDString((String)"\u6216\u6807\u51c6\u6210\u672c\u5dee\u5f02\u5355", (String)"SettleAccountBillStatusCheck_2", (String)"fi-cal-business", (Object[])new Object[0]));
            } else {
                sBuilder.append((String)billTypeNameMap.get(billType));
            }
            sBuilder.append('\uff1a');
            sBuilder.append(row.getString("billno"));
            ExceptionObj exceptionObj = new ExceptionObj(row.getLong("id"), row.getString("billtype"));
            exceptionObj.setDescription(sBuilder.toString());
            exceptionObjs.add(exceptionObj);
        }
        return exceptionObjs;
    }

    private String getLocalName(String entity) {
        return EntityMetadataCache.getDataEntityType((String)entity).getDisplayName().getLocaleValue();
    }

    private Set<Long> getCostAccountIdSet(DataCheckParam param) {
        Set<Long> accountIdSet = param.getCostAccount();
        Set<Long> orgIdSet = param.getCalorg();
        if (accountIdSet == null || accountIdSet.isEmpty()) {
            if (orgIdSet == null || orgIdSet.isEmpty()) {
                return null;
            }
            QFilter accountQ = new QFilter("calorg", "in", orgIdSet);
            accountQ.and("enable", "=", (Object)"1");
            DynamicObjectCollection costAccounts = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"id", (QFilter[])accountQ.toArray());
            accountIdSet = new HashSet<Long>(16);
            for (DynamicObject costAccount : costAccounts) {
                accountIdSet.add(costAccount.getLong("id"));
            }
        }
        return accountIdSet;
    }

    @Override
    protected String getDataEntityType() {
        return "cal_costrecord";
    }

    @Override
    protected Set<String> getSelectedFields() {
        return null;
    }

    @Override
    public List<ExceptionObj> collectExceptionObj(DataSet dataSet, DataCheckParam param) {
        return null;
    }
}

