/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.datacheck.item;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.business.datacheck.DataCheckParam;
import kd.fi.cal.business.datacheck.ExceptionObj;
import kd.fi.cal.business.datacheck.item.DataEntityDataCheck;
import kd.fi.cal.common.enums.DischargeTypeEnum;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.common.util.DateUtils;

public class SettleAccountVoucherCheck
extends DataEntityDataCheck {
    @Override
    public List<ExceptionObj> collectExceptionObj(DataCheckParam param) {
        return this.checkBill(param);
    }

    private List<ExceptionObj> checkBill(DataCheckParam param) {
        List<ExceptionObj> exceptionObjs = new LinkedList<ExceptionObj>();
        Set<Long> accountIdSet = this.getCostAccountIdSet(param);
        if (accountIdSet == null || accountIdSet.isEmpty()) {
            return null;
        }
        Map accountPeriodMap = PeriodHelper.getCurrentPeriods(accountIdSet);
        for (Map.Entry accountEntry : accountPeriodMap.entrySet()) {
            String errorMessage;
            Long costAccountId = (Long)accountEntry.getKey();
            DynamicObject period = (DynamicObject)accountEntry.getValue();
            QFilter bookDateQFilter = this.getCommonFilter(costAccountId, period, "bookdate");
            QFilter writeoffDateQFilter = this.getCommonFilter(costAccountId, period, "writeoffdate");
            Set purBills = CommonSettingHelper.getBizEntityNumbers((String)"purbiztype");
            purBills.addAll(CommonSettingHelper.getBizEntityNumbers((String)"ominbiztype"));
            QFilter purQFilter = new QFilter("bizentityobject", "in", (Object)purBills);
            Set saleBills = CommonSettingHelper.getBizEntityNumbers((String)"outsplitebiztype");
            QFilter saleQFilter = new QFilter("bizentityobject", "in", (Object)saleBills);
            QFilter noPurSaleQFilter = new QFilter("bizentityobject", "not in", (Object)purBills).and("bizentityobject", "not in", (Object)saleBills);
            QFilter bizQFilter = new QFilter("dischargetype", "=", (Object)DischargeTypeEnum.UNCLEAR.getValue());
            bizQFilter.and("issplitcreate", "=", (Object)Boolean.FALSE);
            bizQFilter.and("billstatus", "=", (Object)"C");
            DynamicObjectCollection coll = QueryServiceHelper.query((String)"cal_costrecord", (String)"id,billno", (QFilter[])new QFilter[]{bookDateQFilter, purQFilter, bizQFilter});
            this.filterNoVoucherRecord(coll, "A");
            if (coll.size() > 0) {
                errorMessage = ResManager.loadKDString((String)"\u672a\u751f\u6210\u91c7\u8d2d\u6b63\u5f0f\u51ed\u8bc1\u7684\u5355\u636e\uff1a", (String)"SettleAccountFacade_29", (String)"fi-cal-business", (Object[])new Object[0]);
                exceptionObjs = this.getExceptionObj(errorMessage, coll, "cal_costrecord_subentity", exceptionObjs);
            }
            bizQFilter = new QFilter("dischargetype", "in", (Object)new String[]{DischargeTypeEnum.BEGINPERIODCLEAR.getValue()});
            bizQFilter.and("writeofftype", "in", (Object)new String[]{"A"});
            bizQFilter.and("billstatus", "=", (Object)"C");
            bizQFilter.and("writeoffstatus", "=", (Object)"A");
            coll = QueryServiceHelper.query((String)"cal_costrecord", (String)"id,billno", (QFilter[])new QFilter[]{writeoffDateQFilter, purQFilter, bizQFilter});
            this.filterNoVoucherRecord(coll, "A");
            if (coll.size() > 0) {
                errorMessage = ResManager.loadKDString((String)"\u672a\u751f\u6210\u91c7\u8d2d\u6b63\u5f0f\u51ed\u8bc1\u7684\u5355\u636e\uff1a", (String)"SettleAccountFacade_29", (String)"fi-cal-business", (Object[])new Object[0]);
                exceptionObjs = this.getExceptionObj(errorMessage, coll, "cal_costrecord_subentity", exceptionObjs);
            }
            bizQFilter = new QFilter("dischargetype", "in", (Object)new String[]{DischargeTypeEnum.BILLCOMECLEAR.getValue()});
            bizQFilter.and("writeofftype", "in", (Object)new String[]{"A"});
            bizQFilter.and("billstatus", "=", (Object)"C");
            bizQFilter.and("istempvoucher", "=", (Object)Boolean.FALSE);
            bizQFilter.and("writeoffstatus", "=", (Object)"A");
            coll = QueryServiceHelper.query((String)"cal_costrecord", (String)"id,billno", (QFilter[])new QFilter[]{writeoffDateQFilter, purQFilter, bizQFilter});
            this.filterNoVoucherRecord(coll, "A");
            if (coll.size() > 0) {
                errorMessage = ResManager.loadKDString((String)"\u672a\u751f\u6210\u91c7\u8d2d\u6b63\u5f0f\u51ed\u8bc1\u7684\u5355\u636e\uff1a", (String)"SettleAccountFacade_29", (String)"fi-cal-business", (Object[])new Object[0]);
                exceptionObjs = this.getExceptionObj(errorMessage, coll, "cal_costrecord_subentity", exceptionObjs);
            }
            bizQFilter = new QFilter("dischargetype", "in", (Object)new String[]{DischargeTypeEnum.BILLCOMECLEAR.getValue(), DischargeTypeEnum.BEGINPERIODCLEAR.getValue()});
            bizQFilter.and("writeofftype", "in", (Object)new String[]{"B"});
            bizQFilter.and("billstatus", "=", (Object)"C");
            bizQFilter.and("writeoffstatus", "=", (Object)"A");
            coll = QueryServiceHelper.query((String)"cal_costrecord", (String)"id,billno", (QFilter[])new QFilter[]{writeoffDateQFilter, purQFilter, bizQFilter});
            this.filterNoVoucherRecord(coll, "A");
            if (coll.size() > 0) {
                errorMessage = ResManager.loadKDString((String)"\u672a\u751f\u6210\u91c7\u8d2d\u6b63\u5f0f\u51ed\u8bc1\u7684\u5355\u636e\uff1a", (String)"SettleAccountFacade_29", (String)"fi-cal-business", (Object[])new Object[0]);
                exceptionObjs = this.getExceptionObj(errorMessage, coll, "cal_costrecord_subentity", exceptionObjs);
            }
            Date endDate = period.getDate("enddate");
            endDate = DateUtils.getDayEndTime((Date)endDate);
            bizQFilter = new QFilter("dischargetype", "=", (Object)DischargeTypeEnum.BEGINPERIODCLEAR.getValue());
            bizQFilter.and("billstatus", "=", (Object)"C");
            bizQFilter.and("bookdate", "<=", (Object)endDate);
            bizQFilter.and("writeoffdate", "<=", (Object)endDate);
            bizQFilter.and("writeoffstatus", "in", (Object)new String[]{"B"});
            bizQFilter.and("costaccount", "=", (Object)costAccountId);
            QFilter endPeriodQ1 = new QFilter("writeoffendperiod", "=", (Object)0L);
            QFilter endPeriodQ2 = new QFilter("writeoffendperiod", ">", (Object)period.getLong("id"));
            endPeriodQ1.or(endPeriodQ2);
            coll = QueryServiceHelper.query((String)"cal_costrecord", (String)"id,billno,issplit,period", (QFilter[])new QFilter[]{purQFilter, bizQFilter, endPeriodQ1});
            this.filterNoVoucherRecord(coll, "B");
            if (coll.size() > 0) {
                errorMessage = ResManager.loadKDString((String)"\u672a\u751f\u6210\u91c7\u8d2d\u6682\u4f30\u51ed\u8bc1\u7684\u5355\u636e\uff1a", (String)"SettleAccountFacade_30", (String)"fi-cal-business", (Object[])new Object[0]);
                exceptionObjs = this.getExceptionObj(errorMessage, coll, "cal_costrecord_subentity", exceptionObjs);
            }
            bizQFilter = new QFilter("dischargetype", "in", (Object)new String[]{DischargeTypeEnum.BILLCOMECLEAR.getValue()});
            bizQFilter.and("writeoffstatus", "in", (Object)new String[]{"B"});
            bizQFilter.and("billstatus", "=", (Object)"C");
            coll = QueryServiceHelper.query((String)"cal_costrecord", (String)"id,billno", (QFilter[])new QFilter[]{bookDateQFilter, writeoffDateQFilter, purQFilter, bizQFilter});
            this.filterNoVoucherRecord(coll, "B");
            if (coll.size() > 0) {
                errorMessage = ResManager.loadKDString((String)"\u672a\u751f\u6210\u91c7\u8d2d\u6682\u4f30\u51ed\u8bc1\u7684\u5355\u636e\uff1a", (String)"SettleAccountFacade_30", (String)"fi-cal-business", (Object[])new Object[0]);
                exceptionObjs = this.getExceptionObj(errorMessage, coll, "cal_costrecord_subentity", exceptionObjs);
            }
            bizQFilter = new QFilter("dischargetype", "in", (Object)new String[]{DischargeTypeEnum.BILLCOMECLEAR.getValue()});
            bizQFilter.and("writeofftype", "in", (Object)new String[]{"B"});
            bizQFilter.and("billstatus", "=", (Object)"C");
            bizQFilter.and("istempvoucher", "=", (Object)Boolean.TRUE);
            coll = QueryServiceHelper.query((String)"cal_costrecord", (String)"id,billno", (QFilter[])new QFilter[]{writeoffDateQFilter, purQFilter, bizQFilter});
            this.filterNoVoucherRecord(coll, "C");
            if (coll.size() > 0) {
                errorMessage = ResManager.loadKDString((String)"\u672a\u751f\u6210\u91c7\u8d2d\u51b2\u56de\u51ed\u8bc1\u7684\u5355\u636e\uff1a", (String)"SettleAccountFacade_31", (String)"fi-cal-business", (Object[])new Object[0]);
                exceptionObjs = this.getExceptionObj(errorMessage, coll, "cal_costrecord_subentity", exceptionObjs);
            }
            bizQFilter = new QFilter("dischargetype", "in", (Object)new String[]{DischargeTypeEnum.BEGINPERIODCLEAR.getValue()});
            bizQFilter.and("isinitbill", "=", (Object)Boolean.TRUE);
            bizQFilter.and("billstatus", "=", (Object)"C");
            bizQFilter.and("issplitcreate", "=", (Object)Boolean.FALSE);
            bizQFilter.and("costaccount", "=", (Object)costAccountId);
            bizQFilter.and("period", "=", (Object)period.getLong("id"));
            coll = QueryServiceHelper.query((String)"cal_costrecord", (String)"id,billno,period", (QFilter[])new QFilter[]{purQFilter, bizQFilter});
            this.filterNoVoucherRecord(coll, "C");
            if (coll.size() > 0) {
                errorMessage = ResManager.loadKDString((String)"\u672a\u751f\u6210\u91c7\u8d2d\u51b2\u56de\u51ed\u8bc1\u7684\u5355\u636e\uff1a", (String)"SettleAccountFacade_31", (String)"fi-cal-business", (Object[])new Object[0]);
                exceptionObjs = this.getExceptionObj(errorMessage, coll, "cal_costrecord_subentity", exceptionObjs);
            }
            bizQFilter = new QFilter("dischargetype", "in", (Object)new String[]{DischargeTypeEnum.BEGINPERIODCLEAR.getValue(), DischargeTypeEnum.BILLCOMECLEAR.getValue()});
            bizQFilter.and("billstatus", "=", (Object)"C");
            bizQFilter.and("issplitcreate", "=", (Object)Boolean.FALSE);
            bizQFilter.and("entry.fee", "<>", (Object)BigDecimal.ZERO);
            coll = QueryServiceHelper.query((String)"cal_costrecord", (String)"id,billno", (QFilter[])new QFilter[]{bookDateQFilter, purQFilter, bizQFilter});
            this.filterNoVoucherRecord(coll, "E");
            if (coll.size() > 0) {
                errorMessage = ResManager.loadKDString((String)"\u672a\u751f\u6210\u91c7\u8d2d\u8d39\u7528\u51ed\u8bc1\u7684\u5355\u636e\uff1a", (String)"SettleAccountFacade_32", (String)"fi-cal-business", (Object[])new Object[0]);
                exceptionObjs = this.getExceptionObj(errorMessage, coll, "cal_costrecord_subentity", exceptionObjs);
            }
            bizQFilter = new QFilter("issplitcreate", "=", (Object)Boolean.FALSE);
            bizQFilter.and("billstatus", "=", (Object)"C");
            coll = QueryServiceHelper.query((String)"cal_costrecord", (String)"id,billno", (QFilter[])new QFilter[]{bookDateQFilter, saleQFilter, bizQFilter});
            this.filterNoVoucherRecord(coll, "A");
            if (coll.size() > 0) {
                errorMessage = ResManager.loadKDString((String)"\u672a\u751f\u6210\u9500\u552e\u53d1\u51fa\u51ed\u8bc1\u7684\u5355\u636e\uff1a", (String)"SettleAccountFacade_33", (String)"fi-cal-business", (Object[])new Object[0]);
                exceptionObjs = this.getExceptionObj(errorMessage, coll, "cal_costrecord_subentity", exceptionObjs);
            }
            bizQFilter = new QFilter("writeofftype", "=", (Object)"B");
            bizQFilter.and("billstatus", "=", (Object)"C");
            coll = QueryServiceHelper.query((String)"cal_costrecord", (String)"id,billno", (QFilter[])new QFilter[]{writeoffDateQFilter, saleQFilter, bizQFilter});
            this.filterNoVoucherRecord(coll, "D");
            if (coll.size() > 0) {
                errorMessage = ResManager.loadKDString((String)"\u672a\u751f\u6210\u6210\u672c\u7ed3\u8f6c\u51ed\u8bc1\u7684\u5355\u636e\uff1a", (String)"SettleAccountFacade_34", (String)"fi-cal-business", (Object[])new Object[0]);
                exceptionObjs = this.getExceptionObj(errorMessage, coll, "cal_costrecord_subentity", exceptionObjs);
            }
            bizQFilter = new QFilter("issplitcreate", "=", (Object)Boolean.FALSE);
            bizQFilter.and("billstatus", "=", (Object)"C");
            coll = QueryServiceHelper.query((String)"cal_costrecord", (String)"id,billno", (QFilter[])new QFilter[]{bookDateQFilter, noPurSaleQFilter, bizQFilter});
            this.filterNoVoucherRecord(coll, "A");
            if (coll.size() > 0) {
                errorMessage = ResManager.loadKDString((String)"\u672a\u751f\u6210\u5176\u4ed6\u6b63\u5f0f\u51ed\u8bc1\u7684\u5355\u636e\uff1a", (String)"SettleAccountFacade_35", (String)"fi-cal-business", (Object[])new Object[0]);
                exceptionObjs = this.getExceptionObj(errorMessage, coll, "cal_costrecord_subentity", exceptionObjs);
            }
            bizQFilter = new QFilter("isvoucher", "=", (Object)Boolean.FALSE);
            bizQFilter.and("billstatus", "=", (Object)"C");
            coll = QueryServiceHelper.query((String)"cal_costadjustbill", (String)"id,billno", (QFilter[])new QFilter[]{bookDateQFilter, bizQFilter});
            if (coll.size() > 0) {
                errorMessage = ResManager.loadKDString((String)"\u672a\u751f\u6210\u51ed\u8bc1\u7684\u6210\u672c\u8c03\u6574\u5355\u636e\uff1a", (String)"SettleAccountFacade_36", (String)"fi-cal-business", (Object[])new Object[0]);
                exceptionObjs = this.getExceptionObj(errorMessage, coll, "cal_costadjust_subentity", exceptionObjs);
            }
            QFilter fallPriceQ = this.getCommonFilter(costAccountId, period, "bizdate");
            fallPriceQ.and("billstatus", "=", (Object)"C");
            exceptionObjs = this.getFallPriceExceptionObj("cal_price_provbill", ResManager.loadKDString((String)"\u4e1a\u52a1\u65e5\u671f\u5728\u5f53\u524d\u671f\u95f4\u5b58\u5728\u5df2\u5ba1\u6838\u672a\u751f\u6210\u51ed\u8bc1\u7684\u5b58\u8d27\u8dcc\u4ef7\u8ba1\u63d0\u5355\uff1a", (String)"SettleAccountVoucherCheck_0", (String)"fi-cal-business", (Object[])new Object[0]), fallPriceQ, exceptionObjs);
            exceptionObjs = this.getFallPriceExceptionObj("cal_price_revbill", ResManager.loadKDString((String)"\u4e1a\u52a1\u65e5\u671f\u5728\u5f53\u524d\u671f\u95f4\u5b58\u5728\u5df2\u5ba1\u6838\u672a\u751f\u6210\u51ed\u8bc1\u7684\u5b58\u8d27\u8dcc\u4ef7\u51b2\u56de\u5355\uff1a", (String)"SettleAccountVoucherCheck_1", (String)"fi-cal-business", (Object[])new Object[0]), fallPriceQ, exceptionObjs);
        }
        return exceptionObjs;
    }

    private List<ExceptionObj> getFallPriceExceptionObj(String entityNumber, String errorMsg, QFilter fallPriceQ, List<ExceptionObj> exceptionObjs) {
        DynamicObjectCollection fallPriceBills = QueryServiceHelper.query((String)entityNumber, (String)"id,billno", (QFilter[])fallPriceQ.toArray());
        if (fallPriceBills.size() > 0) {
            HashMap<Long, String> provBillMap = new HashMap<Long, String>(fallPriceBills.size());
            HashSet<Long> provBillSet = new HashSet<Long>(fallPriceBills.size());
            for (DynamicObject provBill : fallPriceBills) {
                Long billid = provBill.getLong("id");
                provBillMap.put(billid, provBill.getString("billno"));
                provBillSet.add(billid);
            }
            DynamicObjectCollection daps = QueryServiceHelper.query((String)"ai_daptracker", (String)"sourcebillid", (QFilter[])new QFilter("sourcebillid", "in", provBillSet).toArray());
            HashSet<Long> hasVoucherIdSet = new HashSet<Long>(16);
            for (DynamicObject dap : daps) {
                hasVoucherIdSet.add(dap.getLong("sourcebillid"));
            }
            provBillSet.removeAll(hasVoucherIdSet);
            for (Long noVoucherbillId : provBillSet) {
                String billNo = (String)provBillMap.get(noVoucherbillId);
                StringBuilder sBuilder = new StringBuilder();
                sBuilder.append(errorMsg);
                sBuilder.append(billNo);
                ExceptionObj exceptionObj = new ExceptionObj(noVoucherbillId, entityNumber);
                exceptionObj.setDescription(sBuilder.toString());
                exceptionObjs.add(exceptionObj);
            }
        }
        return exceptionObjs;
    }

    private List<ExceptionObj> getExceptionObj(String message, DynamicObjectCollection billDycs, String entity, List<ExceptionObj> exceptionObjs) {
        for (DynamicObject bill : billDycs) {
            StringBuilder sBuilder = new StringBuilder();
            sBuilder.append(message);
            sBuilder.append(bill.getString("billno"));
            ExceptionObj exceptionObj = new ExceptionObj(bill.getLong("id"), entity);
            exceptionObj.setDescription(sBuilder.toString());
            exceptionObjs.add(exceptionObj);
        }
        return exceptionObjs;
    }

    private QFilter getCommonFilter(Long costAccountId, DynamicObject currentPeriod, String dateName) {
        Date beginDate = currentPeriod.getDate("begindate");
        Date endDate = currentPeriod.getDate("enddate");
        QFilter q = new QFilter(dateName, ">=", (Object)beginDate);
        q.and(dateName, "<=", (Object)endDate);
        q.and("costaccount", "=", (Object)costAccountId);
        return q;
    }

    private void filterNoVoucherRecord(DynamicObjectCollection costRecordColl, String voucherType) {
        HashSet<Long> costRecordSet = new HashSet<Long>();
        for (DynamicObject info : costRecordColl) {
            costRecordSet.add(info.getLong("id"));
        }
        QFilter q = new QFilter("vouchertype", "=", (Object)voucherType);
        q.and("costrecordid", "in", costRecordSet);
        DynamicObjectCollection voucherColl = QueryServiceHelper.query((String)"cal_voucher", (String)"id,costrecordid,voucherid", (QFilter[])new QFilter[]{q});
        for (DynamicObject info : voucherColl) {
            costRecordSet.remove(info.getLong("costrecordid"));
        }
        for (int i = costRecordColl.size() - 1; i >= 0; --i) {
            DynamicObject info;
            info = (DynamicObject)costRecordColl.get(i);
            if (costRecordSet.contains(info.getLong("id"))) continue;
            costRecordColl.remove(i);
        }
    }

    private Set<Long> getCostAccountIdSet(DataCheckParam param) {
        Set<Long> accountIdSet = param.getCostAccount();
        Set<Long> orgIdSet = param.getCalorg();
        if (accountIdSet == null || accountIdSet.isEmpty()) {
            if (orgIdSet == null || orgIdSet.isEmpty()) {
                return null;
            }
            QFilter accountQ = new QFilter("calorg", "in", orgIdSet);
            accountQ.and("enable", "=", (Object)"1");
            DynamicObjectCollection costAccounts = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"id", (QFilter[])accountQ.toArray());
            accountIdSet = new HashSet<Long>(16);
            for (DynamicObject costAccount : costAccounts) {
                accountIdSet.add(costAccount.getLong("id"));
            }
        }
        return accountIdSet;
    }

    @Override
    protected String getDataEntityType() {
        return "cal_costrecord_subentity";
    }

    @Override
    protected Set<String> getSelectedFields() {
        return null;
    }

    @Override
    public List<ExceptionObj> collectExceptionObj(DataSet dataSet, DataCheckParam param) {
        return null;
    }
}

