/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.datacheck.item;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.input.OrmInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QEmptyValue;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.business.datacheck.DataCheckParam;
import kd.fi.cal.business.datacheck.ExceptionObj;
import kd.fi.cal.business.datacheck.item.DataEntityDataCheck;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.common.helper.PeriodHelper;

public class SettleAccountZeroCostCheck
extends DataEntityDataCheck {
    @Override
    public List<ExceptionObj> collectExceptionObj(DataCheckParam param) {
        List<ExceptionObj> exceptionObjs = new LinkedList<ExceptionObj>();
        Set<Long> accountIdSet = this.getCostAccountIdSet(param);
        if (accountIdSet == null || accountIdSet.isEmpty()) {
            return null;
        }
        Map accountPeriodMap = PeriodHelper.getCurrentPeriods(accountIdSet);
        ArrayList<OrmInput> accountsIO = new ArrayList<OrmInput>(16);
        for (Map.Entry entry : accountPeriodMap.entrySet()) {
            Long costAccountId = (Long)entry.getKey();
            QFilter checkQ = this.getCheckQ(costAccountId, (DynamicObject)entry.getValue());
            if (!param.isAllMaterial() && param.getMaterial() != null && !param.getMaterial().isEmpty()) {
                checkQ.and("entry.material.id", "in", param.getMaterial());
            }
            OrmInput accountIO = new OrmInput(this.getClass().getName(), this.getDataEntityType(), "id,billno,costaccount.number", new QFilter[]{checkQ});
            accountsIO.add(accountIO);
        }
        Algo algo = Algo.create((String)this.getClass().getName());
        DataSet dataSet = algo.createDataSet((Input[])accountsIO.toArray(new OrmInput[accountsIO.size()]));
        if (!dataSet.isEmpty()) {
            exceptionObjs = this.getExceptionObj(dataSet, this.getDataEntityType(), exceptionObjs);
        }
        return exceptionObjs;
    }

    private QFilter getCheckQ(Long costAccountId, DynamicObject currentPeriod) {
        Date beginDate = currentPeriod.getDate("begindate");
        Date endDate = currentPeriod.getDate("enddate");
        QFilter q = new QFilter("bookdate", ">=", (Object)beginDate);
        q.and("bookdate", "<=", (Object)endDate);
        q.and("costaccount", "=", (Object)costAccountId);
        q.and("entry.unitactualcost", this.getErrorFilter(), (Object)0);
        QFilter presentQ = this.getPresentQFilter();
        q.and(presentQ);
        Object[] zeroInOutBizTypeIds = CommonSettingHelper.getZeroInOutBizTypeIds();
        if (zeroInOutBizTypeIds.length > 0) {
            q.and("biztype", "not in", (Object)zeroInOutBizTypeIds);
        }
        q.and("entry.ispresent", "=", (Object)Boolean.FALSE);
        q.and("invscheme.zerocost", "=", (Object)Boolean.FALSE);
        q.and("issplitcreate", "=", (Object)Boolean.FALSE);
        QFilter billStatusf = new QFilter("billstatus", "=", (Object)"C");
        q.and(billStatusf);
        QFilter costPriceSourceFilter = new QFilter("entry.costpricesource", "=", (Object)QEmptyValue.value);
        q.and(costPriceSourceFilter);
        return q;
    }

    protected QFilter getPresentQFilter() {
        QFilter presentQ = new QFilter("entry.ispresent", "=", (Object)Boolean.FALSE);
        presentQ.and("calbilltype", "=", (Object)"IN");
        presentQ.or("calbilltype", "=", (Object)"OUT");
        return presentQ;
    }

    protected String getErrorFilter() {
        return "=";
    }

    private List<ExceptionObj> getExceptionObj(DataSet dataSet, String entity, List<ExceptionObj> exceptionObjs) {
        HashSet<String> caBillNoSet = new HashSet<String>(16);
        for (Row row : dataSet) {
            String costAccountNumber = row.getString("costaccount.number");
            String billNo = row.getString("billno");
            if (caBillNoSet.contains(costAccountNumber + "#" + billNo)) continue;
            StringBuilder sBuilder = new StringBuilder();
            sBuilder.append(MessageFormat.format(this.getErrorMsg(), costAccountNumber));
            sBuilder.append(billNo);
            ExceptionObj exceptionObj = new ExceptionObj(row.getLong("id"), entity);
            exceptionObj.setDescription(sBuilder.toString());
            exceptionObjs.add(exceptionObj);
            caBillNoSet.add(costAccountNumber + "#" + billNo);
        }
        return exceptionObjs;
    }

    protected String getErrorMsg() {
        return ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\uff1a{0} \u5b58\u5728\uff08\u9664\u5165\u5e93\u8d60\u54c1\u884c\u5916\uff09\u5355\u4f4d\u5b9e\u9645\u6210\u672c=0\u7684\u5355\u636e\uff1a", (String)"SettleAccountZeroCostCheck_1", (String)"fi-cal-business", (Object[])new Object[0]);
    }

    private Set<Long> getCostAccountIdSet(DataCheckParam param) {
        Set<Long> accountIdSet = param.getCostAccount();
        Set<Long> orgIdSet = param.getCalorg();
        if (accountIdSet == null || accountIdSet.isEmpty()) {
            if (orgIdSet == null || orgIdSet.isEmpty()) {
                return null;
            }
            QFilter accountQ = new QFilter("calorg", "in", orgIdSet);
            accountQ.and("enable", "=", (Object)"1");
            DynamicObjectCollection costAccounts = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"id", (QFilter[])accountQ.toArray());
            accountIdSet = new HashSet<Long>(16);
            for (DynamicObject costAccount : costAccounts) {
                accountIdSet.add(costAccount.getLong("id"));
            }
        }
        return accountIdSet;
    }

    @Override
    protected String getDataEntityType() {
        return "cal_costrecord_subentity";
    }

    @Override
    protected Set<String> getSelectedFields() {
        return null;
    }

    @Override
    public List<ExceptionObj> collectExceptionObj(DataSet dataSet, DataCheckParam param) {
        return null;
    }
}

